<?php
/**
 * Impeka Elementor Cascading Image Widget.
 *
 * Elementor widget that inserts cascading images into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Cascading_Image_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_cascading_image';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Cascading Image', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-double-image';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'image_mode',
			[
				'label' => esc_html__( 'Image Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => apply_filters( 'impeka_elementor_ext_image_options', array(
					''  => esc_html__( 'Full ( Custom )', 'impeka-elementor-extension' ),
					'square'  => esc_html__( 'Square Small Crop', 'impeka-elementor-extension' ),
					'landscape'  => esc_html__( 'Landscape Small Crop', 'impeka-elementor-extension' ),
					'landscape-medium'  => esc_html__( 'Landscape Medium Crop', 'impeka-elementor-extension' ),
					'portrait'  => esc_html__( 'Portrait Small Crop', 'impeka-elementor-extension' ),
					'portrait-medium'  => esc_html__( 'Portrait Medium Crop', 'impeka-elementor-extension' ),
					'extra-extra-large' => esc_html__( 'Resize ( Extra Extra Large )', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Resize ( Large )', 'impeka-elementor-extension' ),
					'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka-elementor-extension' ),
					'medium' => esc_html__( 'Resize ( Medium )', 'impeka-elementor-extension' ),
					'thumbnail' => esc_html__( 'Thumbnail', 'impeka-elementor-extension' ),
				) ),
				'default' => '',
				'description' => esc_html__( "Select your Image Size.", 'impeka-elementor-extension' ),
			]
		);

		$repeater->add_control(
			'image',
			[
				'label' => esc_html__( 'Image', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => false,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( "Select your image.", 'impeka-elementor-extension' ),
			]
		);

		$repeater->add_control(
			'retina_image',
			[
				'label' => esc_html__( 'Retina Image', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => false,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( "Select a 2x image.", 'impeka-elementor-extension' ),
				'condition' => [
					'image_mode' => [ '' ],
				],
			]
		);

		$repeater->add_control(
			'offset_x',
			[
				'label' => esc_html__( 'Offset X', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
			]
		);

		$repeater->add_control(
			'offset_y',
			[
				'label' => esc_html__( 'Offset Y', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
			]
		);

		$repeater->add_control( 'shadow', impeka_elementor_ext_add_shadow() );
		$repeater->add_control( 'radius', impeka_elementor_ext_add_radius() );

		$repeater->add_control( 'grve_animation', impeka_elementor_ext_add_animation() );
		$repeater->add_control( 'grve_animation_delay', impeka_elementor_ext_add_animation_delay() );
		$repeater->add_control( 'grve_animation_duration', impeka_elementor_ext_add_animation_duration() );

		$this->add_control(
			'image_item',
			[
				'label' => esc_html__( 'Image', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'offset_x' => '',
						'offset_y' => '',
					],
					[
						'offset_x' => '10%',
						'offset_y' => '10%',
					],
				],
				'description' => esc_html__( "Configure your images.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'image_width',
			[
				'label' => esc_html__( 'Image Width', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'auto' => esc_html__( 'Auto' , 'impeka-elementor-extension' ),
					'100' => esc_html__( 'Column Width' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select if you want your image to fill the column space.', 'impeka-elementor-extension' ),
				'default' => 'auto',
			]
		);

		$this->add_control( 'image_load_mode', impeka_elementor_ext_add_image_load_mode() );
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		echo impeka_elementor_ext_locate_template( 'cascading-image.php', array( 'atts' => $atts ) );
	}

}