<?php
/**
 * Impeka Elementor Divider Widget.
 *
 * Elementor widget that inserts a divider element into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Divider_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_divider';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Divider', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-divider';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'line_type',
			[
				'label' => esc_html__( 'Line Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'line' => esc_html__( 'With Line', 'impeka-elementor-extension' ),
					'double-line' => esc_html__( 'Double Line', 'impeka-elementor-extension' ),
					'dashed-line' => esc_html__( 'Dashed Line', 'impeka-elementor-extension' ),
					'top-line' => esc_html__( 'Back to Top', 'impeka-elementor-extension' ),
					'vertical-line' => esc_html__( 'Vertical Line', 'impeka-elementor-extension' ),
					'custom-line' => esc_html__( 'Custom Line', 'impeka-elementor-extension' ),
				],
				'default' => 'line',
				'description' => esc_html__( 'Line Type of the divider.', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'line_width',
			[
				'label' => esc_html__( 'Line Width', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '50',
				'description' => esc_html__( "Enter the width for your line (Note: CSS measurement units allowed).", 'impeka-elementor-extension' ),
				'condition' => [
					'line_type' => [ 'custom-line', 'vertical-line' ],
				],
			]
		);

		$this->add_control(
			'vertical_line_height',
			[
				'label' => esc_html__( 'Line Height', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1x' => '1x',
					'2x' => '2x',
					'3x' => '3x',
					'4x' => '4x',
					'5x' => '5x',
					'6x' => '6x',
					'custom' => esc_html__( 'Custom', 'impeka-elementor-extension' ),
				],
				'default' => '3x',
				'description' => esc_html__( 'Select the height for your line.', 'impeka-elementor-extension' ),
				'condition' => [
					'line_type' => [ 'vertical-line' ],
				],
			]
		);

		$this->add_control(
			'vertical_line_height_custom',
			[
				'label' => esc_html__( 'Line Height Custom', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '50',
				'description' => esc_html__( 'Enter the height for your line (Note: CSS measurement units allowed).', 'impeka-elementor-extension' ),
				'condition' => [
					'vertical_line_height' => [ 'custom' ],
				],
			]
		);

		$this->add_control(
			'line_height',
			[
				'label' => esc_html__( 'Line Height', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [ '1', '2', '3', '4' , '5', '6', '7', '8', '9' , '10' ],
				'default' => '2',
				'description' => esc_html__( 'Enter the hight for your line in px.', 'impeka-elementor-extension' ),
				'condition' => [
					'line_type' => [ 'custom-line' ],
				],
			]
		);

		$this->add_control(
			'line_color',
			[
				'label' => esc_html__( 'Line Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['primary', 'standard', 'custom'] ),
				'default' => 'primary-1',
				'description' => esc_html__( 'Color for the line.', 'impeka-elementor-extension' ),
				'condition' => [
					'line_type' => [ 'custom-line', 'vertical-line' ],
				],
			]
		);

		$this->add_control(
			'line_color_custom',
			[
				'label' => esc_html__( 'Custom Line Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'default' => '#000000',
				'description' => esc_html__( "Select a custom color for your line", 'impeka-elementor-extension' ),
				'condition' => [
					'line_color' => [ 'custom' ],
				],
			]
		);

		$this->add_control(
			'align',
			[
				'label' => esc_html__( 'Alignment', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'left' => esc_html__( 'Left', 'impeka-elementor-extension' ),
					'right' => esc_html__( 'Right', 'impeka-elementor-extension' ),
					'center' => esc_html__( 'Center', 'impeka-elementor-extension' ),
				],
				'default' => 'left',
				'condition' => [
					'line_type' => [ 'custom-line', 'vertical-line' ],
				],
			]
		);

		$this->add_control(
			'line_loop_animation',
			[
				'label' => esc_html__( 'Line Loop Animation', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'None', 'impeka-elementor-extension' ),
					'top-bottom' => esc_html__( 'Top to Bottom', 'impeka-elementor-extension' ),
					'bottom-top' => esc_html__( 'Bottom to Top', 'impeka-elementor-extension' ),
				],
				'default' => '',
				'description' => esc_html__( "Select loop animation for your line.", 'impeka-elementor-extension' ),
				'condition' => [
					'line_type' => [ 'vertical-line' ],
				],
			]
		);

		$this->add_control(
			'backtotop_title',
			[
				'label' => esc_html__( 'Back to Top Title', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Back to top',
				'description' => esc_html__( "Set Back to top title.", 'impeka-elementor-extension' ),
				'condition' => [
					'line_type' => [ 'top-line' ],
				],
			]
		);

		$this->add_control(
			'padding_top',
			[
				'label' => esc_html__( 'Top padding', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'padding_bottom',
			[
				'label' => esc_html__( 'Bottom padding', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

		//Animation Section
		$this->start_controls_section(
			'animation_section',
			[
				'label' => esc_html__( 'Animation', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation() );
		$this->add_control( 'grve_animation_delay', impeka_elementor_ext_add_animation_delay() );
		$this->add_control( 'grve_animation_duration', impeka_elementor_ext_add_animation_duration() );
		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();

		echo impeka_elementor_ext_locate_template( 'divider.php', array( 'atts' => $atts ) );
	}

}