<?php
/**
 * Impeka Elementor Icon Box Widget.
 *
 * Elementor widget that inserts an icon box into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Icon_Box_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_icon_box';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Icon Box', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-icon-box';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'icon_box_type',
			[
				'label' => esc_html__( 'Icon Box Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'top-icon'  => esc_html__( 'Top Icon', 'impeka-elementor-extension' ),
					'side-icon'  => esc_html__( 'Side Icon', 'impeka-elementor-extension' ),
				),
				'default' => 'top-icon',
				'description' => esc_html__( "Select icon box type.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'icon_box_layout',
			[
				'label' => esc_html__( 'Icon Box Layout', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'layout-1'  => esc_html__( 'Layout 1', 'impeka-elementor-extension' ),
					'layout-2'  => esc_html__( 'Layout 2', 'impeka-elementor-extension' ),
				),
				'default' => 'layout-1',
				'description' => esc_html__( "Select icon box layout.", 'impeka-elementor-extension' ),
				'condition' => [
					'icon_box_type' => [ 'side-icon' ],
				],
			]
		);
		$this->add_responsive_control(
			'icon_top_align',
			[
				'label' => esc_html__( 'Alignment', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'impeka-elementor-extension' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'impeka-elementor-extension' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'impeka-elementor-extension' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'condition' => [
					'icon_box_type' => [ 'top-icon' ],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'prefix_class' => 'grve-elementor-align-%s',
			]
		);
		$this->add_responsive_control(
			'icon_side_align',
			[
				'label' => esc_html__( 'Alignment', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'impeka-elementor-extension' ),
						'icon' => 'eicon-text-align-left',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'impeka-elementor-extension' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'condition' => [
					'icon_box_type' => [ 'side-icon' ],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'prefix_class' => 'grve-elementor-align-%s',
				
			]
		);
		$this->add_control(
			'icon_type',
			[
				'label' => esc_html__( 'Icon Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'icon'  => esc_html__( 'Icon', 'impeka-elementor-extension' ),
					'image'  => esc_html__( 'Image', 'impeka-elementor-extension' ),
					'char'  => esc_html__( 'Character', 'impeka-elementor-extension' ),
				),
				'default' => 'icon',
				'description' => esc_html__( "Select icon type.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'extra-large' => esc_html__( 'Extra Large', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Large', 'impeka-elementor-extension' ),
					'medium' => esc_html__( 'Medium', 'impeka-elementor-extension' ),
					'small' => esc_html__( 'Small', 'impeka-elementor-extension' ),
					'extra-small' => esc_html__( 'Extra Small', 'impeka-elementor-extension' ),
				],
				'default' => 'medium',
				'description' => esc_html__( "Select icon size.", 'impeka-elementor-extension' ),
				'conditions' => [
					'terms' => [
						[ 'name' => 'icon_type', 'operator' => '!in', 'value' => [ 'image' ] ],
					],
				],
			]
		);
		$this->add_control(
			'icon_vertical_align',
			[
				'label' => esc_html__( 'Icon Vertical Align', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'top'  => esc_html__( 'Top', 'impeka-elementor-extension' ),
					'middle'  => esc_html__( 'Middle', 'impeka-elementor-extension' ),
				),
				'default' => 'middle',
				'description' => esc_html__( "Select icon vertical align.", 'impeka-elementor-extension' ),
				'condition' => [
					'icon_box_type' => [ 'side-icon' ],
				],
			]
		);
		$this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'fa-solid',
				],
				'condition' => [
					'icon_type' => [ 'icon' ],
				],
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['primary', 'gradient', 'standard', 'custom'] ),
				'default' => 'primary-1',
				'description' => esc_html__( 'Select the color of your icon.', 'impeka-elementor-extension' ),
				'conditions' => [
					'terms' => [
						[ 'name' => 'icon_type', 'operator' => '!in', 'value' => [ 'image' ] ],
					],
				],
			]
		);
		$this->add_control(
			'icon_color_custom',
			[
				'label' => esc_html__( 'Custom Icon Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'default' => '#000000',
				'description' => esc_html__( "Select a custom color for your icon", 'impeka-elementor-extension' ),
				'condition' => [
					'icon_color' => [ 'custom' ],
				],
			]
		);
		$this->add_control(
			'icon_shape',
			[
				'label' => esc_html__( 'Icon Shape', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no-shape'  => esc_html__( 'None', 'impeka-elementor-extension' ),
					'square'  => esc_html__( 'Square', 'impeka-elementor-extension' ),
					'round'  => esc_html__( 'Round', 'impeka-elementor-extension' ),
					'circle'  => esc_html__( 'Circle', 'impeka-elementor-extension' ),
				),
				'default' => 'no-shape',
				'description' => esc_html__( "Select icon shape.", 'impeka-elementor-extension' ),
				'conditions' => [
					'terms' => [
						[ 'name' => 'icon_type', 'operator' => '!in', 'value' => [ 'image' ] ],
					],
				],
			]
		);
		$this->add_control(
			'shape_type',
			[
				'label' => esc_html__( 'Shape Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'simple'  => esc_html__( 'Simple', 'impeka-elementor-extension' ),
					'outline'  => esc_html__( 'Outline', 'impeka-elementor-extension' ),
				),
				'default' => 'simple',
				'description' => esc_html__( "Select shape type.", 'impeka-elementor-extension' ),
				'condition' => [
					'icon_shape' => [ 'square', 'round', 'circle' ],
				],
			]
		);
		$this->add_control(
			'icon_shape_color',
			[
				'label' => esc_html__( 'Icon Shape Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['primary', 'gradient', 'standard', 'custom'] ),
				'default' => 'grey',
				'description' => esc_html__( 'Select the color of your icon.', 'impeka-elementor-extension' ),
				'condition' => [
					'icon_shape' => [ 'square', 'round', 'circle' ],
				],
			]
		);
		$this->add_control(
			'icon_shape_color_custom',
			[
				'label' => esc_html__( 'Custom Icon Shape Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'default' => '#000000',
				'description' => esc_html__( "Select a custom color for your icon", 'impeka-elementor-extension' ),
				'condition' => [
					'icon_shape_color' => [ 'custom' ],
				],
			]
		);
		$this->add_control(
			'icon_animation',
			[
				'label' => esc_html__( 'Enable Advanced Hover', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'condition' => [
					'icon_box_type' => [ 'top-icon' ],
				],
			]
		);
		$this->add_control(
			'icon_image',
			[
				'label' => esc_html__( 'Icon Image', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => false,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( "Select your image.", 'impeka-elementor-extension' ),
				'condition' => [
					'icon_type' => [ 'image' ],
				],
			]
		);

		$this->add_control(
			'retina_icon_image',
			[
				'label' => esc_html__( 'Retina Icon Image', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => false,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( "Select a 2x image.", 'impeka-elementor-extension' ),
				'condition' => [
					'icon_type' => [ 'image' ],
				],
			]
		);
		$this->add_control(
			'image_load_mode',
			[
				'label' => esc_html__( 'Image Load Mode', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					'' => esc_html__( 'Inherit', 'impeka-elementor-extension' ),
					'off' => esc_html__( 'Off', 'impeka-elementor-extension' ),
					'native-lazyload' => esc_html__( 'Native Lazyload', 'impeka-elementor-extension' ),
					'lazyload' => esc_html__( 'Theme Lazyload', 'impeka-elementor-extension' ),
				),
				'description' => esc_html__( "Enable Lazy load.", 'impeka-elementor-extension' ),
				'condition' => [
					'icon_type' => [ 'image' ],
				],
			]
		);
		$this->add_control(
			'icon_char',
			[
				'label' => esc_html__( 'Character', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'A',
				'description' => esc_html__( 'Type a single character.', 'impeka-elementor-extension' ),
				'condition' => [
					'icon_type' => [ 'char' ],
				],
			]
		);
		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter your title.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
				'default' => 'inherit',
				'description' => esc_html__( 'Choose the title color.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control( 'heading_tag', impeka_elementor_ext_add_heading_tag( 'h3' ) );
		$this->add_control(
			'heading',
			[
				'label' => esc_html__( 'Title Size/Typography', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'auto' => esc_html__( 'Auto', 'impeka-elementor-extension' ),
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'body-text' => esc_html__( 'Body Text', 'impeka-elementor-extension' ),
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'small-text' => esc_html__( 'Small Text', 'impeka-elementor-extension' ),
					'link-text' => esc_html__( 'Link Text', 'impeka-elementor-extension' ),
					'page-title' => esc_html__( 'Page Title', 'impeka-elementor-extension' ),
					'feature-title' => esc_html__( 'Feature Title', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Title size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
				'default' => 'h3',
			]
		);
		$this->add_control( 'custom_font_family', impeka_elementor_ext_add_custom_font_family() );
		$this->add_control(
			'content',
			[
				'label' => esc_html__( 'Text', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => '',
				'description' => esc_html__( "Enter your text", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
				'default' => 'inherit',
				'description' => esc_html__( 'Choose the text color.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'text_style',
			[
				'label' => esc_html__( 'Text Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					''  => esc_html__( 'None', 'impeka-elementor-extension' ),
					'leader-text'  => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text'  => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
				),
				'default' => '',
				'description' => esc_html__( "Select your text style.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'link',
			[
				'label' => esc_html__( 'Link', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
				'dynamic' => [
					'active' => false,
				],
				'placeholder' => 'https://your-link.com',
			]
		);
		$this->add_control(
			'link_class',
			[
				'label' => esc_html__( 'Link Class', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter a class for your link.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

		//Animation Section
		$this->start_controls_section(
			'animation_section',
			[
				'label' => esc_html__( 'Animation', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation() );
		$this->add_control( 'grve_animation_delay', impeka_elementor_ext_add_animation_delay() );
		$this->add_control( 'grve_animation_duration', impeka_elementor_ext_add_animation_duration() );
		$this->end_controls_section();


	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();


		echo impeka_elementor_ext_locate_template( 'icon-box.php', array( 'atts' => $atts ) );
	}

}