<?php
/**
 * Impeka Elementor Single Image Widget.
 *
 * Elementor widget that inserts a single image into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Image_Single_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_image_single';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Single Image', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-image';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'image_type',
			[
				'label' => esc_html__( 'Image Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'image' => esc_html__( 'Image', 'impeka-elementor-extension' ),
					'image-content' => esc_html__( 'Image With Content', 'impeka-elementor-extension' ),
				),
				'default' => 'image',
				'description' => esc_html__( "Select your image type.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'image_mode',
			[
				'label' => esc_html__( 'Image Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => apply_filters( 'impeka_elementor_ext_image_options', array(
					''  => esc_html__( 'Full', 'impeka-elementor-extension' ),
					'square'  => esc_html__( 'Square Small Crop', 'impeka-elementor-extension' ),
					'landscape'  => esc_html__( 'Landscape Small Crop', 'impeka-elementor-extension' ),
					'landscape-medium'  => esc_html__( 'Landscape Medium Crop', 'impeka-elementor-extension' ),
					'portrait'  => esc_html__( 'Portrait Small Crop', 'impeka-elementor-extension' ),
					'portrait-medium'  => esc_html__( 'Portrait Medium Crop', 'impeka-elementor-extension' ),
					'extra-extra-large' => esc_html__( 'Resize ( Extra Extra Large )', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Resize ( Large )', 'impeka-elementor-extension' ),
					'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka-elementor-extension' ),
					'medium' => esc_html__( 'Resize ( Medium )', 'impeka-elementor-extension' ),
					'thumbnail' => esc_html__( 'Thumbnail', 'impeka-elementor-extension' ),
				) ),
				'default' => '',
				'description' => esc_html__( "Select your Image Size.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'image',
			[
				'label' => esc_html__( 'Image', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => false,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( "Select your image.", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'retina_image',
			[
				'label' => esc_html__( 'Retina Image', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( "Select a 2x image.", 'impeka-elementor-extension' ),
				'condition' => [
					'image_mode' => [ '' ],
				],
			]
		);
		$this->add_control(
			'image_load_mode',
			[
				'label' => esc_html__( 'Image Load Mode', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Inherit', 'impeka-elementor-extension' ),
					'off' => esc_html__( 'Off', 'impeka-elementor-extension' ),
					'native-lazyload' => esc_html__( 'Native Lazyload', 'impeka-elementor-extension' ),
					'lazyload' => esc_html__( 'Theme Lazyload', 'impeka-elementor-extension' ),
				),
				'default' => '',
				'description' => esc_html__( "Enable Lazy load.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'image_column_space',
			[
				'label' => esc_html__( 'Image Column Space', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'auto' => esc_html__( 'Auto', 'impeka-elementor-extension' ),
					'100' => esc_html__( '100%', 'impeka-elementor-extension' ),
					'125' => esc_html__( '125%', 'impeka-elementor-extension' ),
					'150' => esc_html__( '150%', 'impeka-elementor-extension' ),
					'175' => esc_html__( '175%', 'impeka-elementor-extension' ),
					'200' => esc_html__( '200%', 'impeka-elementor-extension' ),
					'225' => esc_html__( '225%', 'impeka-elementor-extension' ),
					'250' => esc_html__( '250%', 'impeka-elementor-extension' ),

				],
				'default' => 'auto',
				'description' => esc_html__( 'Define the max width of the image on this column. Setting percentage larger than 100% the image overflows out of the column. Default is the image resolution.', 'impeka-elementor-extension' ),
				'condition' => [
					'image_type' => [ 'image' ],
				],
			]
		);
		$this->add_control(
			'image_column_space_reset',
			[
				'label' => esc_html__( 'Reset Image Column Space', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'Never', 'impeka-elementor-extension' ),
					'tablet' => esc_html__( 'on 1200px and below', 'impeka-elementor-extension' ),
					'tablet-sm' => esc_html__( 'on 959px and below', 'impeka-elementor-extension' ),
					'mobile' => esc_html__( 'on 767px and below', 'impeka-elementor-extension' ),

				],
				'default' => '',
				'description' => esc_html__( 'Select if you want to reset the image size to auto in some devices.', 'impeka-elementor-extension' ),
				'conditions' => [
					'terms' => [
						[ 'name' => 'image_column_space', 'operator' => '!in', 'value' => [ 'auto', '100' ] ],
					],
				],
			]
		);
		$this->add_responsive_control( 'align', impeka_elementor_ext_add_responsive_align() );
		$this->add_control(
			'image_effect',
			[
				'label' => esc_html__( 'Image Effect', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'none' => esc_html__( 'None' , 'impeka-elementor-extension' ),
					'grayscale-image' => esc_html__( 'Grayscale Image' , 'impeka-elementor-extension' ),
					'grayscale-image-hover' => esc_html__( 'Colored on Hover' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Choose the grayscale effect.', 'impeka-elementor-extension' ),
				'default' => 'none',
			]
		);

		$this->add_control( 'shadow', impeka_elementor_ext_add_shadow() );
		$this->add_control(
			'radius',
			[
				'label' => esc_html__( 'Border Radius', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'none' => esc_html__( 'None' , 'impeka-elementor-extension' ),
					'3' => esc_html__( 'Radius 3px' , 'impeka-elementor-extension' ),
					'5' => esc_html__( 'Radius 5px' , 'impeka-elementor-extension' ),
					'10' => esc_html__( 'Radius 10px' , 'impeka-elementor-extension' ),
					'15' => esc_html__( 'Radius 15px' , 'impeka-elementor-extension' ),
					'20' => esc_html__( 'Radius 20px' , 'impeka-elementor-extension' ),
					'25' => esc_html__( 'Radius 25px' , 'impeka-elementor-extension' ),
					'30' => esc_html__( 'Radius 30px' , 'impeka-elementor-extension' ),
					'35' => esc_html__( 'Radius 35px' , 'impeka-elementor-extension' ),
					'circle' => esc_html__( 'Circle' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select your border radius', 'impeka-elementor-extension' ),
				'default' => 'none',
			]
		);
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

		//Extras Section
		$this->start_controls_section(
			'extras_section',
			[
				'label' => esc_html__( 'Extras', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'link_type',
			[
				'label' => esc_html__( 'Link Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'none' => esc_html__( 'None' , 'impeka-elementor-extension' ),
					'image-popup' => esc_html__( 'Image Popup' , 'impeka-elementor-extension' ),
					'video-popup' => esc_html__( 'Video Popup' , 'impeka-elementor-extension' ),
					'gallery-popup' => esc_html__( 'Gallery Popup' , 'impeka-elementor-extension' ),
					'custom-link' => esc_html__( 'Custom Link' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select the link type of your single image.', 'impeka-elementor-extension' ),
				'default' => 'none',
			]
		);
		$this->add_control(
			'image_popup_size',
			[
				'label' => esc_html__( 'Image Popup Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'large' => esc_html__( 'Large', 'impeka-elementor-extension' ),
					'extra-extra-large' => esc_html__( 'Extra Extra Large', 'impeka-elementor-extension' ),
					'full' => esc_html__( 'Full', 'impeka-elementor-extension' ),
				),
				'default' => 'extra-extra-large',
				'description' => esc_html__( "Select size for your popup image.", 'impeka-elementor-extension' ),
				'condition' => [
					'link_type' => [ 'image-popup', 'gallery-popup' ],
				],
			]
		);
		$this->add_control(
			'image_popup_title_caption',
			[
				'label' => esc_html__( 'Image Title & Description Visibility', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'none' => esc_html__( 'None' , 'impeka-elementor-extension' ),
					'title-caption' => esc_html__( 'Title and Description' , 'impeka-elementor-extension' ),
					'title-only' => esc_html__( 'Title Only' , 'impeka-elementor-extension' ),
					'caption-only' => esc_html__( 'Description Only' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Define the visibility for your popup image title - description.', 'impeka-elementor-extension' ),
				'default' => 'none',
			]
		);

		$this->add_control(
			'img_ids',
			[
				'label' => esc_html__( 'Attach Images', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'default' => [],
				'show_label' => false,
				'dynamic' => [
					'active' => false,
				],
				'description' => esc_html__( "Select your gallery images.", 'impeka-elementor-extension' ),
				'condition' => [
					'link_type' => [ 'gallery-popup' ],
				],
			]
		);

		$this->add_control(
			'video_link',
			[
				'label' => esc_html__( 'Video Link', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'condition' => [
					'link_type' => [ 'video-popup' ],
				],
			]
		);
		$this->add_control(
			'video_icon_color',
			[
				'label' => esc_html__( 'Video Icon Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['primary', 'gradient', 'standard'] ),
				'default' => 'primary-1',
				'description' => esc_html__( 'Color of the video icon.', 'impeka-elementor-extension' ),
				'condition' => [
					'link_type' => [ 'video-popup' ],
				],
			]
		);

		$this->add_control(
			'link',
			[
				'label' => esc_html__( 'Link', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
				'dynamic' => [
					'active' => false,
				],
				'placeholder' => 'https://your-link.com',
				'condition' => [
					'link_type' => [ 'custom-link' ],
				],
			]
		);
		$this->add_control(
			'link_class',
			[
				'label' => esc_html__( 'Link Class', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter a class for your link.", 'impeka-elementor-extension' ),
				'condition' => [
					'link_type' => [ 'custom-link' ],
				],
			]
		);

		$this->end_controls_section();

		//Titles and Hovers Section
		$this->start_controls_section(
			'styles_section',
			[
				'label' => esc_html__( 'Titles & Hovers', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'image_type' => [ 'image-content' ],
				],
			]
		);
		$this->add_control(
			'hover_style',
			[
				'label' => esc_html__( 'Hover Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'style-1' => esc_html__( 'Text below image' , 'impeka-elementor-extension' ),
					'style-2' => esc_html__( 'Split text on hover' , 'impeka-elementor-extension' ),
					'style-3' => esc_html__( 'Text on media' , 'impeka-elementor-extension' ),
					'style-4' => esc_html__( 'Tilt media on hover' , 'impeka-elementor-extension' ),
					'style-5' => esc_html__( 'Cursor effect' , 'impeka-elementor-extension' ),
					'style-6' => esc_html__( 'Mouse move effect' , 'impeka-elementor-extension' ),
					'style-7' => esc_html__( 'Gradient Overlay' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select the hover style for the gallery overview.', 'impeka-elementor-extension' ),
				'default' => 'style-1',
				'condition' => [
					'image_type' => [ 'image-content' ],
				],
			]
		);
		$this->add_control(
			'title_heading_tag',
			[
				'label' => esc_html__( 'Title Tag', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'div' => 'div',
				],
				'description' => esc_html__( 'Title Tag for SEO', 'impeka-elementor-extension' ),
				'default' => 'h3',
				'condition' => [
					'image_type' => [ 'image-content' ],
				],
			]
		);

		$this->add_control(
			'title_heading',
			[
				'label' => esc_html__( 'Title Size/Typography', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'small-text' => esc_html__( 'Small Text', 'impeka-elementor-extension' ),
					'link-text' => esc_html__( 'Link Text', 'impeka-elementor-extension' ),
				],
				'default' => 'h3',
				'description' => esc_html__( 'Title size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
				'condition' => [
					'image_type' => [ 'image-content' ],
				],
			]
		);

		$this->add_control(
			'title_custom_font_family',
			[
				'label' => esc_html__( 'Title Custom Font Family', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'Same as Typography', 'impeka-elementor-extension' ),
					'custom-font-1' => esc_html__( 'Custom Font Family 1', 'impeka-elementor-extension' ),
					'custom-font-2' => esc_html__( 'Custom Font Family 2', 'impeka-elementor-extension' ),
					'custom-font-3' => esc_html__( 'Custom Font Family 3', 'impeka-elementor-extension' ),
					'custom-font-4' => esc_html__( 'Custom Font Family 4', 'impeka-elementor-extension' ),


				],
				'default' => '',
				'description' => esc_html__( 'Select a different font family, defined in Theme Options - Typography Options - Extras - Custom Font Family', 'impeka-elementor-extension' ),
				'condition' => [
					'image_type' => [ 'image-content' ],
				],
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['default', 'primary', 'standard'] ),
				'default' => 'default',
				'description' => esc_html__( 'Choose the title color.', 'impeka-elementor-extension' ),
				'condition' => [
					'image_type' => [ 'image-content' ],
				],
			]
		);
		$this->add_control(
			'title_bg_color',
			[
				'label' => esc_html__( 'Title Background Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['transparent', 'primary', 'standard'] ),
				'default' => 'transparent',
				'description' => esc_html__( 'Choose the title background color.', 'impeka-elementor-extension' ),
				'condition' => [
					'hover_style' => [ 'style-5' ],
					'image_type' => [ 'image-content' ],
				],
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Description/Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['default', 'primary', 'standard'] ),
				'default' => 'default',
				'description' => esc_html__( 'Choose the description/text color.', 'impeka-elementor-extension' ),
				'condition' => [
					'image_type' => [ 'image-content' ],
				],
			]
		);
		$this->add_control(
			'text_bg_color',
			[
				'label' => esc_html__( 'Description/Text Background Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['transparent', 'primary', 'standard'] ),
				'default' => 'transparent',
				'description' => esc_html__( 'Choose the description/text background color.', 'impeka-elementor-extension' ),
				'condition' => [
					'hover_style' => [ 'style-5' ],
					'image_type' => [ 'image-content' ],
				],
			]
		);
		$this->add_control(
			'custom_title',
			[
				'label' => esc_html__( 'Title', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter your title.", 'impeka-elementor-extension' ),
				'condition' => [
					'image_type' => [ 'image-content' ],
				],
			]
		);
		$this->add_control(
			'custom_caption',
			[
				'label' => esc_html__( 'Caption', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter your caption.", 'impeka-elementor-extension' ),
				'condition' => [
					'image_type' => [ 'image-content' ],
				],
			]
		);

		$this->add_control(
			'overlay_color',
			[
				'label' => esc_html__( 'Overlay Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['primary', 'gradient', 'standard', 'dominant'] ),
				'description' => esc_html__( 'Choose the image color overlay.( Not available for Gradient Overlay).', 'impeka-elementor-extension' ),
				'default' => 'white',
				'condition' => [
					'image_type' => [ 'image-content' ],
				],
			]
		);

		$this->add_control(
			'overlay_opacity',
			[
				'label' => esc_html__( 'Overlay Opacity', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'0' => esc_html__( '0%', 'impeka-elementor-extension' ),
					'10' => esc_html__( '10%', 'impeka-elementor-extension' ),
					'20' => esc_html__( '20%', 'impeka-elementor-extension' ),
					'30' => esc_html__( '30%', 'impeka-elementor-extension' ),
					'40' => esc_html__( '40%', 'impeka-elementor-extension' ),
					'50' => esc_html__( '50%', 'impeka-elementor-extension' ),
					'60' => esc_html__( '60%', 'impeka-elementor-extension' ),
					'70' => esc_html__( '70%', 'impeka-elementor-extension' ),
					'80' => esc_html__( '80%', 'impeka-elementor-extension' ),
					'90' => esc_html__( '90%', 'impeka-elementor-extension' ),
					'100' => esc_html__( '100%', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Choose the opacity for the overlay.', 'impeka-elementor-extension' ),
				'default' => '90',
				'condition' => [
					'image_type' => [ 'image-content' ],
				],
			]
		);

		$this->end_controls_section();

		//Animation Section
		$this->start_controls_section(
			'animation_section',
			[
				'label' => esc_html__( 'Animation', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation_all() );
		$this->add_control( 'clipping_animation', impeka_elementor_ext_add_clipping() );
		$this->add_control( 'clipping_animation_colors', impeka_elementor_ext_add_clipping_colors( 'black' ) );
		$this->add_control( 'appear_animation', impeka_elementor_ext_add_appear() );
		$this->add_control( 'grve_animation_delay', impeka_elementor_ext_add_animation_delay() );
		$this->add_control( 'grve_animation_duration', impeka_elementor_ext_add_animation_duration() );
		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		echo impeka_elementor_ext_locate_template( 'image-single.php', array( 'atts' => $atts ) );
	}

}