<?php
/**
 * Impeka Elementor Team Widget.
 *
 * Elementor widget that inserts a team into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Team_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_team';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Team', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-team';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'team_layout',
			[
				'label' => esc_html__( 'Team Layout', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'layout-1' => esc_html__( 'Layout 1', 'impeka-elementor-extension' ),
					'layout-2' => esc_html__( 'Layout 2', 'impeka-elementor-extension' ),
					'layout-3' => esc_html__( 'Layout 3', 'impeka-elementor-extension' ),
					'layout-4' => esc_html__( 'Layout 4', 'impeka-elementor-extension' ),
				),
				'default' => 'layout-1',
				'description' => esc_html__( "Layout of the team.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'image_size',
			[
				'label' => esc_html__( 'Image Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => apply_filters( 'impeka_elementor_ext_image_options', array(
					''  => esc_html__( 'Full', 'impeka-elementor-extension' ),
					'square'  => esc_html__( 'Square Small Crop', 'impeka-elementor-extension' ),
					'landscape'  => esc_html__( 'Landscape Small Crop', 'impeka-elementor-extension' ),
					'portrait'  => esc_html__( 'Portrait Small Crop', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Resize ( Large )', 'impeka-elementor-extension' ),
					'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka-elementor-extension' ),
					'medium' => esc_html__( 'Resize ( Medium )', 'impeka-elementor-extension' ),
				) ),
				'default' => '',
				'description' => esc_html__( "Select your Image Size.", 'impeka-elementor-extension' ),
				'condition' => [
					'team_layout' => [ 'layout-1', 'layout-2' ],
				],
			]
		);
		$this->add_control(
			'image',
			[
				'label' => esc_html__( 'Image', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => false,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( "Select your image.", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'retina_image',
			[
				'label' => esc_html__( 'Retina Image', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => false,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( "Select a 2x image.", 'impeka-elementor-extension' ),
				'condition' => [
					'image_size' => [ '' ],
				],
			]
		);
		$this->add_control(
			'image_load_mode',
			[
				'label' => esc_html__( 'Image Load Mode', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Inherit', 'impeka-elementor-extension' ),
					'off' => esc_html__( 'Off', 'impeka-elementor-extension' ),
					'native-lazyload' => esc_html__( 'Native Lazyload', 'impeka-elementor-extension' ),
					'lazyload' => esc_html__( 'Theme Lazyload', 'impeka-elementor-extension' ),
				),
				'default' => '',
				'description' => esc_html__( "Enable Lazy load.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'image_effect',
			[
				'label' => esc_html__( 'Image Effect', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'none' => esc_html__( 'None' , 'impeka-elementor-extension' ),
					'grayscale-image' => esc_html__( 'Grayscale Image' , 'impeka-elementor-extension' ),
					'grayscale-image-hover' => esc_html__( 'Colored on Hover' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Choose the grayscale effect.', 'impeka-elementor-extension' ),
				'default' => 'none',
			]
		);

		$this->add_control(
			'image_animation_effect',
			[
				'label' => esc_html__( 'Image Animation Effect', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'None' , 'impeka-elementor-extension' ),
					'mouse-move' => esc_html__( 'Mouse Move' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Choose the image animation effect.', 'impeka-elementor-extension' ),
				'default' => 'mouse-move',
			]
		);
		$this->add_control(
			'name',
			[
				'label' => esc_html__( 'Name', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'John Smith',
				'description' => esc_html__( 'Enter your team name.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'name_color',
			[
				'label' => esc_html__( 'Name Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
				'default' => 'inherit',
				'description' => esc_html__( 'Choose the name color.', 'impeka-elementor-extension' ),
				'condition' => [
					'team_layout' => [ 'layout-1', 'layout-3', 'layout-4'  ],
				],
			]
		);
		$this->add_control( 'heading_tag', impeka_elementor_ext_add_heading_tag( 'h3' ) );
		$this->add_control( 'heading', impeka_elementor_ext_add_heading( 'h5' ) );
		$this->add_control( 'custom_font_family', impeka_elementor_ext_add_custom_font_family() );

		$this->add_control(
			'identity',
			[
				'label' => esc_html__( 'Identity', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( 'Enter your team identity/profession e.g: Designer', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'identity_color',
			[
				'label' => esc_html__( 'Identity Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
				'default' => 'inherit',
				'description' => esc_html__( 'Choose the identity color.', 'impeka-elementor-extension' ),
				'condition' => [
					'team_layout' => [ 'layout-1', 'layout-3', 'layout-4'  ],
				],
			]
		);
		$this->add_control(
			'shadow',
			[
				'label' => esc_html__( 'Shadow', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'No' , 'impeka-elementor-extension' ),
					'small-shadow' => esc_html__( 'Small' , 'impeka-elementor-extension' ),
					'medium-shadow' => esc_html__( 'Medium' , 'impeka-elementor-extension' ),
					'large-shadow' => esc_html__( 'Large' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select your shadow', 'impeka-elementor-extension' ),
				'default' => '',
				'condition' => [
					'team_layout' => [ 'layout-1', 'layout-2' ],
				],
			]
		);

		$this->add_control(
			'radius',
			[
				'label' => esc_html__( 'Border Radius', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'none' => esc_html__( 'None' , 'impeka-elementor-extension' ),
					'3' => esc_html__( 'Radius 3px' , 'impeka-elementor-extension' ),
					'5' => esc_html__( 'Radius 5px' , 'impeka-elementor-extension' ),
					'10' => esc_html__( 'Radius 10px' , 'impeka-elementor-extension' ),
					'15' => esc_html__( 'Radius 15px' , 'impeka-elementor-extension' ),
					'20' => esc_html__( 'Radius 20px' , 'impeka-elementor-extension' ),
					'25' => esc_html__( 'Radius 25px' , 'impeka-elementor-extension' ),
					'30' => esc_html__( 'Radius 30px' , 'impeka-elementor-extension' ),
					'35' => esc_html__( 'Radius 35px' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select your border radius', 'impeka-elementor-extension' ),
				'default' => 'none',
				'condition' => [
					'team_layout' => [ 'layout-1', 'layout-2' ],
				],
			]
		);

		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();


		//Socials Section
		$this->start_controls_section(
			'socials_section',
			[
				'label' => esc_html__( 'Socials', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'team_layout' => [ 'layout-1', 'layout-2' ],
				],
			]
		);

		$this->add_control(
			'social_facebook',
			[
				'label' => esc_html__( 'Facebook', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter facebook URL. Clear input if you don't want to display.", 'impeka-elementor-extension' ),
				'condition' => [
					'team_layout' => [ 'layout-1', 'layout-2' ],
				],
			]
		);
		$this->add_control(
			'social_twitter',
			[
				'label' => esc_html__( 'Twitter', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter Twitter URL. Clear input if you don't want to display.", 'impeka-elementor-extension' ),
				'condition' => [
					'team_layout' => [ 'layout-1', 'layout-2' ],
				],
			]
		);
		$this->add_control(
			'social_linkedin',
			[
				'label' => esc_html__( 'Linkedin', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter Linkedin URL. Clear input if you don't want to display.", 'impeka-elementor-extension' ),
				'condition' => [
					'team_layout' => [ 'layout-1', 'layout-2' ],
				],
			]
		);
		$this->add_control(
			'social_xing',
			[
				'label' => esc_html__( 'Xing', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter Xing URL. Clear input if you don't want to display.", 'impeka-elementor-extension' ),
				'condition' => [
					'team_layout' => [ 'layout-1', 'layout-2' ],
				],
			]
		);
		$this->add_control(
			'social_instagram',
			[
				'label' => esc_html__( 'Instagram', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter Instagram URL. Clear input if you don't want to display.", 'impeka-elementor-extension' ),
				'condition' => [
					'team_layout' => [ 'layout-1', 'layout-2' ],
				],
			]
		);
		$this->add_control(
			'social_youtube',
			[
				'label' => esc_html__( 'YouTube', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter YouTube URL. Clear input if you don't want to display.", 'impeka-elementor-extension' ),
				'condition' => [
					'team_layout' => [ 'layout-1', 'layout-2' ],
				],
			]
		);
		$this->add_control(
			'social_vimeo',
			[
				'label' => esc_html__( 'Vimeo', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter Vimeo URL. Clear input if you don't want to display.", 'impeka-elementor-extension' ),
				'condition' => [
					'team_layout' => [ 'layout-1', 'layout-2' ],
				],
			]
		);
		$this->add_control(
			'email',
			[
				'label' => esc_html__( 'Email', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter your email. Clear input if you don't want to display.", 'impeka-elementor-extension' ),
				'condition' => [
					'team_layout' => [ 'layout-1', 'layout-2' ],
				],
			]
		);
		
		$this->end_controls_section();
		
		//Link Section
		$this->start_controls_section(
			'link_section',
			[
				'label' => esc_html__( 'Link', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'link',
			[
				'label' => esc_html__( 'Link', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
				'dynamic' => [
					'active' => false,
				],
				'placeholder' => 'https://your-link.com',
			]
		);
		$this->add_control(
			'link_class',
			[
				'label' => esc_html__( 'Link Class', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter a class for your link.", 'impeka-elementor-extension' ),
			]
		);

		$this->end_controls_section();

		//Animation Section
		$this->start_controls_section(
			'animation_section',
			[
				'label' => esc_html__( 'Animation', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation() );
		$this->add_control( 'grve_animation_delay', impeka_elementor_ext_add_animation_delay() );
		$this->add_control( 'grve_animation_duration', impeka_elementor_ext_add_animation_duration() );
		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		echo impeka_elementor_ext_locate_template( 'team.php', array( 'atts' => $atts ) );
	}

}