<?php
/**
 * Impeka Elementor Testimonial Widget.
 *
 * Elementor widget that inserts a testimonial grid into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Testimonial_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_testimonial';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Testimonial', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-testimonial';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'mode',
			[
				'label' => esc_html__( 'Testimonial Mode', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'masonry' => esc_html__( 'Masonry', 'impeka-elementor-extension' ),
					'grid' => esc_html__( 'Grid', 'impeka-elementor-extension' ),
				],
				'default' => 'masonry',
				'description' => esc_html__( "Select your Testimonial Mode.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'columns_large_screen',
			[
				'label' => esc_html__( 'Large Screen Columns', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'default' => '3',
				'description' => esc_html__( "Select your Testimonial Columns", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'columns',
			[
				'label' => esc_html__( 'Columns', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'default' => '3',
				'description' => esc_html__( "Select your Testimonial Columns", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'columns_tablet_landscape',
			[
				'label' => esc_html__( 'Tablet Landscape Columns', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'default' => '2',
				'description' => esc_html__( "Select responsive column on tablet devices, landscape orientation.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'columns_tablet_portrait',
			[
				'label' => esc_html__( 'Tablet Portrait Columns', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'default' => '2',
				'description' => esc_html__( "Select responsive column on tablet devices, portrait orientation.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'columns_mobile',
			[
				'label' => esc_html__( 'Mobile Columns', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
				],
				'default' => '1',
				'description' => esc_html__( "Select responsive column on mobile devices.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'item_gutter',
			[
				'label' => esc_html__( 'Gutter between items', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'gutter_size',
			[
				'label' => esc_html__( 'Gutter Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '40',
				'condition' => [
					'item_gutter' => [ 'yes' ],
				],
			]
		);
		$this->add_control( 'order_by', impeka_elementor_ext_add_order_by() );
		$this->add_control( 'order', impeka_elementor_ext_add_order() );
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation() );
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );


		$this->add_control(
			'el_id',
			[
				'label' => esc_html__( 'Element ID', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter element ID (Note: make sure it is unique)', 'impeka-elementor-extension' ),
				'default' => $this->get_id(),
			]
		);
		$this->end_controls_section();

		//Styles and Titles Section
		$this->start_controls_section(
			'styles_section',
			[
				'label' => esc_html__( 'Styles & Titles', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'style',
			[
				'label' => esc_html__( 'Testimonial Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'style-4' => esc_html__( 'Style 4' , 'impeka-elementor-extension' ),
					'style-5' => esc_html__( 'Style 5' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select the hover style for the testimonial overview.', 'impeka-elementor-extension' ),
				'default' => 'style-4',
			]
		);
		$this->add_control(
			'show_title',
			[
				'label' => esc_html__( 'Show Item Title', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'no' => esc_html__( 'No' , 'impeka-elementor-extension' ),
					'yes' => esc_html__( 'Yes' , 'impeka-elementor-extension' ),
				],
				'default' => 'yes',
			]
		);

		$this->add_control(
			'heading_tag',
			[
				'label' => esc_html__( 'Title Tag', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'div' => 'div',
				],
				'description' => esc_html__( 'Title Tag for SEO', 'impeka-elementor-extension' ),
				'default' => 'h3',
				'condition' => [
					'show_title' => [ 'yes' ],
				],
			]
		);

		$this->add_control(
			'heading',
			[
				'label' => esc_html__( 'Title Size/Typography', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'small-text' => esc_html__( 'Small Text', 'impeka-elementor-extension' ),
					'link-text' => esc_html__( 'Link Text', 'impeka-elementor-extension' ),
					'page-title' => esc_html__( 'Page Title', 'impeka-elementor-extension' ),
					'feature-title' => esc_html__( 'Feature Title', 'impeka-elementor-extension' ),
				],
				'default' => 'h3',
				'description' => esc_html__( 'Title size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
				'condition' => [
					'show_title' => [ 'yes' ],
				],
			]
		);

		$this->add_control(
			'text_style',
			[
				'label' => esc_html__( 'Text Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'none' => esc_html__( 'None', 'impeka-elementor-extension' ),
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'small-text' => esc_html__( 'Small Text', 'impeka-elementor-extension' ),
					'quote-text' => esc_html__( 'Quote Text', 'impeka-elementor-extension' ),
				],
				'default' => 'none',
				'description' => esc_html__( 'Text size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'show_image',
			[
				'label' => esc_html__( 'Show Featured Image', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'no' => esc_html__( 'No' , 'impeka-elementor-extension' ),
					'yes' => esc_html__( 'Yes' , 'impeka-elementor-extension' ),
				],
				'default' => 'yes',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'black',
				'description' => esc_html__( 'Choose the title color.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['default', 'primary', 'standard'] ),
				'default' => 'black',
				'description' => esc_html__( 'Choose the text color.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'bg_color',
			[
				'label' => esc_html__( 'Background Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'white',
				'description' => esc_html__( 'Choose the text color.', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control( 'shadow', impeka_elementor_ext_add_shadow() );
		$this->add_control( 'radius', impeka_elementor_ext_add_radius() );

		$this->end_controls_section();

		//Pagination & Extras
		$this->start_controls_section(
			'pagination_extras_section',
			[
				'label' => esc_html__( 'Pagination & Extras', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'label_pagination',
			[
				'label' => esc_html__( 'Pagination', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'description' => esc_html__( 'Define the items to show per page or the total items number according to the selected display style.', 'impeka-elementor-extension' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'posts_per_page',
			[
				'label' => esc_html__( 'Items per Page', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '20',
				'description' => esc_html__( 'Enter how many items per page you want to display.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'display_style',
			[
				'label' => esc_html__( 'Display Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'Show All', 'impeka-elementor-extension' ),
					'pagination' => esc_html__( 'Pagination', 'impeka-elementor-extension' ),
					'load-more' => esc_html__( 'Load More', 'impeka-elementor-extension' ),
					'infinite-scroll' => esc_html__( 'Infinite Scroll', 'impeka-elementor-extension' ),
				],
				'default' => 'pagination',
				'description' => esc_html__( 'Select Show All or define your pagination style.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'load_more_title',
			[
				'label' => esc_html__( 'Load More Title', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Title for load more.', 'impeka-elementor-extension' ),
				'default' => 'Load More',
				'condition' => [
					'display_style' => [ 'load-more' ],
				],
			]
		);

		$this->end_controls_section();

		//Categories
		$this->start_controls_section(
			'categories_section',
			[
				'label' => esc_html__( 'Categories', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'exclude_posts',
			[
				'label' => esc_html__( 'Exclude Posts', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Type the post ids you want to exclude separated by comma ( , ).', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);
		$this->add_control(
			'categories',
			[
				'label' => esc_html__( 'Testimonial Categories', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => impeka_elementor_ext_get_post_categories( 'testimonial_category' ),
				"description" => esc_html__( 'Select all or multiple categories, leave empty for all.', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);
		$this->add_control(
			'include_posts',
			[
				'label' => esc_html__( 'Include Specific Posts', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);
		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		echo impeka_elementor_ext_locate_template( 'testimonial.php', array( 'atts' => $atts ) );
	}

}