jQuery(document).ready(function($) {

	"use strict";

	if( 0 !== $('.grve-typekit-font-normal').length ) {
		$('.grve-delete-typekit-fonts-button').show();
	}

	//Upload Font
	var grveFontFrame;
	var grveFontID;
	var grveFontUpload;
	var grveFontMime;

	$(document).on("click",".grve-upload-remove-font",function(e) {
		e.preventDefault();
		$(this).parent().find('.grve-font-id').val('');
		$(this).parent().find('.grve-upload-font').removeClass('active');
		$(this).removeClass('button-primary');
		$(this).hide();
	});

	$(document).on("click",".grve-upload-font",function() {

		grveFontUpload = $(this);
		grveFontID = $(this).parent().find('.grve-font-id');
		grveFontMime = $(this).data('mime');

        grveFontFrame = wp.media.frames.grveFontFrame = wp.media({
            className: 'media-frame grve-font-frame',
            frame: 'select',
            multiple: false,
            title: "Upload Font",
            library: {
                type: grveFontMime
            },
            button: {
                text:  "Upload Font"
            }
        });

        grveFontFrame.on('select', function(){
			var selection = grveFontFrame.state().get('selection');
			var id = selection.pluck('id');
			grveFontID.val( id.toString() );
			grveFontID.change();
			grveFontUpload.addClass('active');
			grveFontUpload.parent().find('.grve-upload-remove-font').css('display','inline-block');;
        });

        grveFontFrame.open();
	});

	//Fonts lists
	if( 0 === $('.grve-custom-font-normal').length ) {
		$('.grve-custom-font-empty').show();
	}
	if( 0 === $('.grve-userdefined-font-normal').length ) {
		$('.grve-userdefined-font-empty').show();
	}


	$(document).on("click",".grve-fonts-submit-button",function() {
		$('#grve-custom-fonts-form').submit();
	});

    //Custom Fonts
	$(document).on("click",".grve-custom-font-item-delete-button",function() {
		$(this).parents('.grve-custom-font-item').remove();
		if( 0 === $('.grve-custom-font-normal').length ) {
			$('.grve-custom-font-empty').show();
		}
		$('#grve-custom-fonts-form').submit();
	});

	$(document).on("click","#grve-add-custom-font-item",function(event) {
		event.preventDefault();
		$('.grve-font-wrap .button').attr('disabled','disabled').addClass('disabled');
		$('.grve-font-notice-empty').hide();
		$('.grve-font-notice-exists').hide();

		var fontFileEOT = $('#grve-custom-font-eot').val(),
			fontFileTTF = $('#grve-custom-font-ttf').val(),
			fontFileWOFF = $('#grve-custom-font-woff').val(),
			fontFileWOFF2 = $('#grve-custom-font-woff2').val(),
			fontName = $('#grve-custom-font-item-name-new').val();

		if ( '' == $.trim(fontName) ) {
			$('.grve-font-notice-empty').show();
			$('.grve-font-wrap .button').removeAttr('disabled').removeClass('disabled');
			$('#grve-custom-font-item-name-new').addClass('grve-validation-error');
		} else {

			var alreadyExists = false;
			var noUploadedFonts = true;

			$('.grve-font-wrap .grve-custom-font-item-name').each(function () {
				if( $(this).val() == fontName ) {
					alreadyExists = true;
					return false;
				}
			});

			$('.grve-font-wrap .grve-font-id').each(function () {
				if( $(this).val() != '' ) {
					noUploadedFonts = false;
					return false;
				}
			});

			if ( alreadyExists ) {
				$('.grve-font-notice-exists').show();
				$('.grve-font-wrap .button').removeAttr('disabled').removeClass('disabled');
				$('#grve-custom-font-item-name-new').addClass('grve-validation-error');
			} else if ( noUploadedFonts ) {
				$('.grve-font-notice-no-uploaded-files').show();
				$('.grve-font-wrap .button').removeAttr('disabled').removeClass('disabled');
			} else {
				var dataParams = {
					action:'impeka_ext_get_custom_font',
					font_name: fontName,
					font_file_eot: fontFileEOT,
					font_file_ttf: fontFileTTF,
					font_file_woff: fontFileWOFF,
					font_file_woff2: fontFileWOFF2,
					_grve_nonce: impeka_ext_custom_font_texts.nonce_custom_font
				};
				$.post( impeka_ext_custom_font_texts.ajaxurl, dataParams, function( fontHtml ) {
					$('#grve-custom-font-container').append(fontHtml);
					$('#grve-custom-font-item-name-new').val('');

					$('.grve-font-wrap .grve-upload-remove-font').each(function () {
						$(this).parent().find('.grve-font-id').val('');
						$(this).parent().find('.grve-upload-font').removeClass('active');
						$(this).hide();
					});
					$('.grve-font-wrap .button').removeAttr('disabled').removeClass('disabled');
					if( 0 !== $('.grve-custom-font-normal').length ) {
						$('.grve-custom-font-empty').hide();
					}
					$('#grve-custom-fonts-form').submit();
				}).fail(function(xhr, status, error) {
					$('.grve-font-wrap .button').removeAttr('disabled').removeClass('disabled');
				});
			}
		}
	});

   //User Defined Fonts
	$(document).on("click",".grve-userdefined-font-item-delete-button",function() {
		$(this).parents('.grve-userdefined-font-item').remove();
		if( 0 === $('.grve-userdefined-font-normal').length ) {
			$('.grve-userdefined-font-empty').show();
		}
		$('#grve-custom-fonts-form').submit();
	});

	$(document).on("click","#grve-add-userdefined-font-item",function(event) {
		event.preventDefault();
		$('.grve-font-wrap .button').attr('disabled','disabled').addClass('disabled');
		$('.grve-userdefined-notice-empty').hide();
		$('.grve-userdefined-notice-exists').hide();
		$('.grve-userdefined-notice-save').hide();

		var fontName = $('#grve-userdefined-font-item-name-new').val();

		if ( '' == $.trim(fontName) ) {
			$('.grve-userdefined-notice-empty').show();
			$('.grve-font-wrap .button').removeAttr('disabled').removeClass('disabled');
			$('#grve-userdefined-font-item-name-new').addClass('grve-validation-error');
		} else {

			var alreadyExists = false;

			$('#grve-fonts-tab-userdefined .grve-userdefined-font-item-name').each(function () {
				if( $(this).val() == fontName ) {
					alreadyExists = true;
					return false;
				}
			});

			if ( alreadyExists ) {
				$('.grve-userdefined-notice-exists').show();
				$('.grve-font-wrap .button').removeAttr('disabled').removeClass('disabled');
				$('#grve-userdefined-font-item-name-new').addClass('grve-validation-error');
			} else {
				var dataParams = {
					action:'impeka_ext_get_userdefined_font',
					font_name: fontName,
					_grve_nonce: impeka_ext_custom_font_texts.nonce_userdefined_font
				};
				$.post( impeka_ext_custom_font_texts.ajaxurl, dataParams, function( fontHtml ) {
					$('#grve-userdefined-font-container').append(fontHtml);
					$('#grve-userdefined-font-item-name-new').val('');

					$('.grve-userdefined-notice-empty').hide();
					$('.grve-userdefined-notice-exists').hide();
					$('.grve-font-wrap .button').removeAttr('disabled').removeClass('disabled');
					if( 0 !== $('.grve-userdefined-font-normal').length ) {
						$('.grve-userdefined-font-empty').hide();
					}
					$('.grve-userdefined-notice-save').show();
				}).fail(function(xhr, status, error) {
					$('.grve-font-wrap .button').removeAttr('disabled').removeClass('disabled');
				});
			}
		}
	});

	$(document).on("click","#grve-scan-typekit-fonts",function(event) {
		event.preventDefault();
		$('.grve-typekit-id-notice-empty').hide();
		$('.grve-typekit-key-notice-empty').hide();

		var typekitID = $('#grve-font-typekit-id').val(),
			typekitAPIKey = $('#grve-font-typekit-api-key').val();

		if ( '' == $.trim(typekitID) ) {
			$('.grve-typekit-id-notice-empty').show();
			return;
		}
		if ( '' == $.trim(typekitAPIKey) ) {
			$('.grve-typekit-key-notice-empty').show();
			return;
		}

		var dataParams = {
			action:'impeka_ext_scan_typekit_fonts',
			typekitID: typekitID,
			typekitAPIKey: typekitAPIKey,
			_grve_nonce: impeka_ext_custom_font_texts.nonce_typekit_font
		};
		$.post( impeka_ext_custom_font_texts.ajaxurl, dataParams, function( fontHtml ) {
			$('#grve-typekit-font-container').html(fontHtml);
			if( 0 !== $('.grve-typekit-font-normal').length ) {
				$('.grve-typekit-font-empty').hide();
				$('.grve-delete-typekit-fonts-button').hide();
			}
			$('#grve-custom-fonts-form').submit();
		}).fail(function(xhr, status, error) {
			$('.grve-delete-typekit-fonts-button').show();
		});
	});

	$(document).on("click",".grve-delete-typekit-fonts-button",function(event) {
		event.preventDefault();
		$('#grve-font-typekit-id').val("");
		$('#grve-custom-fonts-form').submit();
	});

	$( "#grve-custom-font-container" ).sortable();
	$( "#grve-userdefined-font-container" ).sortable();
	$('.grve-font-saved').delay(4000).slideUp();

	// TABS METABOXES
	$(document).on("click",".grve-tabs .grve-tab-links a",function(e) {
		var currentAttrValue = $(this).attr('href');
		$('.grve-tabs ' + currentAttrValue).show().siblings().hide();
		$(this).parent('li').addClass('active').siblings().removeClass('active');
		e.preventDefault();
	});


});