<?php
/*
 * Plugin Name: Impeka Core Extension
 * Description: This plugin adds custom post type capabilities and widgets.
 * Author: Greatives Team
 * Author URI: http://greatives.eu
 * Version: 1.3.6
 * Text Domain: impeka-extension
 */

if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! defined( 'IMPEKA_EXT_VERSION' ) ) {
	define( 'IMPEKA_EXT_VERSION', '1.3.6' );
}

if ( ! defined( 'IMPEKA_EXT_PLUGIN_DIR_PATH' ) ) {
	define( 'IMPEKA_EXT_PLUGIN_DIR_PATH', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'IMPEKA_EXT_PLUGIN_DIR_URL' ) ) {
	define( 'IMPEKA_EXT_PLUGIN_DIR_URL', plugin_dir_url( __FILE__ ) );
}

if ( ! class_exists( 'Impeka_Extension_Plugin' ) ) {

	class Impeka_Extension_Plugin {

		/**
		 * @action plugins_loaded
		 * @return Impeka_Extension_Plugin
		 * @static
		 */
		public static function init()
		{

			static $instance = false;

			if ( ! $instance ) {
				load_plugin_textdomain( 'impeka-extension' , false , dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
				$instance = new Impeka_Extension_Plugin;
			}
			return $instance;

		}

		private function __construct() {
			if ( is_user_logged_in() ) {
				add_action( 'admin_enqueue_scripts' , $this->marshal( 'impeka_ext_add_scripts' ) );
			}
			add_action( 'wp_enqueue_scripts' , $this->marshal( 'impeka_ext_add_front_end_scripts' ) );
			require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'includes/impeka-ext-metaboxes.php';

			require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'shortcodes/impeka_privacy_gtracking.php';
			require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'shortcodes/impeka_privacy_gmaps.php';
			require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'shortcodes/impeka_privacy_gfonts.php';
			require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'shortcodes/impeka_privacy_video_embeds.php';
			require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'shortcodes/impeka_privacy_required.php';
			require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'shortcodes/impeka_privacy_custom.php';
			require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'shortcodes/impeka_privacy_policy_page_link.php';
			require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'shortcodes/impeka_privacy_preferences_link.php';
			require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'shortcodes/impeka_misc_shortcodes.php';

			/**
			 * Remove Emoji scripts/styles
			 */
			if ( function_exists( 'impeka_grve_option' ) && '0' == impeka_grve_option( 'print_emoji', '1' ) ) {
				remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
				remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
				remove_action( 'wp_print_styles', 'print_emoji_styles' );
				remove_action( 'admin_print_styles', 'print_emoji_styles' );
			}

		}

		public function Impeka_Extension_Plugin() {
			$this->__construct();
		}

		public function impeka_ext_add_scripts( $hook ) {
			wp_register_script( 'impeka-ext-codes-script', IMPEKA_EXT_PLUGIN_DIR_URL .'/assets/js/impeka-ext-codes.js', array( 'jquery'), time(), false );
			wp_register_script( 'impeka-ext-custom-fonts-script', IMPEKA_EXT_PLUGIN_DIR_URL . '/assets/js/impeka-ext-custom-fonts.js', array( 'jquery'), time(), false );
			wp_register_script( 'impeka-ext-modals-script', IMPEKA_EXT_PLUGIN_DIR_URL . '/assets/js/impeka-ext-modals.js', array( 'jquery'), time(), false );
			$impeka_ext_custom_font_texts = array(
				'ajaxurl' => esc_url( admin_url( 'admin-ajax.php' ) ),
				'nonce_custom_font' => wp_create_nonce( 'impeka-ext-get-custom-font' ),
				'nonce_userdefined_font' => wp_create_nonce( 'impeka-ext-get-userdefined-font' ),
				'nonce_typekit_font' => wp_create_nonce( 'impeka-ext-scan-typekit-font' ),
			);

			wp_localize_script( 'impeka-ext-custom-fonts-script', 'impeka_ext_custom_font_texts', $impeka_ext_custom_font_texts );
			$modal_texts = array(
				'ajaxurl' => esc_url( admin_url( 'admin-ajax.php' ) ),
				'nonce_custom_modal' => wp_create_nonce( 'impeka-grve-get-custom-modal' ),
			);
			wp_localize_script( 'impeka-ext-modals-script', 'impeka_ext_custom_modal_texts', $modal_texts );

			if ( isset( $_GET['page'] ) && ( 'impeka-codes' == $_GET['page'] ) ) {
				wp_enqueue_style( 'impeka-grve-admin-panel' );
				wp_enqueue_code_editor( array( 'type' => 'text/html' ) );
				wp_enqueue_script( 'impeka-ext-codes-script' );
			}
			if ( isset( $_GET['page'] ) && ( 'impeka-modals' == $_GET['page'] ) ) {
				wp_enqueue_style( 'impeka-grve-admin-panel' );
				wp_enqueue_script( 'jquery-ui-sortable' );
				wp_enqueue_script( 'impeka-ext-modals-script' );
			}
			if ( isset( $_GET['page'] ) && ( 'impeka-fonts' == $_GET['page'] ) ) {
				wp_enqueue_media();
				wp_enqueue_style( 'impeka-grve-admin-panel' );
				wp_enqueue_code_editor( array( 'type' => 'text/css' ) );
				wp_enqueue_script( 'jquery-ui-sortable' );
				wp_enqueue_script( 'impeka-ext-custom-fonts-script' );
			}
		}

		public function impeka_ext_add_front_end_scripts() {
		}

		public function marshal( $method_name ) {
			return array( &$this , $method_name );
		}
	}

	/**
	 * Initialize the Extension Plugin
	 */
	add_action( 'init' , array( 'Impeka_Extension_Plugin' , 'init' ), 12 );


	/**
	 * Initialize Custom Post Types
	 */
	function impeka_ext_rewrite_flush() {
		impeka_ext_register_custom_post_init();
		flush_rewrite_rules();
	}
	register_activation_hook( __FILE__, 'impeka_ext_rewrite_flush' );

	function impeka_ext_register_custom_post_init() {
		require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'includes/impeka-portfolio-post-type.php';
		require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'includes/impeka-testimonial-post-type.php';
		require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'includes/impeka-area-item-post-type.php';
	}
	add_action( 'init', 'impeka_ext_register_custom_post_init', 9 );

	function impeka_ext_body_class( $classes ){
		$impeka_ext_ver = 'grve-ext-ver-' . IMPEKA_EXT_VERSION;
		return array_merge( $classes, array( $impeka_ext_ver ) );
	}
	add_filter( 'body_class', 'impeka_ext_body_class' );

	require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'includes/impeka-ext-global-functions.php';

	/**
	 * Include Theme Widgets
	 */
	function impeka_ext_register_widgets() {
		require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'widgets/grve-widget-contact-info.php';
		require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'widgets/grve-widget-latest-comments.php';
		require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'widgets/grve-widget-latest-portfolio.php';
		require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'widgets/grve-widget-latest-posts.php';
		require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'widgets/grve-widget-social.php';
		require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'widgets/grve-widget-social-list.php';
		require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'widgets/grve-widget-sticky.php';
		register_widget( 'Impeka_Ext_Widget_Contact_Info' );
		register_widget( 'Impeka_Ext_Widget_Latest_Comments' );
		register_widget( 'Impeka_Ext_Widget_Latest_Portfolio' );
		register_widget( 'Impeka_Ext_Widget_Latest_Posts' );
		register_widget( 'Impeka_Ext_Widget_Social' );
		register_widget( 'Impeka_Ext_Widget_Social_List' );
		register_widget( 'Impeka_Ext_Widget_Sticky' );
	}
	add_action( 'widgets_init', 'impeka_ext_register_widgets' );

	/**
	 *Admin Menu
	 */
	require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'includes/admin/impeka-ext-admin-modals.php';
	require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'includes/admin/impeka-ext-admin-font-manager.php';
	require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'includes/admin/impeka-ext-admin-functions.php';
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
