<?php
/*
*	Admin Modals
*
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

	function impeka_grve_add_modal_settings() {

		if ( isset( $_POST['_impeka_grve_nonce_modal_save'] ) && wp_verify_nonce( $_POST['_impeka_grve_nonce_modal_save'], 'impeka_grve_nonce_modal_save' ) ) {

			$modals_items = array();
			if( isset( $_POST['_impeka_grve_custom_modal_item_id'] ) ) {
				$num_of_modals = sizeof( $_POST['_impeka_grve_custom_modal_item_id'] );
				for ( $i=0; $i < $num_of_modals; $i++ ) {
					$this_modal = array (
						'modal_id' => sanitize_text_field( $_POST['_impeka_grve_custom_modal_item_id'][ $i ] ),
						'modal_mode' => sanitize_text_field( $_POST['_impeka_grve_custom_modal_item_mode'][ $i ] ),
						'modal_trigger' => sanitize_text_field( $_POST['_impeka_grve_custom_modal_item_trigger'][ $i ] ),
						'modal_reset' => sanitize_text_field( $_POST['_impeka_grve_custom_modal_item_reset'][ $i ] ),
						'area_id' => sanitize_text_field( $_POST['_impeka_grve_custom_modal_item_area_id'][ $i ] ),
					);
					array_push( $modals_items, $this_modal );
				}
			}
			if ( empty( $modals_items ) ) {
				delete_option( '_impeka_grve_custom_modals' );
			} else {
				update_option( '_impeka_grve_custom_modals', $modals_items );
			}
			//Update Modal list
			wp_safe_redirect( 'admin.php?page=impeka-modals&modal-settings=saved' );

		}
	}

	add_action( 'admin_menu', 'impeka_grve_add_modal_settings' );

	function  impeka_grve_print_admin_custom_modals( $custom_modals ) {
		if ( ! empty( $custom_modals ) ) {
			foreach ( $custom_modals as $custom_modal ) {
				impeka_grve_print_admin_single_custom_modal( $custom_modal );
			}
		}
	}

	function  impeka_grve_print_admin_single_custom_modal( $modal_item, $mode = '' ) {

		$button_class = "grve-custom-modal-item-delete-button grve-delete-btn";
		$modal_item_id = uniqid('grve-modal-');

		if( $mode = "new" ) {
			$button_class = "grve-custom-modal-item-delete-button grve-delete-btn grve-item-new";
		}
		$modal_id = impeka_ext_array_value( $modal_item, 'modal_id', $modal_item_id );
		$modal_mode = impeka_ext_array_value( $modal_item, 'modal_mode' );
		$modal_trigger = impeka_ext_array_value( $modal_item, 'modal_trigger' );
		$modal_reset = impeka_ext_array_value( $modal_item, 'modal_reset', '1' );
		$modal_area_id = impeka_ext_array_value( $modal_item, 'area_id' );

		$area_item_options = array();
		if ( function_exists( 'impeka_grve_global_admin_param' ) ) {
			$area_item_options = impeka_grve_global_admin_param( 'area_item_selection' );
		}
		$reset_disabled = false;
		if ( '' == $modal_trigger ) {
			$reset_disabled = true;
		}
?>

	<tr class="grve-custom-modal-item grve-custom-modal-normal">
		<td class="grve-label-wrapper">
			<h4 class="grve-table-label">#<?php echo esc_attr( $modal_id ); ?></h4>
			<div class="grve-custom-modal-settings">
				<input type="hidden" class="grve-custom-modal-item-id" name="_impeka_grve_custom_modal_item_id[]" value="<?php echo esc_attr( $modal_id ); ?>">
			</div>
		</td>
		<td style="text-align: right;">
			<input class="grve-hidden grve-small-primary-btn grve-custom-modal-item-save-button" type="button" value="<?php esc_attr_e('Save', 'impeka' ); ?>">
		</td>
		<td>
			<select name="_impeka_grve_custom_modal_item_mode[]" class="grve-modal-select">
				<?php
					impeka_ext_print_select_options(
						array(
							'full' =>  esc_html__('Full', 'impeka-extension' ),
							'large' =>  esc_html__('Large', 'impeka-extension' ),
							'medium' =>  esc_html__('Medium', 'impeka-extension' ),
							'small' =>  esc_html__('Small', 'impeka-extension' ),
						),
						$modal_mode
					);
				?>
			</select>
		</td>
		<td>
			<select name="_impeka_grve_custom_modal_item_area_id[]" class="grve-modal-select">
				<?php impeka_ext_print_select_options( $area_item_options, $modal_area_id ); ?>
			</select>
		</td>
		<td>
			<select name="_impeka_grve_custom_modal_item_trigger[]" class="grve-modal-select grve-modal-trigger">
				<?php
					impeka_ext_print_select_options(
						array(
							'' =>  esc_html__('No', 'impeka-extension' ),
							'2000' =>  esc_html__('Open after 2s', 'impeka-extension' ),
							'4000' =>  esc_html__('Open after 4s', 'impeka-extension' ),
							'6000' =>  esc_html__('Open after 6s', 'impeka-extension' ),
							'8000' => esc_html__( 'Open after 8s', 'impeka-extension' ),
							'10000' => esc_html__( 'Open after 10s', 'impeka-extension' ),
							'12000' => esc_html__( 'Open after 12s', 'impeka-extension' ),
							'14000' => esc_html__( 'Open after 14s', 'impeka-extension' ),
							'16000' => esc_html__( 'Open after 16s', 'impeka-extension' ),
							'18000' => esc_html__( 'Open after 18s', 'impeka-extension' ),
							'20000' => esc_html__( 'Open after 20s', 'impeka-extension' ),
						),
						$modal_trigger
					);
				?>
			</select>
		</td>
		<td>
			<select name="_impeka_grve_custom_modal_item_reset[]" class="grve-modal-select grve-modal-reset" <?php disabled( $reset_disabled, true ); ?>>
				<?php
					impeka_ext_print_select_options(
						array(
							'0' => esc_html__( 'Always', 'impeka-extension' ),
							'1' => esc_html__( '1 Day', 'impeka-extension' ),
							'7' => esc_html__( '1 Week', 'impeka-extension' ),
							'14' => esc_html__( '2 Weeks', 'impeka-extension' ),
							'30' => esc_html__( '1 Month', 'impeka-extension' ),
						),
						$modal_reset
					);
				?>
			</select>
		</td>
		<td style="text-align: right;">
			<input class="<?php echo esc_attr( $button_class ); ?> button" type="button" value="<?php esc_attr_e('Delete', 'impeka' ); ?>">
		</td>
	</tr>

<?php

	}

	function impeka_grve_get_custom_modal() {

		check_ajax_referer( 'impeka-grve-get-custom-modal', '_grve_nonce' );

		if( isset( $_POST['modal_id'] ) ) {

			$modal_item_id = sanitize_text_field( $_POST['modal_id'] );
			$modal_item_mode = sanitize_text_field( $_POST['modal_mode'] );
			$modal_item_trigger = sanitize_text_field( $_POST['modal_trigger'] );
			$modal_item_reset = sanitize_text_field( $_POST['modal_reset'] );
			$modal_item_area_id = sanitize_text_field( $_POST['modal_area_id'] );
			$this_modal = array (
				'modal_id' => $modal_item_id,
				'modal_mode' => $modal_item_mode,
				'modal_trigger' => $modal_item_trigger,
				'modal_reset' => $modal_item_reset,
				'area_id' => $modal_item_area_id,
			);

			impeka_grve_print_admin_single_custom_modal( $this_modal, 'new' );
		}
		die();

	}
	add_action( 'wp_ajax_impeka_grve_get_custom_modal', 'impeka_grve_get_custom_modal' );

//Omit closing PHP tag to avoid accidental whitespace output errors.
