<?php
/*
*	Admin Custom Fonts
*
* 	@author		Greatives Team
* 	@URI		http://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
	<div id="grve-admin-pannel-wrapper" class="grve-font-wrap">
		<div id="grve-admin-nav-wrapper">
		<?php
			if ( function_exists( 'impeka_grve_print_admin_links') ) {
				impeka_grve_print_admin_links('fonts');
			}
		?>
		</div>
		<div class="grve-admin-title">
			<h2 class="grve-title"><?php esc_html_e( "Font Manager", 'impeka' ); ?></h2>
			<p class="grve-description"><?php esc_html_e( "Here is the place to add your custom fonts. Upload your font files, add your @font-face rules or use your Typekit Fonts. The added fonts will be available in Theme Options - Typography Options / Responsive Typography Options selectors.", 'impeka' ); ?></p>
		</div>
		<?php if( isset( $_GET['font-settings'] ) ) { ?>
		<div class="grve-font-saved updated inline grve-notice-green">
			<p><strong><?php esc_html_e('Settings Saved!', 'impeka-extension' ); ?></strong></p>
		</div>
		<?php } ?>
		<br/>
		<form id="grve-custom-fonts-form" method="post" action="admin.php?page=impeka-fonts">

			<?php
				$impeka_grve_custom_settings = get_option( 'impeka_ext_custom_font_settings' );
				$disable_gfonts = ( isset($impeka_grve_custom_settings['disable_gfonts'] ) ) ? $impeka_grve_custom_settings['disable_gfonts'] : '';
				$typekit_id = ( isset($impeka_grve_custom_settings['typekit_id'] ) ) ? $impeka_grve_custom_settings['typekit_id'] : '';
				$typekit_api_key = ( isset($impeka_grve_custom_settings['typekit_api_key'] ) ) ? $impeka_grve_custom_settings['typekit_api_key'] : '';
				$css_code = ( isset($impeka_grve_custom_settings['css_code'] ) ) ? $impeka_grve_custom_settings['css_code'] : '';
				$generated_css = impeka_ext_get_custom_fonts_css_code();
			?>

			<div class="grve-tabs">
				<ul class="grve-tab-links">
					<li class="active"><a href="#grve-fonts-tab-general"><?php esc_html_e( 'Fonts Overview', 'impeka-extension' ); ?></a></li>
					<li><a href="#grve-fonts-tab-custom"><?php esc_html_e( 'Uploaded Fonts', 'impeka-extension' ); ?></a></li>
					<li><a href="#grve-fonts-tab-userdefined"><?php esc_html_e( 'User Defined Fonts', 'impeka-extension' ); ?></a></li>
					<li><a href="#grve-fonts-tab-typekit"><?php esc_html_e( 'Typekit Fonts', 'impeka-extension' ); ?></a></li>
				</ul>
				<div class="grve-tab-content">
					<div id="grve-fonts-tab-general" class="grve-tab-item active">
						<table class="grve-table grve-font-table" cellspacing="0">
							<thead>
								<tr>
									<th style="width: 35%;"><span class="grve-table-subtitle"><?php esc_html_e('Font Family', 'impeka-extension' ); ?></span></th>
									<th><span class="grve-table-subtitle"><?php esc_html_e('Type', 'impeka-extension' ); ?></span></th>
								</tr>
							</thead>
							<tbody id="grve-custom-font-container">
								<?php impeka_ext_print_available_fonts(); ?>
							</tbody>
							<tfoot>
								<tr>
									<td><label><input type="checkbox" value="yes" <?php checked( $disable_gfonts, 'yes' ); ?> id="_impeka_ext_custom_font_setting_disable_gfonts" name="_impeka_ext_custom_font_setting_disable_gfonts"><?php esc_html_e('Disable Google Fonts', 'impeka-extension' ); ?></label></td>
									<td><p style="max-width: 230px;"><?php esc_html_e('Disable Google Fonts from the theme, click this option if you want to use only self hosted fonts.', 'impeka-extension' ); ?></p></td>
								</tr>
								<tr>
									<td>
										<input type="button" name="grve-general-fonts-save-settings" id="grve-general-fonts-submit" class="grve-fonts-submit-button button button-primary" value="<?php esc_attr_e( 'Save Settings', 'impeka-extension' ); ?>">
									</td>
									<td>&nbsp;</td>
								</tr>
							</tfoot>
						</table>
					</div>
					<div id="grve-fonts-tab-custom" class="grve-tab-item">
						<table class="grve-table grve-font-table" cellspacing="0">
							<thead>
								<tr>
									<th><span class="grve-table-subtitle"><?php esc_html_e('Font Family', 'impeka-extension' ); ?></span></th>
									<th><span class="grve-table-subtitle"><?php esc_html_e('Files', 'impeka-extension' ); ?></span></th>
									<th>&nbsp;</th>
								</tr>
								<tr>
									<td style="padding-bottom: 60px;">
										<input type="text" class="grve-font-text grve-font-family-name  grve-validation-option" id="grve-custom-font-item-name-new" value=""/>
										<div class="grve-hidden-notice grve-font-notice-empty grve-notice-red">
											<?php esc_html_e('Field must not be empty!', 'impeka-extension' ); ?>
										</div>
										<div class="grve-hidden-notice grve-font-notice-exists grve-notice-red">
											<?php esc_html_e('Font Family with this name already exists!', 'impeka-extension' ); ?>
										</div>
									</td>
									<td style="padding-bottom: 60px;">
										<div class="grve-font-file-upload-wrapper">
											<div class="grve-font-file-container">
												<input type="hidden" id="grve-custom-font-woff2" class="grve-font-id" value="">
												<span class="grve-upload-font" data-mime="font/woff2" title="<?php esc_attr_e('Upload Font', 'impeka-extension' ); ?>">.woff2</span>
												<span class="grve-upload-remove-font" title="<?php esc_attr_e('Remove Font', 'impeka-extension' ); ?>">
													<svg width="9px" height="9px" viewBox="0 0 9 9">
														<polygon points="7.07106781 5.68434189e-14 8.48528137 1.41421356 5.657 4.243 8.48528137 7.07106781 7.07106781 8.48528137 4.243 5.657 1.41421356 8.48528137 7.38964445e-13 7.07106781 2.829 4.243 7.38964445e-13 1.41421356 1.41421356 5.68434189e-14 4.243 2.829"></polygon>
													</svg>
												</span>
											</div>
											<div class="grve-font-file-container">
												<input type="hidden" id="grve-custom-font-woff" class="grve-font-id" value="">
												<span class="grve-upload-font" data-mime="font/woff" title="<?php esc_attr_e('Upload Font', 'impeka-extension' ); ?>">.woff</span>
												<span class="grve-upload-remove-font" title="<?php esc_attr_e('Remove Font', 'impeka-extension' ); ?>">
													<svg width="9px" height="9px" viewBox="0 0 9 9">
														<polygon points="7.07106781 5.68434189e-14 8.48528137 1.41421356 5.657 4.243 8.48528137 7.07106781 7.07106781 8.48528137 4.243 5.657 1.41421356 8.48528137 7.38964445e-13 7.07106781 2.829 4.243 7.38964445e-13 1.41421356 1.41421356 5.68434189e-14 4.243 2.829"></polygon>
													</svg>
												</span>
											</div>
											<div class="grve-font-file-container">
												<input type="hidden" id="grve-custom-font-eot" class="grve-font-id" value="">
												<span class="grve-upload-font" data-mime="application/vnd.ms-fontobject" title="<?php esc_attr_e('Upload Font', 'impeka-extension' ); ?>">.eot</span>
												<span class="grve-upload-remove-font" title="<?php esc_attr_e('Remove Font', 'impeka-extension' ); ?>">
													<svg width="9px" height="9px" viewBox="0 0 9 9">
														<polygon points="7.07106781 5.68434189e-14 8.48528137 1.41421356 5.657 4.243 8.48528137 7.07106781 7.07106781 8.48528137 4.243 5.657 1.41421356 8.48528137 7.38964445e-13 7.07106781 2.829 4.243 7.38964445e-13 1.41421356 1.41421356 5.68434189e-14 4.243 2.829"></polygon>
													</svg>
												</span>
											</div>
											<div class="grve-font-file-container">
												<input type="hidden" id="grve-custom-font-ttf" class="grve-font-id" value="">
												<span class="grve-upload-font" data-mime="font/ttf" title="<?php esc_attr_e('Upload Font', 'impeka-extension' ); ?>">.ttf</span>
												<span class="grve-upload-remove-font" title="<?php esc_attr_e('Remove Font', 'impeka-extension' ); ?>">
													<svg width="9px" height="9px" viewBox="0 0 9 9">
														<polygon points="7.07106781 5.68434189e-14 8.48528137 1.41421356 5.657 4.243 8.48528137 7.07106781 7.07106781 8.48528137 4.243 5.657 1.41421356 8.48528137 7.38964445e-13 7.07106781 2.829 4.243 7.38964445e-13 1.41421356 1.41421356 5.68434189e-14 4.243 2.829"></polygon>
													</svg>
												</span>
											</div>
										</div>
										<div class="grve-hidden-notice grve-font-notice-no-uploaded-files grve-notice-red">
											<?php esc_html_e('For custom fonts you need to upload at least one font file!', 'impeka-extension' ); ?>
										</div>
									</td>
									<td style="text-align: right; padding-bottom: 60px;">
										<a href="#" id="grve-add-custom-font-item" class="grve-add-button">
											<svg width="12px" height="12px" viewBox="0 0 12 12">
												<path d="M7,0 L7,5 L12,5 L12,7 L7,7 L7,12 L5,12 L5,7 L0,7 L0,5 L5,5 L5,0 L7,0 Z"></path>
											</svg>
										</a>
										<span class="grve-font-spinner"></span>
									</td>
								</tr>
							</thead>
							<tbody id="grve-custom-font-container">
								<?php impeka_ext_print_admin_custom_fonts(); ?>
							</tbody>
						</table>
						<table class="grve-table grve-admin-panel-left" cellspacing="0">
							<thead>
								<tr>
									<th scope="row"><h2 class="grve-table-title"><?php esc_html_e( 'Generated CSS', 'impeka-extension'); ?></h2></th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td>
										<?php if ( empty( $generated_css ) ) { ?>
											<p><?php esc_html_e( 'No uploaded fonts found!', 'impeka-extension'); ?></p>
										<?php } else { ?>
											<pre class="grve-generated-css"><?php echo wp_unslash( $generated_css ); ?></pre>
										<?php } ?>
										<p class="description indicator-hint">
											<?php esc_html_e( 'Generated @font-face rules from your uploaded fonts', 'impeka-extension' ); ?><br/>
										</p>
									</td>
								</tr>
							</tbody>
							<tfoot>
								<?php $custom_font_save_other_attributes = array( 'id' => 'grve-custom-fonts-submit' ); ?>
								<tr>
									<td>&nbsp;</td>
									<td>&nbsp;</td>
								</tr>
							</tfoot>
						</table>
					</div>
					<div id="grve-fonts-tab-userdefined" class="grve-tab-item">
						<table class="grve-table grve-font-table" cellspacing="0">
							<thead>
								<tr>
									<th><span class="grve-table-subtitle"><?php esc_html_e('Font Family', 'impeka-extension' ); ?></span></th>
									<th>&nbsp;</th>
								</tr>
								<tr>
									<td style="padding-bottom: 60px;">
										<input type="text" class="grve-font-text grve-font-family-name grve-validation-option" id="grve-userdefined-font-item-name-new" value=""/>
										<div class="grve-hidden-notice grve-userdefined-notice-empty grve-notice-red">
											<?php esc_html_e('Field must not be empty!', 'impeka-extension' ); ?>
										</div>
										<div class="grve-hidden-notice grve-userdefined-notice-exists grve-notice-red">
											<?php esc_html_e('Font Family with this name already exists!', 'impeka-extension' ); ?>
										</div>
										<div class="grve-hidden-notice grve-userdefined-notice-save grve-notice-red">
											<?php esc_html_e('Save is needed, click Save Settings!', 'impeka-extension' ); ?>
										</div>
									</td>
									<td style="padding-bottom: 60px;">
										<a href="#" id="grve-add-userdefined-font-item" class="grve-add-button">
											<svg width="12px" height="12px" viewBox="0 0 12 12">
												<path d="M7,0 L7,5 L12,5 L12,7 L7,7 L7,12 L5,12 L5,7 L0,7 L0,5 L5,5 L5,0 L7,0 Z"></path>
											</svg>
										</a>
										<span class="grve-font-spinner"></span>
									</td>
								</tr>
							</thead>
							<tbody id="grve-userdefined-font-container">
								<?php impeka_ext_print_admin_userdefined_fonts(); ?>
							</tbody>
						</table>
						<table class="grve-table grve-admin-panel-left" cellspacing="0">
							<thead>
								<tr>
									<th scope="row"><strong><?php esc_html_e( 'User Defined CSS', 'impeka-extension'); ?></strong></th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td>
										<textarea id="grve-css-code-area" class="widefat" name="_impeka_ext_custom_font_setting_css_code" rows="20"><?php echo wp_unslash( $css_code ); ?></textarea>
										<p class="description indicator-hint">
											<?php esc_html_e( 'Type css @font-face rules for your fonts ( only for your User Defined fonts )', 'impeka-extension' ); ?><br/>
											<?php esc_html_e( 'Note: If you want to upload your fonts manually via FTP, upload your fonts inside you WordPress uploads directory in a separate folder e.g: fonts', 'impeka-extension' ); ?><br/>
											<?php esc_html_e( 'Fonts css file is generated in a subdirectory of uploads directory, so you can also use a relative path with the previous directory e.g: ../fonts/my-font.woff2', 'impeka-extension' ); ?></br>
										</p>
									</td>
								</tr>
							</tbody>
							<tfoot>
								<tr>
									<td>
										<input type="button" name="grve-general-fonts-save-settings" id="grve-userdefined-fonts-save-settings" class="grve-fonts-submit-button button button-primary" value="<?php esc_attr_e( 'Save Settings', 'impeka-extension' ); ?>">
									</td>
									<td>&nbsp;</td>
								</tr>
							</tfoot>
						</table>
					</div>
					<div id="grve-fonts-tab-typekit" class="grve-tab-item">
						<table class="grve-table grve-font-table" cellspacing="0">
							<thead>
								<tr>
									<th><span class="grve-table-subtitle"><?php esc_html_e('Font Name', 'impeka-extension' ); ?></span></th>
									<th><span class="grve-table-subtitle"><?php esc_html_e('Font Family', 'impeka-extension' ); ?></span></th>
									<th><span class="grve-table-subtitle"><?php esc_html_e('Variants', 'impeka-extension' ); ?></span></th>
								</tr>
							</thead>
							<tbody id="grve-typekit-font-container">
								<?php impeka_ext_print_admin_typekit_fonts(); ?>
							</tbody>
							<tfoot>
								<tr>
									<td><input class="grve-hidden grve-delete-typekit-fonts-button button" type="button" value="<?php esc_attr_e('Remove typekit fonts', 'impeka' ); ?>"></td>
								</tr>
							</tfoot>
						</table>

						<table class="grve-table" cellspacing="0">
							<thead>
								<tr>
									<th><span class="grve-table-subtitle"><?php esc_html_e('Typekit ID', 'impeka-extension' ); ?></span></th>
									<th><span class="grve-table-subtitle"><a href="https://fonts.adobe.com/account/tokens" target="_blank"><?php esc_html_e('Typekit API Token', 'impeka-extension' ); ?></a></span></th>
									<th>&nbsp;</th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td class="grve-no-border">
										<input type="text" class="grve-font-text grve-validation-option" id="grve-font-typekit-id" name="_impeka_ext_custom_font_setting_typekit_id" value="<?php echo esc_attr( $typekit_id ); ?>">
										<div class="grve-hidden-notice grve-typekit-id-notice-empty grve-notice-red">
											<?php esc_html_e('Field must not be empty!', 'impeka-extension' ); ?>
										</div>
									</td>
									<td class="grve-no-border">
										<input type="text" class="grve-font-text grve-validation-option" id="grve-font-typekit-api-key" name="_impeka_ext_custom_font_setting_typekit_api_key" value="<?php echo esc_attr( $typekit_api_key ); ?>">
										<div class="grve-hidden-notice grve-typekit-key-notice-empty grve-notice-red">
											<?php esc_html_e('Field must not be empty!', 'impeka-extension' ); ?>
										</div>
									</td>
									<td class="grve-no-border">
										<a href="#" id="grve-scan-typekit-fonts" class="grve-add-button">
											<svg width="24" height="24" viewBox="0 0 24 24">
												<path d="M12,6V9L16,5L12,1V4A8,8 0 0,0 4,12C4,13.57 4.46,15.03 5.24,16.26L6.7,14.8C6.25,13.97 6,13 6,12A6,6 0 0,1 12,6M18.76,7.74L17.3,9.2C17.74,10.04 18,11 18,12A6,6 0 0,1 12,18V15L8,19L12,23V20A8,8 0 0,0 20,12C20,10.43 19.54,8.97 18.76,7.74Z" />
											</svg>

										</a>
										<span class="grve-font-spinner"></span>
									</td>
								</tr>
							</tbody>
							<tfoot>
								<tr>
									<td>&nbsp;</td>
									<td>&nbsp;</td>
									<td>&nbsp;</td>
								</tr>
							</tfoot>
						</table>
					</div>
				</div>
			</div>
			<?php wp_nonce_field( 'impeka_ext_nonce_font_save', '_impeka_ext_nonce_font_save' ); ?>
		</form>
	</div>
<?php


//Omit closing PHP tag to avoid accidental whitespace output errors.
