<?php
/*
*	Admin Custom Modals
*
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$custom_modals = get_option( '_impeka_grve_custom_modals' );
$area_item_options = array();
if ( function_exists( 'impeka_grve_global_admin_param' ) ) {
	$area_item_options = impeka_grve_global_admin_param( 'area_item_selection' );
}
?>
	<div id="grve-admin-pannel-wrapper" class="grve-modal-wrap">
		<div id="grve-admin-nav-wrapper">
			<?php impeka_grve_print_admin_links('modals'); ?>
		</div>
		<div class="grve-admin-title">
			<h2 class="grve-title"><?php esc_html_e( "Modals", 'impeka' ); ?></h2>
			<p class="grve-description"><?php esc_html_e( "In this area, you can create the global modals for your site. Give a name (ID), define your preferences and click the button to add it. It’s worth noting that you can have any content in your modals with the area items. Enjoy it!", 'impeka' ); ?></p>
		</div>
		<?php if( isset( $_GET['modal-settings'] ) ) { ?>
		<div class="grve-modal-saved updated inline grve-notice-green">
			<p><strong><?php esc_html_e('Settings Saved!', 'impeka' ); ?></strong></p>
		</div>
		<?php } ?>
		<form id="grve-custom-modal-form" method="post" action="admin.php?page=impeka-modals">
			<table class="grve-table grve-modal-table" cellspacing="0">
				<thead>
					<tr>
						<th>&nbsp;</th>
						<th><span class="grve-table-subtitle"><?php esc_html_e('Modal Id', 'impeka-extension' ); ?></span></th>
						<th><span class="grve-table-subtitle"><?php esc_html_e('Modal Size ', 'impeka-extension' ); ?></span></th>
						<th><span class="grve-table-subtitle"><?php esc_html_e('Area Item', 'impeka-extension' ); ?></span></th>
						<th><span class="grve-table-subtitle"><?php esc_html_e('Trigger on Load', 'impeka-extension' ); ?></span></th>
						<th><span class="grve-table-subtitle"><?php esc_html_e('Modal Reset', 'impeka-extension' ); ?></span></th>
						<th>&nbsp;</th>
					</tr>
					<tr>
						<th style="width: 15%; padding-bottom: 60px;">
							<h3 class="grve-table-title"><?php esc_html_e('Add Modal', 'impeka' ); ?></h3>
						</th>
						<th style="width: 15%; padding-bottom: 60px;">
							<input type="text" class="grve-modal-text" id="grve-custom-modal-item-id" value=""/>
							<div class="grve-hidden-notice grve-modal-notice grve-notice-red">
								<?php esc_html_e('Field must not be empty!', 'impeka' ); ?>
							</div>
							<div class="grve-hidden-notice grve-modal-notice-exists grve-notice-red">
								<?php esc_html_e('Modal with this name already exists!', 'impeka' ); ?>
							</div>
						</th>
						<th style="width: 15%; padding-bottom: 60px;">
							<select id="grve-custom-modal-item-mode" class="grve-modal-select">
								<?php
									impeka_ext_print_select_options(
										array(
											'full' =>  esc_html__('Full', 'impeka-extension' ),
											'large' =>  esc_html__('Large', 'impeka-extension' ),
											'medium' =>  esc_html__('Medium', 'impeka-extension' ),
											'small' =>  esc_html__('Small', 'impeka-extension' ),
										),
										''
									);
								?>
							</select>
						</th>
						<th style="width: 15%; padding-bottom: 60px;">
							<select id="grve-custom-modal-item-area-id" class="grve-modal-select">
								<?php impeka_ext_print_select_options( $area_item_options, '' ); ?>
							</select>
						</th>
						<th style="width: 15%; padding-bottom: 60px;">
							<select id="grve-custom-modal-item-trigger" class="grve-modal-select">
								<?php
									impeka_ext_print_select_options(
										array(
											'' =>  esc_html__('No', 'impeka-extension' ),
											'2000' =>  esc_html__('Open after 2s', 'impeka-extension' ),
											'4000' =>  esc_html__('Open after 4s', 'impeka-extension' ),
											'6000' =>  esc_html__('Open after 6s', 'impeka-extension' ),
											'8000' => esc_html__( 'Open after 8s', 'impeka-extension' ),
											'10000' => esc_html__( 'Open after 10s', 'impeka-extension' ),
											'12000' => esc_html__( 'Open after 12s', 'impeka-extension' ),
											'14000' => esc_html__( 'Open after 14s', 'impeka-extension' ),
											'16000' => esc_html__( 'Open after 16s', 'impeka-extension' ),
											'18000' => esc_html__( 'Open after 18s', 'impeka-extension' ),
											'20000' => esc_html__( 'Open after 20s', 'impeka-extension' ),
										),
										''
									);
								?>
							</select>
						</th>
						<th style="width: 15%; padding-bottom: 60px;">
							<select id="grve-custom-modal-item-reset" class="grve-modal-select" <?php disabled( true, true ); ?>>
								<?php
									impeka_ext_print_select_options(
										array(
											'0' => esc_html__( 'Always', 'impeka-extension' ),
											'1' => esc_html__( '1 Day', 'impeka-extension' ),
											'7' => esc_html__( '1 Week', 'impeka-extension' ),
											'14' => esc_html__( '2 Weeks', 'impeka-extension' ),
											'30' => esc_html__( '1 Month', 'impeka-extension' ),
										),
										'1'
									);
								?>
							</select>
						</th>
						<th style="text-align: center; width: 5%; padding-bottom: 60px;">
							<a href="#" id="grve-add-custom-modal-item" class="grve-add-button">
								<svg width="12px" height="12px" viewBox="0 0 12 12">
									<path d="M7,0 L7,5 L12,5 L12,7 L7,7 L7,12 L5,12 L5,7 L0,7 L0,5 L5,5 L5,0 L7,0 Z"></path>
								</svg>
							</a>
						</th>
					</tr>

				</thead>
				<tbody id="grve-custom-modal-container">
					<?php impeka_grve_print_admin_custom_modals( $custom_modals ); ?>
				</tbody>
				<tfoot>
					<tr>
						<td><?php //submit_button(); ?></td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
					</tr>
				</tfoot>
			</table>
			<?php wp_nonce_field( 'impeka_grve_nonce_modal_save', '_impeka_grve_nonce_modal_save' ); ?>
		</form>
	</div>
<?php


//Omit closing PHP tag to avoid accidental whitespace output errors.
