<?php
/*
*	Area Item Post Type Registration
*
* 	@author		Greatives Team
* 	@URI		http://greatives.eu
*/

if ( ! class_exists( 'Impeka_Area_Post_Type' ) ) {
	class Impeka_Area_Post_Type {

		function __construct() {

			// Adds the area post type and taxonomies
			$this->impeka_ext_area_init();

			// Manage Columns for area overview
			add_filter( 'manage_edit-area_columns',  array( &$this, 'impeka_ext_area_edit_columns' ) );

		}

		function impeka_ext_area_init() {

			$labels = array(
				'name' => esc_html_x( 'Area Items', 'Area General Name', 'impeka-extension' ),
				'singular_name' => esc_html_x( 'Area Item', 'Area Singular Name', 'impeka-extension' ),
				'add_new' => esc_html__( 'Add New', 'impeka-extension' ),
				'add_new_item' => esc_html__( 'Add New Area Item', 'impeka-extension' ),
				'edit_item' => esc_html__( 'Edit Area Item', 'impeka-extension' ),
				'new_item' => esc_html__( 'New Area Item', 'impeka-extension' ),
				'view_item' => esc_html__( 'View Area Item', 'impeka-extension' ),
				'search_items' => esc_html__( 'Search Area Items', 'impeka-extension' ),
				'not_found' =>  esc_html__( 'No Area Items found', 'impeka-extension' ),
				'not_found_in_trash' => esc_html__( 'No Area Items found in Trash', 'impeka-extension' ),
				'parent_item_colon' => '',
			);

			$args = array(
				'labels' => $labels,
				'public' => true,
				'publicly_queryable' => true,
				'exclude_from_search' => true,
				'show_in_nav_menus' => false,
				'show_ui' => true,
				'query_var' => true,
				'rewrite' => true,
				'capability_type' => 'post',
				'hierarchical' => false,
				'menu_position' => 5,
				'menu_icon' => 'dashicons-media-text',
				'show_in_rest' => true,
				'supports' => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt' ),
				'rewrite' => array( 'slug' => 'area-item', 'with_front' => false ),
			  );

			register_post_type(
				'area-item' ,
				apply_filters( "impeka_ext_register_post_type_area_item_args", $args )
			);

		}

		function impeka_ext_area_edit_columns( $columns ) {
			$columns['cb'] = "<input type=\"checkbox\" />";
			$columns['title'] = esc_html__( 'Title', 'impeka-extension' );
			$columns['author'] = esc_html__( 'Author', 'impeka-extension' );
			$columns['date'] = esc_html__( 'Date', 'impeka-extension' );
			return $columns;
		}

	}
	new Impeka_Area_Post_Type;
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
