<?php

/*
 *	Metabox functions
 *
 * 	@version	1.0
 * 	@author		Greatives Team
 * 	@URI		http://greatives.eu
 */


/**
 * Functions to print global metaboxes
 */
add_action( 'add_meta_boxes', 'impeka_ext_generic_options_add_custom_boxes' );

function impeka_ext_generic_options_add_custom_boxes() {

	if ( function_exists( 'vc_is_inline' ) && vc_is_inline() ) {
		return;
	}

	//General Page Options
	if ( function_exists( 'impeka_grve_page_options_box' ) ) {

		$post_types = array(
			'page' => esc_html__( 'Page Options', 'impeka-extension' ),
			'post' => esc_html__( 'Post Options', 'impeka-extension' ),
			'portfolio' => esc_html__( 'Portfolio Options', 'impeka-extension' ),
			'product' => esc_html__( 'Product Options', 'impeka-extension' ),
			'tribe_events' => esc_html__( 'Events Options', 'impeka-extension' ),
		);

		$post_types = apply_filters( 'impeka_grve_page_options_post_types', $post_types );

		if ( !empty( $post_types ) ) {

			foreach ( $post_types as $post_type => $title ) {
				add_meta_box(
					'grve-page-options',
					$title,
					'impeka_grve_page_options_box',
					$post_type
				);
			}
		}
	}

	if ( function_exists( 'impeka_grve_option' ) && function_exists( 'impeka_grve_page_feature_section_box' )  ) {
		$post_types = impeka_grve_option( 'feature_section_post_types');
		$post_types = apply_filters( 'impeka_grve_feature_section_post_types', $post_types );

		if ( !empty( $post_types ) ) {

			foreach ( $post_types as $key => $value ) {

				if ( 'attachment' != $value ) {

					add_meta_box(
						'grve-feature-section-metabox',
						esc_html__( 'Feature Section', 'impeka-extension' ),
						'impeka_grve_page_feature_section_box',
						$value,
						'advanced',
						'low'
					);

				}

			}
		}
	}
}

/**
 * Functions to print portfolio metaboxes
 */

add_action( 'add_meta_boxes', 'impeka_ext_portfolio_options_add_custom_boxes' );

function impeka_ext_portfolio_options_add_custom_boxes() {

	if ( function_exists( 'vc_is_inline' ) && vc_is_inline() ) {
		return;
	}

	$visibility = apply_filters( 'impeka_ext_portfolio_options_visibility', true );
	if ( !$visibility ) {
		return;
	}

	if ( function_exists( 'impeka_grve_portfolio_link_mode_box' ) ) {
		add_meta_box(
			'portfolio_link_mode',
			esc_html__( 'Portfolio Link Options', 'impeka-extension' ),
			'impeka_grve_portfolio_link_mode_box',
			'portfolio'
		);
	}
	if ( function_exists( 'impeka_grve_portfolio_overview_mode_box' ) ) {
		add_meta_box(
			'portfolio_overview_mode',
			esc_html__( 'Portfolio Overview Options', 'impeka-extension' ),
			'impeka_grve_portfolio_overview_mode_box',
			'portfolio'
		);
	}
	if ( function_exists( 'impeka_grve_portfolio_media_section_box' ) ) {
		add_meta_box(
			'portfolio_media_section',
			esc_html__( 'Portfolio Media', 'impeka-extension' ),
			'impeka_grve_portfolio_media_section_box',
			'portfolio'
		);
	}
	if ( function_exists( 'impeka_grve_second_featured_image_section_box' ) ) {
		add_meta_box(
			'portfolio_second_featured_image',
			esc_html__( 'Second Featured Image', 'impeka-extension' ),
			'impeka_grve_second_featured_image_section_box',
			'portfolio',
			'side',
			'low'
		);
	}

}

/**
 * Functions to print post metaboxes
 */
add_action( 'add_meta_boxes', 'impeka_ext_post_options_add_custom_boxes' );

function impeka_ext_post_options_add_custom_boxes() {

	if ( function_exists( 'vc_is_inline' ) && vc_is_inline() ) {
		return;
	}

	$visibility = apply_filters( 'impeka_ext_post_options_visibility', true );
	if ( !$visibility ) {
		return;
	}
	if ( function_exists( 'impeka_grve_meta_box_post_format_gallery' ) ) {
		add_meta_box(
			'grve-meta-box-post-format-gallery',
			esc_html__( 'Gallery Format Options', 'impeka-extension' ),
			'impeka_grve_meta_box_post_format_gallery',
			'post'
		);
	}
	if ( function_exists( 'impeka_grve_meta_box_post_format_link' ) ) {
		add_meta_box(
			'grve-meta-box-post-format-link',
			esc_html__( 'Link Format Options', 'impeka-extension' ),
			'impeka_grve_meta_box_post_format_link',
			'post'
		);
	}
	if ( function_exists( 'impeka_grve_meta_box_post_format_quote' ) ) {
		add_meta_box(
			'grve-meta-box-post-format-quote',
			esc_html__( 'Quote Format Options', 'impeka-extension' ),
			'impeka_grve_meta_box_post_format_quote',
			'post'
		);
	}
	if ( function_exists( 'impeka_grve_meta_box_post_format_video' ) ) {
		add_meta_box(
			'grve-meta-box-post-format-video',
			esc_html__( 'Video Format Options', 'impeka-extension' ),
			'impeka_grve_meta_box_post_format_video',
			'post'
		);
	}
	if ( function_exists( 'impeka_grve_meta_box_post_format_audio' ) ) {
		add_meta_box(
			'grve-meta-box-post-format-audio',
			esc_html__( 'Audio Format Options', 'impeka-extension' ),
			'impeka_grve_meta_box_post_format_audio',
			'post'
		);
	}
	if ( function_exists( 'impeka_grve_meta_box_post_custom_overview' ) ) {
		add_meta_box(
			'grve-meta-box-post-custom-overview',
			esc_html__( 'Custom Overview Options', 'impeka-extension' ),
			'impeka_grve_meta_box_post_custom_overview',
			'post'
		);
	}	

}



/**
 * Functions to print testimonial metaboxes
 */

add_action( 'add_meta_boxes', 'impeka_ext_testimonial_options_add_custom_boxes' );

function impeka_ext_testimonial_options_add_custom_boxes() {

	$visibility = apply_filters( 'impeka_ext_testimonial_options_visibility', true );
	if ( !$visibility ) {
		return;
	}

	if ( function_exists( 'impeka_grve_testimonial_options_box' ) ) {
		add_meta_box(
			'testimonial_oprions',
			esc_html__( 'Testimonial Options', 'impeka-extension' ),
			'impeka_grve_testimonial_options_box',
			'testimonial'
		);
	}

}
//Omit closing PHP tag to avoid accidental whitespace output errors.
