<?php
/**
 * Greatives Social Networking
 * A widget that displays social networking links.
 * @author		Greatives Team
 * @URI			http://greatives.eu
 */

class Impeka_Ext_Widget_Social extends WP_Widget {

	function __construct() {
		$widget_ops = array(
			'classname' => 'grve-widget grve-element grve-social grve-icon-type',
			'description' => esc_html__( 'A widget that displays social networking links', 'impeka-extension' ),
		);
		$control_ops = array(
			'width' => 400,
			'height' => 600,
			'id_base' => 'grve-widget-social',
		);
		parent::__construct( 'grve-widget-social', '(Greatives) ' . esc_html__( 'Social Networking', 'impeka-extension' ), $widget_ops, $control_ops );
	}

	function impeka_ext_widget_social() {
		$this->__construct();
	}

	function widget( $args, $instance ) {

		global $impeka_grve_social_list_extended;

		//Our variables from the widget settings.
		extract( $args );

		echo wp_kses( $before_widget, impeka_ext_get_widget_allowed_html() );

		// Display the widget title
		$title = impeka_ext_array_value( $instance, 'title' );
		$title = apply_filters( 'widget_title', $title );
		if ( $title ) {
			echo wp_kses( $before_title, impeka_ext_get_widget_allowed_html() ) . esc_html( $title ) . wp_kses( $after_title, impeka_ext_get_widget_allowed_html() );
		}

		$icon_size = impeka_ext_array_value( $instance, 'icon_size', 'extrasmall' );
		$icon_shape = impeka_ext_array_value( $instance, 'shape', 'square' );
		$shape_type = impeka_ext_array_value( $instance, 'shape_type', 'outline' );
		$icon_color = impeka_ext_array_value( $instance, 'icon_color', 'primary-1' );
		$shape_color = impeka_ext_array_value( $instance, 'shape_color', 'black' );


		$social_shape_classes = array();
		$social_shape_classes[] = 'grve-' . $icon_size;
		$social_shape_classes[] = 'grve-' . $icon_shape;

		if ( 'no-shape' != $icon_shape ) {
			$social_shape_classes[] = 'grve-with-shape';
			$social_shape_classes[] = 'grve-' . $shape_type;
			if ( 'outline' != $shape_type ) {
				$social_shape_classes[] = 'grve-bg-' . $shape_color;
			} else {
				$social_shape_classes[] = 'grve-text-' . $shape_color;
				$social_shape_classes[] = 'grve-text-hover-' . $shape_color;
			}
		}

		$social_shape_class_string = implode( ' ', $social_shape_classes );

	?>

		<ul>
		<?php
		if ( isset( $impeka_grve_social_list_extended ) ) {
			foreach ( $impeka_grve_social_list_extended as $social_item ) {

				$social_item_url = impeka_ext_array_value( $instance, $social_item['url'] );

				if ( ! empty( $social_item_url ) ) {

					if ( 'skype' == $social_item['id'] ) {
		?>
					<li>
						<a href="<?php echo esc_url( $social_item_url, array( 'skype', 'http', 'https' ) ); ?>" class="<?php echo esc_attr( $social_shape_class_string ); ?>">
							<span class="screen-reader-text"><?php echo esc_html( $social_item['title'] ); ?></span>
							<span class="grve-icon grve-text-<?php echo esc_attr( $icon_color ); ?> <?php echo esc_attr( $social_item['class'] ); ?>"></span>
						</a>
					</li>
		<?php
					} else {
		?>
					<li>
						<a href="<?php echo esc_url( $social_item_url ); ?>" class="<?php echo esc_attr( $social_shape_class_string ); ?>" target="_blank">
							<span class="screen-reader-text"><?php echo esc_html( $social_item['title'] ); ?></span>
							<span class="grve-icon grve-text-<?php echo esc_attr( $icon_color ); ?> <?php echo esc_attr( $social_item['class'] ); ?>"></span>
						</a>
					</li>
		<?php
					}
				}
			}
		}
		?>
		</ul>


	<?php

		echo wp_kses( $after_widget, impeka_ext_get_widget_allowed_html() );
	}

	//Update the widget

	function update( $new_instance, $old_instance ) {

		global $impeka_grve_social_list_extended;
		$instance = $old_instance;

		//Strip tags from title to remove HTML
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['icon_size'] = strip_tags( $new_instance['icon_size'] );
		$instance['icon_color'] = strip_tags( $new_instance['icon_color'] );
		$instance['shape'] = strip_tags( $new_instance['shape'] );
		$instance['shape_type'] = strip_tags( $new_instance['shape_type'] );
		$instance['shape_color'] = strip_tags( $new_instance['shape_color'] );

		if ( isset( $impeka_grve_social_list_extended ) ) {
			foreach ( $impeka_grve_social_list_extended as $social_item ) {
				$instance[ $social_item['url'] ] = strip_tags( $new_instance[ $social_item['url'] ] );
			}
		}

		return $instance;
	}

	function form( $instance ) {

		global $impeka_grve_social_list_extended;

		//Set up some default widget settings.
		$defaults = array(
			'title' => '',
			'icon_size' => 'extrasmall',
			'icon_color' => 'primary-1',
			'shape' => 'square',
			'shape_type' => 'outline',
			'shape_color' => 'black',
		);

		$instance = wp_parse_args( (array) $instance, $defaults );

		$icon_size = impeka_ext_array_value( $instance, 'icon_size');
		$icon_shape = impeka_ext_array_value( $instance, 'shape');
		$icon_shape_type = impeka_ext_array_value( $instance, 'shape_type');
		$icon_color = impeka_ext_array_value( $instance, 'icon_color' );
		$shape_color = impeka_ext_array_value( $instance, 'shape_color' );

		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php echo esc_html__( 'Title:', 'impeka-extension' ); ?></label>
			<input id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $instance['title'] ); ?>" style="width:100%;" />
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'icon_size' ) ); ?>"><?php echo esc_html__( 'Icon Size:', 'impeka-extension' ); ?></label>
			<select name="<?php echo esc_attr( $this->get_field_name( 'icon_size' ) ); ?>" style="width:100%;">
				<?php
					impeka_ext_print_select_options(
						array(
							'large' =>  esc_html__('Large', 'impeka-extension' ),
							'medium' =>  esc_html__('Medium', 'impeka-extension' ),
							'small' =>  esc_html__('Small', 'impeka-extension' ),
							'extrasmall' =>  esc_html__('Extra Small', 'impeka-extension' ),
						),
						$icon_size
					);
				?>
			</select>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'icon_color' ) ); ?>"><?php echo esc_html__( 'Icon Color:', 'impeka-extension' ); ?></label>
			<select name="<?php echo esc_attr( $this->get_field_name( 'icon_color' ) ); ?>" style="width:100%;">
				<?php
					impeka_ext_print_select_options(
						array(
							'primary-1' =>  esc_html__('Primary 1', 'impeka-extension' ),
							'primary-2' =>  esc_html__('Primary 2', 'impeka-extension' ),
							'primary-3' =>  esc_html__('Primary 3', 'impeka-extension' ),
							'primary-4' =>  esc_html__('Primary 4', 'impeka-extension' ),
							'primary-5' =>  esc_html__('Primary 5', 'impeka-extension' ),
							'primary-6' =>  esc_html__('Primary 6', 'impeka-extension' ),
							'green' =>  esc_html__('Green', 'impeka-extension' ),
							'orange' =>  esc_html__('Orange', 'impeka-extension' ),
							'red' =>  esc_html__('Red', 'impeka-extension' ),
							'blue' =>  esc_html__('Blue', 'impeka-extension' ),
							'aqua' =>  esc_html__('Aqua', 'impeka-extension' ),
							'purple' =>  esc_html__('Purple', 'impeka-extension' ),
							'black' =>  esc_html__('Black', 'impeka-extension' ),
							'grey' =>  esc_html__('Grey', 'impeka-extension' ),
							'dark-grey' =>  esc_html__('Dark Grey', 'impeka-extension' ),
							'light-grey' =>  esc_html__('Light Grey', 'impeka-extension' ),
							'white' =>  esc_html__('White', 'impeka-extension' ),
						),
						$icon_color
					);
				?>
			</select>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'shape' ) ); ?>"><?php echo esc_html__( 'Shape:', 'impeka-extension' ); ?></label>
			<select  name="<?php echo esc_attr( $this->get_field_name( 'shape' ) ); ?>" style="width:100%;">
				<?php
					impeka_ext_print_select_options(
						array(
							'square' =>  esc_html__('Square', 'impeka-extension' ),
							'round' =>  esc_html__('Round', 'impeka-extension' ),
							'circle' =>  esc_html__('Circle', 'impeka-extension' ),
							'no-shape' =>  esc_html__('None', 'impeka-extension' ),
						),
						$icon_shape
					);
				?>
			</select>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'shape_type' ) ); ?>"><?php echo esc_html__( 'Shape Type:', 'impeka-extension' ); ?></label>
			<select  name="<?php echo esc_attr( $this->get_field_name( 'shape_type' ) ); ?>" style="width:100%;">
				<?php
					impeka_ext_print_select_options(
						array(
							'simple' =>  esc_html__('Simple', 'impeka-extension' ),
							'outline' =>  esc_html__('Outline', 'impeka-extension' ),
						),
						$icon_shape_type
					);
				?>
			</select>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'shape_color' ) ); ?>"><?php echo esc_html__( 'Shape Color:', 'impeka-extension' ); ?></label>
			<select  name="<?php echo esc_attr( $this->get_field_name( 'shape_color' ) ); ?>" style="width:100%;">
				<?php
					impeka_ext_print_select_options(
						array(
							'primary-1' =>  esc_html__('Primary 1', 'impeka-extension' ),
							'primary-2' =>  esc_html__('Primary 2', 'impeka-extension' ),
							'primary-3' =>  esc_html__('Primary 3', 'impeka-extension' ),
							'primary-4' =>  esc_html__('Primary 4', 'impeka-extension' ),
							'primary-5' =>  esc_html__('Primary 5', 'impeka-extension' ),
							'primary-6' =>  esc_html__('Primary 6', 'impeka-extension' ),
							'green' =>  esc_html__('Green', 'impeka-extension' ),
							'orange' =>  esc_html__('Orange', 'impeka-extension' ),
							'red' =>  esc_html__('Red', 'impeka-extension' ),
							'blue' =>  esc_html__('Blue', 'impeka-extension' ),
							'aqua' =>  esc_html__('Aqua', 'impeka-extension' ),
							'purple' =>  esc_html__('Purple', 'impeka-extension' ),
							'black' =>  esc_html__('Black', 'impeka-extension' ),
							'grey' =>  esc_html__('Grey', 'impeka-extension' ),
							'dark-grey' =>  esc_html__('Dark Grey', 'impeka-extension' ),
							'light-grey' =>  esc_html__('Light Grey', 'impeka-extension' ),
							'white' =>  esc_html__('White', 'impeka-extension' ),
						),
						$shape_color
					);
				?>
			</select>
		</p>

		<p>
				<em><?php echo esc_html__( 'Note: Make sure you include the full URL (i.e. http://www.samplesite.com)', 'impeka-extension' ); ?></em>
				<br>
				 <?php echo esc_html__( 'If you do not want a social to be visible, simply delete the supplied URL.', 'impeka-extension' ); ?>
		</p>

		<?php
		if ( isset( $impeka_grve_social_list_extended ) ) {
			foreach ( $impeka_grve_social_list_extended as $social_item ) {
				$social_item_url = impeka_ext_array_value( $instance, $social_item['url'] );
		?>
				<p>
					<label for="<?php echo esc_attr( $this->get_field_id( $social_item['url'] ) ); ?>"><?php echo esc_html( $social_item['title'] ); ?>:</label>
					<input style="width: 100%;" id="<?php echo esc_attr( $this->get_field_id( $social_item['url'] ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( $social_item['url'] ) ); ?>" value="<?php echo esc_attr( $social_item_url ); ?>" />
				</p>

		<?php
			}
		}
		?>

	<?php
	}
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
