<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product;

$default_gift_product = wc_get_product( get_option ( YWGC_PRODUCT_PLACEHOLDER ) );

$fixed_shipping_cost = get_option( 'ywgc_gift_this_product_fixed_shipping_value', '0');

do_action( 'yith_ywgc_gift_card_preview_end', $default_gift_product ); //Load the modal content

?>

<form class="gift-cards_form cart" method="post" enctype='multipart/form-data' data-product_id="<?php echo absint( yit_get_prop($default_gift_product, 'id' )); ?>">

	<input type="hidden" name="ywgc-is-digital" value="1" />
	<input type='hidden' name='ywgc_has_custom_design' value='1' />


	<?php if ( ! $product->is_purchasable() ) : ?>
		<p class="gift-card-not-valid">
			<?php _e( "This product cannot be purchased", 'yith-woocommerce-gift-cards' ); ?>
		</p>
	<?php else : ?>

		<?php do_action( 'yith_ywgc_gift_card_design_section', $default_gift_product ); ?>

		<?php do_action( 'yith_ywgc_gift_card_delivery_info_section', $default_gift_product ); ?>


		<?php if ( 'yes' == get_option('ywgc_gift_this_product_include_shipping', 'no') ) : ?>
			<div class="ywgc-include-shipping-container">
				<input type="checkbox" id="ywgc-include-shipping-checkbox" name="ywgc-include-shipping-checkbox">
				<label for="ywgc-include-shipping-checkbox"><?php echo apply_filters('ywgc_include_shipping_label',esc_html__( "Pay also the shipping cost for this item", 'yith-woocommerce-gift-cards' )); ?></label>
			</div>

			<div class="ywgc-country-select-main-container ywgc-hidden">
				<div class="ywgc-country-select-container">

					<div class="ywgc-country-select-title">
						<p><?php echo esc_html__( "Ship to:", 'yith-woocommerce-gift-cards' ); ?></p>
					</div>

					<div class="ywgc-country-select-div">
						<p class="form-row form-row-wide" id="ywgc-country-select_field">
							<select name="ywgc-country-select" id="ywgc-country-select" class="country_to_state country_select" rel="ywgc-country-select">
								<option value="default"><?php esc_html_e( 'Select a country / region&hellip;', 'woocommerce' ); ?></option>
								<?php
								foreach ( WC()->countries->get_shipping_countries() as $key => $value ) {
									echo '<option value="' . esc_attr( $key ) . '"' . selected( WC()->customer->get_shipping_country(), esc_attr( $key ), false ) . '>' . esc_html( $value ) . '</option>';
								}
								?>
							</select>
						</p>
					</div>

					<div class="ywgc-postal-code-select">
						<input type="text" id="ywgc-postal-code-input" placeholder="<?php echo esc_html__( "Postal code", 'yith-woocommerce-gift-cards' ); ?>">
					</div>
				</div>

				<div class="ywgc-gift-this-product-totals"  data-currency="<?php echo get_woocommerce_currency_symbol();?>"  data-decimal-separator="<?php echo esc_attr ( wc_get_price_decimal_separator () );?>" >
					<p class="ywgc-gift-card-product-total"><?php echo esc_html__( "Product value: ", 'yith-woocommerce-gift-cards' ); ?>
						<span class="ywgc-gift-card-product-total-value"><?php echo wc_price( $product->get_price() )?></span></p>

					<?php
					$frontend_class = YITH_YWGC_Frontend_Premium::get_instance();
					$default_shipping_cost = ywgc_string_to_float( $frontend_class->ywgc_get_shipping_cost_by_country( WC()->customer->get_shipping_country() ) );

					?>

					<p class="ywgc-gift-card-shipping-total"><?php echo esc_html__( "Shipping cost: ", 'yith-woocommerce-gift-cards' ); ?>
						<span class="ywgc-gift-card-shipping-total-value" data-shipping-cost="<?php echo $default_shipping_cost?>"><?php echo wc_price( $default_shipping_cost )?></span></p>
					<p class="ywgc-gift-card-total"><?php echo esc_html__( "Gift Card total: ", 'yith-woocommerce-gift-cards' ); ?>
						<span class="ywgc-gift-card-total-value"><?php echo wc_price( $product->get_price() + $default_shipping_cost ) ?></span></p>
					<input type="hidden" name="ywgc-gift-this-product-total-value" class="ywgc-gift-this-product-total-value" value="<?php echo (float)$product->get_price() + (float)$default_shipping_cost; ?>">
				</div>
			</div>

		<div class="ywgc-include-fixed-shipping-container ywgc-hidden">

			<p class="ywgc-gift-card-fixed-shipping-total"><?php echo esc_html__( "Shipping cost: ", 'yith-woocommerce-gift-cards' ); ?>
				<span class="ywgc-gift-card-fixed-shipping-total-value" data-shipping-cost="<?php echo $default_shipping_cost?>"><?php echo wc_price( $fixed_shipping_cost )?></span></p>

			<p class="ywgc-gift-card-total"><?php echo esc_html__( "Gift Card total: ", 'yith-woocommerce-gift-cards' ); ?>
				<span class="ywgc-gift-card-total-value"><?php echo wc_price( $product->get_price() + $fixed_shipping_cost ) ?></span></p>
			<input type="hidden" name="ywgc-gift-this-product-total-value" class="ywgc-gift-this-product-total-value" value="<?php echo (float)$product->get_price() + (float)$fixed_shipping_cost; ?>">

		</div>




		<?php endif; ?>

	<?php endif; ?>

</form>

<?php



if ( $product->is_type('variable') ) {
	$variations_data =[]; // Initializing

	// Loop through variations data
	foreach($product->get_available_variations() as $variation ) {
	// Set for each variation ID the corresponding price in the data array (to be used in jQuery)
	$variations_data[$variation['variation_id']] = $variation['display_price'];
	}
	?>
	<script>
		jQuery(function($) {
			var jsonData = <?php echo json_encode($variations_data); ?>,
				inputVID = 'input.variation_id';

			$('input.variation_id').change( function(){
				if( '' != $(inputVID).val() ) {
					var     vid      = $(inputVID).val(), // VARIATION ID
							vprice   = ''; // Initilizing

					// Loop through variation IDs / Prices pairs
					$.each( jsonData, function( index, price ) {
						if( index == vid ) {
							vprice = price;
						}
					});

					var shipping_price = parseFloat($('.ywgc-gift-card-shipping-total-value').data('shipping-cost')).toFixed(2);
					var total_price_raw = parseFloat( vprice ) + parseInt ( shipping_price );

					var currency_format_decimal_sep = $('.ywgc-gift-this-product-totals').data('decimal-separator');
					var currency_format_symbol = $('.ywgc-gift-this-product-totals').data('currency');

					vprice = vprice.toString().replace('.', currency_format_decimal_sep) + ' ' + currency_format_symbol;
					var total_price = total_price_raw.toFixed(2).toString().replace('.', currency_format_decimal_sep) + ' ' + currency_format_symbol;

					$('.ywgc-gift-card-product-total-value').text( vprice );
					$('.ywgc-gift-card-total-value').text( total_price );
					$('input.ywgc-gift-this-product-total-value').val( total_price_raw );
				}
			});
		});
	</script>
<?php
}
