<?php
/*
*	Page 404 Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( impeka_grve_visibility( 'page_404_header' ) ) {
	get_header();
} else {
	get_header( 'basic' );
}

$section_classes = "grve-section grve-percentage-height grve-loading-height";
?>
			<div id="grve-content" class="grve-error-404 clearfix">
				<div class="grve-content-wrapper">
					<div id="grve-main-content">
						<div class="grve-main-content-wrapper grve-padding-none clearfix">
						<?php
							$page_404_mode = impeka_grve_option('page_404_mode');
							if ( 'area-item' == $page_404_mode ) {
								$area_id = impeka_grve_option('page_404_area');
								if ( !empty( $area_id ) ) {
						?>
								<div id="grve-page-404">
									<?php do_action( 'impeka_grve_area_content', $area_id ); ?>
								</div>
						<?php
								}
							} else {
						?>
							<div id="grve-default-page-404">
								<div class="grve-container">
									<div class="grve-inner">
										<div class="grve-404-content">
											<?php
												$page_404_search_box = impeka_grve_option('page_404_search');
												$page_404_home_button = impeka_grve_option('page_404_home_button');
												echo do_shortcode( wp_kses_post( impeka_grve_option( 'page_404_content' ) ) );
											?>

											<?php if ( $page_404_search_box ) { ?>
											<div class="grve-widget">
												<?php get_search_form(); ?>
											</div>
											<?php } ?>

											<?php if ( $page_404_home_button ) { ?>
											<div class="grve-element">
												<a class="grve-btn grve-btn-medium grve-round grve-bg-primary-1 grve-bg-hover-black grve-border-primary-1 grve-border-hover-black grve-text-white grve-text-hover-white" target="_self" href="<?php echo esc_url( home_url( '/' ) ); ?>">
													<span><?php echo esc_html( get_bloginfo( 'name' ) ); ?></span>
												</a>
											</div>
											<?php } ?>
										</div>
									</div>
								</div>
							</div>

						<?php
							}
						?>
						</div>
					</div>
				</div>
			</div>
<?php

if ( impeka_grve_visibility( 'page_404_footer' ) ) {
	get_footer();
} else {
	get_footer( 'basic' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
