<?php
/*
*	Post Content Quote Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$disable_media = impeka_grve_post_meta( '_impeka_grve_disable_media' );
$media_type = impeka_grve_option( 'post_feature_media_type' );
$media_type = impeka_grve_post_meta( '_impeka_grve_feature_media_type', $media_type );
$media_classes = array('grve-media');
if( 'wide' == $media_type ) {
	$media_classes[] = 'grve-wide';
}
$media_class_string = implode( ' ', $media_classes );

$post_quote_name = impeka_grve_post_meta( '_impeka_grve_post_quote_name' );
$post_quote_content = impeka_grve_post_meta( '_impeka_grve_post_quote_text' );

?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> itemscope itemType="http://schema.org/BlogPosting">

	<?php
		if ( impeka_grve_visibility( 'post_feature_image_visibility', '1' ) && 'yes' != $disable_media && has_post_thumbnail() ) {
			if( 'wide' == $media_type ) {
				$image_size = "impeka-grve-large-rect-horizontal";
			} else {
				$image_size = "large";
			}
	?>
	<div id="grve-single-media">
		<div class="grve-container">
			<div class="<?php echo esc_attr( $media_class_string ); ?>">
				<?php
					$img_id = get_post_thumbnail_id();
					$img_src = wp_get_attachment_image_src( $img_id, $image_size );
					$img_width = $img_src[1];
					$img_height = $img_src[2];

					if( ($img_width >= $img_height && $img_width >= 1024) || 'wide' == $media_type ) {
						impeka_grve_the_post_thumbnail( $image_size, array( 'data-column-space' => 100 ) );
					} else {
						impeka_grve_the_post_thumbnail( $image_size );
					}
				?>
			</div>
		</div>
	</div>
	<?php
		}
	?>
	<?php do_action( 'impeka_grve_single_content_before' ); ?>
	<div id="grve-single-content">
		<?php impeka_grve_print_post_simple_title(); ?>
		<div itemprop="articleBody">
			<?php if ( !empty( $post_quote_content ) ) { ?>
			<div class="grve-container">
				<div class="grve-single-quote-wrapper grve-svg-primary-1 grve-margin-bottom-3x">
					<?php echo impeka_grve_quote_excerpt(); ?>
					<?php if ( !empty( $post_quote_name ) ) { ?>
						<div class="grve-quote-writer"><?php echo wp_kses_post(  $post_quote_name ); ?></div>
					<?php } ?>
					<svg width="104px" height="85px" viewBox="0 0 104 85">
						<path d="M28.7828947,85 C34.8135965,85 39.8574561,83.1019417 43.9144737,79.3058252 C47.9714912,75.5097087 50,70.9708738 50,65.6893204 C50,60.8478964 48.3278509,56.7491909 44.9835526,53.3932039 C41.6392544,50.0372168 37.7192982,48.3592233 33.2236842,48.3592233 C31.25,48.3592233 29.0570175,48.7718447 26.6447368,49.5970874 C24.2324561,50.4223301 22.3135965,50.8349515 20.8881579,50.8349515 C19.4627193,50.8349515 18.2565789,50.0647249 17.2697368,48.5242718 C16.1732456,47.0938511 15.625,44.4530744 15.625,40.6019417 C15.625,34.1100324 17.7083333,28.1132686 21.875,22.6116505 C26.0416667,17.1100324 32.9495614,11.828479 42.5986842,6.76699029 L42.5986842,6.76699029 L42.5986842,0 C28.7828947,4.51132686 18.2291667,11.52589 10.9375,21.0436893 C3.64583333,30.5614887 0,40.8220065 0,51.8252427 C0,61.1779935 2.96052632,69.0453074 8.88157895,75.4271845 C14.8026316,81.8090615 21.4364035,85 28.7828947,85 Z M82.1967213,85 C88.3169399,85 93.4808743,83.0116959 97.6885246,79.0350877 C101.896175,75.0584795 104,70.3638726 104,64.9512671 C104,60.2014295 102.333333,56.197206 99,52.9385965 C95.6666667,49.679987 91.7595628,48.0506823 87.2786885,48.0506823 C84.8743169,48.0506823 82.4699454,48.4925276 80.0655738,49.3762183 C77.6612022,50.259909 75.8579235,50.7017544 74.6557377,50.7017544 C73.3442623,50.7017544 72.0874317,49.928525 70.8852459,48.3820663 C69.6830601,46.8356075 69.0819672,44.5159194 69.0819672,41.4230019 C69.0819672,34.574399 70.8306011,28.6094867 74.3278689,23.5282651 C77.8251366,18.4470435 85.0928962,12.7030539 96.1311475,6.2962963 L96.1311475,6.2962963 L96.1311475,0 C82.6885246,3.97660819 72.3060109,10.7423652 64.9836066,20.297271 C57.6612022,29.8521767 54,40.4288499 54,52.0272904 C54,61.4165042 56.8961749,69.2592593 62.6885246,75.5555556 C68.4808743,81.8518519 74.9836066,85 82.1967213,85 Z"></path>
					</svg>
				</div>
			</div>
			<?php } ?>
			<?php the_content(); ?>
		</div>
		<?php impeka_grve_print_post_structured_data(); ?>
	</div>
	<?php do_action( 'impeka_grve_single_content_after' ); ?>
</article>