<?php
/*
*	Admin Check
*
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Impeka_Grve_Admin_Check {

	private static $instance = null;
	private $server_url = 'https://hub.greatives.eu';
	private $item_id = '31105756';
	private $item_name = 'Impeka';

	public static function get_instance() {
		if ( ! self::$instance ) {
			self::$instance = new self;
		}
		return self::$instance;
	}

	public function __construct() {
		add_action( 'wp_ajax_impeka_grve_check_api', array( $this, 'check_api' ), 30 );
	}

	public function Impeka_Grve_Admin_Check() {
		$this->__construct();
	}

	function check_api() {
		check_ajax_referer( 'impeka-grve-check-nonce', '_grve_nonce' );
		if( isset( $_POST['purchase_code'] ) ) {
			$code = filter_input( INPUT_POST, 'purchase_code', FILTER_SANITIZE_STRING );

			if ( empty( $code ) ) {
				echo esc_html__( 'Purchase code is empty!', 'impeka' );
				die();
			}

			$api_action = 'check';
			if( isset( $_POST['api_action'] ) ) {
				$api_action = filter_input( INPUT_POST, 'api_action', FILTER_SANITIZE_STRING );
			}

			$api_params = array(
				'grve-hub-action'	=> $api_action,
				'grve-hub-purchase-code'=> $code,
				'grve-hub-item-id' => $this->item_id,
				'grve-hub-url' => home_url(),
				'grve-hub-environment' => function_exists( 'wp_get_environment_type' ) ? wp_get_environment_type() : 'production',
			);

			// Call the custom API.
			$response = wp_remote_post(
				$this->server_url  . '/grve-hub-api',
				array(
					'timeout'   => 15,
					'sslverify' => false,
					'body'      => $api_params,
				)
			);

			if ( is_wp_error( $response ) || 200 !== wp_remote_retrieve_response_code( $response ) ) {

				if ( is_wp_error( $response ) ) {
					echo wp_kses_post( $response->get_error_message() );
				} else {
					echo esc_html__( 'An error occurred, please try again.', 'impeka' );
				}
			} else {
				$license_data = json_decode( wp_remote_retrieve_body( $response ) );
				if ( 'activate' == $api_action ) {
					if ( true === $license_data->success ) {
						update_option( impeka_grve_get_purchase_code_option_name(), $code );
						update_option( 'impeka_grve_registration_status', 'active' );
						echo 'success';
					} else {
						$message = $this->get_api_message( $license_data->error );
						echo wp_kses_post( $message );

					}
				} elseif ( 'deactivate' == $api_action ) {
						delete_option( impeka_grve_get_purchase_code_option_name() );
						delete_option( 'impeka_grve_registration_status' );
						echo 'success';
				} else {
					if ( true === $license_data->success ) {
						$message = $this->get_api_message( $license_data->status );
						echo wp_kses_post( $message );
					} else {
						$message = $this->get_api_message( $license_data->error );
						echo wp_kses_post( $message );
					}
				}
			}

		}
		if( isset( $_POST['purchase_code'] ) ) { die(); }
	}

	function get_api_message( $error ) {
		switch ( $error ) {
			case 'expired':
				$message = esc_html__( 'Your purchase code has been expired.', 'impeka' );
				break;
			case 'disabled':
			case 'revoked':
				$message = esc_html__( 'Your purchase code has been disabled.', 'impeka' );
				break;
			case 'missing':
			case 'invalid':
				$message = esc_html__( 'Invalid purchase code.', 'impeka' );
				break;
			case 'site_inactive':
			case 'inactive':
				$message = esc_html__( 'Your purchase code is not active for this URL.', 'impeka' );
				break;
			case 'item_name_mismatch':
				$message = esc_html__( 'This appears to be an invalid purchase code for this theme.', 'impeka' );
				break;
			case 'no_activations_left':
				$message = esc_html__( 'Your purchase code is already used in another website.', 'impeka' );
				break;
			case 'valid':
			case 'active':
				$message = esc_html__( 'Your purchase code is active for this URL.', 'impeka' );
				break;
			default:
				$message = esc_html__( 'An error occurred, please try again.', 'impeka' );
				break;
		}
		return $message;
	}

}
new Impeka_Grve_Admin_Check;

//Omit closing PHP tag to avoid accidental whitespace output errors.
