<?php

/*
*	Admin functions and definitions
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

/**
 * Default hidden metaboxes for portfolio
 */
function impeka_grve_change_default_hidden( $hidden, $screen ) {
    if ( 'portfolio' == $screen->id ) {
        $hidden = array_flip( $hidden );
        unset( $hidden['portfolio_categorydiv'] ); //show portfolio category box
        $hidden = array_flip( $hidden );
        $hidden[] = 'postexcerpt';
		$hidden[] = 'postcustom';
		$hidden[] = 'commentstatusdiv';
		$hidden[] = 'commentsdiv';
		$hidden[] = 'authordiv';
    }
    return $hidden;
}
add_filter( 'default_hidden_meta_boxes', 'impeka_grve_change_default_hidden', 10, 2 );

/**
 * Enqueue scripts and styles for the back end.
 */
function impeka_grve_backend_scripts( $hook ) {
	global $post, $pagenow;

	wp_register_style( 'impeka-grve-page-feature-section', get_template_directory_uri() . '/includes/css/grve-page-feature-section.css', array(), time() );
	wp_register_style( 'impeka-grve-admin-meta', get_template_directory_uri() . '/includes/css/grve-admin-meta.css', array(), time() );
	wp_register_style( 'impeka-grve-admin-panel', get_template_directory_uri() . '/includes/css/grve-admin-panel.css', array(), time() );
	wp_register_style( 'impeka-grve-custom-nav-menu', get_template_directory_uri() . '/includes/css/grve-custom-nav-menu.css', array(), time());

	$upload_slider_texts = array(
		'modal_title' => esc_html__( 'Insert Images', 'impeka' ),
		'modal_button_title' => esc_html__( 'Insert Images', 'impeka' ),
		'ajaxurl' => esc_url( admin_url( 'admin-ajax.php' ) ),
		'nonce_feature_slider_media' => wp_create_nonce( 'impeka-grve-get-feature-slider-media' ),
		'nonce_slider_media' => wp_create_nonce( 'impeka-grve-get-slider-media' ),
	);
	$upload_image_replace_texts = array(
		'modal_title' => esc_html__( 'Replace Image', 'impeka' ),
		'modal_button_title' => esc_html__( 'Replace Image', 'impeka' ),
		'ajaxurl' => esc_url( admin_url( 'admin-ajax.php' ) ),
		'nonce_replace' => wp_create_nonce( 'impeka-grve-get-replaced-image' ),
	);
	$upload_media_texts = array(
		'modal_title' => esc_html__( 'Insert Media', 'impeka' ),
		'modal_button_title' => esc_html__( 'Insert Media', 'impeka' ),
	);
	$feature_section_texts = array(
		'ajaxurl' => esc_url( admin_url( 'admin-ajax.php' ) ),
		'nonce_map_point' => wp_create_nonce( 'impeka-grve-get-map-point' ),
	);
	$sidebar_texts = array(
		'ajaxurl' => esc_url( admin_url( 'admin-ajax.php' ) ),
		'nonce_custom_sidebar' => wp_create_nonce( 'impeka-grve-get-custom-sidebar' ),
	);
	$modal_texts = array(
		'ajaxurl' => esc_url( admin_url( 'admin-ajax.php' ) ),
		'nonce_modal_item' => wp_create_nonce( 'impeka-grve-get-modal-item' ),
	);
	$check_texts = array(
		'ajaxurl' => esc_url( admin_url( 'admin-ajax.php' ) ),
		'nonce_check' => wp_create_nonce( 'impeka-grve-check-nonce' ),
	);

	wp_register_script( 'impeka-grve-status', get_template_directory_uri() . '/includes/js/grve-status.js', array( 'jquery'), time(), false );

	wp_register_script( 'impeka-grve-check', get_template_directory_uri() . '/includes/js/grve-check.js', array( 'jquery'), time(), false );
	wp_localize_script( 'impeka-grve-check', 'impeka_grve_check_texts', $check_texts );

	wp_register_script( 'impeka-grve-custom-sidebars', get_template_directory_uri() . '/includes/js/grve-custom-sidebars.js', array( 'jquery'), time(), false );
	wp_localize_script( 'impeka-grve-custom-sidebars', 'impeka_grve_custom_sidebar_texts', $sidebar_texts );

	wp_register_script( 'impeka-grve-upload-slider-script', get_template_directory_uri() . '/includes/js/grve-upload-slider.js', array( 'jquery'), time(), false );
	wp_localize_script( 'impeka-grve-upload-slider-script', 'impeka_grve_upload_slider_texts', $upload_slider_texts );

	wp_register_script( 'impeka-grve-upload-feature-slider-script', get_template_directory_uri() . '/includes/js/grve-upload-feature-slider.js', array( 'jquery'), time(), false );
	wp_localize_script( 'impeka-grve-upload-feature-slider-script', 'impeka_grve_upload_feature_slider_texts', $upload_slider_texts );

	wp_register_script( 'impeka-grve-upload-image-replace-script', get_template_directory_uri() . '/includes/js/grve-upload-image-replace.js', array( 'jquery'), time(), false );
	wp_localize_script( 'impeka-grve-upload-image-replace-script', 'impeka_grve_upload_image_replace_texts', $upload_image_replace_texts );

	wp_register_script( 'impeka-grve-upload-simple-media-script', get_template_directory_uri() . '/includes/js/grve-upload-simple.js', array( 'jquery'), time(), false );
	wp_localize_script( 'impeka-grve-upload-simple-media-script', 'impeka_grve_upload_media_texts', $upload_media_texts );

	wp_register_script( 'impeka-grve-page-feature-section-script', get_template_directory_uri() . '/includes/js/grve-page-feature-section.js', array( 'jquery', 'wp-color-picker' ), time(), false );
	wp_localize_script( 'impeka-grve-page-feature-section-script', 'impeka_grve_feature_section_texts', $feature_section_texts );

	wp_register_script( 'impeka-grve-modals-script', get_template_directory_uri() . '/includes/js/grve-modals.js', array( 'jquery' ), time(), false );
	wp_localize_script( 'impeka-grve-modals-script', 'impeka_grve_modal_texts', $modal_texts );

	wp_register_script( 'impeka-grve-post-options-script', get_template_directory_uri() . '/includes/js/grve-post-options.js', array( 'jquery'), time(), false );
	wp_register_script( 'impeka-grve-portfolio-options-script', get_template_directory_uri() . '/includes/js/grve-portfolio-options.js', array( 'jquery'), time(), false );

	wp_register_script( 'impeka-grve-custom-nav-menu-script', get_template_directory_uri().'/includes/js/grve-custom-nav-menu.js', array( 'jquery'), time(), false );


	wp_register_script( 'jquery-blockui', get_template_directory_uri().'/includes/js/jquery.blockUI.js', array( 'jquery' ), '2.70', true );
	wp_register_script( 'impeka-grve-admin-wizard', get_template_directory_uri().'/includes/js/grve-admin-wizard.js', array('jquery', 'jquery-blockui' ), time(), false);
	wp_localize_script( 'impeka-grve-admin-wizard', 'impeka_grve_wizard_params', array(
		'tgm_plugin_nonce' => array(
			'update'  => wp_create_nonce( 'tgmpa-update' ),
			'install' => wp_create_nonce( 'tgmpa-install' ),
		),
		'tgm_bulk_url'     => admin_url( 'admin.php?page=impeka-tgmpa-install-plugins' ),
		'ajaxurl'          => admin_url( 'admin-ajax.php' ),
		'nonce_wizard'      => wp_create_nonce( 'impeka-grve-wizard-nonce' ),
		'verify_text'      => esc_html__( '...verifying', 'impeka' ),
	) );


	if ( $hook == 'post-new.php' || $hook == 'post.php' ) {

		$feature_section_post_types = impeka_grve_option( 'feature_section_post_types' );
		$feature_section_post_types = apply_filters( 'impeka_grve_feature_section_post_types', $feature_section_post_types );

		if ( !empty( $feature_section_post_types ) && in_array( $post->post_type, $feature_section_post_types ) && 'attachment' != $post->post_type ) {

			wp_enqueue_style( 'impeka-grve-admin-meta' );
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_style( 'impeka-grve-page-feature-section' );

			wp_enqueue_script( 'impeka-grve-upload-simple-media-script' );
			wp_enqueue_script( 'impeka-grve-upload-image-script' );
			wp_enqueue_script( 'impeka-grve-upload-slider-script' );
			wp_enqueue_script( 'impeka-grve-upload-feature-slider-script' );
			wp_enqueue_script( 'impeka-grve-upload-image-replace-script' );
			wp_enqueue_script( 'impeka-grve-page-feature-section-script' );
		}


        if ( 'post' === $post->post_type ) {

			wp_enqueue_style( 'impeka-grve-admin-meta' );
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_style( 'impeka-grve-page-feature-section' );

			wp_enqueue_script( 'impeka-grve-upload-simple-media-script' );
			wp_enqueue_script( 'impeka-grve-upload-image-script' );
			wp_enqueue_script( 'impeka-grve-upload-slider-script' );
			wp_enqueue_script( 'impeka-grve-upload-feature-slider-script' );
			wp_enqueue_script( 'impeka-grve-upload-image-replace-script' );
			wp_enqueue_script( 'impeka-grve-page-feature-section-script' );
			wp_enqueue_script( 'impeka-grve-post-options-script' );
			wp_enqueue_script( 'impeka-grve-modals-script' );

        } else if ( 'page' === $post->post_type || 'portfolio' === $post->post_type || 'product' === $post->post_type || 'tribe_events' === $post->post_type ) {

			wp_enqueue_style( 'impeka-grve-admin-meta' );
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_style( 'impeka-grve-page-feature-section' );

			wp_enqueue_script( 'impeka-grve-upload-simple-media-script' );
			wp_enqueue_script( 'impeka-grve-upload-image-script' );
			wp_enqueue_script( 'impeka-grve-upload-slider-script' );
			wp_enqueue_script( 'impeka-grve-upload-feature-slider-script' );
			wp_enqueue_script( 'impeka-grve-upload-image-replace-script' );
			wp_enqueue_script( 'impeka-grve-page-feature-section-script' );
			wp_enqueue_script( 'impeka-grve-modals-script' );

			wp_enqueue_script( 'impeka-grve-portfolio-options-script' );

        } else if ( 'testimonial' === $post->post_type ) {

			wp_enqueue_style( 'impeka-grve-admin-meta' );
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_style( 'impeka-grve-page-feature-section' );

        }
    }

	if ( $hook == 'edit-tags.php' || $hook == 'term.php') {
		wp_enqueue_style( 'impeka-grve-admin-meta' );
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_style( 'impeka-grve-page-feature-section' );


		wp_enqueue_media();
		wp_enqueue_script( 'impeka-grve-page-feature-section-script' );
		wp_enqueue_script( 'impeka-grve-upload-image-script' );
		wp_enqueue_script( 'impeka-grve-upload-image-replace-script' );

	}

	if ( $hook == 'nav-menus.php' ) {
		wp_enqueue_style( 'impeka-grve-custom-nav-menu' );

		wp_enqueue_media();
		wp_enqueue_script( 'impeka-grve-upload-simple-media-script' );
		wp_enqueue_script( 'impeka-grve-custom-nav-menu-script' );
	}

	//Admin Screens
	if ( isset( $_GET['page'] ) ) {
		$current_page = $_GET['page'];
		switch( $current_page ) {
			case 'impeka':
				wp_enqueue_style( 'impeka-grve-admin-panel' );
				wp_enqueue_script( 'impeka-grve-check' );
			break;
			case 'impeka-import':
			case 'impeka-tgmpa-install-plugins':
				wp_enqueue_style( 'impeka-grve-admin-panel' );
			break;
			case 'impeka-sidebars':
				wp_enqueue_style( 'impeka-grve-admin-panel' );
				wp_enqueue_script( 'jquery-ui-sortable' );
				wp_enqueue_script( 'impeka-grve-custom-sidebars' );
			break;
			case 'impeka-status':
				wp_enqueue_style( 'impeka-grve-admin-panel' );
				wp_enqueue_script( 'impeka-grve-status' );
			break;
			case 'impeka-wizard':
				wp_enqueue_style( 'impeka-grve-admin-panel' );
				wp_enqueue_script( 'impeka-grve-admin-wizard' );
			break;
			default:
			break;
		}
	}
	wp_enqueue_style(
		'impeka-grve-redux-custom',
		get_template_directory_uri() . '/includes/css/grve-redux-panel.css',
		array(),
		time(),
		'all'
	);

}
add_action( 'admin_enqueue_scripts', 'impeka_grve_backend_scripts', 10, 1 );

/**
 * Enqueue custom script for options panel
 */
function impeka_grve_redux_script() {
	wp_enqueue_script( 'impeka-grve-redux-script', get_template_directory_uri().'/includes/js/grve-redux.js', array( 'jquery'), false, time() );
}
add_action( 'redux/page/impeka_grve_options/enqueue', 'impeka_grve_redux_script' );

/**
 * Helper function to get custom fields with fallback
 */
function impeka_grve_post_meta( $id, $fallback = false ) {
	$post_id = get_the_ID();
	if ( $fallback == false ) $fallback = '';
	$post_meta = get_post_meta( $post_id, $id, true );
	$output = ( $post_meta !== '' ) ? $post_meta : $fallback;
	return $output;
}

function impeka_grve_admin_post_meta( $post_id, $id, $fallback = false ) {
	if ( $fallback == false ) $fallback = '';
	$post_meta = get_post_meta( $post_id, $id, true );
	$output = ( $post_meta !== '' ) ? $post_meta : $fallback;
	return $output;
}

function impeka_grve_get_term_meta( $term_id, $meta_key ) {
	$term_meta  = '';

	if ( function_exists( 'get_term_meta' ) ) {
		$term_meta = get_term_meta( $term_id, $meta_key, true );
	}
	if( empty ( $term_meta ) ) {
		$term_meta = array();
	}
	return $term_meta;
}

function impeka_grve_update_term_meta( $term_id , $meta_key, $meta_value ) {

	if ( function_exists( 'update_term_meta' ) ) {
		update_term_meta( $term_id, $meta_key, $meta_value );
	}

}

/**
 * Helper function to get global params with fallback
 */
function impeka_grve_global_param( $id, $fallback = false, $param = false ) {
	global $impeka_grve_global_params;
	$params = $impeka_grve_global_params;

	if ( $fallback == false ) $fallback = '';
	$output = ( isset($params[$id]) && $params[$id] !== '' ) ? $params[$id] : $fallback;
	if ( !empty($params[$id]) && $param ) {
		$output = ( isset($params[$id][$param]) && $params[$id][$param] !== '' ) ? $params[$id][$param] : $fallback;
	}
	return $output;
}

/**
 * Helper function to get theme options with fallback
 */
function impeka_grve_option( $id, $fallback = false, $param = false ) {
	global $impeka_grve_options;
	if ( ! $impeka_grve_options ) {
		$impeka_grve_options = get_option( 'impeka_grve_options', array() );
	}
	$grve_theme_options = $impeka_grve_options;

	if ( $fallback == false ) $fallback = '';
	$output = ( isset($grve_theme_options[$id]) && $grve_theme_options[$id] !== '' ) ? $grve_theme_options[$id] : $fallback;
	if ( !empty($grve_theme_options[$id]) && $param ) {
		$output = ( isset($grve_theme_options[$id][$param]) && $grve_theme_options[$id][$param] !== '' ) ? $grve_theme_options[$id][$param] : $fallback;
		if ( 'font-family' == $param ) {
			//Backup Font Test
			$backupFont = isset($grve_theme_options[$id]['font-backup']) ? $grve_theme_options[$id]['font-backup'] : '';
			$google = isset($grve_theme_options[$id]['google']) ? $grve_theme_options[$id]['google'] : 'false';
			if ( !empty( $backupFont ) && 'true' == $google ) {
				$output .= $output . ' ,' . $backupFont;
			}
			$output = urldecode( $output );
			if ( strpos($output, ' ') && !strpos($output, ',') ) {
				$output = '"' . $output . '"';
			}
		}
	}
	return $output;
}

/**
 * Helper function to print css code if not empty
 */
function impeka_grve_css_option( $id, $fallback = false, $param = false, $important = false  ) {
	$option = impeka_grve_option( $id, $fallback, $param );
	if ( !empty( $option ) && 0 !== $option && $param ) {
		if ( 'important' == $important ) {
			return $param . ': ' . $option . ' !important;';
		} else {
			return $param . ': ' . $option . ';';
		}

	}
}


/**
 * Helper function to get array value with fallback
 */
function impeka_grve_array_value( $input_array, $id, $fallback = false, $param = false ) {

	if ( $fallback == false ) $fallback = '';
	$output = ( isset($input_array[$id]) && $input_array[$id] !== '' ) ? $input_array[$id] : $fallback;
	if ( !empty($input_array[$id]) && $param ) {
		$output = ( isset($input_array[$id][$param]) && $input_array[$id][$param] !== '' ) ? $input_array[$id][$param] : $fallback;
	}
	return $output;
}

/**
 * Helper function to return trimmed css code
 */
if ( ! function_exists( 'impeka_grve_compress_css' ) ) {
	function impeka_grve_compress_css( $css ) {
		$css_trim =  preg_replace( '/\s+/', ' ', $css );
		return $css_trim;
	}
}

/**
 * Helper function to get css template code
 */
function impeka_grve_get_css_template( $template_name = '' ) {
	ob_start();
	get_template_part( '/includes/css-templates/' . $template_name );
	return ob_get_clean();
}

/**
 * Helper function convert hex to rgb
 */
function impeka_grve_hex2rgb( $hex ) {

	if (strpos($hex, '#') !== 0) {
		$hex = "#ffffff";
	}
	$hex = str_replace("#", "", $hex);

	if(strlen($hex) == 3) {
		$r = hexdec( substr( $hex, 0, 1 ).substr( $hex, 0, 1) );
		$g = hexdec( substr( $hex, 1, 1 ).substr( $hex, 1, 1) );
		$b = hexdec( substr( $hex, 2, 1 ).substr( $hex, 2, 1) );
	} else {
		$r = hexdec( substr( $hex, 0, 2) );
		$g = hexdec( substr( $hex, 2, 2) );
		$b = hexdec( substr( $hex, 4, 2) );
	}
	$rgb = array($r, $g, $b);
	return implode(",", $rgb);
}

/**
 * Helper function to get theme visibility options
 */
function impeka_grve_visibility( $id, $fallback = '' ) {
	$visibility = impeka_grve_option( $id, $fallback  );
	if ( '1' == $visibility ) {
		return true;
	}
	return false;
}

function impeka_grve_is_enabled( $value ) {
	if ( '1' == $value || 'yes' == $value || 'on' == $value ) {
		return true;
	}
	return false;
}

/**
 * Get Color
 */
function impeka_grve_get_color( $color = 'dark', $color_custom = '#000000' ) {

	switch( $color ) {

		case 'none':
		case 'transparent':
			$color_custom = 'transparent';
			break;
		case 'dark':
		case 'black':
			$color_custom = '#000000';
			break;
		case 'light':
		case 'white':
			$color_custom = '#ffffff';
			break;
		case 'primary-1':
			$color_custom = impeka_grve_option( 'body_primary_1_color' );
			break;
		case 'primary-2':
			$color_custom = impeka_grve_option( 'body_primary_2_color' );
			break;
		case 'primary-3':
			$color_custom = impeka_grve_option( 'body_primary_3_color' );
			break;
		case 'primary-4':
			$color_custom = impeka_grve_option( 'body_primary_4_color' );
			break;
		case 'primary-5':
			$color_custom = impeka_grve_option( 'body_primary_5_color' );
			break;
		case 'primary-6':
			$color_custom = impeka_grve_option( 'body_primary_6_color' );
			break;
	}

	return $color_custom;
}

/**
 * Backend Theme Activation Actions
 */
function impeka_grve_backend_theme_activation() {
	global $pagenow;

	if ( is_admin() && isset( $_GET['activated'] ) && $pagenow == 'themes.php' ) {

		//Redirect to Welcome
		header( 'Location: ' . esc_url( admin_url() ) . 'admin.php?page=impeka' ) ;
	}
}

add_action('admin_init','impeka_grve_backend_theme_activation');

/**
 * Check if Revolution slider is active
 */

/**
 * Check if to replace Backend Logo
 */
function impeka_grve_admin_login_logo() {
	$replace_logo = impeka_grve_option( 'replace_admin_logo' );
	if ( $replace_logo ) {
		$admin_logo = impeka_grve_option( 'admin_logo','','url' );
		$admin_logo_height = impeka_grve_option( 'admin_logo_height','84');
		$admin_logo_height = preg_match('/(px|em|\%|pt|cm)$/', $admin_logo_height) ? $admin_logo_height : $admin_logo_height . 'px';
		if( empty( $admin_logo ) ) {
			$admin_logo = impeka_grve_option( 'logo','','url' );
		} else {
			$admin_logo = str_replace( array( 'http:', 'https:' ), '', $admin_logo );
			echo "
			<style>
			.login h1 a {
				background-image: url('" . esc_url( $admin_logo ) . "');
				width: 100%;
				max-width: 300px;
				background-size: auto " . esc_attr( $admin_logo_height ) . ";
				height: " . esc_attr( $admin_logo_height ) . ";
			}
			</style>
			";
		}
	}

}
add_action( 'login_head', 'impeka_grve_admin_login_logo' );

function impeka_grve_panel_logo() {
	$admin_logo =  get_template_directory_uri() . "/includes/images/redux-panel/logo.png";

	$replace_logo = impeka_grve_option( 'replace_admin_logo' );
	if ( $replace_logo ) {
		$admin_logo = impeka_grve_option( 'admin_logo','','url' );
		if( empty( $admin_logo ) ) {
			$admin_logo = impeka_grve_option( 'logo','','url' );
		} else {
			$admin_logo = str_replace( array( 'http:', 'https:' ), '', $admin_logo );
		}
	}
	$admin_logo = apply_filters( 'impeka_grve_admin_panel_logo_url', $admin_logo );
	?>
	<img src="<?php echo esc_url( $admin_logo ); ?>" alt="Admin Logo">
	<?php
}

function impeka_grve_login_headerurl( $url ){
	$replace_logo = impeka_grve_option( 'replace_admin_logo' );
	if ( $replace_logo ) {
		return esc_url( home_url( '/' ) );
	}
	return esc_url( $url );
}
add_filter('login_headerurl', 'impeka_grve_login_headerurl');

function impeka_grve_login_headertitle( $title ) {
	$replace_logo = impeka_grve_option( 'replace_admin_logo' );
	if ( $replace_logo ) {
		return esc_attr( get_bloginfo( 'name' ) );
	}
	return esc_attr( $title );
}
add_filter('login_headertext', 'impeka_grve_login_headertitle' );

/**
 * Browser Webkit Check
 */
if ( ! function_exists( 'impeka_grve_browser_webkit_check' ) ) {
	function impeka_grve_browser_webkit_check() {
		$scrolling_speed = impeka_grve_option( 'scrolling_speed', 'normal' );
		if ( 'disabled' == $scrolling_speed ) {
			return false;
		} else {
			if ( function_exists( 'impeka_ext_browser_webkit_check' ) ) {
				return impeka_ext_browser_webkit_check();
			} else {
				return false;
			}
		}
	}
}

/**
 * Add Hooks for Page Redirect ( Coming Soon )
 */
add_filter( 'template_include', 'impeka_grve_redirect_page_template', 99 );

if ( ! function_exists( 'impeka_grve_redirect_page_template' ) ) {
	function impeka_grve_redirect_page_template( $template ) {
		if ( impeka_grve_visibility('coming_soon_enabled' )  && !is_user_logged_in() ) {
			$redirect_page = impeka_grve_option( 'coming_soon_page' );
			$redirect_template = impeka_grve_option( 'coming_soon_template' );
			if ( !empty( $redirect_page ) && 'content' == $redirect_template ) {
				$new_template = get_template_directory() . '/page-templates/template-content-only.php';
				return $new_template ;
			}
		}
		return $template;
	}
}

add_filter( 'template_redirect', 'impeka_grve_redirect' );

if ( ! function_exists( 'impeka_grve_redirect' ) ) {
	function impeka_grve_redirect() {
		if ( impeka_grve_visibility('coming_soon_enabled' ) && !is_user_logged_in() ) {
			$redirect_page = impeka_grve_option( 'coming_soon_page' );
			if ( !empty( $redirect_page )
				&& !in_array( $GLOBALS['pagenow'], array('wp-login.php', 'wp-register.php') )
				&& !is_admin()
				&& !is_page( $redirect_page ) ) {
				wp_redirect( get_permalink( $redirect_page ) );
				exit();

			}
		}
		return false;
	}
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
