<?php

/*
*	Admin Global Parameter and functions
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

$impeka_grve_global_admin_params = array(
	'tag_selection' => array(
		'div' => esc_html__( 'div', 'impeka' ),
		'h1' => esc_html__( 'h1', 'impeka' ),
		'h2' => esc_html__( 'h2', 'impeka' ),
		'h3' => esc_html__( 'h3', 'impeka' ),
		'h4' => esc_html__( 'h4', 'impeka' ),
		'h5' => esc_html__( 'h5', 'impeka' ),
		'h6' => esc_html__( 'h6', 'impeka' ),
	),
	'heading_selection' => array(
		'h1' => esc_html__( 'h1', 'impeka' ),
		'h2' => esc_html__( 'h2', 'impeka' ),
		'h3' => esc_html__( 'h3', 'impeka' ),
		'h4' => esc_html__( 'h4', 'impeka' ),
		'h5' => esc_html__( 'h5', 'impeka' ),
		'h6' => esc_html__( 'h6', 'impeka' ),
		'body-text' => esc_html__( 'Paragraph Text', 'impeka' ),
		'leader-text' => esc_html__( 'Leader Text', 'impeka' ),
		'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka' ),
		'small-text' => esc_html__( 'Small Text', 'impeka' ),
		'link-text' => esc_html__( 'Link Text', 'impeka' ),
		'feature-title' => esc_html__( 'Feature Title', 'impeka' ),
		'feature-text' => esc_html__( 'Feature Description', 'impeka' ),
		'feature-subheading' => esc_html__( 'Feature Sub Heading', 'impeka' ),
	),
	'custom_font_family_selection' => array(
		'' => esc_html__( 'Default', 'impeka' ),
		'custom-font-1' => esc_html__( 'Custom Font Family 1', 'impeka' ),
		'custom-font-2' => esc_html__( 'Custom Font Family 2', 'impeka' ),
		'custom-font-3' => esc_html__( 'Custom Font Family 3', 'impeka' ),
		'custom-font-4' => esc_html__( 'Custom Font Family 4', 'impeka' ),
	),
	'boolean_selection' => array(
		'yes' => esc_html__( 'Yes', 'impeka' ),
		'no' => esc_html__( 'No', 'impeka' ),
	),
	'align_selection' => array(
		'left' => esc_html__( 'Left', 'impeka' ),
		'right' => esc_html__( 'Right', 'impeka' ),
		'center' => esc_html__( 'Center', 'impeka' ),
	),
	'color_selection' => array(
		'black' => esc_html__( 'Black', 'impeka' ),
		'white' => esc_html__( 'White', 'impeka' ),
		'primary-1' => esc_html__( 'Primary 1', 'impeka' ),
		'primary-2' => esc_html__( 'Primary 2', 'impeka' ),
		'primary-3' => esc_html__( 'Primary 3', 'impeka' ),
		'primary-4' => esc_html__( 'Primary 4', 'impeka' ),
		'primary-5' => esc_html__( 'Primary 5', 'impeka' ),
		'primary-6' => esc_html__( 'Primary 6', 'impeka' ),
	),
	'color_extra_selection' => array(
		'black' => esc_html__( 'Black', 'impeka' ),
		'white' => esc_html__( 'White', 'impeka' ),
		'primary-1' => esc_html__( 'Primary 1', 'impeka' ),
		'primary-2' => esc_html__( 'Primary 2', 'impeka' ),
		'primary-3' => esc_html__( 'Primary 3', 'impeka' ),
		'primary-4' => esc_html__( 'Primary 4', 'impeka' ),
		'primary-5' => esc_html__( 'Primary 5', 'impeka' ),
		'primary-6' => esc_html__( 'Primary 6', 'impeka' ),
		'custom' => esc_html__( 'Custom', 'impeka' ),
	),
	'opacity_selection' => array(
		'0'    => '0%',
		'0.05' => '5%',
		'0.10' => '10%',
		'0.15' => '15%',
		'0.20' => '20%',
		'0.25' => '25%',
		'0.30' => '30%',
		'0.35' => '35%',
		'0.40' => '40%',
		'0.45' => '45%',
		'0.50' => '50%',
		'0.55' => '55%',
		'0.60' => '60%',
		'0.65' => '65%',
		'0.70' => '70%',
		'0.75' => '75%',
		'0.80' => '80%',
		'0.85' => '85%',
		'0.90' => '90%',
		'0.95' => '95%',
		'1'    => '100%',
	),
	'header_skin_selection' => array(
		'default' => esc_html__( 'Default', 'impeka' ),
		'dark' => esc_html__( 'Dark', 'impeka' ),
		'light' => esc_html__( 'Light', 'impeka' ),
	),
	//Overlay
	'color_overlay_selection' => array(
		'' => esc_html__( 'None', 'impeka' ),
		'black' => esc_html__( 'Black', 'impeka' ),
		'white' => esc_html__( 'White', 'impeka' ),
		'primary-1' => esc_html__( 'Primary 1', 'impeka' ),
		'primary-2' => esc_html__( 'Primary 2', 'impeka' ),
		'primary-3' => esc_html__( 'Primary 3', 'impeka' ),
		'primary-4' => esc_html__( 'Primary 4', 'impeka' ),
		'primary-5' => esc_html__( 'Primary 5', 'impeka' ),
		'primary-6' => esc_html__( 'Primary 6', 'impeka' ),
	),
	'pattern_overlay_selection' => array(
		'' => esc_html__( 'No', 'impeka' ),
		'default' => esc_html__( 'Yes', 'impeka' ),
	),
	//Buttons
	'button_color_selection' => array(
		'primary-1' => esc_html__( 'Primary 1', 'impeka' ),
		'primary-2' => esc_html__( 'Primary 2', 'impeka' ),
		'primary-3' => esc_html__( 'Primary 3', 'impeka' ),
		'primary-4' => esc_html__( 'Primary 4', 'impeka' ),
		'primary-5' => esc_html__( 'Primary 5', 'impeka' ),
		'primary-6' => esc_html__( 'Primary 6', 'impeka' ),
		'green' => esc_html__( 'Green', 'impeka' ),
		'orange' => esc_html__( 'Orange', 'impeka' ),
		'red' => esc_html__( 'Red', 'impeka' ),
		'blue' => esc_html__( 'Blue', 'impeka' ),
		'aqua' => esc_html__( 'Aqua', 'impeka' ),
		'purple' => esc_html__( 'Purple', 'impeka' ),
		'black' => esc_html__( 'Black', 'impeka' ),
		'grey' => esc_html__( 'Grey', 'impeka' ),
		'dark-grey' => esc_html__( 'Dark Grey', 'impeka' ),
		'light-grey' => esc_html__( 'Light Grey', 'impeka' ),
		'white' => esc_html__( 'White', 'impeka' ),
	),
	'button_color_gradient_selection' => array(
		'primary-1' => esc_html__( 'Primary 1', 'impeka' ),
		'primary-2' => esc_html__( 'Primary 2', 'impeka' ),
		'primary-3' => esc_html__( 'Primary 3', 'impeka' ),
		'primary-4' => esc_html__( 'Primary 4', 'impeka' ),
		'primary-5' => esc_html__( 'Primary 5', 'impeka' ),
		'primary-6' => esc_html__( 'Primary 6', 'impeka' ),
		'gradient-1' => esc_html__( "Gradient 1", "impeka" ),
		'gradient-2' => esc_html__( "Gradient 2", "impeka" ),
		'gradient-3' => esc_html__( "Gradient 3", "impeka" ),
		'green' => esc_html__( 'Green', 'impeka' ),
		'orange' => esc_html__( 'Orange', 'impeka' ),
		'red' => esc_html__( 'Red', 'impeka' ),
		'blue' => esc_html__( 'Blue', 'impeka' ),
		'aqua' => esc_html__( 'Aqua', 'impeka' ),
		'purple' => esc_html__( 'Purple', 'impeka' ),
		'black' => esc_html__( 'Black', 'impeka' ),
		'grey' => esc_html__( 'Grey', 'impeka' ),
		'dark-grey' => esc_html__( 'Dark Grey', 'impeka' ),
		'light-grey' => esc_html__( 'Light Grey', 'impeka' ),
		'white' => esc_html__( 'White', 'impeka' ),
	),
	'button_size_selection' => array(
		'extrasmall' => esc_html__( 'Extra Small', 'impeka' ),
		'small' => esc_html__( 'Small', 'impeka' ),
		'medium' => esc_html__( 'Medium', 'impeka' ),
		'large' => esc_html__( 'Large', 'impeka' ),
		'extralarge' => esc_html__( 'Extra Large', 'impeka' ),
	),
	'button_shape_selection' => array(
		'square' => esc_html__( 'Square', 'impeka' ),
		'round' => esc_html__( 'Round', 'impeka' ),
		'extra-round' => esc_html__( 'Extra Round', 'impeka' ),
	),
	'button_type_selection' => array(
		'simple' => esc_html__( 'Simple', 'impeka' ),
		'outline' => esc_html__( 'Outline', 'impeka' ),
	),
	'button_target_selection' => array(
		'_self' => esc_html__( 'Same Page', 'impeka' ),
		'_blank' => esc_html__( 'New page', 'impeka' ),
	),
	//Post
	'post_color_selection' => array(
		'primary-1' => esc_html__( 'Primary 1', 'impeka' ),
		'primary-2' => esc_html__( 'Primary 2', 'impeka' ),
		'primary-3' => esc_html__( 'Primary 3', 'impeka' ),
		'primary-4' => esc_html__( 'Primary 4', 'impeka' ),
		'primary-5' => esc_html__( 'Primary 5', 'impeka' ),
		'primary-6' => esc_html__( 'Primary 6', 'impeka' ),
		'green' => esc_html__( 'Green', 'impeka' ),
		'orange' => esc_html__( 'Orange', 'impeka' ),
		'red' => esc_html__( 'Red', 'impeka' ),
		'blue' => esc_html__( 'Blue', 'impeka' ),
		'aqua' => esc_html__( 'Aqua', 'impeka' ),
		'purple' => esc_html__( 'Purple', 'impeka' ),
		'black' => esc_html__( 'Black', 'impeka' ),
		'grey' => esc_html__( 'Grey', 'impeka' ),
		'dark-grey' => esc_html__( 'Dark Grey', 'impeka' ),
		'light-grey' => esc_html__( 'Light Grey', 'impeka' ),
	),
	'post_bg_opacity_selection' => array(
		'none' => '0%',
		'10' => '10%',
		'20' => '20%',
		'30' => '30%',
		'40' => '40%',
		'50' => '50%',
		'60' => '60%',
		'70' => '70%',
		'80' => '80%',
		'90' => '90%',
		'100' => '100%',
	),
	//Background
	'bg_position_selection' => array(
		'left-top' => esc_html__( 'Left Top', 'impeka' ),
		'left-center' => esc_html__( 'Left Center', 'impeka' ),
		'left-bottom' => esc_html__( 'Left Bottom', 'impeka' ),
		'center-top' => esc_html__( 'Center Top', 'impeka' ),
		'center-center' => esc_html__( 'Center Center', 'impeka' ),
		'center-bottom' => esc_html__( 'Center Bottom', 'impeka' ),
		'right-top' => esc_html__( 'Right Top', 'impeka' ),
		'right-center' => esc_html__( 'Right Center', 'impeka' ),
		'right-bottom' => esc_html__( 'Right Bottom', 'impeka' ),
	),
	//Area Item
	'area_item_selection' => impeka_grve_admin_get_area_item_selection(),
	//Misc
	'text_animation_selection' => array(
		'none' => esc_html__( 'None', 'impeka' ),
		'fade-in' => esc_html__( 'Fade In', 'impeka' ),
		'fade-in-up' => esc_html__( 'Fade In Up', 'impeka' ),
		'fade-in-down' => esc_html__( 'Fade In Down', 'impeka' ),
		'fade-in-left' => esc_html__( 'Fade In Left', 'impeka' ),
		'fade-in-right' => esc_html__( 'Fade In Right', 'impeka' ),
		'zoom-in' => esc_html__( 'Zoom In', 'impeka' ),
		'zoom-out' => esc_html__( 'Zoom Out', 'impeka' ),
		'appear-up' => esc_html__( 'Appear Up', 'impeka' ),
		'appear-down' => esc_html__( 'Appear Down', 'impeka' ),
		'appear-left' => esc_html__( 'Appear Left', 'impeka' ),
		'appear-right' => esc_html__( 'Appear Right', 'impeka' ),
	),
	'area_height' => array(
		'small' => esc_html__( 'Small Height', 'impeka' ),
		'medium' => esc_html__( 'Medium Height', 'impeka' ),
		'large' => esc_html__( 'Large Height', 'impeka' ),
		'10' => '10%',
		'15' => '15%',
		'20' => '20%',
		'25' => '25%',
		'30' => '30%',
		'35' => '35%',
		'40' => '40%',
		'45' => '45%',
		'50' => '50%',
		'55' => '55%',
		'60' => '60%',
		'65' => '65%',
		'70' => '70%',
		'75' => '75%',
		'80' => '80%',
		'85' => '85%',
		'90' => '90%',
	),
);


function impeka_grve_admin_get_color_array( $options = ['primary', 'standard'] ) {

	$colors = array();

	if( in_array('none', $options ) ) {
		$colors['none'] = esc_html__( 'None', 'impeka' );
	}

	if( in_array('default', $options ) ) {
		$colors['default'] = esc_html__( 'Default', 'impeka' );
	}

	if( in_array('inherit', $options ) ) {
		$colors['inherit'] = esc_html__( 'Inherit', 'impeka' );
	}

	if( in_array('transparent', $options ) ) {
		$colors['transparent'] = esc_html__( 'Transparent', 'impeka' );
	}


	if( in_array('primary', $options ) ) {
		$colors['primary-1'] = esc_html__( 'Primary 1', 'impeka' );
		$colors['primary-2'] = esc_html__( 'Primary 2', 'impeka' );
		$colors['primary-3'] = esc_html__( 'Primary 3', 'impeka' );
		$colors['primary-4'] = esc_html__( 'Primary 4', 'impeka' );
		$colors['primary-5'] = esc_html__( 'Primary 5', 'impeka' );
		$colors['primary-6'] = esc_html__( 'Primary 6', 'impeka' );
	}

	if( in_array('gradient', $options ) ) {
		$colors['gradient-1'] = esc_html__( 'Gradient 1', 'impeka' );
		$colors['gradient-2'] = esc_html__( 'Gradient 2', 'impeka' );
		$colors['gradient-3'] = esc_html__( 'Gradient 3', 'impeka' );
	}

	if( in_array('single-gradient', $options ) ) {
		$colors['gradient'] = esc_html__( 'Gradient', 'impeka' );
	}

	if( in_array('black-white', $options ) ) {
		$colors['black'] = esc_html__( 'Black', 'impeka' );
		$colors['white'] = esc_html__( 'White', 'impeka' );
	}

	if( in_array('standard', $options ) ) {
		$colors['green'] = esc_html__( 'Green', 'impeka' );
		$colors['orange'] = esc_html__( 'Orange', 'impeka' );
		$colors['red'] = esc_html__( 'Red', 'impeka' );
		$colors['blue'] = esc_html__( 'Blue', 'impeka' );
		$colors['aqua'] = esc_html__( 'Aqua', 'impeka' );
		$colors['purple'] = esc_html__( 'Purple', 'impeka' );
		$colors['black'] = esc_html__( 'Black', 'impeka' );
		$colors['grey'] = esc_html__( 'Grey', 'impeka' );
		$colors['dark-grey'] = esc_html__( 'Dark Grey', 'impeka' );
		$colors['light-grey'] = esc_html__( 'Light Grey', 'impeka' );
		$colors['white'] = esc_html__( 'White', 'impeka' );
	}

	if( in_array('custom', $options ) ) {
		$colors['custom'] = esc_html__( 'Custom', 'impeka' );
	}

	if( in_array('dominant', $options ) ) {
		$colors['dominant'] = esc_html__( 'Image Dominant', 'impeka' );
	}

	return $colors;
}

/**
 * Helper function to get global admin params with fallback
 */
function impeka_grve_global_admin_param( $id, $fallback = false, $param = false ) {
	global $impeka_grve_global_admin_params;
	$params = $impeka_grve_global_admin_params;

	if ( $fallback == false ) $fallback = '';
	$output = ( isset($params[$id]) && $params[$id] !== '' ) ? $params[$id] : $fallback;
	if ( !empty($params[$id]) && $param ) {
		$output = ( isset($params[$id][$param]) && $params[$id][$param] !== '' ) ? $params[$id][$param] : $fallback;
	}
	return $output;
}

 /**
 * Fetch Post Type Categories
 */
function impeka_grve_global_get_post_type_categories( $term_slug = 'category' ) {
	$category = array();
	$cats = get_terms( $term_slug );
	if ( is_array( $cats ) ) {
	  foreach ( $cats as $cat ) {
		$category[$cat->term_id] = $cat->name;
	  }
	}
	return $category;
}

/**
 * Get Area Item Selection
 */
function impeka_grve_admin_get_area_item_selection() {

	$area_item_selection = array();
	$area_item_posts = get_posts( array(
		'posts_per_page' => '-1',
		'orderby' => 'post_title',
		'post_status'=>'publish',
		'post_type' => 'area-item',
	) );
	if ( !empty( $area_item_posts ) ) {
		foreach ( $area_item_posts as $post ) {
			$area_item_selection[ $post->ID ] = esc_html( $post->post_title );
		}
		wp_reset_postdata();
	}
	return $area_item_selection;
}


function impeka_grve_admin_check_php_val( $size, $min_size ) {
	if ( wp_convert_hr_to_bytes( $size ) < wp_convert_hr_to_bytes( $min_size ) ) {
		return true;
	}
	return false;
}


/**
 * Check Server Status
 */
function impeka_grve_admin_check_server_status() {
	if ( version_compare( phpversion(), '5.6', '<' ) ) {
		return false;
	}
	if ( impeka_grve_admin_check_php_val( WP_MEMORY_LIMIT, '96M' ) ) {
		return false;
	}
	if ( impeka_grve_admin_check_php_val( ini_get( 'memory_limit' ), '256M' ) ) {
		return false;
	}
	if ( impeka_grve_admin_check_php_val( ini_get( 'post_max_size' ), '128M' ) ) {
		return false;
	}
	if ( impeka_grve_admin_check_php_val( ini_get( 'upload_max_filesize' ), '32M' ) ) {
		return false;
	}
	if ( impeka_grve_admin_check_php_val( ini_get( 'max_execution_time' ), '300' ) ) {
		return false;
	}
	if ( impeka_grve_admin_check_php_val( ini_get( 'max_input_vars' ), '3000' ) ) {
		return false;
	}
	return true;
}


/**
 * Get Purchase Code option name
 */
function impeka_grve_get_purchase_code_option_name() {
	return 'envato_purchase_code_31105756';
}

/**
 * Check Server Status
 */
function impeka_grve_check_theme_status( $mode = '' ) {
	return true;
	switch ( $mode ) {
		case 'wizard':
		case 'plugin':
			return true;
			break;
		case 'import':
		default:
			$purchase_code = get_option( impeka_grve_get_purchase_code_option_name() );
			$status = get_option( 'impeka_grve_registration_status' );
			if ( !empty( $purchase_code ) && 'active' == $status ) {
				return true;
			}
			break;
	}
	return false;
}

/**
 * Theme Check Theme Code
 */
function impeka_grve_check_theme_code() {
	$old_code = get_option( 'impeka_grve_purchase_code' );
	if ( !empty( $old_code ) ) {
		$code = get_option( impeka_grve_get_purchase_code_option_name() );
		if ( empty( $code ) ) {
			update_option( impeka_grve_get_purchase_code_option_name(), $old_code );
			delete_option( 'impeka_grve_purchase_code' );
		} else {
			delete_option( 'impeka_grve_purchase_code' );
		}
	}
}
add_action( 'after_setup_theme', 'impeka_grve_check_theme_code' );


//Omit closing PHP tag to avoid accidental whitespace output errors.
