<?php
/*
*	Collection of functions for admin single post modals
*
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/


/**
 * Get Single Modal Item with ajax
 */
function impeka_grve_get_modal_item() {

	check_ajax_referer( 'impeka-grve-get-modal-item', '_grve_nonce' );

	if( isset( $_POST['mode'] ) ) {
		$mode = sanitize_text_field( $_POST['mode'] );
		impeka_grve_print_admin_modal_item( array(), $mode );
	}
	if( isset( $_POST['mode'] ) ) { die(); }
}
add_action( 'wp_ajax_impeka_grve_get_modal_item', 'impeka_grve_get_modal_item' );

/**
 * Prints Modal Items
 */
function impeka_grve_print_admin_modal_items( $modal_items ) {

	if( !empty($modal_items) ) {
		foreach ( $modal_items as $modal_item ) {
			impeka_grve_print_admin_modal_item( $modal_item );
		}
	}

}

/**
 * Prints Modal Item
 */
function impeka_grve_print_admin_modal_item( $modal_item, $mode = '' ) {

	$modal_item_id = uniqid('_impeka_grve_modal_item_');
	$id = impeka_grve_array_value( $modal_item, 'id', $modal_item_id );
	$group_id = $id .'_group';

	$modal_id = impeka_grve_array_value( $modal_item, 'modal_id' );
	$modal_mode = impeka_grve_array_value( $modal_item, 'modal_mode', 'full' );
	$modal_trigger = impeka_grve_array_value( $modal_item, 'modal_trigger' );
	$modal_reset = impeka_grve_array_value( $modal_item, 'modal_reset', '1' );
	$area_id = impeka_grve_array_value( $modal_item, 'area_id' );

	$closed_class = 'closed';
	$item_new = '';
	if( "new" == $mode ) {
		$closed_class = "";
		$item_new = " grve-toggle-new";
	}
?>
	<div class="grve-modal-item postbox <?php echo esc_attr( $closed_class ); ?>">
		<button class="handlediv button-link" type="button">
			<span class="screen-reader-text"><?php esc_html_e( 'Toggle panel: Modal Item', 'impeka' ); ?></span>
			<span class="toggle-indicator"></span>
		</button>
		<input class="grve-modal-item-delete-button button<?php echo esc_attr( $item_new ); ?>" type="button" value="<?php esc_attr_e( 'Delete', 'impeka' ); ?>" />
		<span class="grve-button-spacer">&nbsp;</span>
		<span class="grve-modal-spinner"></span>
		<h3 class="grve-modal-title">
			<span><?php esc_html_e( 'Modal Item', 'impeka' ); ?>: </span><span id="<?php echo esc_attr( $id ); ?>_title_admin_label"><?php if ( !empty ($modal_id) ) { echo esc_html( $modal_id ); } ?></span>
		</h3>
		<div class="inside">
			<!--  METABOXES -->
			<div class="grve-metabox-content" id="<?php echo esc_attr( $group_id ); ?>">
				<input type="hidden" name="_impeka_grve_modal_item_id[]" value="<?php echo esc_attr( $id ); ?>"/>
				<?php
					impeka_grve_print_admin_option(
						array(
							'type' => 'textfield',
							'name' => '_impeka_grve_modal_item_modal_id[]',
							'value' => $modal_id,
							'label' => array(
								"title" => esc_html__( 'Modal ID', 'impeka' ),
							),
						)
					);

					impeka_grve_print_admin_option(
						array(
							'type' => 'select',
							'name' => '_impeka_grve_modal_item_modal_mode[]',
							'options' => array(
								'full' => esc_html__( 'Full', 'impeka' ),
								'large' => esc_html__( 'Large', 'impeka' ),
								'medium' => esc_html__( 'Medium', 'impeka' ),
								'small' => esc_html__( 'Small', 'impeka' ),
							),
							'value' => $modal_mode,
							'label' => array(
								"title" => esc_html__( 'Modal Mode', 'impeka' ),
							),
						)
					);

					impeka_grve_print_admin_option(
						array(
							'type' => 'select',
							'name' => '_impeka_grve_modal_item_area_id[]',
							'options' => impeka_grve_global_admin_param( 'area_item_selection' ),
							'value' => $area_id,
							'label' => array(
								"title" => esc_html__( 'Area ID', 'impeka' ),
							),
						)
					);

					impeka_grve_print_admin_option(
						array(
							'type' => 'select',
							'name' => '_impeka_grve_modal_item_modal_trigger[]',
							'id' => $id . '_trigger',
							'options' => array(
								'' => esc_html__( 'No', 'impeka' ),
								'2000' => esc_html__( 'Open after 2s', 'impeka' ),
								'4000' => esc_html__( 'Open after 4s', 'impeka' ),
								'6000' => esc_html__( 'Open after 6s', 'impeka' ),
								'8000' => esc_html__( 'Open after 8s', 'impeka' ),
								'10000' => esc_html__( 'Open after 10s', 'impeka' ),
								'12000' => esc_html__( 'Open after 12s', 'impeka' ),
								'14000' => esc_html__( 'Open after 14s', 'impeka' ),
								'16000' => esc_html__( 'Open after 16s', 'impeka' ),
								'18000' => esc_html__( 'Open after 18s', 'impeka' ),
								'20000' => esc_html__( 'Open after 20s', 'impeka' ),
							),
							'value' => $modal_trigger,
							'label' => array(
								"title" => esc_html__( 'Modal Trigger', 'impeka' ),
							),
							'group_id' => $group_id,
						)
					);
					impeka_grve_print_admin_option(
						array(
							'type' => 'select',
							'name' => '_impeka_grve_modal_item_modal_reset[]',
							'options' => array(
								'0' => esc_html__( 'Always', 'impeka' ),
								'1' => esc_html__( '1 Day', 'impeka' ),
								'7' => esc_html__( '1 Week', 'impeka' ),
								'14' => esc_html__( '2 Weeks', 'impeka' ),
								'30' => esc_html__( '1 Month', 'impeka' ),
							),
							'value' => $modal_reset,
							'label' => array(
								"title" => esc_html__( 'Modal Reset', 'impeka' ),
							),
							'dependency' =>
							'[
								{ "id" : "' . $id . '_trigger' . '", "value_not_equal_to" : [""] }
							]',
						)
					);
				?>
			</div>
		</div>
	</div>
<?php
}

function impeka_grve_admin_save_modal_section( $post_id ) {

	$modal_items = array();
	if ( isset( $_POST['_impeka_grve_modal_item_id'] ) ) {

		$num_of_modal_items = sizeof( $_POST['_impeka_grve_modal_item_id'] );
		for ( $i=0; $i < $num_of_modal_items; $i++ ) {

			$this_item = array (
				'id' => sanitize_text_field( $_POST['_impeka_grve_modal_item_id'][ $i ] ),
				'modal_id' => sanitize_text_field( $_POST['_impeka_grve_modal_item_modal_id'][ $i ] ),
				'modal_mode' => sanitize_text_field( $_POST['_impeka_grve_modal_item_modal_mode'][ $i ] ),
				'modal_trigger' => sanitize_text_field( $_POST['_impeka_grve_modal_item_modal_trigger'][ $i ] ),
				'modal_reset' => sanitize_text_field( $_POST['_impeka_grve_modal_item_modal_reset'][ $i ] ),
				'area_id' => sanitize_text_field( $_POST['_impeka_grve_modal_item_area_id'][ $i ] ),
			);
			$modal_items[] =  $this_item;
		}

	}

	$new_meta_value = $modal_items;
	$meta_key = '_impeka_grve_modals';
	$meta_value = get_post_meta( $post_id, $meta_key, true );

	if ( $new_meta_value != $meta_value ) {
		if( !empty( $modal_items ) ) {
			update_post_meta( $post_id, $meta_key, $new_meta_value );
		} else {
			delete_post_meta( $post_id, $meta_key );
		}
	}

}

//Omit closing PHP tag to avoid accidental whitespace output errors.
