<?php
/*
*	Admin Wizard
*
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Impeka_Grve_Admin_Wizard' ) ) {

	class Impeka_Grve_Admin_Wizard {

		private static $instance = null;
		protected $step = '';
		protected $steps = array();
		protected $page_slug = 'impeka-wizard';

		public static function get_instance() {
			if ( ! self::$instance ) {
				self::$instance = new self;
			}

			return self::$instance;
		}

		public function __construct() {
			add_action( 'admin_init', array( $this, 'init_wizard_steps' ), 30 );
			add_filter( 'tgmpa_load', array( $this, 'tgmpa_load' ), 10, 1 );
			add_action( 'wp_ajax_impeka_grve_wizard_ajax_plugins', array( $this, 'install_plugins' ), 30 );
			add_action( 'wp_ajax_impeka_grve_wizard_ajax_builder_plugins', array( $this, 'builder_plugins' ), 30 );
		}

		public function Impeka_Grve_Admin_Wizard() {
			$this->__construct();
		}

		public function tgmpa_load( $status ) {
			return is_admin() || current_user_can( 'install_themes' );
		}

		public function init_wizard_steps() {

			$this->steps['required-plugins'] = array(
				'name'    => esc_html__( 'Required Plugins', 'impeka' ),
				'view'    => array( $this, 'step_required_plugins' ),
			);
			$this->steps['page-builder'] = array(
				'name'    => esc_html__( 'Page Builder', 'impeka' ),
				'view'    => array( $this, 'step_page_builder' ),
			);
			$this->steps['plugins'] = array(
				'name'    => esc_html__( 'Useful Plugins', 'impeka' ),
				'view'    => array( $this, 'step_plugins' ),
			);
			$this->steps['demo-content'] = array(
				'name'    => esc_html__( 'Demo Content', 'impeka' ),
				'view'    => array( $this, 'step_demo_content' ),
			);
			$this->steps['finish']      = array(
				'name'    => esc_html__( 'Finish', 'impeka' ),
				'view'    => array( $this, 'step_finish' ),
			);
			$this->steps = apply_filters( 'impeka_grve_admin_wizard_steps', $this->steps );


			$this->step = isset( $_GET['step'] ) ? sanitize_key( $_GET['step'] ) : '';
			if ( !array_key_exists($this->step, $this->steps ) ) {
				$this->step = 'required-plugins';
			}
		}

		public function get_step_link( $step ) {
			return add_query_arg( 'step', $step, admin_url( 'admin.php?page=' . $this->page_slug ) );
		}

		public function get_next_step_link() {
			$keys = array_keys( $this->steps );

			if ( 'welcome' == $this->step ) {
				return add_query_arg( 'step', 'required-plugins' );
			} else {
				return add_query_arg( 'step', $keys[ array_search( $this->step, array_keys( $this->steps ) ) + 1 ] );
			}
		}

		public function print_wizard_content() {
			isset( $this->steps[ $this->step ] ) ? call_user_func( $this->steps[ $this->step ]['view'] ) : $this->step_welcome();
		}

		public function print_wizard_steps() {
			$ouput_steps = $this->steps;
			if ( array_key_exists($this->step, $ouput_steps ) ) {
			$index = 0;
			?>
			<ul class="grve-steps">
				<?php foreach ( $ouput_steps as $step_key => $step ) : ?>
					<li class="<?php
					$index++;
					$show_link = false;
					if ( $step_key === $this->step ) {
						echo 'active';
					} elseif ( array_search( $this->step, array_keys( $this->steps ) ) > array_search( $step_key, array_keys( $this->steps ) ) ) {
						echo 'done';
						$show_link = true;
					}
					?>"><div class="grve-step-number"><?php echo esc_html( $index ); ?></div><span>
						<?php
						if ( $show_link ) {
							?>
							<a href="<?php echo esc_url( $this->get_step_link( $step_key ) ); ?>"><?php echo esc_html( $step['name'] ); ?></a>
							<?php
						} else {
							echo esc_html( $step['name'] );
						}
						?></span></li>
				<?php endforeach; ?>
			</ul>
			<?php
			}
		}

		public function print_wizard_buttons() {
			if ( !impeka_grve_check_theme_status( 'wizard' ) ) {
				return;
			}
			echo '<div class="grve-wizard-button-bar">';
			if ( 'welcome' == $this->step ) {
			?>
			<a href="<?php echo esc_url($this->get_next_step_link()); ?>" class="grve-wizard-next button button-primary"><?php echo esc_html__( 'Start Wizard', 'impeka' ); ?></a>
			<?php
			} else if ( 'required-plugins' == $this->step ) {
			?>
			<a href="<?php echo esc_url($this->get_next_step_link()); ?>" data-callback="install_plugins" class="grve-wizard-next button button-primary"><?php echo esc_html__( 'Continue', 'impeka' ); ?></a>
			<?php
			}else {
			?>
			<a href="<?php echo esc_url($this->get_next_step_link()); ?>" data-callback="install_plugins" class="grve-wizard-next button button-primary"><?php echo esc_html__( 'Continue', 'impeka' ); ?></a>
			<a href="<?php echo esc_url($this->get_next_step_link()); ?>" class="grve-wizard-skip grve-wizard-button"><?php echo esc_html__( 'Skip this step', 'impeka' ); ?></a>
			<?php
			}
			echo '</div>';
		}
		public function step_welcome() {
		?>
			<div class="grve-admin-wizard-title">
				<img class="grve-admin-logo" src="<?php echo esc_url( get_template_directory_uri() . '/includes/images/admin-logo/impeka-logo.png' ); ?>" alt="Impeka Logo">
				<h2 class="grve-subtitle"><?php esc_html_e( "Welcome to the", 'impeka' ); ?></h2>
				<h2 class="grve-title"><?php esc_html_e( "Startup Wizard", 'impeka' ); ?></h2>
				<p class="grve-description"><?php esc_html_e( "This quick setup wizard will help you configure your new website. It should only take a few minutes. You can skip or restart the wizard at any time.", 'impeka' ); ?></p>
				<?php $this->print_wizard_buttons(); ?>
			</div>
		<?php
		}
		public function step_required_plugins() {
	?>
			<div class="grve-admin-title">
				<h2 class="grve-title"><?php esc_html_e( "Install", 'impeka' ); ?></h2>
				<h2 class="grve-title"><?php esc_html_e( "Required Plugins", 'impeka' ); ?></h2>
				<p class="grve-description"><?php esc_html_e( "Impeka needs a few essential plugins. This step will install/activate the necessary plugins for you.", 'impeka' ); ?></p>
			</div>
			<div class="grve-wizard-panel-content">
				<?php
					$this->print_plugins_by_mode('required');
					$this->print_wizard_buttons();

				?>
			</div>
	<?php
		}

		public function step_page_builder() {

			$composer_all_class = $composer_only_class = $elementor_all_class = $elementor_only_class = 'grve-builder-button';
			$selected_class = ' grve-selected';

	?>
			<div class="grve-admin-title">
				<h2 class="grve-title"><?php esc_html_e( "Page Builder", 'impeka' ); ?></h2>
				<p class="grve-small-description"><?php esc_html_e( "Impeka supports both WPBakery Page Builder and Elementor builder. You can use these either as they come or with Greatives handcrafted elements. Additionally, Impeka is a Gutenberg optimized theme, so if you prefer to use the new WordPress editor, skip this step. You can also control these on Theme Plugins screen.", 'impeka' ); ?></p>
			</div>
			<div class="grve-wizard-panel-content">
				<div class="grve-wizard-panel-inner">
					<?php
					if ( class_exists( 'Impeka_WPBakery_Extension_Plugin' ) && class_exists( 'WPBakeryShortCode' ) ){
						$mode = 'composer_all';
						$composer_all_class .= $selected_class;
						echo '<div class="grve-wizard-builder-info"><span>' .  esc_html__( 'Page Builder:', 'impeka' ) . '</span> ' .  esc_html__( 'WPBakery Page Builder + Impeka Handcafted Elements', 'impeka' ) . '</div>';
					} elseif ( class_exists( 'WPBakeryShortCode' ) ) {
						$mode = 'composer_only';
						$composer_only_class .= $selected_class;
						echo '<div class="grve-wizard-builder-info"><span>' .  esc_html__( 'Page Builder:', 'impeka' ) . '</span> ' .  esc_html__( 'WPBakery Page Builder', 'impeka' ) . '</div>';
					?>
						<a href="#" class="<?php echo esc_attr( $composer_all_class ); ?>" data-mode="composer_all">
							<div class="grve-builder-button-inner">
								<img class="grve-admin-panel-icon" src="<?php echo esc_url( get_template_directory_uri() . '/includes/images/admin-plugins/plugin-1.jpg' ); ?>" alt="WPBakery Page Builder + Impeka Handcafted Elements">
								<?php echo esc_html__( 'WPBakery Page Builder + Impeka Handcafted Elements', 'impeka' ); ?>
							</div>
						</a>
						<a href="#" class="<?php echo esc_attr( $composer_only_class ); ?>" data-mode="composer_only">
							<div class="grve-builder-button-inner">
								<img class="grve-admin-panel-icon" src="<?php echo esc_url( get_template_directory_uri() . '/includes/images/admin-plugins/plugin-2.jpg' ); ?>" alt="WPBakery Page Builder + Impeka Handcafted Elements">
								<?php echo esc_html__( 'WPBakery Page Builder', 'impeka' ); ?>
							</div>
						</a>
					<?php
					} elseif ( class_exists( 'Impeka_Elementor_Extension_Plugin' ) && class_exists('Elementor\Widget_Base') ) {
						$mode = 'elementor_all';
						$elementor_all_class .= $selected_class;
						echo '<div class="grve-wizard-builder-info"><span>' . esc_html__( 'Page Builder:', 'impeka' ) . '</span> ' .  esc_html__( 'Elementor + Impeka Elementor Elements', 'impeka' ) . '</div>';
					} elseif ( class_exists('Elementor\Widget_Base') ) {
						$mode = 'elementor_only';
						$elementor_only_class .= $selected_class;
						echo '<div class="grve-wizard-builder-info"><span>' . esc_html__( 'Page Builder:', 'impeka' ) . '</span> ' .  esc_html__( 'Elementor', 'impeka' ) . '</div>';
					?>
						<a href="#" class="<?php echo esc_attr( $elementor_all_class ); ?>" data-mode="elementor_all">
							<div class="grve-builder-button-inner">
								<img class="grve-admin-panel-icon" src="<?php echo esc_url( get_template_directory_uri() . '/includes/images/admin-plugins/plugin-3.jpg' ); ?>" alt="WPBakery Page Builder + Impeka Handcafted Elements">
								<?php echo esc_html__( 'Elementor + Impeka Elementor Elements', 'impeka' ); ?>
							</div>
						</a>
						<a href="#" class="<?php echo esc_attr( $elementor_only_class ); ?>" data-mode="elementor_only">
							<div class="grve-builder-button-inner">
								<img class="grve-admin-panel-icon" src="<?php echo esc_url( get_template_directory_uri() . '/includes/images/admin-plugins/plugin-4.jpg' ); ?>" alt="WPBakery Page Builder + Impeka Handcafted Elements">
								<?php echo esc_html__( 'Elementor', 'impeka' ); ?>
							</div>
						</a>
					<?php
					} else {
						$mode = 'composer_all';
						$composer_all_class .= $selected_class;
					?>
						<a href="#" class="<?php echo esc_attr( $composer_all_class ); ?>" data-mode="composer_all">
							<div class="grve-builder-button-inner">
								<img class="grve-admin-panel-icon" src="<?php echo esc_url( get_template_directory_uri() . '/includes/images/admin-plugins/plugin-1.jpg' ); ?>" alt="WPBakery Page Builder + Impeka Handcafted Elements">
								<?php echo esc_html__( 'WPBakery Page Builder + Impeka Handcafted Elements', 'impeka' ); ?>
							</div>
						</a>
						<a href="#" class="<?php echo esc_attr( $composer_only_class ); ?>" data-mode="composer_only">
							<div class="grve-builder-button-inner">
								<img class="grve-admin-panel-icon" src="<?php echo esc_url( get_template_directory_uri() . '/includes/images/admin-plugins/plugin-2.jpg' ); ?>" alt="WPBakery Page Builder + Impeka Handcafted Elements">
								<?php echo esc_html__( 'WPBakery Page Builder', 'impeka' ); ?>
							</div>
						</a>
						<a href="#" class="<?php echo esc_attr( $elementor_all_class ); ?>" data-mode="elementor_all">
							<div class="grve-builder-button-inner">
								<img class="grve-admin-panel-icon" src="<?php echo esc_url( get_template_directory_uri() . '/includes/images/admin-plugins/plugin-3.jpg' ); ?>" alt="WPBakery Page Builder + Impeka Handcafted Elements">
								<?php echo esc_html__( 'Elementor + Impeka Elementor Elements', 'impeka' ); ?>
							</div>
						</a>
						<a href="#" class="<?php echo esc_attr( $elementor_only_class ); ?>" data-mode="elementor_only">
							<div class="grve-builder-button-inner">
								<img class="grve-admin-panel-icon" src="<?php echo esc_url( get_template_directory_uri() . '/includes/images/admin-plugins/plugin-4.jpg' ); ?>" alt="WPBakery Page Builder + Impeka Handcafted Elements">
								<?php echo esc_html__( 'Elementor', 'impeka' ); ?>
							</div>
						</a>
					<?php
					}
					?>
				</div>
				<div class="grve-wizard-builder-container">
					<?php $this->print_plugins_by_mode( $mode ); ?>
				</div>
				<?php $this->print_wizard_buttons(); ?>
			</div>
	<?php
		}
		public function step_plugins() {
	?>
			<div class="grve-admin-title">
				<h2 class="grve-title"><?php esc_html_e( "Recommended Plugins", 'impeka' ); ?></h2>
				<p class="grve-description"><?php esc_html_e( "Find below a few recommended plugins to install/activate. There is no need to install plugins that are useless for your website.", 'impeka' ); ?></p>
			</div>
			<div class="grve-wizard-panel-content">
				<?php
					$this->print_plugins_by_mode('other');
					$this->print_wizard_buttons();
				?>
			</div>
	<?php
		}

		public function step_demo_content() {
	?>
			<div class="grve-admin-title">
				<h2 class="grve-title"><?php esc_html_e( "Demo Content", 'impeka' ); ?></h2>
				<p class="grve-description"><?php esc_html_e( "In this step, you can install/activate the demo importer plugin. With this plugin, you will be able to import any of Impeka demos. If you do not want to import any demo content, skip this step.", 'impeka' ); ?></p>
			</div>
			<div class="grve-wizard-panel-content">
				<?php
					$this->print_plugins_by_mode('demo');
					$this->print_wizard_buttons();
				?>
			</div>
	<?php
		}

		public function step_finish() {

			$docs_link = 'https://docs.greatives.eu/theme/impeka/';
			$videos_link = 'https://www.youtube.com/channel/UCB1GYah-ZnryYHKSK0zrLnw';
			$support_link = 'https://greatives.ticksy.com';
			$import_url = admin_url( 'admin.php?page=impeka-import' );
			$options_url = admin_url( 'admin.php?page=impeka_grve_options' );
			$site_url = admin_url( 'admin.php?page=impeka_grve_options' );
	?>
			<div class="grve-admin-title">
				<h2 class="grve-title"><?php esc_html_e( "You are", 'impeka' ); ?></h2>
				<h2 class="grve-title"><?php esc_html_e( "ready to go!", 'impeka' ); ?></h2>
				<p class="grve-description"><?php esc_html_e( "You can now make further changes and modify your content to suit your needs. Proceed to the next steps or visit any of the additional information links. We are always here for you.", 'impeka' ); ?></p>
			</div>

			<div class="grve-wizard-panel-content">
				<div class="grve-quick-links">
					<span class="grve-label"><?php esc_html_e( "Next Steps:", 'impeka' ); ?></span>
					<ul class="grve-admin-nav">
						<li><a href="<?php echo esc_url( $options_url ); ?>" class="grve-wizard-button"><?php esc_html_e( "Theme Options", 'impeka' ); ?></a></li>
						<?php if ( class_exists( 'Impeka_Importer' ) ) { ?>
						<li><a href="<?php echo esc_url( $import_url ); ?>" class="grve-wizard-button"><?php esc_html_e( "Import Demos", 'impeka' ); ?></a></li>
						<?php } else { ?>
						<li><a href="<?php echo esc_url( $import_url ); ?>" class="grve-wizard-button"><?php esc_html_e( "Install/Activate Demo Importer", 'impeka' ); ?></a></li>
						<?php } ?>
						<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="grve-wizard-button grve-button-primary" target="_blank" rel="noopener noreferrer"><?php esc_html_e( "Visit Site", 'impeka' ); ?></a></li>
					</ul>
				</div>
			</div>
			<div class="grve-admin-panel-iconboxes">
				<div class="grve-iconbox">
					<div class="grve-iconbox-inner">
						<img class="grve-icon" src="<?php echo esc_url( get_template_directory_uri() . '/includes/images/admin-icons/live-tutorial.jpg' ); ?>" alt="Live Tutorial">
						<h3 class="grve-iconbox-title"><?php esc_html_e( "Live Tutorial", 'impeka' ); ?></h3>
						<p class="grve-iconbox-description"><?php esc_html_e( "We hope that in our Live Knowledgebase you will find all required information to get your site running.", 'impeka' ); ?></p>
						<a href="<?php echo esc_url( $docs_link ); ?>" class="grve-iconbox-more grve-primary-3" target="_blank" rel="noopener noreferrer"><?php esc_html_e( "Learn More", 'impeka' ); ?></a>
					</div>
				</div>
				<div class="grve-iconbox">
					<div class="grve-iconbox-inner">
						<img class="grve-icon" src="<?php echo esc_url( get_template_directory_uri() . '/includes/images/admin-icons/video-tutorial.jpg' ); ?>" alt="Video Tutorial">
						<h3 class="grve-iconbox-title"><?php esc_html_e( "Video Tutorials", 'impeka' ); ?></h3>
						<p class="grve-iconbox-description"><?php esc_html_e( "We also recommend to check out our Video Tutorials. The easiest way to discover the amazing features of Impeka.", 'impeka' ); ?></p>
						<a href="<?php echo esc_url( $videos_link ); ?>" class="grve-iconbox-more grve-primary-2" target="_blank" rel="noopener noreferrer"><?php esc_html_e( "Watch Now", 'impeka' ); ?></a>
					</div>
				</div>
				<div class="grve-iconbox">
					<div class="grve-iconbox-inner">
						<img class="grve-icon" src="<?php echo esc_url( get_template_directory_uri() . '/includes/images/admin-icons/support-system.jpg' ); ?>" alt="Live Tutorial">
						<h3 class="grve-iconbox-title"><?php esc_html_e( "Support System", 'impeka' ); ?></h3>
						<p class="grve-iconbox-description"><?php esc_html_e( "Still no luck? No worries, we are here to help. Contact our support agents and they will get back to you asap.", 'impeka' ); ?></p>
						<a href="<?php echo esc_url( $support_link ); ?>" class="grve-iconbox-more grve-primary-4" target="_blank" rel="noopener noreferrer"><?php esc_html_e( "Open Ticket", 'impeka' ); ?></a>
					</div>
				</div>
			</div>
	<?php
		}


		private function print_plugins_by_mode( $mode = 'all' ) {
			if ( !impeka_grve_check_theme_status( 'wizard' ) ) {
				echo '<div class="grve-wizard-content-error">';
				echo sprintf( esc_html__( "You need to %s to install premium plugins.", 'impeka' ), '<a href="' . esc_url( admin_url()  . 'admin.php?page=impeka' ) . '" >' . esc_html__( 'register your product', 'impeka' ) . '</a>' );
				echo '</div>';
				return;
			}
			$plugins = $this->get_tgm_plugins();
			$class = "grve-plugin-item";
			if( 'other' != $mode ) {
				$class = "grve-plugin-item grve-selected";
			}

			if ( is_array( $plugins ) ) {
				if ( isset( $plugins[$mode] ) && count( $plugins[$mode] ) ) {
					if( 'other' == $mode ) {
						echo '<p>' .  esc_html__( 'Please select the additional plugins you might like:', 'impeka' ) . '</p>';
					} else {
						echo '<p>' .  esc_html__( 'The following plugins will be installed or updated:', 'impeka' ) . '</p>';
					}
				?>
					<ul class="grve-wizard-plugins">
						<?php
							foreach ( $plugins[$mode] as $slug => $plugin ) {
						?>
								<li class="<?php echo esc_attr( $class ); ?>" data-slug="<?php echo esc_attr($slug); ?>">
									<div class="grve-plugin-name">
										<?php if( 'other' == $mode) { ?>
										<input class="grve-plugin-checkbox" type="checkbox" value="yes"/>
										<?php } ?>
										<?php echo esc_html($plugin['name']); ?>
									</div>
									<span>
										<?php
										$keys = array();
										if (isset($plugins['install'][$slug])) {
											$keys[] = 'Installation';
										}
										if (isset($plugins['update'][$slug])) {
											$keys[] = 'Update';
										}
										if (isset($plugins['activate'][$slug])) {
											$keys[] = 'Activation';
										}
										echo implode(' and ', $keys) . ' required';
										?>
									</span>
									<div class="spinner"></div>
								</li>
						<?php
							}
						?>
					</ul>
				<?php
				} else {
					if( 'other' == $mode ) {
						echo '<div class="grve-wizard-content-info">' . esc_html__( 'All plugins are already installed and up to date. Please continue.', 'impeka' ) . '</div>';
					} elseif( 'required' == $mode ) {
						echo '<div class="grve-wizard-content-info">' . esc_html__( 'All required plugins are already installed and up to date. Please continue.', 'impeka' ) . '</div>';
					} elseif( 'demo' == $mode ) {
						echo '<div class="grve-wizard-content-info">' . esc_html__( 'Demo Importer plugin is already installed and activated. Please continue.', 'impeka' ) . '</div>';
					} else {
						echo '<div class="grve-wizard-content-info">' . esc_html__( 'All needed plugins are already installed and up to date. Please continue.', 'impeka' ) . '</div>';
					}
				}
			}
		}

		private function get_tgm_plugins() {

			tgmpa_load_bulk_installer();
			// install plugins with TGM.
			if ( ! class_exists( 'TGM_Plugin_Activation' ) || ! isset( $GLOBALS['tgmpa'] ) ) {
				die( 'Failed to find TGM' );
			}
			$url     = wp_nonce_url( add_query_arg( array( 'plugins' => 'go' ) ), 'impeka-wizard' );
			// copied from TGM
			$method = ''; // Leave blank so WP_Filesystem can populate it as necessary.
			$fields = array_keys( $_POST ); // Extra fields to pass to WP_Filesystem.
			if ( false === ( $creds = request_filesystem_credentials( esc_url_raw( $url ), $method, false, false, $fields ) ) ) {
				return true; // Stop the normal page form from displaying, credential request form will be shown.
			}
			// Now we have some credentials, setup WP_Filesystem.
			if ( ! WP_Filesystem( $creds ) ) {
				// Our credentials were no good, ask the user for them again.
				request_filesystem_credentials( esc_url_raw( $url ), $method, true, false, $fields );
				return true;
			}

			$instance = call_user_func( array( get_class( $GLOBALS['tgmpa'] ), 'get_instance' ) );
			$plugins  = array(
				'all'      => array(),
				'install'  => array(),
				'update'   => array(),
				'activate' => array(),
				'required' => array(),
				'elementor_only' => array(),
				'elementor_all' => array(),
				'composer_only' => array(),
				'composer_all' => array(),
				'demo' => array(),
				'other' => array(),
			);

			foreach ( $instance->plugins as $slug => $plugin ) {
				if ( call_user_func(array($instance, 'is_plugin_active'), $slug) && false === $instance->does_plugin_have_update( $slug ) ) {
					continue;
				} else {

					if ( true == $plugin['required'] ) {
						$plugins['required'][ $slug ] = $plugin;
					} elseif ( 'js_composer' == $slug ) {
						$plugins['composer_only'][ $slug ] = $plugin;
						$plugins['composer_all'][ $slug ] = $plugin;
					} elseif ( 'impeka-wpb-extension' == $slug ) {
						$plugins['composer_all'][ $slug ] = $plugin;
					} elseif ( 'elementor' == $slug  ) {
						$plugins['elementor_only'][ $slug ] = $plugin;
						$plugins['elementor_all'][ $slug ] = $plugin;
					} elseif ( 'impeka-elementor-extension' == $slug ) {
						$plugins['elementor_all'][ $slug ] = $plugin;
					} elseif ( 'impeka-dummy-importer' == $slug  ) {
						$plugins['demo'][ $slug ] = $plugin;
					} else {
						if ( isset( $plugin['has_wizard'] ) && false == $plugin['has_wizard'] ) {
							//skip
						} else {
							$plugins['other'][ $slug ] = $plugin;
						}
					}
					$plugins['all'][ $slug ] = $plugin;

					if ( ! $instance->is_plugin_installed( $slug ) ) {
						$plugins['install'][ $slug ] = $plugin;
					} else {
						if ( false !== $instance->does_plugin_have_update( $slug ) ) {
							$plugins['update'][ $slug ] = $plugin;
						}

						if ( $instance->can_plugin_activate( $slug ) ) {
							$plugins['activate'][ $slug ] = $plugin;
						}
					}
				}
			}

			return $plugins;
		}

		function builder_plugins() {
			if ( ! check_ajax_referer( 'impeka-grve-wizard-nonce', '_grve_nonce' ) || empty( $_POST['mode'] ) ) {
				wp_send_json_error( array( 'error' => 1, 'message' => esc_html__( 'No Mode Found', 'impeka' ) ) );
			}
			$this->print_plugins_by_mode( sanitize_key( $_POST['mode'] ) );

			exit;

		}

		function install_plugins() {
			if ( ! check_ajax_referer( 'impeka-grve-wizard-nonce', '_grve_nonce' ) || empty( $_POST['slug'] ) ) {
				wp_send_json_error( array( 'error' => 1, 'message' => esc_html__( 'No Slug Found', 'impeka' ) ) );
			}
			$json = array();
			// send back some json we use to hit up TGM
			$plugins = $this->get_tgm_plugins();
			// what are we doing with this plugin?
			foreach ( $plugins['activate'] as $slug => $plugin ) {
				if ( $_POST['slug'] == $slug ) {
					$json = array(
						'url'           => admin_url( 'admin.php?page=impeka-tgmpa-install-plugins'),
						'plugin'        => array( $slug ),
						'tgmpa-page'    => 'impeka-tgmpa-install-plugins',
						'plugin_status' => 'all',
						'_wpnonce'      => wp_create_nonce( 'bulk-plugins' ),
						'action'        => 'tgmpa-bulk-activate',
						'action2'       => - 1,
						'message'       => esc_html__( 'Activating Plugin', 'impeka' ),
					);
					break;
				}
			}
			foreach ( $plugins['update'] as $slug => $plugin ) {
				if ( $_POST['slug'] == $slug ) {
					$json = array(
						'url'           => admin_url( 'admin.php?page=impeka-tgmpa-install-plugins' ),
						'plugin'        => array( $slug ),
						'tgmpa-page'    => 'impeka-tgmpa-install-plugins',
						'plugin_status' => 'all',
						'_wpnonce'      => wp_create_nonce( 'bulk-plugins' ),
						'action'        => 'tgmpa-bulk-update',
						'action2'       => - 1,
						'message'       => esc_html__( 'Updating Plugin', 'impeka' ),
					);
					break;
				}
			}
			foreach ( $plugins['install'] as $slug => $plugin ) {
				if ( $_POST['slug'] == $slug ) {
					$json = array(
						'url'           => admin_url( 'admin.php?page=impeka-tgmpa-install-plugins' ),
						'plugin'        => array( $slug ),
						'tgmpa-page'    => 'impeka-tgmpa-install-plugins',
						'plugin_status' => 'all',
						'_wpnonce'      => wp_create_nonce( 'bulk-plugins' ),
						'action'        => 'tgmpa-bulk-install',
						'action2'       => - 1,
						'message'       => esc_html__( 'Installing Plugin', 'impeka' ),
					);
					break;
				}
			}

			if ( $json ) {
				$json['hash'] = md5( serialize( $json ) ); // used for checking if duplicates happen, move to next plugin
				wp_send_json( $json );
			} else {
				wp_send_json( array( 'done' => 1, 'message' => esc_html__( 'Success', 'impeka' ) ) );
			}
			exit;

		}


	}//Class Impeka_Grve_Admin_Wizard
}


if ( ! function_exists( 'impeka_grve_setup_wizard' ) ) {
	function impeka_grve_setup_wizard() {
		Impeka_Grve_Admin_Wizard::get_instance();
	}
}
add_action( 'after_setup_theme', 'impeka_grve_setup_wizard', 10 );



//Omit closing PHP tag to avoid accidental whitespace output errors.
