<?php
/*
*	Greatives Portfolio Items
*
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

	add_action( 'save_post', 'impeka_grve_portfolio_options_save_postdata', 10, 2 );

	function impeka_grve_second_featured_image_section_box( $post ) {

		$second_featured_image = get_post_meta( $post->ID, '_impeka_grve_second_featured_image', true );

	?>

		<div id="grve-second-featured-image-wrapper">
	<?php

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-image',
				'name' => '_impeka_grve_second_featured_image',
				'value' => $second_featured_image,
				'label' => array(
					"desc" => esc_html__( 'Set Second Fetured Image', 'impeka' ),
				),
				'width' => 'fullwidth',
				'wrap_class' => 'grve-metabox-side',
			)
		);
	?>
		</div>
	<?php
	}

	function impeka_grve_portfolio_link_mode_box( $post ) {

		$link_mode = get_post_meta( $post->ID, '_impeka_grve_portfolio_link_mode', true );
		$link_url = get_post_meta( $post->ID, '_impeka_grve_portfolio_link_url', true );
		$new_window = get_post_meta( $post->ID, '_impeka_grve_portfolio_link_new_window', true );
		$link_class = get_post_meta( $post->ID, '_impeka_grve_portfolio_link_extra_class', true );

		wp_nonce_field( 'impeka_grve_nonce_portfolio_save', '_impeka_grve_nonce_portfolio_save' );

	?>
		<table class="form-table grve-metabox">
			<tbody>
				<tr>
					<td colspan="2">
						<p class="howto"><?php esc_html_e( 'Select link mode for Portfolio Overview (Used in Portfolio Element Link Type: Custom Link).', 'impeka' ); ?></p>
					</td>
				</tr>
			</tbody>
		</table>

		<div id="grve-portfolio-custom-overview">
	<?php

		impeka_grve_print_admin_option(
			array(
				'type' => 'select',
				'name' => '_impeka_grve_portfolio_link_mode',
				'id' => 'grve-portfolio-link-mode',
				'options' => array(
					'' => esc_html__( 'Portfolio Item', 'impeka' ),
					'link' => esc_html__( 'Custom Link', 'impeka' ),
					'none' => esc_html__( 'None', 'impeka' ),
				),
				'value' => $link_mode,
				'default_value' => '',
				'label' => array(
					'title' => esc_html__( 'Link Mode', 'impeka' ),
					'desc' => esc_html__( 'Select Link Mode', 'impeka' ),
				),
				'group_id' => 'grve-portfolio-custom-overview',
				'highlight' => 'highlight',
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'textfield',
				'name' => '_impeka_grve_portfolio_link_url',
				'value' => $link_url,
				'label' => array(
					'title' => esc_html__( 'Link URL', 'impeka' ),
					'desc' => esc_html__( 'Enter the full URL of your link.', 'impeka' ),
				),
				'width' => 'fullwidth',
				'dependency' =>
				'[
					{ "id" : "grve-portfolio-link-mode", "values" : ["link"] }
				]',
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'checkbox',
				'name' => '_impeka_grve_portfolio_link_new_window',
				'value' => $new_window ,
				'label' => array(
					'title' => esc_html__( 'Open Link in new window', 'impeka' ),
					'desc' => esc_html__( 'If selected, link will open in a new window.', 'impeka' ),
				),
				'dependency' =>
				'[
					{ "id" : "grve-portfolio-link-mode", "values" : ["link"] }
				]',
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'textfield',
				'name' => '_impeka_grve_portfolio_link_extra_class',
				'value' => $link_class,
				'label' => array(
					'title' => esc_html__( 'Link extra class name', 'impeka' ),
				),
				'dependency' =>
				'[
					{ "id" : "grve-portfolio-link-mode", "values" : ["link"] }
				]',
			)
		);
	?>
		</div>
	<?php
	}

	function impeka_grve_portfolio_overview_mode_box( $post ) {

		$color_selection = impeka_grve_global_admin_param( 'button_color_selection' );
		$opacity_selection = impeka_grve_global_admin_param( 'post_bg_opacity_selection' );

		$overview_mode = get_post_meta( $post->ID, '_impeka_grve_portfolio_overview_mode', true );
		$overview_color = get_post_meta( $post->ID, '_impeka_grve_portfolio_overview_color', true );
		$overview_overlay_color = get_post_meta( $post->ID, '_impeka_grve_portfolio_overview_overlay_color', true );
		$overview_overlay_opacity = get_post_meta( $post->ID, '_impeka_grve_portfolio_overview_overlay_opacity', true );
		$overview_text = get_post_meta( $post->ID, '_impeka_grve_portfolio_overview_text', true );
		$overview_text_heading = get_post_meta( $post->ID, '_impeka_grve_portfolio_overview_text_heading', true );


		wp_nonce_field( 'impeka_grve_nonce_portfolio_save', '_impeka_grve_nonce_portfolio_save' );

	?>
		<table class="form-table grve-metabox">
			<tbody>
				<tr>
					<td colspan="2">
						<p class="howto"><?php esc_html_e( 'Select the portfolio overview options ( Used in Portfolio Overview Type: Custom Overview ).', 'impeka' ); ?></p>
					</td>
				</tr>
			</tbody>
		</table>

		<div id="grve-portfolio-custom-overview">
	<?php
		impeka_grve_print_admin_option(
			array(
				'type' => 'select',
				'name' => '_impeka_grve_portfolio_overview_mode',
				'id' => 'grve-portfolio-overview-mode',
				'options' => array(
					'' => esc_html__( 'Default', 'impeka' ),
					'color' => esc_html__( 'Custom Color', 'impeka' ),
				),
				'value' => $overview_mode,
				'default_value' => '',
				'label' => esc_html__( 'Overview Mode', 'impeka' ),
				'group_id' => 'grve-portfolio-custom-overview',
				'highlight' => 'highlight',
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'select',
				'name' => '_impeka_grve_portfolio_overview_overlay_color',
				'options' => $color_selection,
				'value' => $overview_overlay_color,
				'default_value' => 'primary-1',
				'label' => esc_html__( 'Overlay color', 'impeka' ),
				'dependency' =>
				'[
					{ "id" : "grve-portfolio-overview-mode", "values" : ["color"] }
				]',
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'select',
				'name' => '_impeka_grve_portfolio_overview_overlay_opacity',
				'options' => $opacity_selection,
				'value' => $overview_overlay_opacity,
				'default_value' => '90',
				'label' => esc_html__( 'Overlay Opacity', 'impeka' ),
				'dependency' =>
				'[
					{ "id" : "grve-portfolio-overview-mode", "values" : ["color"] }
				]',
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'select',
				'name' => '_impeka_grve_portfolio_overview_color',
				'options' => $color_selection,
				'value' => $overview_color,
				'default_value' => 'black',
				'label' => esc_html__( 'Text Color', 'impeka' ),
				'dependency' =>
				'[
					{ "id" : "grve-portfolio-overview-mode", "values" : ["color"] }
				]',
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'textarea',
				'name' => '_impeka_grve_portfolio_overview_text',
				'value' => $overview_text,
				'label' => array(
					'title' => esc_html__( 'Custom Text', 'impeka' ),
					'desc' => esc_html__( 'If entered, this text will replace default title and description.', 'impeka' ),
				),
				'width' => 'fullwidth',
				'dependency' =>
				'[
					{ "id" : "grve-portfolio-overview-mode", "values" : ["color"] }
				]',
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select',
				'name' => '_impeka_grve_portfolio_overview_text_heading',
				'options' => array(
					''  => esc_html__( 'Default', 'impeka' ),
					'h2'  => 'h2',
					'h3'  => 'h3',
					'h4'  => 'h4',
					'h5'  => 'h5',
					'h6'  => 'h6',
					'leader-text' => esc_html__( 'Leader Text', 'impeka' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka' ),
					'small-text' => esc_html__( 'Small Text', 'impeka' ),
					'link-text' => esc_html__( 'Link Text', 'impeka' ),
				),
				'value' => $overview_text_heading,
				'default_value' => '',
				'label' => array(
					'title' => esc_html__( 'Custom Text size', 'impeka' ),
					'desc' => esc_html__( 'Custom Text size and typography', 'impeka' ),
				),
				'dependency' =>
				'[
					{ "id" : "grve-portfolio-overview-mode", "values" : ["color"] }
				]',
			)
		);
	?>
		</div>
	<?php
	}

	function impeka_grve_portfolio_media_section_box( $post ) {

		wp_nonce_field( 'impeka_grve_nonce_portfolio_save', 'grve_portfolio_media_save_nonce' );

		$portfolio_masonry_size = get_post_meta( $post->ID, '_impeka_grve_portfolio_media_masonry_size', true );
		$portfolio_media = get_post_meta( $post->ID, '_impeka_grve_portfolio_media_selection', true );
		$portfolio_media_fullwidth = get_post_meta( $post->ID, '_impeka_grve_portfolio_media_fullwidth', true );
		$portfolio_media_margin_bottom = get_post_meta( $post->ID, '_impeka_grve_portfolio_media_margin_bottom', true );

		$portfolio_image_mode = get_post_meta( $post->ID, '_impeka_grve_portfolio_media_image_mode', true );
		$portfolio_image_link_mode = get_post_meta( $post->ID, '_impeka_grve_portfolio_media_image_link_mode', true );

		$portfolio_video_webm = get_post_meta( $post->ID, '_impeka_grve_portfolio_video_webm', true );
		$portfolio_video_mp4 = get_post_meta( $post->ID, '_impeka_grve_portfolio_video_mp4', true );
		$portfolio_video_ogv = get_post_meta( $post->ID, '_impeka_grve_portfolio_video_ogv', true );
		$portfolio_video_poster = get_post_meta( $post->ID, '_impeka_grve_portfolio_video_poster', true );
		$portfolio_video_embed = get_post_meta( $post->ID, '_impeka_grve_portfolio_video_embed', true );
		$portfolio_video_code = get_post_meta( $post->ID, '_impeka_grve_portfolio_video_code', true );

		$media_slider_items = get_post_meta( $post->ID, '_impeka_grve_portfolio_slider_items', true );
		$media_slider_settings = get_post_meta( $post->ID, '_impeka_grve_portfolio_slider_settings', true );
		$media_slider_speed = impeka_grve_array_value( $media_slider_settings, 'slideshow_speed', '3500' );
		$media_slider_dir_nav = impeka_grve_array_value( $media_slider_settings, 'direction_nav', '1' );
		$media_slider_dir_nav_color = impeka_grve_array_value( $media_slider_settings, 'direction_nav_color', 'black' );

	?>
			<table class="form-table grve-metabox">
				<tbody>
					<tr>
						<th>
							<label for="grve-portfolio-media-masonry-size">
								<strong><?php esc_html_e( 'Masonry Size', 'impeka' ); ?></strong>
								<span>
									<?php esc_html_e( 'Select your masonry image size.', 'impeka' ); ?>
									<br/>
									<strong><?php esc_html_e( 'Used in Portfolio Element with style Masonry.', 'impeka' ); ?></strong>
								</span>
							</label>
						</th>
						<td>
							<select id="grve-portfolio-media-masonry-size" name="_impeka_grve_portfolio_media_masonry_size">
								<option value="square" <?php selected( 'square', $portfolio_masonry_size ); ?>><?php esc_html_e( 'Square', 'impeka' ); ?></option>
								<option value="large-square" <?php selected( 'large-square', $portfolio_masonry_size ); ?>><?php esc_html_e( 'Large Square', 'impeka' ); ?></option>
								<option value="landscape" <?php selected( 'landscape', $portfolio_masonry_size ); ?>><?php esc_html_e( 'Landscape', 'impeka' ); ?></option>
								<option value="portrait" <?php selected( 'portrait', $portfolio_masonry_size ); ?>><?php esc_html_e( 'Portrait', 'impeka' ); ?></option>
							</select>
						</td>
					</tr>
					<tr>
						<th>
							<label for="grve-portfolio-media-selection">
								<strong><?php esc_html_e( 'Media Selection', 'impeka' ); ?></strong>
								<span>
									<?php esc_html_e( 'Choose your portfolio media.', 'impeka' ); ?>
									<br/>
									<strong><?php esc_html_e( 'In overview only Featured Image is displayed.', 'impeka' ); ?></strong>
								</span>
							</label>
						</th>
						<td>
							<select id="grve-portfolio-media-selection" name="_impeka_grve_portfolio_media_selection">
								<option value="" <?php selected( '', $portfolio_media ); ?>><?php esc_html_e( 'Featured Image', 'impeka' ); ?></option>
								<option value="second-image" <?php selected( 'second-image', $portfolio_media ); ?>><?php esc_html_e( 'Second Featured Image', 'impeka' ); ?></option>
								<option value="gallery" <?php selected( 'gallery', $portfolio_media ); ?>><?php esc_html_e( 'Classic Gallery', 'impeka' ); ?></option>
								<option value="gallery-vertical" <?php selected( 'gallery-vertical', $portfolio_media ); ?>><?php esc_html_e( 'Vertical Gallery', 'impeka' ); ?></option>
								<option value="slider" <?php selected( 'slider', $portfolio_media ); ?>><?php esc_html_e( 'Slider', 'impeka' ); ?></option>
								<option value="video" <?php selected( 'video', $portfolio_media ); ?>><?php esc_html_e( 'YouTube/Vimeo Video', 'impeka' ); ?></option>
								<option value="video-html5" <?php selected( 'video-html5', $portfolio_media ); ?>><?php esc_html_e( 'HMTL5 Video', 'impeka' ); ?></option>
								<option value="video-code" <?php selected( 'video-code', $portfolio_media ); ?>><?php esc_html_e( 'Embed Video', 'impeka' ); ?></option>
								<option value="none" <?php selected( 'none', $portfolio_media ); ?>><?php esc_html_e( 'None', 'impeka' ); ?></option>
							</select>
						</td>
					</tr>
					<tr class="grve-portfolio-media-item grve-portfolio-media-fullwidth">
						<th>
							<label for="grve-portfolio-media-fullwidth">
								<strong><?php esc_html_e( 'Media Fullwidth', 'impeka' ); ?></strong>
								<span>
									<?php esc_html_e( 'Select if you want fullwidth media.', 'impeka' ); ?>
								</span>
							</label>
						</th>
						<td>
							<select id="grve-portfolio-media-fullwidth" name="_impeka_grve_portfolio_media_fullwidth">
								<option value="no" <?php selected( 'no', $portfolio_media_fullwidth ); ?>><?php esc_html_e( 'No', 'impeka' ); ?></option>
								<option value="yes" <?php selected( 'yes', $portfolio_media_fullwidth ); ?>><?php esc_html_e( 'Yes', 'impeka' ); ?></option>
							</select>
						</td>
					</tr>
					<tr class="grve-portfolio-media-item grve-portfolio-media-margin-bottom">
						<th>
							<label for="grve-portfolio-media-margin-bottom">
								<strong><?php esc_html_e( 'Margin Bottom', 'impeka' ); ?></strong>
								<span>
									<?php esc_html_e( 'Define the space below the portfolio media.', 'impeka' ); ?> <?php esc_html_e( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'impeka' ); ?>
								</span>
							</label>
						</th>
						<td>
							<input type="text" id="grve-portfolio-media-margin-bottom" name="_impeka_grve_portfolio_media_margin_bottom" value="<?php echo esc_attr( $portfolio_media_margin_bottom ); ?>" />
						</td>
					</tr>
					<tr class="grve-portfolio-media-item grve-portfolio-video-html5">
						<th>
							<label for="grve-portfolio-video-webm">
								<strong><?php esc_html_e( 'WebM File URL', 'impeka' ); ?></strong>
								<span>
									<?php esc_html_e( 'Upload the .webm video file.', 'impeka' ); ?>
									<br/>
									<strong><?php esc_html_e( 'This Format must be included for HTML5 Video.', 'impeka' ); ?></strong>
								</span>
							</label>
						</th>
						<td>
							<input type="text" id="grve-portfolio-video-webm" class="grve-upload-simple-media-field grve-meta-text" name="_impeka_grve_portfolio_video_webm" value="<?php echo esc_attr( $portfolio_video_webm ); ?>"/>
							<input type="button" data-media-type="video" class="grve-upload-simple-media-button button" value="<?php esc_attr_e( 'Upload Media', 'impeka' ); ?>"/>
							<input type="button" class="grve-remove-simple-media-button button" value="<?php esc_attr_e( 'Remove', 'impeka' ); ?>"/>
						</td>
					</tr>
					<tr class="grve-portfolio-media-item grve-portfolio-video-html5">
						<th>
							<label for="grve-portfolio-video-mp4">
								<strong><?php esc_html_e( 'MP4 File URL', 'impeka' ); ?></strong>
								<span>
									<?php esc_html_e( 'Upload the .mp4 video file.', 'impeka' ); ?>
									<br/>
									<strong><?php esc_html_e( 'This Format must be included for HTML5 Video.', 'impeka' ); ?></strong>
								</span>
							</label>
						</th>
						<td>
							<input type="text" id="grve-portfolio-video-mp4" class="grve-upload-simple-media-field grve-meta-text" name="_impeka_grve_portfolio_video_mp4" value="<?php echo esc_attr( $portfolio_video_mp4 ); ?>"/>
							<input type="button" data-media-type="video" class="grve-upload-simple-media-button button" value="<?php esc_attr_e( 'Upload Media', 'impeka' ); ?>"/>
							<input type="button" class="grve-remove-simple-media-button button" value="<?php esc_attr_e( 'Remove', 'impeka' ); ?>"/>
						</td>
					</tr>
					<tr class="grve-portfolio-media-item grve-portfolio-video-html5">
						<th>
							<label for="grve-portfolio-video-ogv">
								<strong><?php esc_html_e( 'OGV File URL', 'impeka' ); ?></strong>
								<span>
									<?php esc_html_e( 'Upload the .ogv video file (optional).', 'impeka' ); ?>
								</span>
							</label>
						</th>
						<td>
							<input type="text" id="grve-portfolio-video-ogv" class="grve-upload-simple-media-field grve-meta-text" name="_impeka_grve_portfolio_video_ogv" value="<?php echo esc_attr( $portfolio_video_ogv ); ?>"/>
							<input type="button" data-media-type="video" class="grve-upload-simple-media-button button" value="<?php esc_attr_e( 'Upload Media', 'impeka' ); ?>"/>
							<input type="button" class="grve-remove-simple-media-button button" value="<?php esc_attr_e( 'Remove', 'impeka' ); ?>"/>
						</td>
					</tr>
					<tr class="grve-portfolio-media-item grve-portfolio-video-html5">
						<th>
							<label for="grve-portfolio-video-poster">
								<strong><?php esc_html_e( 'Poster Image', 'impeka' ); ?></strong>
								<span>
									<?php esc_html_e( 'Use same resolution as video.', 'impeka' ); ?>
								</span>
							</label>
						</th>
						<td>
							<input type="text" id="grve-portfolio-video-poster" class="grve-upload-simple-media-field grve-meta-text" name="_impeka_grve_portfolio_video_poster" value="<?php echo esc_attr( $portfolio_video_poster ); ?>"/>
							<input type="button" data-media-type="image" class="grve-upload-simple-media-button button" value="<?php esc_attr_e( 'Upload Media', 'impeka' ); ?>"/>
							<input type="button" class="grve-remove-simple-media-button button" value="<?php esc_attr_e( 'Remove', 'impeka' ); ?>"/>
						</td>
					</tr>
					<tr class="grve-portfolio-media-item grve-portfolio-video-embed">
						<th>
							<label for="grve-portfolio-video-embed">
								<strong><?php esc_html_e( 'Vimeo/YouTube URL', 'impeka' ); ?></strong>
								<span>
									<?php esc_html_e( 'Enter the full URL of your video from Vimeo or YouTube.', 'impeka' ); ?>
								</span>
							</label>
						</th>
						<td>
							<input type="text" id="grve-portfolio-video-embed" class="grve-meta-text" name="_impeka_grve_portfolio_video_embed" value="<?php echo esc_attr( $portfolio_video_embed ); ?>"/>
						</td>
					</tr>
					<tr class="grve-portfolio-media-item grve-portfolio-video-code">
						<th>
							<label for="grve-portfolio-video-code">
								<strong><?php esc_html_e( 'Video Embed', 'impeka' ); ?></strong>
								<span>
									<?php esc_html_e( 'Enter the embed code of your video.', 'impeka' ); ?>
								</span>
							</label>
						</th>
						<td>
							<textarea id="grve-portfolio-video-code" name="_impeka_grve_portfolio_video_code" cols="40" rows="5"><?php echo esc_textarea( $portfolio_video_code ); ?></textarea>
						</td>
					</tr>
					<tr class="grve-portfolio-media-item grve-portfolio-media-image-mode">
						<th>
							<label for="grve-portfolio-media-image-mode">
								<strong><?php esc_html_e( 'Image Mode', 'impeka' ); ?></strong>
								<span>
									<?php esc_html_e( 'Select image mode.', 'impeka' ); ?>
								</span>
							</label>
						</th>
						<td>
							<select id="grve-portfolio-media-image-mode" name="_impeka_grve_portfolio_media_image_mode">
								<option value="" <?php selected( '', $portfolio_image_mode ); ?>><?php esc_html_e( 'Auto Crop', 'impeka' ); ?></option>
								<option value="resize" <?php selected( 'resize', $portfolio_image_mode ); ?>><?php esc_html_e( 'Resize', 'impeka' ); ?></option>
							</select>
						</td>
					</tr>
					<tr class="grve-portfolio-media-item grve-portfolio-media-image-link-mode">
						<th>
							<label for="grve-portfolio-media-image-link-mode">
								<strong><?php esc_html_e( 'Image Link Mode', 'impeka' ); ?></strong>
								<span>
									<?php esc_html_e( 'Select image link mode.', 'impeka' ); ?>
								</span>
							</label>
						</th>
						<td>
							<select id="grve-portfolio-media-image-link-mode" name="_impeka_grve_portfolio_media_image_link_mode">
								<option value="" <?php selected( '', $portfolio_image_link_mode ); ?>><?php esc_html_e( 'Popup', 'impeka' ); ?></option>
								<option value="none" <?php selected( 'none', $portfolio_image_link_mode ); ?>><?php esc_html_e( 'None', 'impeka' ); ?></option>
							</select>
						</td>
					</tr>
					<tr id="grve-portfolio-media-slider-speed" class="grve-portfolio-media-item">
						<th>
							<label for="grve-page-slider-speed">
								<strong><?php esc_html_e( 'Slideshow Speed', 'impeka' ); ?></strong>
							</label>
						</th>
						<td>
							<input type="text" id="grve-page-slider-speed" name="_impeka_grve_portfolio_slider_settings_speed" value="<?php echo esc_attr( $media_slider_speed ); ?>" /> ms
						</td>
					</tr>
					<tr id="grve-portfolio-media-slider-direction-nav" class="grve-portfolio-media-item">
						<th>
							<label for="grve-page-slider-direction-nav">
								<strong><?php esc_html_e( 'Arrows', 'impeka' ); ?></strong>
							</label>
						</th>
						<td>
							<select id="grve-page-slider-direction-nav" name="_impeka_grve_portfolio_slider_settings_arrows">
								<option value="yes" <?php selected( "yes", $media_slider_dir_nav ); ?>><?php esc_html_e( 'Yes', 'impeka' ); ?></option>
								<option value="no" <?php selected( "no", $media_slider_dir_nav ); ?>><?php esc_html_e( 'No', 'impeka' ); ?></option>
							</select>
						</td>
					</tr>
					<tr id="grve-portfolio-media-slider-direction-nav-color" class="grve-portfolio-media-item">
						<th>
							<label for="grve-page-slider-direction-nav-color">
								<strong><?php esc_html_e( 'Navigation Buttons Color', 'impeka' ); ?></strong>
							</label>
						</th>
						<td>
							<select id="grve-page-slider-direction-nav-color" name="_impeka_grve_portfolio_slider_settings_direction_nav_color">
								<option value="black" <?php selected( "black", $media_slider_dir_nav_color ); ?>><?php esc_html_e( 'Black', 'impeka' ); ?></option>
								<option value="white" <?php selected( "white", $media_slider_dir_nav_color ); ?>><?php esc_html_e( 'White', 'impeka' ); ?></option>
							</select>
						</td>
					</tr>
					<tr id="grve-portfolio-media-slider" class="grve-portfolio-media-item">
						<th>
							<label><?php esc_html_e( 'Media Items', 'impeka' ); ?></label>
						</th>
						<td>
							<input type="button" class="grve-upload-slider-button button-primary" value="<?php esc_attr_e( 'Insert Images', 'impeka' ); ?>"/>
							<span id="grve-upload-slider-button-spinner" class="grve-action-spinner"></span>
						</td>
					</tr>
				</tbody>
			</table>
			<div id="grve-slider-container" data-mode="minimal" class="grve-portfolio-media-item">
				<?php
					if( !empty( $media_slider_items ) ) {
						impeka_grve_print_admin_media_slider_items( $media_slider_items );
					}
				?>
			</div>


	<?php
	}

	function impeka_grve_portfolio_options_save_postdata( $post_id , $post ) {

		$options = array (
			//Media
			array(
				'id' => '_impeka_grve_portfolio_media_selection',
			),
			array(
				'id' => '_impeka_grve_portfolio_media_fullwidth',
			),
			array(
				'id' => '_impeka_grve_portfolio_media_margin_bottom',
			),
			array(
				'id' => '_impeka_grve_portfolio_media_image_mode',
			),
			array(
				'id' => '_impeka_grve_portfolio_media_image_link_mode',
			),
			array(
				'id' => '_impeka_grve_portfolio_media_masonry_size',
			),
			array(
				'id' => '_impeka_grve_portfolio_video_webm',
			),
			array(
				'id' => '_impeka_grve_portfolio_video_mp4',
			),
			array(
				'id' => '_impeka_grve_portfolio_video_ogv',
			),
			array(
				'id' => '_impeka_grve_portfolio_video_poster',
			),
			array(
				'id' => '_impeka_grve_portfolio_video_embed',
			),
			array(
				'id' => '_impeka_grve_portfolio_video_code',
				'html' => true,
			),

			//Link Mode
			array(
				'id' => '_impeka_grve_portfolio_link_mode',
			),
			array(
				'id' => '_impeka_grve_portfolio_link_url',
			),
			array(
				'id' => '_impeka_grve_portfolio_link_new_window',
			),
			array(
				'id' => '_impeka_grve_portfolio_link_extra_class',
			),
			//Overview Mode
			array(
				'id' => '_impeka_grve_portfolio_overview_mode',
			),
			array(
				'id' => '_impeka_grve_portfolio_overview_color',
			),
			array(
				'id' => '_impeka_grve_portfolio_overview_overlay_color',
			),
			array(
				'id' => '_impeka_grve_portfolio_overview_overlay_opacity',
			),
			array(
				'id' => '_impeka_grve_portfolio_overview_text',
				'html' => true,
			),
			array(
				'id' => '_impeka_grve_portfolio_overview_text_heading',
			),
			array(
				'id' => '_impeka_grve_second_featured_image',
			),

		);

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}

		if ( wp_is_post_revision( $post_id ) || wp_is_post_autosave( $post_id ) ) {
			return $post_id;
		}

		if ( ! isset( $_POST['_impeka_grve_nonce_portfolio_save'] ) || !wp_verify_nonce( $_POST['_impeka_grve_nonce_portfolio_save'], 'impeka_grve_nonce_portfolio_save' ) ) {
			return;
		}

		// Check permissions
		if ( 'portfolio' == $_POST['post_type'] )
		{
			if ( !current_user_can( 'edit_page', $post_id ) ) {
				return;
			}
		}

		foreach ( $options as $value ) {
			$allow_html = ( isset( $value['html'] ) ? $value['html'] : false );
			if( $allow_html ) {
				$new_meta_value = ( isset( $_POST[$value['id']] ) ? wp_filter_post_kses( $_POST[$value['id']] ) : '' );
			} else {
				$new_meta_value = ( isset( $_POST[$value['id']] ) ? sanitize_text_field( $_POST[$value['id']] ) : '' );
			}
			$meta_key = $value['id'];


			$meta_value = get_post_meta( $post_id, $meta_key, true );

			if ( '' != $new_meta_value  && '' == $meta_value ) {
				if ( !add_post_meta( $post_id, $meta_key, $new_meta_value, true ) ) {
					update_post_meta( $post_id, $meta_key, $new_meta_value );
				}
			} elseif ( '' != $new_meta_value && $new_meta_value != $meta_value ) {
				update_post_meta( $post_id, $meta_key, $new_meta_value );
			} elseif ( '' == $new_meta_value && '' != $meta_value ) {
				delete_post_meta( $post_id, $meta_key );
			}
		}

		if ( isset( $_POST['grve_portfolio_media_save_nonce'] ) && wp_verify_nonce( $_POST['grve_portfolio_media_save_nonce'], 'impeka_grve_nonce_portfolio_save' ) ) {


			//Media Slider Items
			$media_slider_items = array();
			if ( isset( $_POST['_impeka_grve_media_slider_item_id'] ) ) {

				$num_of_images = sizeof( $_POST['_impeka_grve_media_slider_item_id'] );
				for ( $i=0; $i < $num_of_images; $i++ ) {

					$this_image = array (
						'id' => sanitize_text_field( $_POST['_impeka_grve_media_slider_item_id'][ $i ] ),
					);
					array_push( $media_slider_items, $this_image );
				}

			}

			if( empty( $media_slider_items ) ) {
				delete_post_meta( $post->ID, '_impeka_grve_portfolio_slider_items' );
				delete_post_meta( $post->ID, '_impeka_grve_portfolio_slider_settings' );
			} else{
				update_post_meta( $post->ID, '_impeka_grve_portfolio_slider_items', $media_slider_items );

				$media_slider_speed = 3500;
				$media_slider_arrows = 'yes';
				$media_slider_direction_nav_color = 'black';
				if ( isset( $_POST['_impeka_grve_portfolio_slider_settings_speed'] ) ) {
					$media_slider_speed = sanitize_text_field( $_POST['_impeka_grve_portfolio_slider_settings_speed'] );
				}
				if ( isset( $_POST['_impeka_grve_portfolio_slider_settings_arrows'] ) ) {
					$media_slider_arrows = sanitize_text_field( $_POST['_impeka_grve_portfolio_slider_settings_arrows'] );
				}
				if ( isset( $_POST['_impeka_grve_portfolio_slider_settings_direction_nav_color'] ) ) {
					$media_slider_direction_nav_color = sanitize_text_field( $_POST['_impeka_grve_portfolio_slider_settings_direction_nav_color'] );
				}

				$media_slider_settings = array (
					'slideshow_speed' => $media_slider_speed,
					'arrows' => $media_slider_arrows,
					'direction_nav_color' => $media_slider_direction_nav_color,
				);
				update_post_meta( $post->ID, '_impeka_grve_portfolio_slider_settings', $media_slider_settings );
			}

		}

	}

//Omit closing PHP tag to avoid accidental whitespace output errors.
