<?php
/*
*	Admin Page Welcome
*
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$docs_link = 'https://docs.greatives.eu/theme/impeka/';
$videos_link = 'https://www.youtube.com/channel/UCB1GYah-ZnryYHKSK0zrLnw';
$support_link = 'https://greatives.ticksy.com';
$cart_url = 'https://1.envato.market/impeka-cart';
$purchase_code_url = 'https://docs.greatives.eu/tutorials/how-to-register-impeka/#where-can-i-find-my-purchase-code';
$licensing_terms_url = 'https://docs.greatives.eu/tutorials/how-to-register-impeka/#registration-licensing-terms';
$hub_url = 'https://hub.greatives.eu/manage-licenses/';

$purchase_code = get_option( impeka_grve_get_purchase_code_option_name() );
?>
	<div id="grve-admin-pannel-wrapper" class="grve-welcome-wrap">
		<div id="grve-welcome-panel" class="grve-admin-panel">
			<div class="grve-admin-title-wrapper">
				<div class="grve-admin-title">
					<div class="grve-logo-wrapper">
						<img class="grve-admin-logo" src="<?php echo esc_url( get_template_directory_uri() . '/includes/images/admin-logo/impeka-logo.png' ); ?>" alt="Impeka Logo">
						<div class="grve-admin-theme-version"><?php echo esc_html( impeka_grve_theme_version() ); ?></div>
					</div>
					<h2 class="grve-title"><?php esc_html_e( "Simply", 'impeka' ); ?><br><?php esc_html_e( "Impeccable.", 'impeka' ); ?></h2>
					<p class="grve-description"><?php esc_html_e( "Thank you so much for this purchase. You are now ready to use another premium WordPress theme by Greatives. Be sure that we'd be happy to support you all the way through and make Impeka Theme a lasting experience.", 'impeka' ); ?></p>
				</div>

				<!-- Registration Start -->
				<div class="grve-registration-wrapper">

					<h2 class="grve-title"><?php esc_html_e( "Product Registration", 'impeka' ); ?></h2>
					<?php echo sprintf( esc_html__( "We kindly ask you to register your product. You need to purchase one single license for every site (multisite) you install Impeka. If you already using this license to another installation, purchase %s.", 'impeka' ), '<a href="' . esc_url( $cart_url ) . '" target="_blank" rel="noopener noreferrer">' . esc_html__( 'new license here', 'impeka' ) . '</a>' ); ?>

					<div class="grve-theme-registration">
						<h3 class="grve-title"><?php esc_html_e( "Envato Purchase Code", 'impeka' ); ?></h3>
						<?php echo sprintf( esc_html__( "Please insert below your %s.", 'impeka' ), '<a href="' . esc_url( $purchase_code_url ) . '" target="_blank" rel="noopener noreferrer">' . esc_html__( 'Envato Purchase Code', 'impeka' ) . '</a>' ); ?>
						<?php if ( impeka_grve_check_theme_status() ) { ?>
						<div class="grve-input-wrapper">
							<input type="text" id="grve-purchase-code" value="<?php echo esc_attr( $purchase_code ); ?>" placeholder="XXXXXXXX-XXX-XXXX-XXXX-XXXXXXXXXXXX" readonly>
							<button id="grve-deactivate-license" class="grve-btn"><?php esc_html_e( 'Deregister', 'impeka' ); ?></button>
							<a href="#" id="grve-check-license" class="grve-btn-plain" title="<?php esc_attr_e( 'Check Status', 'impeka' ); ?>"><span class="dashicons dashicons-info"></span></a>
						</div>
						<?php } else { ?>
						<div class="grve-input-wrapper">
							<input type="text" id="grve-purchase-code" value="<?php echo esc_attr( $purchase_code ); ?>" placeholder="XXXXXXXX-XXX-XXXX-XXXX-XXXXXXXXXXXX">
							<button id="grve-activate-license" class="grve-btn" disabled><?php esc_html_e( 'Register', 'impeka' ); ?></button>
						</div>
						<p class="grve-description"><input type="checkbox" id="grve-consent-license" ><?php esc_html_e( "I give my consent to record my site address and purchase code in order to ensure License and copyright compliance.", 'impeka' ); ?></p>
						<?php } ?>
						<div class="grve-license-errors"></div>
					</div>
					<i><?php echo sprintf( esc_html__( "Find %s how to set up multiple local or staging websites with the same license.", 'impeka' ), '<a href="' . esc_url( $licensing_terms_url ) . '" target="_blank" rel="noopener noreferrer">' . esc_html__( "on this article.", 'impeka' ) . '</a>' ); ?></i><br>
					<i><?php echo sprintf( esc_html__( "If you want to manage your licenses sign up on %s.", 'impeka' ), '<a href="' . esc_url( $hub_url ) . '" target="_blank" rel="noopener noreferrer">Greatives Hub</a>' ); ?></i>

				</div>
				<!-- Registration End -->
			</div>

			<div class="grve-quick-links">
				<span class="grve-label"><?php esc_html_e( "Quick Links:", 'impeka' ); ?></span>
				<?php impeka_grve_print_admin_links('welcome', 'skip'); ?>
			</div>
			<div class="grve-admin-panel-iconboxes">
				<div class="grve-iconbox">
					<div class="grve-iconbox-inner">
						<img class="grve-icon" src="<?php echo esc_url( get_template_directory_uri() . '/includes/images/admin-icons/hub.jpg' ); ?>" alt="greatives hub">
						<h3 class="grve-iconbox-title"><?php esc_html_e( "Greatives Hub", 'impeka' ); ?></h3>
						<p class="grve-iconbox-description"><?php esc_html_e( "A hub website, accessible exclusively to Impeka users, to improve and support Impeka in many ways.", 'impeka' ); ?></p>
						<a href="<?php echo esc_url( $hub_url ); ?>" class="grve-iconbox-more grve-primary-5" target="_blank" rel="noopener noreferrer"><?php esc_html_e( "Learn More", 'impeka' ); ?></a>
					</div>
				</div>
				<div class="grve-iconbox">
					<div class="grve-iconbox-inner">
						<img class="grve-icon" src="<?php echo esc_url( get_template_directory_uri() . '/includes/images/admin-icons/live-tutorial.jpg' ); ?>" alt="Live Tutorial">
						<h3 class="grve-iconbox-title"><?php esc_html_e( "Live Tutorial", 'impeka' ); ?></h3>
						<p class="grve-iconbox-description"><?php esc_html_e( "We hope that in our Live Knowledgebase you will find all required information to get your site running.", 'impeka' ); ?></p>
						<a href="<?php echo esc_url( $docs_link ); ?>" class="grve-iconbox-more grve-primary-3" target="_blank" rel="noopener noreferrer"><?php esc_html_e( "Learn More", 'impeka' ); ?></a>
					</div>
				</div>
				<div class="grve-iconbox">
					<div class="grve-iconbox-inner">
						<img class="grve-icon" src="<?php echo esc_url( get_template_directory_uri() . '/includes/images/admin-icons/video-tutorial.jpg' ); ?>" alt="Video Tutorial">
						<h3 class="grve-iconbox-title"><?php esc_html_e( "Video Tutorials", 'impeka' ); ?></h3>
						<p class="grve-iconbox-description"><?php esc_html_e( "We also recommend to check out our Video Tutorials. The easiest way to discover the amazing features of Impeka.", 'impeka' ); ?></p>
						<a href="<?php echo esc_url( $videos_link ); ?>" class="grve-iconbox-more grve-primary-2" target="_blank" rel="noopener noreferrer"><?php esc_html_e( "Watch Now", 'impeka' ); ?></a>
					</div>
				</div>
				<div class="grve-iconbox">
					<div class="grve-iconbox-inner">
						<img class="grve-icon" src="<?php echo esc_url( get_template_directory_uri() . '/includes/images/admin-icons/support-system.jpg' ); ?>" alt="Live Tutorial">
						<h3 class="grve-iconbox-title"><?php esc_html_e( "Support System", 'impeka' ); ?></h3>
						<p class="grve-iconbox-description"><?php esc_html_e( "Still no luck? No worries, we are here to help. Contact our support agents and they will get back to you asap.", 'impeka' ); ?></p>
						<a href="<?php echo esc_url( $support_link ); ?>" class="grve-iconbox-more grve-primary-4" target="_blank" rel="noopener noreferrer"><?php esc_html_e( "Open Ticket", 'impeka' ); ?></a>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php

//Omit closing PHP tag to avoid accidental whitespace output errors.
