<?php
/**
 *  Dynamic css style for Events Calendar
 * 	@author		Greatives Team
 * 	@URI		https://greatives.eu
 */

$css = "";

// Event Anchor Size
$css .= "

#grve-event-anchor {
	height: " . intval( impeka_grve_option( 'event_anchor_menu_height', 120 ) + 2 ) . "px;
}

#grve-event-anchor .grve-anchor-wrapper {
	line-height: " . impeka_grve_option( 'event_anchor_menu_height' ) . "px;
}

";

/* Tribe Events
============================================================================= */
$css .= "
.events-list.tribe-bar-is-disabled #tribe-events-content-wrapper {
    max-width: " . esc_attr( impeka_grve_option( 'container_size', 1390 ) ) . "px;
}

.tribe-events-day {
    padding: 0;
}

";

/* Event Page Title
============================================================================= */
$css .= "

.grve-tribe-events-list-event-title {
	margin-bottom: 6px;
}

.grve-tribe-events-event-meta.grve-post-meta {
	line-height: 24px;
	margin-bottom: 20px;
	opacity: .8;
}

";

/* Event Page Title
============================================================================= */
$css .= "

#grve-event-title .event-is-recurring,
#grve-event-title .grve-description a,
#grve-event-tax-title .grve-description a {
	color: inherit;
}

#grve-event-title .grve-description a:hover,
#grve-event-tax-title .grve-description a:hover {
	opacity: 0.5;
}

";


/* Event Tooltip
============================================================================= */
$css .= "

.recurring-info-tooltip,
.tribe-events-calendar .tribe-events-tooltip,
.tribe-events-shortcode.view-week .tribe-events-tooltip,
.tribe-events-week .tribe-events-tooltip {
	padding: 30px;
	text-align: left;
}

.tribe-events-tooltip .tribe-events-event-thumb {
	float: none;
	margin-bottom: 10px;
}

.tribe-events-tooltip .tribe-events-event-body .tribe-events-event-thumb img {
	width: 100%;
	max-width: none;
	max-height: none;
}

.tribe-events-tooltip.tribe-event-featured .tribe-event-description {
	margin-top: 10px;
}
";

/* Event Navigation Bar
============================================================================= */
$css .= "
#grve-event-bar.grve-layout-1 {
	color: " . impeka_grve_option( 'event_bar_nav_text_color' ) . ";
	background-color: " . impeka_grve_option( 'event_bar_background_color' ) . ";
	padding-top: " . impeka_grve_option( 'event_nav_spacing', '', 'padding-top' ) . ";
	padding-bottom: " . impeka_grve_option( 'event_nav_spacing', '', 'padding-bottom'  ) . ";
}

#grve-event-bar.grve-layout-3 {
	color: " . impeka_grve_option( 'event_bar_nav_text_color' ) . ";
	padding-top: " . impeka_grve_option( 'event_nav_spacing', '', 'padding-top' ) . ";
	padding-bottom: " . impeka_grve_option( 'event_nav_spacing', '', 'padding-bottom'  ) . ";
	background-color: " . impeka_grve_option( 'event_bar_background_color' ) . ";
}

";


/* Event Photo Layout
============================================================================= */
$css .= "

.type-tribe_events.tribe-events-photo-event .tribe-events-photo-event-wrap {
	background-color: #ffffff;
	-webkit-box-shadow: 0px 0px 25px 0px rgba(0,0,0,0.1);
	-moz-box-shadow: 0px 0px 25px 0px rgba(0,0,0,0.1);
	box-shadow: 0px 0px 25px 0px rgba(0,0,0,0.1);
}

.tribe-events-list .tribe-events-photo-event .tribe-events-event-details {
	padding: 36px;
}

.tribe-events-list .tribe-events-loop .tribe-event-featured,
.tribe-events-list #tribe-events-day.tribe-events-loop .tribe-event-featured,
.type-tribe_events.tribe-events-photo-event.tribe-event-featured .tribe-events-photo-event-wrap,
.type-tribe_events.tribe-events-photo-event.tribe-event-featured .tribe-events-photo-event-wrap:hover {
	background-color: #101215 !important;
}

";


/**
* Header Colors
* ----------------------------------------------------------------------------
*/

$css .= "
.tribe-events-day .tribe-event-featured a,
.tribe-events-day .tribe-event-featured a:hover,
.grve-tribe-events-meta-group ul li span,
#tribe-events-content .tribe-events-calendar div[id*=tribe-events-event-] h3.tribe-events-month-event-title a {
	color: " . impeka_grve_option( 'body_heading_color' ) . ";
}

";


/**
* Borders
* ----------------------------------------------------------------------------
*/
$css .= "

.grve-tribe-events-meta-group ul li,
.grve-list-separator:after,
.grve-post-content .grve-tribe-events-venue-details,
#tribe-events-content .tribe-events-calendar td,
.tribe-grid-allday .type-tribe_events>div,
.tribe-grid-allday .type-tribe_events>div:hover,
.tribe-grid-body .type-tribe_events .tribe-events-week-hourly-single,
.tribe-grid-body .type-tribe_events .tribe-events-week-hourly-single:hover {
	border-color: " . impeka_grve_option( 'body_border_color' ) . ";
}

";

/**
* Primary Text
* ----------------------------------------------------------------------------
*/

$css .= "

#tribe-events-content .tribe-events-calendar div[id*=tribe-events-event-] h3.tribe-events-month-event-title a:hover,
#tribe_events_filters_wrapper .tribe_events_slider_val {
	color: " . impeka_grve_option( 'body_primary_1_color' ) . ";
}

";

/**
* Primary Bg
* ----------------------------------------------------------------------------
*/

$css .= "

#tribe-bar-form .tribe-bar-submit input[type=submit],
#tribe-events .tribe-events-button,
#tribe-events .tribe-events-button:hover,
#tribe_events_filters_wrapper input[type=submit],
.tribe-events-button,
.tribe-events-button.tribe-active:hover,
.tribe-events-button.tribe-inactive,
.tribe-events-button:hover, .tribe-events-calendar td.tribe-events-present div[id*=tribe-events-daynum-],
.tribe-events-calendar td.tribe-events-present div[id*=tribe-events-daynum-]>a,
.tribe-grid-allday .type-tribe_events>div,
.tribe-grid-allday .type-tribe_events>div:hover,
.tribe-grid-body .type-tribe_events .tribe-events-week-hourly-single,
.tribe-grid-body .type-tribe_events .tribe-events-week-hourly-single:hover {
	background-color: " . impeka_grve_option( 'body_primary_1_color' ) . ";
	color: #ffffff;
}

#tribe-bar-form .tribe-bar-submit input[type=submit]:hover {
	background-color: " . impeka_grve_option( 'body_primary_1_hover_color' ) . ";
	border-color: " . impeka_grve_option( 'body_primary_1_hover_color' ) . ";
	color: #ffffff;
}


";

/**
* Widgets
* ----------------------------------------------------------------------------
*/

$css .= "

#grve-main-content .grve-widget .entry-title a,
#grve-main-content .widget .tribe-countdown-text a,
#tribe-events-content .tribe-events-tooltip h4 {
	color: " . impeka_grve_option( 'body_heading_color' ) . ";
}

#grve-main-content .widget .tribe-mini-calendar .tribe-events-has-events a,
#grve-main-content .widget .tribe-countdown-number,
#grve-main-content .widget .tribe-mini-calendar-no-event {
	color: " . impeka_grve_option( 'body_text_color' ) . ";
}

#grve-main-content .grve-widget .entry-title a:hover,
.widget .tribe-countdown-text a:hover,
.widget .tribe-mini-calendar-event .list-date .list-dayname,
.widget .tribe-countdown-under,
.widget .tribe-mini-calendar td.tribe-events-has-events a {
	color: " . impeka_grve_option( 'body_primary_1_color' ) . ";
}

#grve-main-content .tribe-mini-calendar-event {
	border-color: " . impeka_grve_option( 'body_border_color' ) . ";
}

.widget .tribe-mini-calendar-nav td,
.widget .tribe-mini-calendar td.tribe-events-has-events.tribe-events-present,
.widget .tribe-mini-calendar td.tribe-events-has-events.tribe-events-present a:hover,
.widget .tribe-mini-calendar td.tribe-events-has-events a:hover,
.widget .tribe-mini-calendar td.tribe-events-has-events.tribe-mini-calendar-today {
	background-color: " . impeka_grve_option( 'body_primary_1_color' ) . ";
	color: #ffffff;
}

";

/* Footer */
$css .= "

#grve-footer .grve-widget .entry-title a,
#grve-footer .widget .tribe-countdown-text a {
	color: " . impeka_grve_option( 'footer_widgets_headings_color' ) . ";
}

#grve-footer .widget .tribe-countdown-number,
#grve-footer .widget .tribe-mini-calendar-no-event {
	color: " . impeka_grve_option( 'footer_widgets_font_color' ) . ";
}

#grve-footer .widget .tribe-mini-calendar-event,
#grve-footer table,
#grve-footer td,
#grve-footer th {
	border-color: " . impeka_grve_option( 'footer_widgets_border_color' ) . ";
}

#grve-footer .widget .tribe-mini-calendar-event .list-date,
#grve-footer .widget .tribe-mini-calendar th {
	background-color: " . impeka_grve_option( 'footer_widgets_border_color' ) . ";
}

";

/**
* Typography
* ----------------------------------------------------------------------------
*/

$css .= "

.widget .tribe-mini-calendar-event .list-info {
	font-size: " . impeka_grve_option( 'body_font', '14px', 'font-size'  ) . ";
	font-family: " . impeka_grve_option( 'body_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'body_font', 'normal', 'font-weight'  ) . ";
}

#tribe-bar-form .tribe-bar-submit input[type=submit],
.grve-widget .entry-title,
.widget .tribe-mini-calendar-nav td,
.widget .tribe-countdown-text,
#tribe-events-content .tribe-events-calendar div[id*=tribe-events-event-] h3.tribe-events-month-event-title {
	font-family: " . impeka_grve_option( 'link_text', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'link_text', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'link_text', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'link_text', '11px', 'font-size'  ) . " !important;
	text-transform: " . impeka_grve_option( 'link_text', 'uppercase', 'text-transform'  ) . ";
}

";

// output dynamic css
echo impeka_grve_compress_css( $css );

//Omit closing PHP tag to avoid accidental whitespace output errors.
