<?php
/**
 *  Dynamic css style
 * 	@author		Greatives Team
 * 	@URI		https://greatives.eu
 */

$css = "";


/* =========================================================================== */

/* Body
/* Container Size
/* Boxed Size
/* Single Post Content Width
/* Top Bar

/* Default Header
	/* - Default Header Colors
	/* - Default Header Menu Colors
	/* - Default Header Sub Menu Colors
	/* - Default Header Layout
	/* - Default Header Overlaping

/* Logo On Top Header
	/* - Logo On Top Header Colors
	/* - Logo On Top Header Menu Colors
	/* - Logo On Top Header Sub Menu Colors
	/* - Logo On Top Header Layout
	/* - Logo On Top Header Overlaping
/* - Horizontal Menu Spacing
/* Light Header
/* Dark Header

/* Sticky Header
	/* - Sticky Default Header
	/* - Sticky Logo On Top Header
	/* - Sticky Header Colors
	/* - Impeka Sticky Header

/* Side Area Colors
/* Modals Colors
/* Media Popup Colors

/* Responsive Header
	/* - Header Layout
	/* - Responsive Menu
	/* - Responsive Header Elements

/* Page Transitions
/* Box Item
/* Primary Text Color
/* Primary Bg Color
/* Anchor Menu
/* Breadcrumbs
/* Main Content
	/* - Main Content Borders
	/* - Widget Colors

/* Bottom Bar Colors
/* Post Navigation Bar
/* Portfolio Navigation Bar
/* Single Post Tags & Categories
/* Footer
	/* - Widget Area
	/* - Footer Widget Colors
	/* - Footer Bar Colors




/* =========================================================================== */


/* Body
============================================================================= */

$impeka_grve_container_size_threshold = impeka_grve_option( 'container_size', '1390' );
$impeka_grve_container_size_threshold = filter_var( $impeka_grve_container_size_threshold, FILTER_SANITIZE_NUMBER_INT );

$impeka_grve_responsive_header_threshold = impeka_grve_option( 'responsive_header_threshold', '1024' );
$impeka_grve_responsive_header_threshold = filter_var( $impeka_grve_responsive_header_threshold, FILTER_SANITIZE_NUMBER_INT );

$impeka_grve_content_body_background = impeka_grve_option( 'body_background', array( 'background-color' => '#171A1D' ) );
$css .= "
.grve-body {
	" . impeka_grve_get_background_css( $impeka_grve_content_body_background ) . "
}
";

if ( 'fixed' == impeka_grve_array_value( $impeka_grve_content_body_background, 'background-attachment' ) ) {
	$impeka_grve_content_body_background['background-attachment'] = 'scroll';
	$css .= "
		.grve-body {
			clip: rect(auto auto auto auto);
		}
		.grve-body:before {
			" . impeka_grve_get_background_css( $impeka_grve_content_body_background ) . "
			content: '';
			position:fixed;
			top:0;
			width:100vw;
			height:100vh;
			left:0;
			right:0;
			z-index:-1;
		}
	";
}

/* Container Size
============================================================================= */
$css .= "

.grve-container,
#disqus_thread,
#grve-content.grve-left-sidebar .grve-content-wrapper,
#grve-content.grve-right-sidebar .grve-content-wrapper {
	max-width: " . impeka_grve_option( 'container_size', 1390 ) . "px;
	width: calc( 100% - 10.500rem );
}

.grve-section.grve-container-width {
	max-width: " . impeka_grve_option( 'container_size', 1390 ) . "px;
	width: calc( 100% - 10.500rem );
	margin-left: auto;
	margin-right: auto;
}

@media only screen and (max-width: " . esc_attr( $impeka_grve_container_size_threshold + 60 ) . "px) {
	.grve-container,
	#disqus_thread,
	#grve-content.grve-left-sidebar .grve-content-wrapper,
	#grve-content.grve-right-sidebar .grve-content-wrapper {
		max-width: " . impeka_grve_option( 'container_size', 1390 ) . "px;
	}
	.grve-section.grve-container-width {
		max-width: " . impeka_grve_option( 'container_size', 1390 ) . "px;
	}
}

@media only screen and (max-width: 1200px) {
	.grve-container,
	#grve-theme-wrapper.grve-header-side.grve-container,
	#grve-theme-wrapper.grve-header-side #grve-content.grve-left-sidebar .grve-content-wrapper,
	#grve-theme-wrapper.grve-header-side #grve-content.grve-right-sidebar .grve-content-wrapper {
		max-width: " . impeka_grve_option( 'container_size', 1390 ) . "px;
		width: calc( 100% - 7.500rem );
	}
	.grve-section.grve-container-width {
		max-width: " . impeka_grve_option( 'container_size', 1390 ) . "px;
		width: calc( 100% - 7.500rem );
	}
}

@media only screen and (max-width: 960px) {
	.grve-container,
	#grve-theme-wrapper.grve-header-side.grve-container,
	#grve-theme-wrapper.grve-header-side #grve-content.grve-left-sidebar .grve-content-wrapper,
	#grve-theme-wrapper.grve-header-side #grve-content.grve-right-sidebar .grve-content-wrapper {
		max-width: " . impeka_grve_option( 'container_size', 1390 ) . "px;
		width: calc( 100% - 6.000rem );
	}
	.grve-section.grve-container-width {
		max-width: " . impeka_grve_option( 'container_size', 1390 ) . "px;
		width: calc( 100% - 6.000rem );
	}
}
@media only screen and (max-width: 767px) {
	.grve-container,
	#grve-content.grve-left-sidebar .grve-content-wrapper,
	#grve-content.grve-right-sidebar .grve-content-wrapper {
		max-width: 500px;
		width: calc( 100% - " . impeka_grve_option( 'mobile_container_space', 1390 ) * 2 . "px );
	}
	.grve-section.grve-container-width {
		max-width: 500px;
		width: calc( 100% - " . impeka_grve_option( 'mobile_container_space', 1390 ) * 2 . "px );
	}
}


";

/* Framed Size
============================================================================= */
$impeka_grve_theme_layout = impeka_grve_option( 'theme_layout', 'stretched' );
$impeka_grve_frame_size = impeka_grve_option( 'frame_size', 30 );
$impeka_grve_boxed_size = impeka_grve_option( 'boxed_size', 1220 );
if ( 'framed' == $impeka_grve_theme_layout ) {
	$css .= "

	@media only screen and (min-width: " . esc_attr( $impeka_grve_responsive_header_threshold ) . "px) {
		body.grve-framed {
			margin: " . esc_attr( $impeka_grve_frame_size ) . "px;
		}
		.grve-frame {
			background-color: " . impeka_grve_option( 'frame_color' ) . ";
		}
		.grve-frame.grve-top {
			top: 0;
			left: 0;
			width: 100%;
			height: " . esc_attr( $impeka_grve_frame_size ) . "px;
		}
		.grve-frame.grve-left {
			top: 0;
			left: 0;
			width: " . esc_attr( $impeka_grve_frame_size ) . "px;
			height: 100%;
		}
		.grve-frame.grve-right {
			top: 0;
			right: 0;
			width: " . esc_attr( $impeka_grve_frame_size ) . "px;
			height: 100%;
		}
		.grve-frame.grve-bottom {
			bottom: 0;
			left: 0;
			width: 100%;
			height: " . esc_attr( $impeka_grve_frame_size ) . "px;
		}

		body.admin-bar .grve-frame.grve-top {
			top: 32px;
		}

		#grve-main-header {
			width: calc( 100vw - (" . esc_attr( $impeka_grve_frame_size ) . "px * 2) );
		}

		#grve-main-header.grve-fixed,
		.grve-anchor-menu .grve-anchor-wrapper.grve-sticky {
			width: auto;
			left: " . esc_attr( $impeka_grve_frame_size ) . "px;
			right: " . esc_attr( $impeka_grve_frame_size ) . "px;
		}

		#grve-sliding-area {
			width: auto;
			top: " . esc_attr( $impeka_grve_frame_size ) . "px;
			left: " . esc_attr( $impeka_grve_frame_size ) . "px;
			right: " . esc_attr( $impeka_grve_frame_size ) . "px;
		}

		.grve-back-top {
			bottom: calc(" . esc_attr( $impeka_grve_frame_size ) . "px + 2rem);
			right: calc(" . esc_attr( $impeka_grve_frame_size ) . "px + 1.5rem);
		}

		.grve-safebutton-icon-wrapper.grve-fixed {
			right: calc(" . esc_attr( $impeka_grve_frame_size ) . "px + 0.875rem);
		}

		.grve-close-button-wrapper {
			top: " . ( esc_attr( $impeka_grve_frame_size ) + 20 ) . "px;
			right: " . ( esc_attr( $impeka_grve_frame_size ) + 20 ) . "px;
		}

		.grve-hiddenarea-wrapper {
			top: " . esc_attr( $impeka_grve_frame_size ) . "px;
		}

		#fp-nav.right,
		#pp-nav.right {
			right: " . ( esc_attr( $impeka_grve_frame_size ) + 20 ) . "px;
		}

		#grve-top-bar.grve-sticky-topbar.grve-fixed .grve-top-bar-section {
			top: " . esc_attr( $impeka_grve_frame_size ) . "px;
		}

		.mfp-arrow {
			right: " . ( esc_attr( $impeka_grve_frame_size ) + 20 ) . "px;
		}

		.mfp-arrow-left {
			top: 111px;
		}

		.mfp-arrow-right {
			top: 172px;
		}

		.grve-body:not(.grve-open-safebutton-area) #grve-footer.grve-fixed-footer {
			left: " . esc_attr( $impeka_grve_frame_size ) . "px;
			right: " . esc_attr( $impeka_grve_frame_size ) . "px;
			bottom: " . esc_attr( $impeka_grve_frame_size ) . "px;
		}

		.grve-navigation-bar.grve-layout-2 {
			left: " . esc_attr( $impeka_grve_frame_size ) . "px;
		}

		.grve-page-nav,
		.grve-social-bar.grve-layout-1 {
			left: calc(" . esc_attr( $impeka_grve_frame_size ) . "px + 32px);
		}

		#grve-feature-section.grve-fullscreen .grve-goto-section-wrapper {
			bottom: calc(" . esc_attr( $impeka_grve_frame_size ) . "px + 2rem);
		}
	}
	";
} else if ( 'boxed' == $impeka_grve_theme_layout ) {

	$css .= "
		#grve-theme-wrapper {
			width: 100%;
			max-width: " . esc_attr( $impeka_grve_boxed_size ) . "px;
			overflow: hidden;
		}

		#grve-main-header,
		.grve-anchor-menu .grve-anchor-wrapper.grve-sticky,
		#grve-footer.grve-fixed-footer,
		#grve-sliding-area {
			max-width: " . esc_attr( $impeka_grve_boxed_size ) . "px;
		}

		.grve-page-nav,
		.grve-social-bar.grve-layout-1 {
			left: calc( (100vw - " . esc_attr( $impeka_grve_boxed_size ) . "px)/2 + 32px);
		}

		.grve-back-top {
			right: calc((100vw - " . esc_attr( $impeka_grve_boxed_size ) . "px)/2 + 1.5rem);
		}

		.grve-safebutton-icon-wrapper.grve-fixed {
			right: calc((100vw - " . esc_attr( $impeka_grve_boxed_size ) . "px)/2 + 0.875rem);
		}

		@media only screen and (max-width: 1200px) {

			#grve-header.grve-sticky-header #grve-main-header.grve-header-default,
			#grve-header.grve-sticky-header #grve-main-header .grve-bottom-header-area,
			#grve-header.grve-fixed #grve-main-header,
			#grve-sliding-area {
				max-width: 90%;
			}

			#grve-theme-wrapper,
			.grve-anchor-menu .grve-anchor-wrapper.grve-sticky,
			#grve-content.grve-right-sidebar .grve-content-wrapper,
			#grve-content.grve-left-sidebar .grve-content-wrapper	{
				max-width: 90%;
			}

		    #grve-theme-wrapper {
		        margin-top: 0;
		        margin-bottom: 0;
		    }
		}

		@media only screen and (max-width: 1023px) {
			#grve-content.grve-right-sidebar .grve-content-wrapper,
			#grve-content.grve-left-sidebar .grve-content-wrapper {
				max-width: 100%;
			}
		}
	";
}

/* Top Bar
============================================================================= */
$css .= "
#grve-top-bar .grve-top-bar-section {
	padding-top: " . impeka_grve_option( 'top_bar_spacing', '', 'padding-top' ) . ";
	padding-bottom: " . impeka_grve_option( 'top_bar_spacing', '', 'padding-bottom'  ) . ";
}

#grve-top-bar .grve-top-bar-section,
#grve-top-bar .grve-language > li > ul,
#grve-top-bar .grve-top-bar-menu ul.sub-menu {
	background-color: " . impeka_grve_option( 'top_bar_bg_color' ) . ";
	color: " . impeka_grve_option( 'top_bar_font_color' ) . ";
}

#grve-top-bar a,
#grve-top-bar .grve-search-btn {
	color: " . impeka_grve_option( 'top_bar_link_color' ) . ";
}

#grve-top-bar a:hover,
#grve-top-bar .grve-search-btn:hover {
	color: " . impeka_grve_option( 'top_bar_hover_color' ) . ";
}

";


/* Default Header
============================================================================= */
$header_group = impeka_grve_global_param( 'header_group' );
$header_style = impeka_grve_global_param( 'header_style' );

if ( 'default' == $header_group ) {

	/* - Default Header Layout
	========================================================================= */
	$css .= "

	#grve-main-header {
		padding-top: " . impeka_grve_option( 'header_spacing', '', 'padding-top' ) . ";
		padding-bottom: " . impeka_grve_option( 'header_spacing', '', 'padding-bottom'  ) . ";
	}
	#grve-main-header .grve-logo:not(.grve-logo-text) a {
		height: " . impeka_grve_option( 'logo_height', 20 ) . "px;
	}

	#grve-main-header.grve-layout-default.grve-style-2 .grve-header-row {
		min-height: " . impeka_grve_option( 'logo_height', 20 ) . "px;
	}

	@media only screen and (max-width: 1200px) {
		#grve-main-header .grve-logo:not(.grve-logo-text) a {
			height: " . impeka_grve_option( 'logo_small_screens_height', 20 ) . "px;
		}

		#grve-main-header.grve-layout-default.grve-style-2 .grve-header-row {
			min-height: " . impeka_grve_option( 'logo_small_screens_height', 20 ) . "px;
		}
	}

	";

	/* - Sub Menu Position
	========================================================================= */
	$impeka_grve_submenu_top_position = impeka_grve_option( 'submenu_top_position', '0' );
	if( 0 != $impeka_grve_submenu_top_position ) {
		$css .= "
		#grve-main-header:not(.grve-sticky-header) .grve-horizontal-menu li.grve-first-level > .grve-sub-menu,
		#grve-main-header.grve-sticky-header[data-sticky='simple'] .grve-horizontal-menu li.grve-first-level > .grve-sub-menu {
			margin-top: -" . impeka_grve_option( 'submenu_top_position' ) . "px;
		}
		";
	}

	$css .= "
		#grve-main-header:not(.grve-style-2) .grve-header-menu.grve-horizontal-menu .grve-first-level > .grve-sub-menu,
		#grve-main-header .grve-header-menu.grve-horizontal-menu .grve-first-level:not(.grve-menu-size-fullwidth) > .grve-sub-menu {
			top: calc(100% + " . impeka_grve_option( 'header_spacing', '', 'padding-bottom'  ) . ");
		}
	";

/* Offcanvas Style 1
============================================================================= */
} else if ( 'offcanvas' == $header_group ) {

	if ( 'style-1' == $header_style ) {
	$css .= "

	#grve-main-header {
		padding-top: " . impeka_grve_option( 'header_spacing', '', 'padding-top' ) . ";
		padding-bottom: " . impeka_grve_option( 'header_spacing', '', 'padding-bottom'  ) . ";
	}
	#grve-main-header .grve-logo:not(.grve-logo-text) a {
		height: " . impeka_grve_option( 'logo_height', 20 ) . "px;
	}

	";
	} else {
		$css .= "

		#grve-main-header .grve-logo:not(.grve-logo-text) a {
			height: " . impeka_grve_option( 'logo_height', 30 ) . "px;
		}

		#grve-main-header .grve-logo {
			padding-top: " . impeka_grve_option( 'header_side_logo_spacing', '', 'padding-top' ) . ";
			padding-bottom: " . impeka_grve_option( 'header_side_logo_spacing', '', 'padding-bottom'  ) . ";
		}

		#grve-main-header {
			width: " . impeka_grve_option( 'header_side_width', 120 ) . "px;
		}

		@media only screen and (min-width: " . esc_attr( $impeka_grve_responsive_header_threshold ) . "px) {
			.grve-body.grve-header-vertical #grve-theme-wrapper,
			.grve-body.grve-header-vertical #grve-footer.grve-fixed-footer {
				padding-left: " . impeka_grve_option( 'header_side_width', 120 ) . "px;
				left: 0;
			}

			.grve-anchor-menu .grve-anchor-wrapper.grve-sticky {
				width: calc(100% - " . impeka_grve_option( 'header_side_width', 120 ) . "px);
			}

			#grve-post-social-bar {
				left: calc( " . impeka_grve_option( 'header_side_width', 120 ) . "px + 2.000rem );
			}
		}

		";
	}


/* Logo On Top Header
============================================================================= */
} else if ( 'top-bottom' == $header_group ) {


	/* - Logo On Top Header Colors
	============================================================================= */
	$impeka_grve_logo_top_logo_area_background_color = impeka_grve_option( 'logo_top_header_logo_area_background_color', '#ffffff' );
	$impeka_grve_logo_top_menu_area_background_color = impeka_grve_option( 'logo_top_header_menu_area_background_color', '#ffffff' );
	$css .= "

	#grve-main-header .grve-top-header-area {
		background-color: rgba(" . impeka_grve_hex2rgb( $impeka_grve_logo_top_logo_area_background_color ) . "," . impeka_grve_option( 'logo_top_header_logo_area_background_color_opacity', '1') . ");
	}

	#grve-main-header .grve-bottom-header-area {
		background-color: rgba(" . impeka_grve_hex2rgb( $impeka_grve_logo_top_menu_area_background_color ) . "," . impeka_grve_option( 'logo_top_header_menu_area_background_color_opacity', '1') . ");
	}

	#grve-main-header.grve-skin-light .grve-top-header-area,
	#grve-main-header.grve-skin-dark .grve-top-header-area,
	#grve-main-header.grve-skin-light .grve-bottom-header-area,
	#grve-main-header.grve-skin-dark .grve-bottom-header-area {
		background-color: transparent;
	}

	";


	/* - Logo On Top Header Text
	========================================================================= */
	$css .= "

	#grve-main-header .grve-header-text {
		color: " . impeka_grve_option( 'logo_top_header_text_color' ) . ";
	}

	#grve-main-header .grve-header-text h1,
	#grve-main-header .grve-header-text h2,
	#grve-main-header .grve-header-text h3,
	#grve-main-header .grve-header-text h4,
	#grve-main-header .grve-header-text h5,
	#grve-main-header .grve-header-text h6 {
		color: " . impeka_grve_option( 'logo_top_header_headings_color' ) . ";
	}

	#grve-main-header .grve-header-text a {
		color: " . impeka_grve_option( 'logo_top_header_link_color' ) . ";
	}

	#grve-main-header .grve-header-text a:hover {
		color: " . impeka_grve_option( 'logo_top_header_link_hover_color' ) . ";
	}

	";


	/* - Logo On Top Header Layout
	========================================================================= */
	$css .= "
	#grve-main-header .grve-top-header-area {
		padding-top: " . impeka_grve_option( 'header_top_spacing', '', 'padding-top' ) . ";
		padding-bottom: " . impeka_grve_option( 'header_top_spacing', '', 'padding-bottom'  ) . ";
	}

	#grve-main-header .grve-bottom-header-area {
		padding-top: " . impeka_grve_option( 'header_bottom_spacing', '', 'padding-top' ) . ";
		padding-bottom: " . impeka_grve_option( 'header_bottom_spacing', '', 'padding-bottom'  ) . ";
	}

	#grve-main-header .grve-logo:not(.grve-logo-text) a {
		height: " . impeka_grve_option( 'logo_height', 30 ) . "px;
	}
	";

	/* - Sub Menu Position
	========================================================================= */
	$impeka_grve_submenu_top_position = impeka_grve_option( 'submenu_top_position', '0' );
	if( 0 != $impeka_grve_submenu_top_position ) {
		$css .= "
		#grve-main-header:not(.grve-sticky-header) .grve-horizontal-menu li.grve-first-level > .grve-sub-menu,
		#grve-main-header.grve-sticky-header[data-sticky='simple'] .grve-horizontal-menu li.grve-first-level > .grve-sub-menu {
			margin-top: -" . impeka_grve_option( 'submenu_top_position' ) . "px;
		}
		";
	}

	$css .= "
		#grve-main-header .grve-header-menu.grve-horizontal-menu .grve-first-level .grve-sub-menu  {
			top: calc(100% + " . impeka_grve_option( 'header_bottom_spacing', '', 'padding-bottom'  ) . ");
		}
	";

} else {

	/* - Side Header Layout
	========================================================================= */
	$css .= "

	#grve-main-header .grve-logo:not(.grve-logo-text) a {
		height: " . impeka_grve_option( 'logo_height', 30 ) . "px;
	}

	#grve-main-header .grve-logo {
		padding-top: " . impeka_grve_option( 'header_side_logo_spacing', '', 'padding-top' ) . ";
		padding-bottom: " . impeka_grve_option( 'header_side_logo_spacing', '', 'padding-bottom'  ) . ";
	}

	#grve-main-header .grve-header-row {
		padding-left: " . impeka_grve_option( 'header_side_spacing', '', 'padding-left' ) . ";
		padding-right: " . impeka_grve_option( 'header_side_spacing', '', 'padding-right'  ) . ";
	}

	#grve-main-header {
		width: " . impeka_grve_option( 'header_side_width', 120 ) . "px;
	}

	#grve-main-header .grve-vertical-menu li.menu-item + li.menu-item,
	#grve-main-header .grve-vertical-menu .grve-go-back-wrapper + *,
	#grve-main-header .grve-vertical-menu.grve-toggle-animation li .grve-sub-menu,
	#grve-main-header .grve-vertical-menu.grve-accordion-animation li .grve-sub-menu {
		margin-top: " . impeka_grve_option( 'menu_item_space', 36 ) . "px;
	}

	@media only screen and (min-width: " . esc_attr( $impeka_grve_responsive_header_threshold ) . "px) {
		body.grve-header-vertical:not(.grve-safebutton-ready) #grve-theme-wrapper,
		.grve-body.grve-header-vertical #grve-footer.grve-fixed-footer {
			padding-left: " . impeka_grve_option( 'header_side_width', 120 ) . "px;
			left: 0;
		}

		#grve-post-social-bar {
			left: calc( " . impeka_grve_option( 'header_side_width', 120 ) . "px + 2.000rem );
		}

		.grve-body.grve-header-vertical.rtl #grve-theme-wrapper,
		.grve-body.grve-header-vertical.rtl #grve-footer.grve-fixed-footer {
			padding-left: 0;
			padding-right: " . impeka_grve_option( 'header_side_width', 120 ) . "px;
		}

		.grve-body.grve-header-vertical.rtl #grve-footer.grve-fixed-footer {
			margin-left: 0;
			margin-right: -" . impeka_grve_option( 'header_side_width', 120 ) . "px;
		}

		.grve-anchor-menu .grve-anchor-wrapper.grve-sticky {
			width: calc(100% - " . impeka_grve_option( 'header_side_width', 120 ) . "px);
		}
	}

	";

}

/* - Sticky Default Header
========================================================================= */
if ( 'default' == $header_group || ( 'offcanvas' == $header_group && 'style-1' == $header_style ) ) {
	$css .= "
	#grve-main-header.grve-sticky-header.grve-shrink-sticky,
	#grve-main-header.grve-sticky-header.grve-scrollup-sticky {
		padding-top: " . impeka_grve_option( 'header_sticky_shrink_spacing', '', 'padding-top' ) . ";
		padding-bottom: " . impeka_grve_option( 'header_sticky_shrink_spacing', '', 'padding-bottom'  ) . ";
	}

	#grve-main-header.grve-sticky-header.grve-shrink-sticky .grve-logo a,
	#grve-main-header.grve-sticky-header.grve-scrollup-sticky .grve-logo a {
		height: " . impeka_grve_option( 'header_sticky_shrink_logo_height', 20 ) . "px;
	}
	";

	/* - Sub Menu Position
	========================================================================= */
	$css .= "
		#grve-main-header.grve-sticky-header:not(.grve-style-2) .grve-header-menu.grve-horizontal-menu .grve-first-level > .grve-sub-menu,
		#grve-main-header.grve-sticky-header .grve-header-menu.grve-horizontal-menu .grve-first-level:not(.grve-menu-size-fullwidth) > .grve-sub-menu {
			top: calc(100% + " . impeka_grve_option( 'header_sticky_shrink_spacing', '', 'padding-bottom'  ) . ");
		}
	";

/* - Sticky Logo On Top Header
========================================================================= */
} else if ( 'top-bottom' == $header_group ) {
	$css .= "

	#grve-main-header.grve-sticky-header.grve-scrollup-sticky .grve-bottom-header-area {
		padding-top: " . impeka_grve_option( 'header_sticky_shrink_spacing', '', 'padding-top' ) . ";
		padding-bottom: " . impeka_grve_option( 'header_sticky_shrink_spacing', '', 'padding-bottom'  ) . ";
	}

	";
}


/* - Horizontal Menu Spacing
============================================================================= */
if ( is_rtl() ) {
	$css .= "
	.grve-horizontal-menu > .grve-menu > .grve-first-level + .grve-first-level {
		margin-right: " . impeka_grve_option( 'menu_item_space', 36 ) . "px;
	}
	";
} else {
	$css .= "
	.grve-horizontal-menu > .grve-menu > .grve-first-level + .grve-first-level {
		margin-left: " . impeka_grve_option( 'menu_item_space', 36 ) . "px;
	}
	";
}

/* - Header Colors
============================================================================= */
$impeka_grve_default_header_background_color = impeka_grve_option( 'default_header_background_color', '#ffffff' );
$impeka_grve_default_header_border_color = impeka_grve_option( 'default_header_border_color', '#000000' );
$css .= "

#grve-main-header {
	background-color: rgba(" . impeka_grve_hex2rgb( $impeka_grve_default_header_background_color ) . "," . impeka_grve_option( 'default_header_background_color_opacity', '1') . ");
}

#grve-main-header.grve-skin-light,
#grve-main-header.grve-skin-dark {
	background-color: transparent;
}

#grve-main-header.grve-border,
#grve-main-header .grve-border {
	border-color: rgba(" . impeka_grve_hex2rgb( $impeka_grve_default_header_border_color ) . "," . impeka_grve_option( 'default_header_border_color_opacity', '1') . ");
}


#grve-main-header .grve-logo-text a,
#grve-main-header .grve-horizontal-menu:not(.grve-menu-element) > .grve-menu > li > .grve-link-wrapper,
#grve-main-header .grve-horizontal-menu:not(.grve-menu-element) > .grve-menu > li > .grve-link-wrapper a,

#grve-main-header .grve-vertical-menu:not(.grve-menu-element) > .grve-menu > li > .grve-link-wrapper,
#grve-main-header .grve-vertical-menu:not(.grve-menu-element) > .grve-menu > li > .grve-link-wrapper a,
#grve-main-header .grve-vertical-menu:not(.grve-menu-element) .grve-sub-menu:not(.grve-area-item-sub-menu) .grve-link-wrapper,
#grve-main-header .grve-vertical-menu:not(.grve-menu-element) .grve-sub-menu:not(.grve-area-item-sub-menu) .grve-link-wrapper a,

#grve-main-header .grve-hidden-menu-icon,
#grve-main-header .grve-header-elements .grve-header-search,
#grve-main-header .grve-header-elements .grve-header-element > a,
#grve-main-header .grve-header-elements .grve-socials-elements a,
#grve-main-header .grve-header-elements .grve-header-text-element,
#grve-main-header .grve-header-elements .grve-language.grve-dropdown > li > a {
	color: " . impeka_grve_option( 'default_header_menu_text_color' ) . ";
}

#grve-main-header .grve-logo-text a:hover,
#grve-main-header .grve-horizontal-menu:not(.grve-menu-element) > .grve-menu > li:hover > .grve-link-wrapper a,
#grve-main-header .grve-horizontal-menu:not(.grve-menu-element) > .grve-menu > li.current-menu-item > .grve-link-wrapper a,
#grve-main-header .grve-horizontal-menu:not(.grve-menu-element) > .grve-menu > li.current-menu-ancestor > .grve-link-wrapper a,

#grve-main-header .grve-vertical-menu:not(.grve-menu-element) > .grve-menu > li > .grve-link-wrapper a:hover,
#grve-main-header .grve-vertical-menu:not(.grve-menu-element) > .grve-menu > li > .grve-link-wrapper .grve-arrow:hover,
#grve-main-header .grve-vertical-menu:not(.grve-menu-element) > .grve-menu > li.current-menu-item > .grve-link-wrapper a,
#grve-main-header .grve-vertical-menu:not(.grve-menu-element) .grve-sub-menu:not(.grve-area-item-sub-menu) .grve-link-wrapper a:hover,
#grve-main-header .grve-vertical-menu:not(.grve-menu-element) .grve-sub-menu:not(.grve-area-item-sub-menu) .grve-link-wrapper .grve-arrow:hover,

#grve-main-header .grve-header-elements .grve-header-element > a:not(.grve-btn):hover,
#grve-main-header .grve-header-elements .grve-socials-elements a:hover,
#grve-main-header .grve-hidden-menu-icon:hover,
#grve-main-header .grve-header-elements .grve-language.grve-dropdown > li > a:hover {
	color: " . impeka_grve_option( 'default_header_menu_text_hover_color' ) . ";
}

#grve-main-header.grve-menu-type-underline .grve-header-menu .grve-first-level > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-underline .grve-header-menu .grve-first-level.current-menu-item > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-underline .grve-header-menu .grve-first-level.current-menu-ancestor > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-underline-first-level .grve-header-menu .grve-first-level > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-underline-first-level .grve-header-menu .grve-first-level.current-menu-item > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-underline-first-level .grve-header-menu .grve-first-level.current-menu-ancestor > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-line-through .grve-header-menu .grve-first-level:hover > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-line-through .grve-header-menu .grve-first-level.current-menu-item > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-line-through .grve-header-menu .grve-first-level.current-menu-ancestor > .grve-link-wrapper a .grve-item:after {
	border-color: " . impeka_grve_option( 'default_header_menu_item_style_color' ) . ";
}

";

/* Light Header
============================================================================= */
$impeka_grve_light_header_border_color = impeka_grve_option( 'light_header_border_color', '#ffffff' );
$css .= "
#grve-main-header.grve-skin-light .grve-logo-text a,
#grve-main-header.grve-skin-light .grve-horizontal-menu:not(.grve-menu-element) > .grve-menu > li > .grve-link-wrapper,
#grve-main-header.grve-skin-light .grve-horizontal-menu:not(.grve-menu-element) > .grve-menu > li > .grve-link-wrapper a,
#grve-main-header.grve-skin-light .grve-hidden-menu-icon,
#grve-main-header.grve-skin-light .grve-header-elements .grve-header-search,
#grve-main-header.grve-skin-light .grve-header-elements .grve-header-element > a,
#grve-main-header.grve-skin-light .grve-header-elements .grve-socials-elements a,
#grve-main-header.grve-skin-light .grve-header-elements .grve-header-text-element,
#grve-main-header.grve-skin-light .grve-header-elements .grve-language.grve-dropdown > li > a {
	color: " . impeka_grve_option( 'light_menu_text_color' ) . ";
}

#grve-main-header.grve-skin-light .grve-logo-text a:hover,
#grve-main-header.grve-skin-light .grve-horizontal-menu:not(.grve-menu-element) > .grve-menu > li:hover > .grve-link-wrapper a,
#grve-main-header.grve-skin-light .grve-horizontal-menu:not(.grve-menu-element) > .grve-menu > li.current-menu-item > .grve-link-wrapper a,
#grve-main-header.grve-skin-light .grve-horizontal-menu:not(.grve-menu-element) > .grve-menu > li.current-menu-ancestor > .grve-link-wrapper a,
#grve-main-header.grve-skin-light .grve-header-elements .grve-header-element > a:not(.grve-btn):hover,
#grve-main-header.grve-skin-light .grve-header-elements .grve-socials-elements a:hover,
#grve-main-header.grve-skin-light .grve-hidden-menu-icon:hover,
#grve-main-header.grve-skin-light .grve-header-elements .grve-language.grve-dropdown > li > a:hover {
	color: " . impeka_grve_option( 'light_menu_text_hover_color' ) . ";
}

#grve-main-header.grve-skin-light.grve-border,
#grve-main-header.grve-skin-light .grve-border {
	border-color: rgba(" . impeka_grve_hex2rgb( $impeka_grve_light_header_border_color ) . "," . impeka_grve_option( 'light_header_border_color_opacity', '1') . ");
}

#grve-main-header.grve-menu-type-underline.grve-skin-light .grve-header-menu .grve-first-level > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-underline.grve-skin-light .grve-header-menu .grve-first-level.current-menu-item > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-underline.grve-skin-light .grve-header-menu .grve-first-level.current-menu-ancestor > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-underline-first-level.grve-skin-light .grve-header-menu .grve-first-level > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-underline-first-level.grve-skin-light .grve-header-menu .grve-first-level.current-menu-item > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-underline-first-level.grve-skin-light .grve-header-menu .grve-first-level.current-menu-ancestor > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-line-through.grve-skin-light .grve-header-menu .grve-first-level:hover > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-line-through.grve-skin-light .grve-header-menu .grve-first-level.current-menu-item > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-line-through.grve-skin-light .grve-header-menu .grve-first-level.current-menu-ancestor > .grve-link-wrapper a .grve-item:after {
	border-color: " . impeka_grve_option( 'light_menu_item_style_color' ) . ";
}

";

/* - Light Header Text
========================================================================= */
$css .= "

#grve-main-header.grve-skin-light .grve-header-text {
	color: " . impeka_grve_option( 'light_header_text_color' ) . ";
}

#grve-main-header.grve-skin-light .grve-header-text h1,
#grve-main-header.grve-skin-light .grve-header-text h2,
#grve-main-header.grve-skin-light .grve-header-text h3,
#grve-main-header.grve-skin-light .grve-header-text h4,
#grve-main-header.grve-skin-light .grve-header-text h5,
#grve-main-header.grve-skin-light .grve-header-text h6 {
	color: " . impeka_grve_option( 'light_header_headings_color' ) . ";
}

#grve-main-header.grve-skin-light .grve-header-text a {
	color: " . impeka_grve_option( 'light_header_link_color' ) . ";
}

#grve-main-header.grve-skin-light .grve-header-text a:hover {
	color: " . impeka_grve_option( 'light_header_link_hover_color' ) . ";
}

";

/* Dark Header
============================================================================= */
$impeka_grve_dark_header_border_color = impeka_grve_option( 'dark_header_border_color', '#ffffff' );
$css .= "

#grve-main-header.grve-skin-dark .grve-logo-text a,
#grve-main-header.grve-skin-dark .grve-horizontal-menu:not(.grve-menu-element) > .grve-menu > li > .grve-link-wrapper,
#grve-main-header.grve-skin-dark .grve-horizontal-menu:not(.grve-menu-element) > .grve-menu > li > .grve-link-wrapper a,
#grve-main-header.grve-skin-dark .grve-hidden-menu-icon,
#grve-main-header.grve-skin-dark .grve-header-elements .grve-header-search,
#grve-main-header.grve-skin-dark .grve-header-elements .grve-header-element > a,
#grve-main-header.grve-skin-dark .grve-header-elements .grve-socials-elements a,
#grve-main-header.grve-skin-dark .grve-header-elements .grve-header-text-element,
#grve-main-header.grve-skin-dark .grve-header-elements .grve-language.grve-dropdown > li > a {
	color: " . impeka_grve_option( 'dark_menu_text_color' ) . ";
}

#grve-main-header.grve-skin-dark .grve-logo-text a:hover,
#grve-main-header.grve-skin-dark .grve-horizontal-menu:not(.grve-menu-element) > .grve-menu > li:hover > .grve-link-wrapper a,
#grve-main-header.grve-skin-dark .grve-horizontal-menu:not(.grve-menu-element) > .grve-menu > li.current-menu-item > .grve-link-wrapper a,
#grve-main-header.grve-skin-dark .grve-horizontal-menu:not(.grve-menu-element) > .grve-menu > li.current-menu-ancestor > .grve-link-wrapper a,
#grve-main-header.grve-skin-dark .grve-header-elements .grve-header-element > a:not(.grve-btn):hover,
#grve-main-header.grve-skin-dark .grve-header-elements .grve-socials-elements a:hover,
#grve-main-header.grve-skin-dark .grve-hidden-menu-icon:hover,
#grve-main-header.grve-skin-dark .grve-header-elements .grve-language.grve-dropdown > li > a:hover {
	color: " . impeka_grve_option( 'dark_menu_text_hover_color' ) . ";
}

#grve-main-header.grve-skin-dark.grve-border,
#grve-main-header.grve-skin-dark .grve-border {
	border-color: rgba(" . impeka_grve_hex2rgb( $impeka_grve_dark_header_border_color ) . "," . impeka_grve_option( 'dark_header_border_color_opacity', '1') . ");
}

#grve-main-header.grve-menu-type-underline.grve-skin-dark .grve-header-menu .grve-first-level > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-underline.grve-skin-dark .grve-header-menu .grve-first-level.current-menu-item > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-underline.grve-skin-dark .grve-header-menu .grve-first-level.current-menu-ancestor > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-underline-first-level.grve-skin-dark .grve-header-menu .grve-first-level > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-underline-first-level.grve-skin-dark .grve-header-menu .grve-first-level.current-menu-item > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-underline-first-level.grve-skin-dark .grve-header-menu .grve-first-level.current-menu-ancestor > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-line-through.grve-skin-dark .grve-header-menu .grve-first-level:hover > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-line-through.grve-skin-dark .grve-header-menu .grve-first-level.current-menu-item > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-line-through.grve-skin-dark .grve-header-menu .grve-first-level.current-menu-ancestor > .grve-link-wrapper a .grve-item:after {
	border-color: " . impeka_grve_option( 'dark_menu_item_style_color' ) . ";
}

";

/* - Dark Header Text
========================================================================= */
$css .= "

#grve-main-header.grve-skin-dark .grve-header-text {
	color: " . impeka_grve_option( 'dark_header_text_color' ) . ";
}

#grve-main-header.grve-skin-dark .grve-header-text h1,
#grve-main-header.grve-skin-dark .grve-header-text h2,
#grve-main-header.grve-skin-dark .grve-header-text h3,
#grve-main-header.grve-skin-dark .grve-header-text h4,
#grve-main-header.grve-skin-dark .grve-header-text h5,
#grve-main-header.grve-skin-dark .grve-header-text h6 {
	color: " . impeka_grve_option( 'dark_header_headings_color' ) . ";
}

#grve-main-header.grve-skin-dark .grve-header-text a {
	color: " . impeka_grve_option( 'dark_header_link_color' ) . ";
}

#grve-main-header.grve-skin-dark .grve-header-text a:hover {
	color: " . impeka_grve_option( 'dark_header_link_hover_color' ) . ";
}

";

/* - Sticky Header Colors
========================================================================= */
$impeka_grve_header_sticky_border_color = impeka_grve_option( 'header_sticky_border_color', '#ffffff' );
$impeka_grve_header_sticky_background_color = impeka_grve_option( 'header_sticky_background_color', '#ffffff' );
$css .= "

#grve-main-header.grve-skin-sticky:not(.grve-layout-top-bottom),
#grve-main-header.grve-skin-sticky .grve-bottom-header-area {
	background-color: rgba(" . impeka_grve_hex2rgb( $impeka_grve_header_sticky_background_color ) . "," . impeka_grve_option( 'header_sticky_background_color_opacity', '1') . ");
}

#grve-header.grve-header-top-bottom.grve-skin-sticky #grve-main-header {
	background-color: transparent;
}

#grve-main-header.grve-skin-sticky .grve-logo-text a,
#grve-main-header.grve-skin-sticky .grve-horizontal-menu:not(.grve-menu-element) > .grve-menu > li > .grve-link-wrapper,
#grve-main-header.grve-skin-sticky .grve-horizontal-menu:not(.grve-menu-element) > .grve-menu > li > .grve-link-wrapper a,
#grve-main-header.grve-skin-sticky .grve-hidden-menu-icon,
#grve-main-header.grve-skin-sticky .grve-header-elements .grve-header-search,
#grve-main-header.grve-skin-sticky .grve-header-elements .grve-header-element > a,
#grve-main-header.grve-skin-sticky .grve-header-elements .grve-socials-elements a,
#grve-main-header.grve-skin-sticky .grve-header-elements .grve-header-text-element,
#grve-main-header.grve-skin-sticky .grve-header-elements .grve-language.grve-dropdown > li > a {
	color: " . impeka_grve_option( 'sticky_menu_text_color' ) . ";
}

#grve-main-header.grve-skin-sticky .grve-logo-text a:hover,
#grve-main-header.grve-skin-sticky .grve-horizontal-menu:not(.grve-menu-element) > .grve-menu > li:hover > .grve-link-wrapper a,
#grve-main-header.grve-skin-sticky .grve-horizontal-menu:not(.grve-menu-element) > .grve-menu > li.current-menu-item > .grve-link-wrapper a,
#grve-main-header.grve-skin-sticky .grve-horizontal-menu:not(.grve-menu-element) > .grve-menu > li.current-menu-ancestor > .grve-link-wrapper a,
#grve-main-header.grve-skin-sticky .grve-header-elements .grve-header-element > a:not(.grve-btn):hover,
#grve-main-header.grve-skin-sticky .grve-header-elements .grve-socials-elements a:hover,
#grve-main-header.grve-skin-sticky .grve-hidden-menu-icon:hover,
#grve-main-header.grve-skin-sticky .grve-header-elements .grve-language.grve-dropdown > li > a:hover {
	color: " . impeka_grve_option( 'sticky_menu_text_hover_color' ) . ";
}

#grve-main-header.grve-skin-sticky .grve-burger-icon span {
	background-color: " . impeka_grve_option( 'sticky_menu_text_color' ) . ";
}

#grve-main-header.grve-skin-sticky.grve-border,
#grve-main-header.grve-skin-sticky .grve-border {
	border-color: rgba(" . impeka_grve_hex2rgb( $impeka_grve_header_sticky_border_color ) . "," . impeka_grve_option( 'impeka_grve_header_sticky_border_color_opacity', '1') . ");
}

#grve-main-header.grve-menu-type-underline.grve-skin-sticky .grve-header-menu .grve-first-level > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-underline.grve-skin-sticky .grve-header-menu .grve-first-level.current-menu-item > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-underline.grve-skin-sticky .grve-header-menu .grve-first-level.current-menu-ancestor > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-underline-first-level.grve-skin-sticky .grve-header-menu .grve-first-level > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-underline-first-level.grve-skin-sticky .grve-header-menu .grve-first-level.current-menu-item > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-underline-first-level.grve-skin-sticky .grve-header-menu .grve-first-level.current-menu-ancestor > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-line-through.grve-skin-sticky .grve-header-menu .grve-first-level:hover > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-line-through.grve-skin-sticky .grve-header-menu .grve-first-level.current-menu-item > .grve-link-wrapper a .grve-item:after,
#grve-main-header.grve-menu-type-line-through.grve-skin-sticky .grve-header-menu .grve-first-level.current-menu-ancestor > .grve-link-wrapper a .grve-item:after {
	border-color: " . impeka_grve_option( 'header_sticky_menu_item_style_color' ) . ";
}

";

/* - Header Sub Menu Colors
========================================================================= */
$css .= "
.grve-header-menu.grve-horizontal-menu .grve-first-level:not(.megamenu):not(.grve-menu-area-item) .grve-classic-sub-menu,
.grve-header-menu.grve-horizontal-menu .grve-megamenu-sub-menu,
.grve-header-menu.grve-horizontal-menu .grve-area-item-sub-menu,
#grve-main-header .grve-language.grve-dropdown ul {
	background-color: " . impeka_grve_option( 'default_header_submenu_bg_color' ) . ";
}

.grve-header-menu.grve-horizontal-menu .grve-first-level:not(.megamenu):not(.grve-menu-area-item) li,
.grve-header-menu.grve-horizontal-menu .grve-first-level:not(.megamenu):not(.grve-menu-area-item) li a,
.grve-header-menu.grve-horizontal-menu .grve-megamenu-sub-menu li,
.grve-header-menu.grve-horizontal-menu .grve-megamenu-sub-menu li a,
#grve-main-header .grve-language.grve-dropdown ul li a {
	color: " . impeka_grve_option( 'default_header_submenu_text_color' ) . ";
}

.grve-header-menu.grve-horizontal-menu .grve-first-level:not(.megamenu):not(.grve-menu-area-item) li a:hover,
.grve-header-menu.grve-horizontal-menu .grve-first-level:not(.megamenu):not(.grve-menu-area-item) li.current-menu-item > .grve-link-wrapper a,
.grve-header-menu.grve-horizontal-menu .grve-first-level:not(.megamenu):not(.grve-menu-area-item) li.grve-menu-hover > .grve-link-wrapper a,
.grve-header-menu.grve-horizontal-menu .grve-megamenu-sub-menu li a:hover,
#grve-main-header .grve-language.grve-dropdown ul li a:hover {
	color: " . impeka_grve_option( 'default_header_submenu_text_hover_color' ) . ";
}

.grve-header-menu.grve-horizontal-menu .grve-megamenu-sub-menu .sub-menu > li.menu-item-has-children > .grve-link-wrapper > a {
	color: " . impeka_grve_option( 'default_header_submenu_column_text_color' ) . ";
}

.grve-header-menu.grve-horizontal-menu .grve-megamenu-sub-menu .sub-menu > li.menu-item-has-children:hover > .grve-link-wrapper > a {
	color: " . impeka_grve_option( 'default_header_submenu_column_text_hover_color' ) . ";
}

.grve-header-menu.grve-horizontal-menu > .grve-menu .grve-megamenu-sub-menu .sub-menu > li {
	border-color: " . impeka_grve_option( 'default_header_submenu_border_color' ) . ";
}

#grve-main-header.grve-layout-default.grve-megamenu-change-header-skin.grve-skin-changed {
	background-color: " . impeka_grve_option( 'default_header_submenu_bg_color' ) . ";
}

";

/* Menu Label
============================================================================= */
$css .= "

.grve-header-menu .grve-label.grve-bg-default {
	background-color: " . impeka_grve_option( 'default_header_label_bg_color' ) . ";
	color: " . impeka_grve_option( 'default_header_label_text_color' ) . ";
	border-top-color: " . impeka_grve_option( 'default_header_label_bg_color' ) . ";
}

";

/* Off Canvas Menu
============================================================================= */
$impeka_grve_offcanvas_bg_mode = impeka_grve_option( 'offcanvas_menu_bg_mode', 'color' );
$impeka_grve_offcanvas_menu_background_image = impeka_grve_option( 'offcanvas_menu_background_image', array() );
$impeka_grve_offcanvas_menu_background_color = impeka_grve_option( 'offcanvas_menu_background_color' );

if ( 'custom' == $impeka_grve_offcanvas_bg_mode ) {
$css .= "
	#grve-offcanvas-area .grve-area-inner {
		" . impeka_grve_get_background_css( $impeka_grve_offcanvas_menu_background_image ) . "
		color: " . impeka_grve_option( 'offcanvas_text_color' ) . ";
	}
";
} else {
$css .= "
	#grve-offcanvas-area .grve-area-inner {
		background-color: rgba(" . impeka_grve_hex2rgb( $impeka_grve_offcanvas_menu_background_color ) . "," . impeka_grve_option( 'offcanvas_menu_background_color_opacity', '1') . ");
		color: " . impeka_grve_option( 'offcanvas_text_color' ) . ";
	}
";
}


$css .= "
#grve-offcanvas-area.grve-offcanvas-custom-width {
	max-width: " . impeka_grve_option( 'offcanvas_custom_width' ) . "px;
}

#grve-offcanvas-area .grve-area-bottom a {
	color: " . impeka_grve_option( 'offcanvas_text_color' ) . ";
}

#grve-offcanvas-area .grve-area-bottom a:hover{
	color: " . impeka_grve_option( 'offcanvas_menu_link_hover_color' ) . ";
}

#grve-offcanvas-area .grve-vertical-menu:not(.grve-menu-element) > .grve-menu > li > .grve-link-wrapper,
#grve-offcanvas-area .grve-vertical-menu:not(.grve-menu-element) .grve-sub-menu .grve-go-back,
#grve-offcanvas-area .grve-vertical-menu:not(.grve-menu-element) > .grve-menu > li > .grve-link-wrapper a,
#grve-offcanvas-area .grve-vertical-menu:not(.grve-menu-element) .grve-sub-menu:not(.grve-area-item-sub-menu) .grve-link-wrapper,
#grve-offcanvas-area .grve-vertical-menu:not(.grve-menu-element) .grve-sub-menu:not(.grve-area-item-sub-menu) .grve-link-wrapper a {
	color: " . impeka_grve_option( 'offcanvas_menu_link_color' ) . ";
}

#grve-offcanvas-area .grve-vertical-menu:not(.grve-menu-element) > .grve-menu > li > .grve-link-wrapper a:hover,
#grve-offcanvas-area .grve-vertical-menu:not(.grve-menu-element) .grve-sub-menu .grve-go-back:hover,
#grve-offcanvas-area .grve-vertical-menu:not(.grve-menu-element) > .grve-menu > li > .grve-link-wrapper .grve-arrow:hover,
#grve-offcanvas-area .grve-vertical-menu:not(.grve-menu-element) .grve-sub-menu:not(.grve-area-item-sub-menu) .grve-link-wrapper a:hover,
#grve-offcanvas-area .grve-vertical-menu:not(.grve-menu-element) .grve-sub-menu:not(.grve-area-item-sub-menu) .grve-link-wrapper .grve-arrow:hover {
	color: " . impeka_grve_option( 'offcanvas_menu_link_hover_color' ) . ";
}

#grve-offcanvas-area.grve-menu-type-underline .grve-header-menu li .grve-link-wrapper a .grve-item:after,
#grve-offcanvas-area.grve-menu-type-line-through .grve-header-menu li .grve-link-wrapper a .grve-item:after {
	border-color: " . impeka_grve_option( 'offcanvas_menu_item_style_color' ) . ";
}

#grve-offcanvas-area .grve-area-content {
	flex-basis: " . impeka_grve_option( 'offcanvas_content_width' ) . "px;
	max-width: " . impeka_grve_option( 'offcanvas_content_width' ) . "px;
}

#grve-offcanvas-area .grve-vertical-menu li.menu-item + li.menu-item,
#grve-offcanvas-area .grve-vertical-menu .grve-go-back-wrapper + *,
#grve-offcanvas-area .grve-vertical-menu.grve-toggle-animation li .grve-sub-menu,
#grve-offcanvas-area .grve-vertical-menu.grve-accordion-animation li .grve-sub-menu {
	margin-top: " . impeka_grve_option( 'menu_item_space', 36 ) . "px;
}

#grve-offcanvas-area .grve-offcanvas-logo a {
	height: " . impeka_grve_option( 'logo_height', 30 ) . "px;
}

";

/* Off Canvas Menu Style 3
============================================================================= */
$css .= "

@media only screen and (max-width: " . esc_attr( $impeka_grve_responsive_header_threshold - 1 ) . "px) {
	.grve-offcanvas-icon-wrapper.grve-fixed {
		display: none;
	}
}

";

/* Side Area Colors
============================================================================= */
$impeka_grve_side_area_overflow_background_color = impeka_grve_option( 'side_area_overflow_background_color', '#000000' );
$css .= "
#grve-side-area .grve-area-inner {
	background-color: " . impeka_grve_option( 'side_area_background_color' ) . ";
	color: " . impeka_grve_option( 'side_area_text_color' ) . ";
}

#grve-side-area .grve-hidden-area-overlay {
	background-color: rgba(" . impeka_grve_hex2rgb( $impeka_grve_side_area_overflow_background_color ) . "," . impeka_grve_option( 'side_area_overflow_background_color_opacity', '0.9') . ");
}

#grve-side-area .widget,
#grve-side-area form,
#grve-side-area form p,
#grve-side-area form div,
#grve-side-area form span {
	color: " . impeka_grve_option( 'side_area_text_color' ) . ";
}

#grve-side-area h1,
#grve-side-area h2,
#grve-side-area h3,
#grve-side-area h4,
#grve-side-area h5,
#grve-side-area h6,
#grve-side-area .widget .grve-widget-title {
	color: " . impeka_grve_option( 'side_area_title_color' ) . ";
}

#grve-side-area a {
	color: " . impeka_grve_option( 'side_area_link_color' ) . ";
}

#grve-side-area .widget li a .grve-arrow:after,
#grve-side-area .widget li a .grve-arrow:before {
	color: " . impeka_grve_option( 'side_area_link_color' ) . ";
}

#grve-side-area a:hover {
	color: " . impeka_grve_option( 'side_area_link_hover_color' ) . ";
}

#grve-side-area .grve-border,
#grve-side-area form,
#grve-side-area form p,
#grve-side-area form div,
#grve-side-area form span,
#grve-side-area .widget a,
#grve-side-area .widget ul,
#grve-side-area .widget li,
#grve-side-area .widget table,
#grve-side-area .widget table td,
#grve-side-area .widget table th,
#grve-side-area .widget table tr,
#grve-side-area table,
#grve-side-area tr,
#grve-side-area td,
#grve-side-area th,
#grve-side-area .widget,
#grve-side-area .widget ul,
#grve-side-area .widget li,
#grve-side-area .widget div,
#grve-theme-wrapper #grve-side-area form,
#grve-theme-wrapper #grve-side-area .wpcf7-form-control-wrap {
	border-color: " . impeka_grve_option( 'side_area_border_color' ) . ";
}
";

/* Sliding Modals Colors
============================================================================= */

$css .= "
#grve-sliding-area {
	color: " . impeka_grve_option( 'sliding_modals_text_color' ) . ";
	background-color: " . impeka_grve_option( 'sliding_modals_background_color', '#000000' ) . ";
}

#grve-sliding-area a,
#grve-sliding-area .grve-search-item .grve-search-btn {
	color: " . impeka_grve_option( 'sliding_modals_text_color' ) . ";
}

#grve-sliding-area .grve-heading-color {
	color: " . impeka_grve_option( 'sliding_modals_title_color' ) . ";
}

#grve-sliding-area .grve-border,
#grve-theme-wrapper #grve-sliding-area .wpcf7-form-control-wrap,
#grve-sliding-area form {
	border-color: " . impeka_grve_option( 'sliding_modals_border_color' ) . ";
}

";

/* Modals Colors
============================================================================= */
$impeka_grve_modal_overflow_background_color = impeka_grve_option( 'modal_overflow_background_color', '#000000' );
$css .= "

#grve-modal-area .grve-modal-overlay {
	background-color: rgba(" . impeka_grve_hex2rgb( $impeka_grve_modal_overflow_background_color ) . "," . impeka_grve_option( 'modal_overflow_background_color_opacity', '0.9') . ");
}

";

/* Safe Button Area
============================================================================= */
$css .="
#grve-safebutton-area {
	background-color: " . impeka_grve_option( 'safebutton_background_color' ) . ";
}

#grve-safebutton-overlay {
	background-color: " . impeka_grve_option( 'safebutton_overflow_background_color' ) . ";
}

";

/* Media Popup Colors
============================================================================= */
$impeka_grve_media_popup_overflow_background_color = impeka_grve_option( 'media_popup_overflow_background_color' );

$css .= "
.pswp__bg,
.mfp-bg.grve-media-popup,
.lg-backdrop {
	background-color: rgba(" . impeka_grve_hex2rgb( $impeka_grve_media_popup_overflow_background_color ) . "," . impeka_grve_option( 'media_popup_overflow_background_color_opacity', '1') . ");
}

";

$impeka_grve_media_popup_navigation_color = impeka_grve_option( 'media_popup_navigation_color', 'white' );
if ( 'black' == $impeka_grve_media_popup_navigation_color ) {
	$css .= "
	.pswp__counter,
	.pswp__button,
	.grve-media-popup .grve-close-modal {
		color: #000000;
	}
	";
} else {
	$css .= "
	.pswp__counter,
	.pswp__button,
	.grve-media-popup .grve-close-modal {
		color: #ffffff;
	}
	";
}

/* Quick View Colors
============================================================================= */
$css .= "

#grve-quick-view-wrapper,
#grve-quick-view-wrapper .grve-mask {
	background-color: " . impeka_grve_option( 'quick_view_background_color' ) . ";
}

#grve-quick-view-wrapper .grve-quick-view-modal .grve-title {
	color: " . impeka_grve_option( 'quick_view_title_color' ) . ";
}

#grve-quick-view-wrapper .grve-quick-view-modal {
	color: " . impeka_grve_option( 'quick_view_text_color' ) . ";
}

";

/* Responsive Header
============================================================================= */
$impeka_grve_responsive_header_background_color = impeka_grve_option( 'responsive_header_background_color', '#000000' );
$css .= "
#grve-main-responsive-header {
	background-color: rgba(" . impeka_grve_hex2rgb( $impeka_grve_responsive_header_background_color ) . "," . impeka_grve_option( 'responsive_header_background_opacity', '1') . ");
}

";
	/* - Header Layout
	========================================================================= */
	$css .= "
	#grve-main-responsive-header {
		padding-top: " . impeka_grve_option( 'responsive_header_spacing', '', 'padding-top' ) . ";
		padding-bottom: " . impeka_grve_option( 'responsive_header_spacing', '', 'padding-bottom'  ) . ";
	}

	#grve-main-responsive-header .grve-logo a {
		height: " . impeka_grve_option( 'responsive_logo_height' ) . "px;
	}

	#grve-responsive-header .grve-logo .grve-wrapper img {
		padding-top: 0;
		padding-bottom: 0;
	}
	";

	/* - Responsive Header / Responsive Menu
	========================================================================= */
	$css .= "

	@media only screen and (max-width: " . esc_attr( $impeka_grve_responsive_header_threshold - 1 ) . "px) {
		#grve-main-header {
			display: none;
		}

		#grve-main-responsive-header {
			display: block;
		}

		.grve-header-responsive-elements {
			display: block;
		}

		#grve-logo.grve-position-center,
		#grve-logo.grve-position-center .grve-wrapper {
			position: relative;
			left: 0;
		}

		#grve-responsive-menu-wrapper {
			display: block;
		}
	}
	";

	/* - Responsive Menu
	========================================================================= */
	$impeka_menu_responsive_bg_mode = impeka_grve_option( 'menu_responsive_bg_mode', 'color' );
	$impeka_grve_responsive_menu_background = impeka_grve_option( 'menu_responsive_background', array() );

	if ( 'custom' == $impeka_menu_responsive_bg_mode ) {
	$css .= "
	#grve-responsive-menu-area .grve-area-inner {
		" . impeka_grve_get_background_css( $impeka_grve_responsive_menu_background ) . "
		color: " . impeka_grve_option( 'responsive_menu_text_color' ) . ";
	}
	";
	} else {
	$css .= "
	#grve-responsive-menu-area .grve-area-inner {
		background-color: " . impeka_grve_option( 'responsive_menu_bg_color' ) . ";
		color: " . impeka_grve_option( 'responsive_menu_text_color' ) . ";
	}
	";
	}

	$css .= "
	#grve-responsive-menu-area .grve-area-bottom h1,
	#grve-responsive-menu-area .grve-area-bottom h2,
	#grve-responsive-menu-area .grve-area-bottom h3,
	#grve-responsive-menu-area .grve-area-bottom h4,
	#grve-responsive-menu-area .grve-area-bottom h5,
	#grve-responsive-menu-area .grve-area-bottom h6,
	#grve-responsive-menu-area .grve-area-bottom .grve-heading-color {
		color: " . impeka_grve_option( 'responsive_menu_headings_color' ) . ";
	}
	";
	if ( 'custom' == $impeka_menu_responsive_bg_mode && 'fixed' == impeka_grve_array_value( $impeka_grve_responsive_menu_background, 'background-attachment' ) ) {
		$impeka_grve_responsive_menu_background['background-attachment'] = 'scroll';
		$css .= "
			#grve-responsive-menu-area .grve-area-inner {
				clip: rect(auto auto auto auto);
			}
			#grve-responsive-menu-area:before .grve-area-inner {
				" . impeka_grve_get_background_css( $impeka_grve_responsive_menu_background ) . "
				content: '';
				position:fixed;
				top:0;
				width:100vw;
				height:100vh;
				left:0;
				right:0;
				z-index:-1;
			}
		";
	}

	$css .= "
	#grve-responsive-menu-area .grve-area-top > .grve-vertical-menu-wrapper > .grve-vertical-menu > .grve-menu > li > .grve-link-wrapper a,
	#grve-responsive-menu-area .grve-area-top > .grve-vertical-menu-wrapper > .grve-vertical-menu > .grve-menu > li .grve-sub-menu:not(.grve-area-item-sub-menu) a,
	#grve-responsive-menu-area .grve-area-bottom a:not(.grve-btn),
	#grve-responsive-menu-area .grve-go-back,
	#grve-responsive-menu-area .grve-search-btn {
		color: " . impeka_grve_option( 'responsive_menu_link_color' ) . ";
	}

	#grve-theme-wrapper .grve-header-responsive-elements form,
	#grve-theme-wrapper .grve-header-responsive-elements form p,
	#grve-theme-wrapper .grve-header-responsive-elements form div,
	#grve-theme-wrapper .grve-header-responsive-elements form span {
		color: " . impeka_grve_option( 'responsive_menu_link_color' ) . ";
	}

	#grve-responsive-menu-area .grve-area-top > .grve-vertical-menu-wrapper > .grve-vertical-menu > .grve-menu > li > .grve-link-wrapper a:hover,
	#grve-responsive-menu-area .grve-area-top > .grve-vertical-menu-wrapper > .grve-vertical-menu > .grve-menu > li .grve-sub-menu:not(.grve-area-item-sub-menu) a:hover,
	#grve-responsive-menu-area .grve-area-bottom a:not(.grve-btn):hover,
	#grve-responsive-menu-area .grve-search-btn:hover,
	#grve-responsive-main-menu ul.grve-menu li.current-menu-item > .grve-link-wrapper a {
		color: " . impeka_grve_option( 'responsive_menu_link_hover_color' ) . ";
	}

	#grve-theme-wrapper .grve-header-responsive-elements form,
	#grve-theme-wrapper .grve-header-responsive-elements form p,
	#grve-theme-wrapper .grve-header-responsive-elements form div,
	#grve-theme-wrapper .grve-header-responsive-elements form span {
		border-color: " . impeka_grve_option( 'responsive_menu_border_color' ) . ";
	}

	#grve-responsive-main-menu .grve-arrow {
		color: " . impeka_grve_option( 'responsive_menu_link_color' ) . ";
	}

	#grve-responsive-menu-area .grve-go-back .grve-arrow,
	#grve-responsive-main-menu .grve-arrow:hover {
		color: " . impeka_grve_option( 'responsive_menu_link_hover_color' ) . ";
	}

	#grve-responsive-menu-area .grve-vertical-menu li.menu-item + li.menu-item,
	#grve-responsive-menu-area .grve-vertical-menu .grve-go-back-wrapper + *,
	#grve-responsive-menu-area .grve-vertical-menu.grve-toggle-animation li .grve-sub-menu,
	#grve-responsive-menu-area .grve-vertical-menu.grve-accordion-animation li .grve-sub-menu {
		margin-top: " . impeka_grve_option( 'responsive_menu_item_space', 36 ) . "px;
	}

	";

	/* - Responsive Header Elements
	========================================================================= */
	$css .= "
	#grve-main-responsive-header .grve-logo-text a,
	#grve-main-responsive-header .grve-header-elements,
	#grve-main-responsive-header .grve-hidden-menu-icon,
	#grve-main-responsive-header .grve-header-elements .grve-header-element > a:not(.grve-btn),
	#grve-main-responsive-header .grve-header-elements .grve-purchased-items {
		color: " . impeka_grve_option( 'responsive_header_elements_color' ) . ";
	}

	#grve-main-responsive-header .grve-logo-text a:hover,
	#grve-main-responsive-header .grve-header-elements .grve-header-element > a:not(.grve-btn):hover {
		color: " . impeka_grve_option( 'responsive_header_elements_hover_color' ) . ";
	}

	#grve-responsive-header .grve-hidden-menu-btn a .grve-item:not(.grve-with-text) span {
		background-color: " . impeka_grve_option( 'responsive_header_elements_color' ) . ";
	}
	";


/* Intro Homepage
============================================================================= */
$css .= "

#grve-intro {
	color: " . impeka_grve_option( 'intro_title_color' ) . ";
	background-color: " . impeka_grve_option( 'intro_background_color' ) . ";
}
#grve-intro .grve-intro-graphic img {
	width: auto;
	height: " . impeka_grve_option( 'intro_image_height', 30 ) . "px;
}

";

/* Page Transitions
============================================================================= */
$css .= "
#grve-loader-overflow {
	background-color: " . impeka_grve_option( 'page_transitions_bg_color' ) . ";
}
";

$spinner_icon = impeka_grve_option( 'spinner_icon', 'spinner-1' );
$spinner_image_id = impeka_grve_option( 'spinner_image', '', 'id' );
if ( 'spinner-custom' == $spinner_icon && !empty( $spinner_image_id ) ) {
	$spinner_src = wp_get_attachment_image_src( $spinner_image_id, 'full' );
	$spinner_image_url = $spinner_src[0];
	$spinner_width = $spinner_src[1]/2;
	$spinner_height = $spinner_src[2]/2;

	$css .= "

	.grve-spinner.grve-spinner-custom {
		width: " . intval( $spinner_width ) . "px;
		height: " . intval( $spinner_height ) . "px;
		background-image: url(" . esc_url( $spinner_image_url ) . ");
	}

	";
}

$css .= "
.grve-spinner-1 {
	border-color: rgba(" . impeka_grve_hex2rgb( impeka_grve_option( 'page_transitions_spinner_color' ) ) . ",0.2);
	border-left-color: " . impeka_grve_option( 'page_transitions_spinner_color' ) . ";
}

.grve-spinner-2 {
	border-color: " . impeka_grve_option( 'page_transitions_spinner_color' ) . ";
}

.grve-spinner-2:before,
.grve-spinner-2:after {
	background-color: " . impeka_grve_option( 'page_transitions_bg_color' ) . ";
}

";


/* Anchor Menu
============================================================================= */

// Anchor Colors
$css .= "

.grve-anchor-menu .grve-anchor-wrapper,
.grve-anchor-menu .grve-container ul {
	background-color: " . impeka_grve_option( 'page_anchor_menu_background_color' ) . ";
}

.grve-anchor-menu .grve-anchor-wrapper {
	border-color: " . impeka_grve_option( 'page_anchor_menu_border_color' ) . ";
}

.grve-anchor-menu li a,
.grve-anchor-menu li:last-child a,
.grve-anchor-responsive.grve-anchor-menu .grve-container > ul > li > a {
	color: " . impeka_grve_option( 'page_anchor_menu_text_color' ) . ";
	background-color: transparent;
	border-color: " . impeka_grve_option( 'page_anchor_menu_border_color' ) . ";
}

.grve-anchor-menu li a:hover,
.grve-anchor-menu li:last-child a:hover,
.grve-anchor-responsive.grve-anchor-menu .grve-container > ul > li > a:hover {
	color: " . impeka_grve_option( 'page_anchor_menu_text_hover_color' ) . ";
	background-color: " . impeka_grve_option( 'page_anchor_menu_background_hover_color' ) . ";
	border-color: " . impeka_grve_option( 'page_anchor_menu_border_color' ) . ";
}

.grve-anchor-menu a .grve-arrow:after,
.grve-anchor-menu a .grve-arrow:before {
	background-color: " . impeka_grve_option( 'page_anchor_menu_text_hover_color' ) . ";
}

.grve-anchor-dropdown-wrapper {
	color: " . impeka_grve_option( 'page_anchor_menu_text_color' ) . ";
}
";

// Page Anchor Size
$css .= "

#grve-page-anchor {
	height: " . intval( impeka_grve_option( 'page_anchor_menu_height', 120 ) + 2 ) . "px;
}

#grve-page-anchor .grve-anchor-wrapper {
	line-height: " . impeka_grve_option( 'page_anchor_menu_height' ) . "px;
}

#grve-page-anchor .grve-anchor-dropdown {
	height: " . impeka_grve_option( 'page_anchor_menu_height' ) . "px;
}

";

// Post Anchor Size
$css .= "

#grve-post-anchor {
	height: " . intval( impeka_grve_option( 'post_anchor_menu_height', 120 ) + 2 ) . "px;
}

#grve-post-anchor .grve-anchor-wrapper {
	line-height: " . impeka_grve_option( 'post_anchor_menu_height' ) . "px;
}

#grve-post-anchor .grve-anchor-dropdown {
	height: " . impeka_grve_option( 'post_anchor_menu_height' ) . "px;
}

";

// Portfolio Anchor Size
$css .= "

#grve-portfolio-anchor {
	height: " . intval( impeka_grve_option( 'portfolio_anchor_menu_height', 120 ) + 2 ) . "px;
}

#grve-portfolio-anchor .grve-anchor-wrapper {
	line-height: " . impeka_grve_option( 'portfolio_anchor_menu_height' ) . "px;
}

#grve-portfolio-anchor .grve-anchor-dropdown {
	height: " . impeka_grve_option( 'portfolio_anchor_menu_height' ) . "px;
}
";


/* Breadcrumbs
============================================================================= */
$css .= "
.grve-breadcrumbs {
	background-color: " . impeka_grve_option( 'page_breadcrumbs_background_color' ) . ";
	border-color: " . impeka_grve_option( 'page_breadcrumbs_border_color' ) . ";
}

.grve-breadcrumbs ul li,
.grve-yoast-breadcrumbs span span {
	color: " . impeka_grve_option( 'page_breadcrumbs_divider_color' ) . ";
}

.grve-breadcrumbs ul li a,
.grve-yoast-breadcrumbs span span a {
	color: " . impeka_grve_option( 'page_breadcrumbs_text_color' ) . ";
}

.grve-breadcrumbs ul li a:hover,
.grve-yoast-breadcrumbs span span a:hover{
	color: " . impeka_grve_option( 'page_breadcrumbs_text_hover_color' ) . ";
}

";

// Page Breadcrumbs Size
$css .= "

#grve-page-breadcrumbs ul,
#grve-page-breadcrumbs .grve-yoast-breadcrumbs > span{
	height: " . impeka_grve_option( 'page_breadcrumbs_height' ) . "px;
}

";

// Post Breadcrumbs Size
$css .= "

#grve-post-breadcrumbs ul,
#grve-post-breadcrumbs .grve-yoast-breadcrumbs > span {
	height: " . impeka_grve_option( 'post_breadcrumbs_height' ) . "px;
}

";

// Portfolio Breadcrumbs Size
$css .= "

#grve-portfolio-breadcrumbs ul,
#grve-portfolio-breadcrumbs .grve-yoast-breadcrumbs > span {
	height: " . impeka_grve_option( 'portfolio_breadcrumbs_height' ) . "px;
}

";

// Product Breadcrumbs Size
$css .= "

#grve-product-breadcrumbs ul,
#grve-product-breadcrumbs .grve-yoast-breadcrumbs > span {
	height: " . impeka_grve_option( 'product_breadcrumbs_height' ) . "px;
}

";


	/* - Main Content Borders
	========================================================================= */
	$css .= "
	.grve-border,
	a.grve-border,
	#grve-content table,
	#grve-content tr,
	#grve-content td,
	#grve-content th,
	#grve-theme-wrapper form,
	#grve-theme-wrapper form p,
	#grve-theme-wrapper .wpcf7-form-control-wrap,
	#grve-theme-wrapper .wpcf7-list-item,
	#grve-content form div,
	.mfp-content form div,
	hr,
	.grve-hr.grve-element div,
	.grve-title-double-line span:before,
	.grve-title-double-line span:after,
	.grve-title-double-bottom-line span:after,
	.vc_tta.vc_general .vc_tta-panel-title,
	#grve-single-post-tags .grve-tags li a {
		border-color: " . impeka_grve_option( 'body_border_color' ) . ";
	}

	";

	/* Primary Border */
	$css .= "
	#grve-content .grve-blog-large .grve-blog-item.sticky ul.grve-post-meta,
	.grve-carousel-pagination-2 .grve-carousel .owl-controls .owl-page.active span,
	.grve-carousel-pagination-2 .grve-carousel .owl-controls.clickable .owl-page:hover span,
	.grve-carousel-pagination-2.grve-testimonial .owl-controls .owl-page.active span,
	.grve-carousel-pagination-2.grve-testimonial .owl-controls.clickable .owl-page:hover span,
	.grve-carousel-pagination-2 .grve-flexible-carousel .owl-controls .owl-page.active span,
	.grve-carousel-pagination-2 .grve-flexible-carousel .owl-controls.clickable .owl-page:hover span,
	#grve-content .grve-read-more:after,
	#grve-content .more-link:after,
	.grve-blog-large .grve-blog-item.sticky .grve-blog-item-inner:after,
	.grve-quote-text,
	blockquote {
		border-color: " . impeka_grve_option( 'body_primary_1_color' ) . ";
	}
	";

	/* - Widget Colors
	========================================================================= */
	$css .= "

	.widget,
	.widget ul,
	.widget li,
	.widget div {
		border-color: " . impeka_grve_option( 'body_border_color' ) . ";
	}

	.grve-widget.grve-social li a.grve-outline:hover {
		border-color: " . impeka_grve_option( 'body_primary_1_color' ) . ";
	}

	.widget:not(.grve-social) a:not(.grve-outline):not(.grve-btn):hover,
	.widget.widget_nav_menu li.open > a {
		color: " . impeka_grve_option( 'body_primary_1_color' ) . ";
	}
	";



/* Post Navigation Bar
============================================================================= */
$css .= "
#grve-post-bar.grve-layout-1 {
	color: " . impeka_grve_option( 'post_bar_nav_text_color' ) . ";
	background-color: " . impeka_grve_option( 'post_bar_background_color' ) . ";
	padding-top: " . impeka_grve_option( 'post_nav_spacing', '', 'padding-top' ) . ";
	padding-bottom: " . impeka_grve_option( 'post_nav_spacing', '', 'padding-bottom'  ) . ";
}

#grve-post-bar.grve-layout-3 {
	color: " . impeka_grve_option( 'post_bar_nav_text_color' ) . ";
	padding-top: " . impeka_grve_option( 'post_nav_spacing', '', 'padding-top' ) . ";
	padding-bottom: " . impeka_grve_option( 'post_nav_spacing', '', 'padding-bottom'  ) . ";
	background-color: " . impeka_grve_option( 'post_bar_background_color' ) . ";
}

";

/* Portfolio Navigation Bar
============================================================================= */
$css .= "
#grve-portfolio-bar.grve-layout-1 {
	color: " . impeka_grve_option( 'portfolio_bar_nav_text_color' ) . ";
	background-color: " . impeka_grve_option( 'portfolio_bar_background_color' ) . ";
	padding-top: " . impeka_grve_option( 'portfolio_nav_spacing', '', 'padding-top' ) . ";
	padding-bottom: " . impeka_grve_option( 'portfolio_nav_spacing', '', 'padding-bottom'  ) . ";
}

#grve-portfolio-bar.grve-layout-3 {
	color: " . impeka_grve_option( 'portfolio_bar_nav_text_color' ) . ";
	padding-top: " . impeka_grve_option( 'portfolio_nav_spacing', '', 'padding-top' ) . ";
	padding-bottom: " . impeka_grve_option( 'portfolio_nav_spacing', '', 'padding-bottom'  ) . ";
	background-color: " . impeka_grve_option( 'portfolio_bar_background_color' ) . ";
}

";

/* Primary Text Color
============================================================================= */
$css .= "
::-moz-selection {
    color: #ffffff;
    background: " . impeka_grve_option( 'body_primary_1_color' ) . ";
}

::selection {
    color: #ffffff;
    background: " . impeka_grve_option( 'body_primary_1_color' ) . ";
}
";

$css .= "

.grve-blog ul.grve-post-meta a:hover {
	color: " . impeka_grve_option( 'body_primary_1_color' ) . ";
}

";


function impeka_grve_print_css_colors() {

	$css = '';

	$impeka_grve_colors = impeka_grve_get_color_array();
	foreach ( $impeka_grve_colors as $key => $value ) {

		$font_color = '#ffffff';
		if( 'white' == $key || 'light' == $key ) {
			$font_color = '#000000';
		}

		if( 'grey' == $key || 'light-grey' == $key ) {
			$font_color = '#7b7b7b';
		}

		// Background Color
		$css .= "
			.grve-bg-" . esc_attr( $key ) . ",
			#grve-theme-wrapper .grve-bg-" . esc_attr( $key ) . ",
			#grve-theme-wrapper .grve-bg-hover-" . esc_attr( $key ) . ":hover,
			#grve-theme-wrapper a.grve-bg-hover-" . esc_attr( $key ) . ":hover,
			#grve-theme-wrapper a .grve-bg-hover-" . esc_attr( $key ) . ":hover,
			#grve-theme-wrapper a:hover .grve-bg-hover-" . esc_attr( $key ) . " {
				background-color: " . esc_attr( $value ) . ";
			}
			.grve-filter.grve-filter-style-button.grve-filter-color-" . esc_attr( $key ) . " ul li.selected,
			#grve-theme-wrapper .grve-contact-form.grve-form-btn-bg-" . esc_attr( $key ) . " input[type='submit']:not(.grve-custom-btn),
			#grve-theme-wrapper .grve-contact-form.grve-form-btn-bg-hover-" . esc_attr( $key ) . " input[type='submit']:not(.grve-custom-btn):hover,
			#grve-theme-wrapper .grve-contact-form.grve-form-btn-bg-" . esc_attr( $key ) . " input:checked + .wpcf7-list-item-label:after {
				background-color: " . esc_attr( $value ) . ";
				border-color: " . esc_attr( $value ) . ";
				color: " . esc_attr( $font_color ) . ";
			}


			#grve-theme-wrapper .grve-contact-form.grve-form-btn-outline.grve-form-btn-bg-" . esc_attr( $key ) . " input[type='submit']:not(.grve-custom-btn) {
				background-color: transparent;
				border-color: " . esc_attr( $value ) . ";
				color: " . esc_attr( $value ) . ";
			}

			#grve-theme-wrapper .grve-contact-form.grve-form-btn-outline.grve-form-btn-bg-hover-" . esc_attr( $key ) . " input[type='submit']:not(.grve-custom-btn):hover {
				background-color: " . esc_attr( $value ) . ";
				border-color: " . esc_attr( $value ) . ";
				color: " . esc_attr( $font_color ) . ";
			}

			#grve-main-header .grve-header-menu .grve-first-level.grve-menu-type-button.grve-" . esc_attr( $key ) . " > .grve-link-wrapper a .grve-item,
			#grve-main-header .grve-header-menu .grve-first-level.grve-menu-type-button.grve-hover-" . esc_attr( $key ) . ":hover > .grve-link-wrapper a .grve-item {
				background-color: " . esc_attr( $value ) . ";
				color: " . esc_attr( $font_color ) . ";
			}

			#grve-main-header .grve-header-menu .grve-first-level.grve-menu-type-outline.grve-" . esc_attr( $key ) . " > .grve-link-wrapper a .grve-item {
				border-color: " . esc_attr( $value ) . ";
				color: " . esc_attr( $value ) . ";
			}
			#grve-main-header .grve-header-menu .grve-first-level.grve-menu-type-outline.grve-hover-" . esc_attr( $key ) . ":hover > .grve-link-wrapper a .grve-item {
				background-color: " . esc_attr( $value ) . ";
				border-color: " . esc_attr( $value ) . ";
				color: " . esc_attr( $font_color ) . ";
			}

		";

		// Headings Color
		$css .= "
			.grve-headings-" . esc_attr( $key ) . " h1,
			.grve-headings-" . esc_attr( $key ) . " h2,
			.grve-headings-" . esc_attr( $key ) . " h3,
			.grve-headings-" . esc_attr( $key ) . " h4,
			.grve-headings-" . esc_attr( $key ) . " h5,
			.grve-headings-" . esc_attr( $key ) . " h6,
			.grve-headings-" . esc_attr( $key ) . " .grve-heading-color,
			.grve-inner-section.grve-headings-" . esc_attr( $key ) . " h1,
			.grve-inner-section.grve-headings-" . esc_attr( $key ) . " h2,
			.grve-inner-section.grve-headings-" . esc_attr( $key ) . " h3,
			.grve-inner-section.grve-headings-" . esc_attr( $key ) . " h4,
			.grve-inner-section.grve-headings-" . esc_attr( $key ) . " h5,
			.grve-inner-section.grve-headings-" . esc_attr( $key ) . " h6,
			.grve-inner-section.grve-headings-" . esc_attr( $key ) . " .grve-heading-color,
			.grve-column.grve-headings-" . esc_attr( $key ) . " h1,
			.grve-column.grve-headings-" . esc_attr( $key ) . " h2,
			.grve-column.grve-headings-" . esc_attr( $key ) . " h3,
			.grve-column.grve-headings-" . esc_attr( $key ) . " h4,
			.grve-column.grve-headings-" . esc_attr( $key ) . " h5,
			.grve-column.grve-headings-" . esc_attr( $key ) . " h6,
			.grve-column.grve-headings-" . esc_attr( $key ) . " .grve-heading-color,
			.grve-inner-section .grve-column-inner.grve-headings-" . esc_attr( $key ) . " h1,
			.grve-inner-section .grve-column-inner.grve-headings-" . esc_attr( $key ) . " h2,
			.grve-inner-section .grve-column-inner.grve-headings-" . esc_attr( $key ) . " h3,
			.grve-inner-section .grve-column-inner.grve-headings-" . esc_attr( $key ) . " h4,
			.grve-inner-section .grve-column-inner.grve-headings-" . esc_attr( $key ) . " h5,
			.grve-inner-section .grve-column-inner.grve-headings-" . esc_attr( $key ) . " h6,
			.grve-inner-section .grve-column-inner.grve-headings-" . esc_attr( $key ) . " .grve-heading-color,
			#grve-theme-wrapper .grve-post-item-inner.grve-headings-" . esc_attr( $key ) . " .grve-heading-color,
			#grve-theme-wrapper .grve-fixed-colors.grve-headings-" . esc_attr( $key ) . " .grve-box-title {
				color: " . esc_attr( $value ) . ";
			}
		";

		// Text Color
		$css .= "
			#grve-theme-wrapper .grve-text-" . esc_attr( $key ) . ",
			#grve-theme-wrapper .grve-text-hover-" . esc_attr( $key ) . ":hover,
			#grve-theme-wrapper a.grve-text-hover-" . esc_attr( $key ) . ":hover,
			#grve-theme-wrapper a .grve-text-hover-" . esc_attr( $key ) . ":hover {
				color: " . esc_attr( $value ) . ";
			}
		";

		// Link Color
		$css .= "
			.grve-link-" . esc_attr( $key ) . " a,
			.grve-inner-section.grve-link-" . esc_attr( $key ) . " a,
			.grve-column.grve-link-" . esc_attr( $key ) . " a,
			.grve-inner-section .grve-column-inner.grve-link-" . esc_attr( $key ) . " a,
			.grve-link-" . esc_attr( $key ) . " .grve-menu-element .grve-arrow,
			.grve-link-" . esc_attr( $key ) . " .widget a:not(.grve-outline):not(.grve-btn),
			.grve-inner-section.grve-link-" . esc_attr( $key ) . " .widget a:not(.grve-outline):not(.grve-btn),
			.grve-column.grve-link-" . esc_attr( $key ) . " .widget a:not(.grve-outline):not(.grve-btn),
			.grve-inner-section .grve-column-inner.grve-link-" . esc_attr( $key ) . " .widget a:not(.grve-outline):not(.grve-btn),
			#grve-theme-wrapper .grve-fixed-colors.grve-link-" . esc_attr( $key ) . " a {
				color: " . esc_attr( $value ) . ";
			}

			.grve-link-hover-" . esc_attr( $key ) . " a:hover,
			.grve-inner-section.grve-link-hover-" . esc_attr( $key ) . " a:hover,
			.grve-column.grve-link-hover-" . esc_attr( $key ) . " a:hover,
			.grve-inner-section .grve-column-inner.grve-link-hover-" . esc_attr( $key ) . " a:hover,
			.grve-link-hover-" . esc_attr( $key ) . " .grve-menu-element .grve-arrow:hover,
			.grve-link-hover-" . esc_attr( $key ) . " .widget:not(.grve-social) a:not(.grve-outline):not(.grve-btn):hover,
			.grve-inner-section.grve-link-hover-" . esc_attr( $key ) . " .widget:not(.grve-social) a:not(.grve-outline):not(.grve-btn):hover,
			.grve-column.grve-link-hover-" . esc_attr( $key ) . " .widget:not(.grve-social) a:not(.grve-outline):not(.grve-btn):hover,
			.grve-inner-section .grve-column-inner.grve-link-hover-" . esc_attr( $key ) . " .widget:not(.grve-social) a:not(.grve-outline):not(.grve-btn):hover,
			#grve-theme-wrapper .grve-fixed-colors.grve-link-hover-" . esc_attr( $key ) . " a:hover {
				color: " . esc_attr( $value ) . ";
			}

			.grve-link-" . esc_attr( $key ) . " a svg path {
				fill: " . esc_attr( $value ) . ";
			}
			.grve-link-hover-" . esc_attr( $key ) . " a:hover svg path {
				fill: " . esc_attr( $value ) . ";
			}
		";

		// Border Color
		$css .= "
			.grve-border-" . esc_attr( $key ) . ",
			.grve-border-hover-" . esc_attr( $key ) . ":hover {
				border-color: " . esc_attr( $value ) . ";
			}
		";

		// Custom Form Color
		$css .= "
			#grve-theme-wrapper .grve-contact-form.grve-form-input-text-" . esc_attr( $key ) . " input,
			#grve-theme-wrapper .grve-contact-form.grve-form-input-text-" . esc_attr( $key ) . " textarea,
			#grve-theme-wrapper .grve-contact-form.grve-form-input-text-" . esc_attr( $key ) . " select,
			#grve-theme-wrapper .grve-contact-form.grve-form-input-text-" . esc_attr( $key ) . " .wpcf7-list-item-label:before {
				color: " . esc_attr( $value ) . ";
			}
			#grve-theme-wrapper .grve-contact-form.grve-form-input-bg-" . esc_attr( $key ) . " input,
			#grve-theme-wrapper .grve-contact-form.grve-form-input-bg-" . esc_attr( $key ) . " textarea,
			#grve-theme-wrapper .grve-contact-form.grve-form-input-bg-" . esc_attr( $key ) . " select,
			#grve-theme-wrapper .grve-contact-form.grve-form-input-bg-" . esc_attr( $key ) . " .wpcf7-list-item-label:before {
				background-color: " . esc_attr( $value ) . ";
			}
			#grve-theme-wrapper .grve-contact-form.grve-form-input-focus-text-" . esc_attr( $key ) . " input:focus,
			#grve-theme-wrapper .grve-contact-form.grve-form-input-focus-text-" . esc_attr( $key ) . " textarea:focus,
			#grve-theme-wrapper .grve-contact-form.grve-form-input-focus-text-" . esc_attr( $key ) . " select:focus {
				color: " . esc_attr( $value ) . ";
			}
			#grve-theme-wrapper .grve-contact-form.grve-form-input-focus-bg-" . esc_attr( $key ) . " input:focus,
			#grve-theme-wrapper .grve-contact-form.grve-form-input-focus-bg-" . esc_attr( $key ) . " textarea:focus,
			#grve-theme-wrapper .grve-contact-form.grve-form-input-focus-bg-" . esc_attr( $key ) . " select:focus {
				background-color: " . esc_attr( $value ) . ";
			}
			#grve-theme-wrapper .grve-contact-form.grve-form-input-placeholder-" . esc_attr( $key ) . " ::-webkit-input-placeholder {
				color: " . esc_attr( $value ) . ";
			}
			#grve-theme-wrapper .grve-contact-form.grve-form-input-placeholder-" . esc_attr( $key ) . " :-moz-placeholder {
				color: " . esc_attr( $value ) . ";
			}
			#grve-theme-wrapper .grve-contact-form.grve-form-input-placeholder-" . esc_attr( $key ) . " ::-moz-placeholder {
				color: " . esc_attr( $value ) . ";
			}
			#grve-theme-wrapper .grve-contact-form.grve-form-input-placeholder-" . esc_attr( $key ) . " :-ms-input-placeholder {
				color: " . esc_attr( $value ) . ";
			}
			#grve-theme-wrapper .grve-contact-form.grve-form-input-focus-placeholder-" . esc_attr( $key ) . " :focus::-webkit-input-placeholder {
				color: " . esc_attr( $value ) . ";
			}
			#grve-theme-wrapper .grve-contact-form.grve-form-input-focus-placeholder-" . esc_attr( $key ) . " :focus:-moz-placeholder {
				color: " . esc_attr( $value ) . ";
			}
			#grve-theme-wrapper .grve-contact-form.grve-form-input-focus-placeholder-" . esc_attr( $key ) . " :focus::-moz-placeholder {
				color: " . esc_attr( $value ) . ";
			}
			#grve-theme-wrapper .grve-contact-form.grve-form-input-focus-placeholder-" . esc_attr( $key ) . " :focus:-ms-input-placeholder {
				color: " . esc_attr( $value ) . ";
			}
			#grve-theme-wrapper .grve-contact-form.grve-form-input-border-" . esc_attr( $key ) . " input,
			#grve-theme-wrapper .grve-contact-form.grve-form-input-border-" . esc_attr( $key ) . " textarea,
			#grve-theme-wrapper .grve-contact-form.grve-form-input-border-" . esc_attr( $key ) . " select,
			#grve-theme-wrapper .grve-contact-form.grve-form-input-border-" . esc_attr( $key ) . " .wpcf7-list-item-label:before,
			#grve-theme-wrapper .grve-contact-form.grve-form-input-border-" . esc_attr( $key ) . " .wpcf7-form .wpcf7-list-item-label:before,
			#grve-theme-wrapper .grve-contact-form.grve-form-input-focus-border-" . esc_attr( $key ) . " input:focus,
			#grve-theme-wrapper .grve-contact-form.grve-form-input-focus-border-" . esc_attr( $key ) . " textarea:focus,
			#grve-theme-wrapper .grve-contact-form.grve-form-input-focus-border-" . esc_attr( $key ) . " select:focus {
				border-color: " . esc_attr( $value ) . ";
			}
		";

		// Headings Color for SVG
		$css .= "
			.grve-headings-" . esc_attr( $key ) . " .grve-svg-heading-color,
			.grve-inner-section.grve-headings-" . esc_attr( $key ) . " .grve-svg-heading-color,
			.grve-column.grve-headings-" . esc_attr( $key ) . " .grve-svg-heading-color,
			.grve-inner-section .grve-column-inner.grve-headings-" . esc_attr( $key ) . " .grve-svg-heading-color {
				fill: " . esc_attr( $value ) . ";
			}
		";

		// SVG Icons color
		$css .= "
			.grve-svg-" . esc_attr( $key ) . " svg {
				fill: " . esc_attr( $value ) . ";
			}
		";

		// Button SVG Icons color
		$css .= "
			.grve-text-" . esc_attr( $key ) . " .grve-btn-svg-icon:not(.grve-with-shape) svg {
				fill: " . esc_attr( $value ) . ";
			}
			.grve-text-hover-" . esc_attr( $key ) . ":hover .grve-btn-svg-icon:not(.grve-with-shape) svg {
				fill: " . esc_attr( $value ) . ";
			}
		";

		// Video Button SVG Icons color
		$css .= "
			.grve-btn-video .grve-svg-" . esc_attr( $key ) . " svg {
				fill: " . esc_attr( $value ) . ";
			}
			.grve-btn-video:hover .grve-svg-hover-" . esc_attr( $key ) . " svg {
				fill: " . esc_attr( $value ) . ";
			}
		";

		//Gutenberg Editor Colors
		$css .= "
			#grve-theme-wrapper .has-" . esc_attr( $key ) . "-color {
				color: " . esc_attr( $value ) . ";
			}
			#grve-theme-wrapper .has-" . esc_attr( $key ) . "-background-color {
				background-color: " . esc_attr( $value ) . ";
			}
		";

		// Underline Text
		if ( 'inherit' != $value ) {
			$css .="
				span.grve-underline.grve-line-" . esc_attr( $key ) . " {
					background-image: linear-gradient(" . esc_attr( $value ) . " 0%, " . esc_attr( $value ) . " 100%);
				}
			";
		}
	}

	//Gradient Color
	$gradient_colors = impeka_grve_get_gradient_color_array();
	foreach ( $gradient_colors as $key => $value ) {

		if ( 'inherit' != $value['first'] && 'inherit' != $value['second'] ) {
			$css .= "
				#grve-theme-wrapper .grve-bg-" . esc_attr( $key ) . ":not(.grve-btn),
				#grve-theme-wrapper .grve-btn.grve-bg-" . esc_attr( $key ) . ":before,
				#grve-theme-wrapper .grve-btn.grve-bg-hover-" . esc_attr( $key ) . ":after {
					background: " . esc_attr( $value['first'] ) .";
					background: -moz-linear-gradient(left, " . esc_attr( $value['first'] ) . " 0%, " . esc_attr( $value['second'] ) . " 100%);
					background: -webkit-linear-gradient(left, " . esc_attr( $value['first'] ) . " 0%, " . esc_attr( $value['second'] ) . " 100%);
					background: linear-gradient(to right, " . esc_attr( $value['first'] ) . " 0%, " . esc_attr( $value['second'] ) . " 100%);
				}


				.grve-text-" . esc_attr( $key ) . " > span,
				i.grve-text-" . esc_attr( $key ) . " {
					-webkit-background-clip: text;
					-webkit-text-fill-color: transparent;
					color: " . esc_attr( $value['first'] ) .";
					background-image: -moz-linear-gradient(left, " . esc_attr( $value['first'] ) . " 0%, " . esc_attr( $value['second'] ) . " 100%);
					background-image: -webkit-linear-gradient(left, " . esc_attr( $value['first'] ) . " 0%, " . esc_attr( $value['second'] ) . " 100%);
					background-image: linear-gradient(to right, " . esc_attr( $value['first'] ) . " 0%, " . esc_attr( $value['second'] ) . " 100%);
				}
			";
		}
	}

	return $css;
}

$css .= impeka_grve_print_css_colors();


/* Primary Text */
$css .= "

.grve-blog .grve-post-meta-wrapper li a:hover,
.grve-search button[type='submit']:hover,
.widget.widget_calendar table tbody a,
blockquote > p:before,
.grve-filter.grve-filter-style-classic ul li:hover,
.grve-filter.grve-filter-style-classic ul li.selected,
.grve-pagination .page-numbers .page-numbers.current,
.grve-pagination .page-numbers a.page-numbers:hover {
	color: " . impeka_grve_option( 'body_primary_1_color' ) . ";
}

";

/* Light */
$css .= "
.grve-carousel-style-2 .grve-blog-carousel .grve-post-title {
	color: #ffffff;
}

";



/* Primary Bg Color
============================================================================= */
/* Primary Background */
$css .= "
#grve-theme-wrapper .grve-with-line:after,
#grve-single-post-tags .grve-tags li a:hover,
.grve-hover-underline:after,
.grve-language-element ul li a:hover,
.grve-language-element ul li a.active,
.wpcf7-form input[type='radio']:checked + .wpcf7-list-item-label:after,
.wpcf7-form input[type='radio']:not(:checked) + .wpcf7-list-item-label:after,
.wpcf7-form input[type='checkbox']:checked + .wpcf7-list-item-label:after,
.wpcf7-form input[type='checkbox']:not(:checked) + .wpcf7-list-item-label:after,
#grve-section-nav .grve-nav-item.active:after,
#grve-section-nav .grve-nav-item:hover:after,
.grve-post-item .grve-post-category.grve-style-btn a:hover,
.grve-single-post-tags ul li a:hover,
.grve-social-bar .grve-line:after,
.grve-filter.grve-filter-style-count .selected .grve-count,
.grve-purchased-items,
input[type='file']::-webkit-file-upload-button {
	background-color: " . impeka_grve_option( 'body_primary_1_color' ) . ";
	border-color: " . impeka_grve_option( 'body_primary_1_color' ) . ";
	color: #ffffff;
}

.grve-like-counter-link.active svg {
	fill: " . impeka_grve_option( 'body_primary_1_color' ) . ";
}

";


/* Buttons Settings
============================================================================= */
$css .= "
a.grve-btn {
	padding: " . impeka_grve_option( 'button_spacing', '', 'padding-top' ) . " " . impeka_grve_option( 'button_spacing', '', 'padding-left'  ) . ";
}

";


/* Footer
============================================================================= */

	/* - Widget Area
	========================================================================= */
	$css .= "
	#grve-footer .grve-widget-area {
		background-color: " . impeka_grve_option( 'footer_widgets_bg_color' ) . ";
	}
	";
	/* - Footer Widget Colors
	========================================================================= */
	$css .= "
	#grve-footer .grve-widget-area .widget .grve-widget-title,
	#grve-footer .grve-widget-area h1,
	#grve-footer .grve-widget-area h2,
	#grve-footer .grve-widget-area h3,
	#grve-footer .grve-widget-area h4,
	#grve-footer .grve-widget-area h5,
	#grve-footer .grve-widget-area h6 {
		color: " . impeka_grve_option( 'footer_widgets_headings_color' ) . ";
	}

	#grve-footer .grve-widget-area .widget,
	#grve-footer .grve-widget-area form,
	#grve-footer .grve-widget-area form p,
	#grve-footer .grve-widget-area form div,
	#grve-footer .grve-widget-area form span {
		color: " . impeka_grve_option( 'footer_widgets_font_color' ) . ";
	}

	#grve-footer .grve-widget-area,
	#grve-footer .grve-widget-area .grve-container,
	#grve-footer .grve-widget-area .widget,
	#grve-footer .grve-widget-area .widget a:not(.grve-outline):not(.grve-btn),
	#grve-footer .grve-widget-area .widget ul,
	#grve-footer .grve-widget-area .widget li,
	#grve-footer .grve-widget-area .widget div,
	#grve-footer .grve-widget-area table,
	#grve-footer .grve-widget-area tr,
	#grve-footer .grve-widget-area td,
	#grve-footer .grve-widget-area th,
	#grve-footer .grve-widget-area form,
	#grve-footer .grve-widget-area .wpcf7-form-control-wrap,
	#grve-footer .grve-widget-area label,
	#grve-footer .grve-widget-area .grve-border,
	#grve-footer .grve-widget-area form,
	#grve-footer .grve-widget-area form p,
	#grve-footer .grve-widget-area form div,
	#grve-footer .grve-widget-area form span {
		border-color: " . impeka_grve_option( 'footer_widgets_border_color' ) . ";
	}

	#grve-footer .grve-footer-wrapper .widget a:not(.grve-outline):not(.grve-btn) {
		color: " . impeka_grve_option( 'footer_widgets_link_color' ) . ";
	}

	#grve-footer .grve-footer-wrapper .widget:not(.widget_tag_cloud) a:not(.grve-outline):not(.grve-btn):hover,
	#grve-footer .grve-footer-wrapper .widget.widget_nav_menu li.open > a {
		color: " . impeka_grve_option( 'footer_widgets_hover_color' ) . ";
	}

	";
	/* - Footer Bar Colors
	========================================================================= */
	$impeka_grve_footer_bar_background_color = impeka_grve_option( 'footer_bar_bg_color', '#000000' );
	$css .= "
	#grve-footer .grve-footer-bar {
		color: " . impeka_grve_option( 'footer_bar_font_color' ) . ";
		background-color: rgba(" . impeka_grve_hex2rgb( $impeka_grve_footer_bar_background_color ) . "," . impeka_grve_option( 'footer_bar_bg_color_opacity', '1') . ");
	}

	#grve-footer .grve-footer-bar a {
		color: " . impeka_grve_option( 'footer_bar_link_color' ) . ";
	}

	#grve-footer .grve-footer-bar a:hover {
		color: " . impeka_grve_option( 'footer_bar_hover_color' ) . ";
	}
	";

	/* - Back To Top Colors
	========================================================================= */
	$css .= "
	.grve-back-top .grve-wrapper-color {
		background-color: " . impeka_grve_option( 'back_to_top_shape_color' ) . ";
	}

	.grve-back-top .grve-with-shape svg {
		fill: " . impeka_grve_option( 'back_to_top_icon_color' ) . ";
	}
	";

/* Tag Cloud
============================================================================= */
if ( '1' != impeka_grve_option( 'wp_tagcloud', '0' ) ) {
	$css .= "
	.widget .tagcloud a {
		display: inline-block;
		margin-bottom: 4px;
		margin-right: 4px;
		border: 1px solid;
		border-color: inherit;
		-webkit-border-radius: 3px;
		border-radius: 3px;
		line-height: 1.2em;
		padding: 5px 10px;
		color: inherit;
		-webkit-transition : all .3s;
		-moz-transition    : all .3s;
		-ms-transition     : all .3s;
		-o-transition      : all .3s;
		transition         : all .3s;
	}

	#grve-theme-wrapper .widget .tagcloud a {
		border-color: " . impeka_grve_option( 'body_border_color' ) . ";
	}

	#grve-theme-wrapper .widget .tagcloud a:hover,
	#grve-theme-wrapper #grve-sidearea .widget.widget_tag_cloud a:hover {
		background-color: " . impeka_grve_option( 'body_primary_1_color' ) . ";
		border-color: " . impeka_grve_option( 'body_primary_1_color' ) . ";
		color: #ffffff;
	}

	#grve-theme-wrapper #grve-sidearea .widget .tagcloud a {
		border-color: " . impeka_grve_option( 'side_area_border_color' ) . ";
	}

	#grve-footer .grve-widget-area .widget .tagcloud a:hover {
		background-color: " . impeka_grve_option( 'body_primary_1_color' ) . ";
		border-color: " . impeka_grve_option( 'body_primary_1_color' ) . ";
		color: #ffffff;
	}
	";
} else {
	$css .= "
	.widget .tagcloud a {
		display: inline-block;
		vertical-align: middle;
		margin-bottom: 4px;
		margin-right: 8px;
		line-height: 1.4;
		-webkit-transition : all .3s;
		-moz-transition    : all .3s;
		-ms-transition     : all .3s;
		-o-transition      : all .3s;
		transition         : all .3s;
	}

	#grve-footer .grve-widget-area .widget .tagcloud a:hover {
		color: " . impeka_grve_option( 'footer_widgets_hover_color' ) . ";
	}
	";
}


/* Theme Indicator
============================================================================= */
$impeka_grve_theme_indicator_color = impeka_grve_option( 'theme_indicator_color', '#969696' );
$impeka_grve_theme_indicator_opacity = impeka_grve_option( 'theme_indicator_opacity', '1' );
$css .= "
	#grve-indicator.grve-style-2:not(.grve-item-hover) .grve-default {
		background-color: rgba(" . impeka_grve_hex2rgb( $impeka_grve_theme_indicator_color ) . "," . $impeka_grve_theme_indicator_opacity . ");
	}
	#grve-indicator.grve-style-2:not(.grve-item-hover) .grve-default:after {
		border-color: rgba(" . impeka_grve_hex2rgb( $impeka_grve_theme_indicator_color ) . "," . $impeka_grve_theme_indicator_opacity . ");
	}
";

/* GDPR Privacy
============================================================================= */
$impeka_grve_privacy_bar_bg_color = impeka_grve_option( 'privacy_bar_bg_color', '#000000' );
$css .= "

#grve-privacy-bar {
	background-color: rgba(" . impeka_grve_hex2rgb( $impeka_grve_privacy_bar_bg_color ) . "," . impeka_grve_option( 'privacy_bar_bg_opacity', '0.90') . ");
	border-color: " . impeka_grve_option( 'privacy_bar_border_color' ) . ";
	color: " . impeka_grve_option( 'privacy_bar_text_color' ) . ";
}

.grve-privacy-agreement {
	background-color: " . impeka_grve_option( 'privacy_bar_button_bg_color' ) . ";
	color: " . impeka_grve_option( 'privacy_bar_button_text_color' ) . ";
}

.grve-privacy-refresh-btn {
	background-color: " . impeka_grve_option( 'privacy_modal_button_bg_color' ) . ";
	color: " . impeka_grve_option( 'privacy_modal_button_text_color' ) . ";
}

.grve-privacy-preferences {
	background-color: transparent;
	color: " . impeka_grve_option( 'privacy_bar_text_color' ) . ";
}

.grve-privacy-agreement:hover {
	background-color: " . impeka_grve_option( 'privacy_bar_button_bg_hover_color' ) . ";
}

.grve-privacy-refresh-btn:hover {
	background-color: " . impeka_grve_option( 'privacy_modal_button_bg_hover_color' ) . ";
}

.grve-privacy-switch .grve-switch input[type='checkbox']:checked + .grve-switch-slider {
    background-color: " . impeka_grve_option( 'privacy_modal_switcher_active_color' ) . ";
}
";

/* Paddings
============================================================================= */
$impeka_grve_space_size_array = array (
	array(
		'id' => '1x',
		'percentage' => 1,
	),
	array(
		'id' => '2x',
		'percentage' => 2,
	),
	array(
		'id' => '3x',
		'percentage' => 3,
	),
	array(
		'id' => '4x',
		'percentage' => 4,
	),
	array(
		'id' => '5x',
		'percentage' => 5,
	),
	array(
		'id' => '6x',
		'percentage' => 6,
	),
);

function impeka_grve_print_space_size( $space_size_array = array() , $ratio = 1 ) {

	$default_space_size = 30;
	$min_space_size = 30;

	$css = '';

	foreach ( $space_size_array as $size ) {

		$space_size = ( $default_space_size * $size['percentage'] ) * $ratio;
		if ( $space_size < $default_space_size ) {
			$space_size = $min_space_size;
		}
		$css .= "
			#grve-theme-wrapper .grve-padding-top-" . esc_attr( $size['id'] ) . "{ padding-top: " . esc_attr( $space_size ) . "px; }
			#grve-theme-wrapper .grve-padding-bottom-" . esc_attr( $size['id'] ) . "{ padding-bottom: " . esc_attr( $space_size ) . "px; }
			#grve-theme-wrapper .grve-margin-top-" . esc_attr( $size['id'] ) . "{ margin-top: " . esc_attr( $space_size ) . "px; }
			#grve-theme-wrapper .grve-margin-bottom-" . esc_attr( $size['id'] ) . "{ margin-bottom: " . esc_attr( $space_size ) . "px; }
			#grve-theme-wrapper .grve-height-" . esc_attr( $size['id'] ) . "{ height: " . esc_attr( $space_size ) . "px; }
			#grve-theme-wrapper .grve-top-" . esc_attr( $size['id'] ) . "{ top: " . esc_attr( $space_size ) . "px; }
			#grve-theme-wrapper .grve-left-" . esc_attr( $size['id'] ) . "{ left: " . esc_attr( $space_size ) . "px; }
			#grve-theme-wrapper .grve-right-" . esc_attr( $size['id'] ) . "{ right: " . esc_attr( $space_size ) . "px; }
			#grve-theme-wrapper .grve-bottom-" . esc_attr( $size['id'] ) . "{ bottom: " . esc_attr( $space_size ) . "px; }
			#grve-theme-wrapper .grve-top-minus-" . esc_attr( $size['id'] ) . "{ top: -" . esc_attr( $space_size ) . "px; }
			#grve-theme-wrapper .grve-left-minus-" . esc_attr( $size['id'] ) . "{ left: -" . esc_attr( $space_size ) . "px; }
			#grve-theme-wrapper .grve-right-minus-" . esc_attr( $size['id'] ) . "{ right: -" . esc_attr( $space_size ) . "px; }
			#grve-theme-wrapper .grve-bottom-minus-" . esc_attr( $size['id'] ) . "{ bottom: -" . esc_attr( $space_size ) . "px; }
			#grve-theme-wrapper .grve-padding-none { padding: 0px !important; }
			#grve-theme-wrapper .grve-margin-none { margin: 0px !important; }
		";

	}

	return $css;
}

$css .= impeka_grve_print_space_size( $impeka_grve_space_size_array, 1 );

$css .= "
	@media only screen and (max-width: 1200px) {
		" . impeka_grve_print_space_size( $impeka_grve_space_size_array, 0.8 ). "
	}
	@media only screen and (max-width: 768px) {
		" . impeka_grve_print_space_size( $impeka_grve_space_size_array, 0.6 ). "
	}
";

$impeka_grve_sidebar_size = impeka_grve_option( 'sidebar_size', '30' );
$impeka_grve_content_size = intval( 100 - $impeka_grve_sidebar_size );

$css .= "
	#grve-content.grve-with-sidebar #grve-main-content { width: " . esc_attr( $impeka_grve_content_size ) . "%; }
	#grve-content.grve-with-sidebar #grve-sidebar { width: " . esc_attr( $impeka_grve_sidebar_size ) . "%; }

	@media only screen and (max-width: 1023px) {

		#grve-content.grve-with-sidebar #grve-main-content {
			width: auto;
		}

		#grve-content.grve-with-sidebar #grve-sidebar {
			width: 90%;
		}

	}
";

$impeka_grve_content_sidebar_space = impeka_grve_option( 'content_sidebar_space', '60' );

if ( is_rtl() ) {
	$css .= "
		#grve-content.grve-right-sidebar #grve-main-content { padding-left: " . esc_attr( $impeka_grve_content_sidebar_space ) . "px; }
		#grve-content.grve-left-sidebar #grve-main-content { padding-right: " . esc_attr( $impeka_grve_content_sidebar_space ) . "px; }
	";
} else {
	$css .= "
		#grve-content.grve-right-sidebar #grve-main-content { padding-right: " . esc_attr( $impeka_grve_content_sidebar_space ) . "px; }
		#grve-content.grve-left-sidebar #grve-main-content { padding-left: " . esc_attr( $impeka_grve_content_sidebar_space ) . "px; }
	";
}

$css .= "
	@media only screen and (max-width: 1023px) {

		#grve-content.grve-right-sidebar #grve-main-content,
		#grve-content.grve-left-sidebar #grve-main-content {
			padding-left: 0;
			padding-right: 0;
		}
	}
";

// output dynamic css
echo impeka_grve_compress_css( $css );

//Omit closing PHP tag to avoid accidental whitespace output errors.
