<?php

/*
*	Custom Nav Menu
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

include_once get_template_directory() . '/includes/custom-menu/grve-walker-nav-menu-edit.php';
include_once get_template_directory() . '/includes/custom-menu/grve-simple-navigation-walker.php';
include_once get_template_directory() . '/includes/custom-menu/grve-element-navigation-walker.php';
include_once get_template_directory() . '/includes/custom-menu/grve-main-navigation-walker.php';
include_once get_template_directory() . '/includes/custom-menu/grve-responsive-navigation-walker.php';
include_once get_template_directory() . '/includes/custom-menu/grve-dropdown-navigation-walker.php';

/**
 * Function to get custom menu items
 */
function impeka_grve_get_custom_nav_menu_items( $menu_item ) {
	$menu_item->grve_megamenu = get_post_meta( $menu_item->ID, '_impeka_grve_menu_item_megamenu', true );
	$menu_item->grve_area_item = get_post_meta( $menu_item->ID, '_impeka_grve_menu_item_area_item', true );
	$menu_item->grve_megamenu_size = get_post_meta( $menu_item->ID, '_impeka_grve_menu_item_megamenu_size', true );
	$menu_item->grve_link_mode = get_post_meta( $menu_item->ID, '_impeka_grve_menu_item_link_mode', true );
	$menu_item->grve_link_classes = get_post_meta( $menu_item->ID, '_impeka_grve_menu_item_link_classes', true );
	$menu_item->grve_label_text = get_post_meta( $menu_item->ID, '_impeka_grve_menu_item_label_text', true );
	$menu_item->grve_label_color = get_post_meta( $menu_item->ID, '_impeka_grve_menu_item_label_color', true );
	$menu_item->grve_icon_fontawesome = get_post_meta( $menu_item->ID, '_impeka_grve_menu_item_icon_fontawesome', true );
	$menu_item->grve_style = get_post_meta( $menu_item->ID, '_impeka_grve_menu_item_style', true );
	$menu_item->grve_color = get_post_meta( $menu_item->ID, '_impeka_grve_menu_item_color', true );
	$menu_item->grve_hover_color = get_post_meta( $menu_item->ID, '_impeka_grve_menu_item_hover_color', true );
	$menu_item->grve_shape = get_post_meta( $menu_item->ID, '_impeka_grve_menu_item_shape', true );
	return $menu_item;
}
add_filter( 'wp_setup_nav_menu_item', 'impeka_grve_get_custom_nav_menu_items' );

/**
 * Function to update custom menu items
 */
function impeka_grve_update_custom_nav_menu_items( $menu_id, $menu_item_db_id, $args ) {

	$custom_nav_menu_fields = array( 'megamenu', 'area_item', 'megamenu_size', 'link_mode', 'link_classes', 'label_text', 'label_color', 'icon_fontawesome', 'style', 'color', 'hover_color', 'shape'  );

	if( isset( $_POST['_impeka_grve_menu_options'] ) ) {
		parse_str( urldecode( $_POST['_impeka_grve_menu_options'] ), $parse_array );

		foreach ( $custom_nav_menu_fields as $key ){
			if( !isset( $parse_array['_impeka_grve_menu_item_' . $key . '_' . $menu_item_db_id] ) ) {
				$parse_array['_impeka_grve_menu_item_' . $key . '_' . $menu_item_db_id] = "";
			}
			$new_meta_value = $parse_array['_impeka_grve_menu_item_' . $key . '_' . $menu_item_db_id];
			$meta_key = '_impeka_grve_menu_item_' . $key;
			$meta_value = get_post_meta( $menu_item_db_id, $meta_key, true );

			if ( $new_meta_value && '' == $meta_value ) {
				if ( !add_post_meta( $menu_item_db_id, $meta_key, $new_meta_value, true ) ) {
					update_post_meta( $menu_item_db_id, $meta_key, $new_meta_value );
				}
			} elseif ( $new_meta_value && $new_meta_value != $meta_value ) {
				update_post_meta( $menu_item_db_id, $meta_key, $new_meta_value );
			} elseif ( '' == $new_meta_value && $meta_value ) {
				delete_post_meta( $menu_item_db_id, $meta_key, $meta_value );
			}
		}
	}

}
add_action( 'wp_update_nav_menu_item', 'impeka_grve_update_custom_nav_menu_items', 10, 3 );

function impeka_grve_add_megamenu_parent_class( $items, $args ) {

	if( isset( $args->grve_walker ) && 'main' == $args->grve_walker ) {
		$parents = array();
		$megamenu = false;
		foreach ( $items as $item ) {
			//Check if the item is mega menu
			if ( 0 == $item->menu_item_parent ) {
				if( isset( $item->grve_megamenu ) && !empty( $item->grve_megamenu ) && 'area-item' != $item->grve_megamenu ) {
					$megamenu = true;
				} else {
					$megamenu = false;
				}
			}
			//Check if the item is a parent item and mega menu column
			if ( $item->menu_item_parent && $item->menu_item_parent > 0 ) {
				if ( $megamenu ) {
					$parents[] = $item->menu_item_parent;
				}
			}
		}
		if ( !empty( $parents ) ) {
			foreach ( $items as $item ) {
				if ( in_array( $item->ID, $parents ) ) {
					//Add "grve-megamenu-column" class to parent item
					$item->classes[] = 'grve-megamenu-column';
				}
			}
		}
	}
	return $items;
}
add_filter( 'wp_nav_menu_objects', 'impeka_grve_add_megamenu_parent_class', 10, 2 );

//Omit closing PHP tag to avoid accidental whitespace output errors.
