<?php

/*
*	Dropdown Navigation Walker
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( !class_exists('Impeka_Grve_Dropdown_Navigation_Walker') ) {

	class Impeka_Grve_Dropdown_Navigation_Walker extends Walker_Nav_Menu {

		function start_lvl( &$output, $depth = 0, $args = array() ) {
			$indent = str_repeat("\t", $depth); // don't output children opening tag (`<ul>`)
		}

		function end_lvl( &$output, $depth = 0, $args = array() ) {
			$indent = str_repeat("\t", $depth); // don't output children closing tag
		}

		public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
			$output .= '<option value="' . esc_attr( $item->ID ) . '">';
			$output .= apply_filters( 'the_title', $item->title, $item->ID );
		}

		public function end_el( &$output, $item, $depth = 0, $args = array() ) {
			$output .= "</option>\n"; // replace closing </li> with the option tag
		}

	}
}