<?php

/*
*	Responsive Navigation Walker
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( !class_exists('Impeka_Grve_Responsive_Navigation_Walker') ) {

	class Impeka_Grve_Responsive_Navigation_Walker extends Walker_Nav_Menu {

		public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
			$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

			$classes = empty( $item->classes ) ? array() : (array) $item->classes;
			$classes[] = 'menu-item-' . $item->ID;

			//Area Item only on first level
			if ( '0' == $depth && isset( $item->grve_megamenu ) && !empty( $item->grve_megamenu ) ) {
				if( 'area-item' == $item->grve_megamenu ) {
					$classes[] = 'grve-menu-area-item';
					$classes[] = 'menu-item-has-children';
				}
			}

			if ( '0' == $depth ) {
				$classes[] = 'grve-first-level';
			}

			//Link Mode
			$link_mode = '';
			if ( isset( $item->grve_link_mode ) ) {
				$link_mode = $item->grve_link_mode;
			}

			if ( 'no-link' == $link_mode ) {
				$classes[] = 'grve-menu-no-link';
			} else if ( 'hidden' == $link_mode ) {
				$classes[] = 'grve-hidden-menu-item';
			}

			//Menu Item Style
			if ( isset( $item->grve_style ) && !empty( $item->grve_style ) ) {
				$menu_item_color = 'primary-1';
				$menu_item_hover_color = 'black';
				$menu_item_shape = 'round';
				if ( 'button' == $item->grve_style ) {
					$classes[] = 'grve-menu-type-button';
				} else if ( 'outline' == $item->grve_style ) {
					$classes[] = 'grve-menu-type-outline';
					$menu_item_color = 'inherit';
					$menu_item_hover_color = 'primary-1';
				}
				if ( isset( $item->grve_color ) && !empty( $item->grve_color ) ) {
					$menu_item_color = $item->grve_color;
				}
				if ( isset( $item->grve_hover_color ) && !empty( $item->grve_hover_color ) ) {
					$menu_item_hover_color = $item->grve_hover_color;
				}
				if ( isset( $item->grve_shape ) && !empty( $item->grve_shape ) ) {
					$menu_item_shape = $item->grve_shape;
				}

				$classes[] = 'grve-' . $menu_item_color;
				$classes[] = 'grve-hover-' . $menu_item_hover_color;
				$classes[] = 'grve-shape-' . $menu_item_shape;

			}

			$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args, $depth ) );
			$class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';

			$id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args, $depth );
			$id = $id ? ' id="' . esc_attr( $id ) . '"' : '';

			$output .= $indent . '<li' . $id . $class_names .'>';

			$atts = array();
			$atts['title']  = ! empty( $item->attr_title ) ? $item->attr_title : '';
			$atts['target'] = ! empty( $item->target )     ? $item->target     : '';
			if ( '_blank' === $item->target && empty( $item->xfn ) ) {
				$atts['rel'] = 'noopener noreferrer';
			} else {
				$atts['rel'] = $item->xfn;
			}
			$atts['href']   = ! empty( $item->url )        ? $item->url        : '';
			$atts['aria-current'] = $item->current ? 'page' : '';

			//Remove href if no-link mode
			if ( 'no-link' == $link_mode ) {
				$atts['href'] = '#';
			}

			//Add Link Class
			if ( isset( $item->grve_link_classes ) && !empty( $item->grve_link_classes ) ) {
				$atts['class'] = $item->grve_link_classes;
			}

			$atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args, $depth );

			$attributes = '';
			foreach ( $atts as $attr => $value ) {
				if ( ! empty( $value ) ) {
					$value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
					$attributes .= ' ' . $attr . '="' . $value . '"';
				}
			}

			$item_output = $args->before;

			$item_output .= '<div class="grve-link-wrapper">';
			$item_output .= apply_filters( 'impeka_grve_nav_menu_before_link', '', $item, $depth, $args );
			$item_output .= '<a'. $attributes .'>';
			$item_output .= $args->link_before;

			//Add Menu icon
			if ( isset( $item->grve_icon_fontawesome ) && !empty( $item->grve_icon_fontawesome ) ) {
				$item_output .= '<i class="grve-menu-icon ' . esc_attr( $item->grve_icon_fontawesome ) . '"></i>';
			}
			$item_output .= apply_filters( 'the_title', $item->title, $item->ID );

			if ( isset( $item->description ) && !empty( $item->description ) && '0' != $depth ) {
				$item_output .= '<span class="grve-menu-description">' . esc_html( $item->description ) . '</span>';
			}

			$item_output .= $args->link_after;
			//Add Label text
			if ( isset( $item->grve_label_text ) && !empty( $item->grve_label_text ) ) {
				$label_class = "grve-label";
				if ( isset( $item->grve_label_color ) && !empty( $item->grve_label_color ) ) {
					$label_class .= " grve-bg-" . $item->grve_label_color;
				} else {
					$label_class .= " grve-bg-default";
				}
				$item_output .= '<span class="' . esc_attr( $label_class ) . '">' . esc_html( $item->grve_label_text ) . '</span>';
			}
			$item_output .= '</a>';

			$is_area_item = false;
			if ( '0' == $depth && isset( $item->grve_megamenu ) && !empty( $item->grve_megamenu ) ) {
				if( 'area-item' == $item->grve_megamenu ) {
					$is_area_item = true;
				}
			}

			if ( in_array('menu-item-has-children', $item->classes) || $is_area_item ) {
				$item_output .= '<div class="grve-arrow"></div>';
			}
			$item_output .= apply_filters( 'impeka_grve_nav_menu_after_link', '', $item, $depth, $args );
			$item_output .= '</div>';

			$item_output .= $args->after;
			if ( '0' == $depth ) {
				if ( isset( $item->grve_megamenu ) && !empty( $item->grve_megamenu ) && 'area-item' == $item->grve_megamenu ) {
						$item_output .= '<div class="grve-area-item-sub-menu grve-sub-menu">';
						$item_output .= '<div class="grve-area-item-sub-menu-inner">';
						if ( isset( $item->grve_area_item ) && !empty( $item->grve_area_item ) ) {
							ob_start();
							do_action('impeka_grve_area_content', $item->grve_area_item );
							$item_output .= ob_get_clean();
						}
						$item_output .= '</div>';
				} else {
					if ( in_array('menu-item-has-children', $item->classes) ) {
						$item_output .= '<div class="grve-classic-sub-menu grve-sub-menu">';
					}
				}
			} else {
				if ( in_array('menu-item-has-children', $item->classes) ) {
					$item_output .= '<div class="grve-classic-sub-menu grve-sub-menu">';
				}
			}

			$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
		}

		public function end_el( &$output, $item, $depth = 0, $args = array() ) {
			if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
				$t = '';
				$n = '';
			} else {
				$t = "\t";
				$n = "\n";
			}
			if ( '0' == $depth && isset( $item->grve_megamenu ) && !empty( $item->grve_megamenu ) ) {
				$output .= '</div>';
			} else {
				if ( in_array('menu-item-has-children', $item->classes) ) {
					$output .= '</div>';
				}
			}
			$output .= "</li>{$n}";
		}


	}
}