<?php

/*
 *	Blog Helper functions
 *
 * 	@version	1.0
 * 	@author		Greatives Team
 * 	@URI		https://greatives.eu
 */



if ( !function_exists('impeka_grve_get_blog_grid_wrapper_params') ) {
	function impeka_grve_get_blog_grid_wrapper_params() {
		$params = array(
			'mode' => impeka_grve_option( 'blog_mode', 'large' ),
			'columns_large_screen' => impeka_grve_option( 'blog_columns_large_screen', '3' ),
			'columns' => impeka_grve_option( 'blog_columns', '3' ),
			'columns_tablet_landscape' => impeka_grve_option( 'blog_columns_tablet_landscape', '2' ),
			'columns_tablet_portrait' => impeka_grve_option( 'blog_columns_tablet_portrait', '2' ),
			'columns_mobile' => impeka_grve_option( 'blog_columns_mobile', '1' ),
			'gutter' => impeka_grve_option( 'blog_gutter', 'yes' ),
			'gutter_size' => impeka_grve_option( 'blog_gutter_size', '30' ),
			'spinner' => impeka_grve_option( 'blog_spinner', 'no' ),
			'display_style' => impeka_grve_option( 'blog_display_style', 'pagination' ),
			'animation' => impeka_grve_option( 'blog_animation' ),
		);
		return $params;
	}
}

if ( !function_exists('impeka_grve_get_blog_params') ) {
	function impeka_grve_get_blog_params() {
		$params = array(
			'mode' => impeka_grve_option( 'blog_mode', 'large' ),
			'style' => impeka_grve_option( 'blog_style', 'style-1' ),
			'small_style' => impeka_grve_option( 'blog_small_style', 'style-small-1' ),
			'custom_overview' => impeka_grve_option( 'blog_custom_overview', 'no' ),
			'heading_color' => impeka_grve_option( 'blog_heading_color' ),
			'text_color' => impeka_grve_option( 'blog_text_color' ),
			'meta_color' => impeka_grve_option( 'blog_meta_color' ),
			'bg_color' => impeka_grve_option( 'blog_bg_color' ),
			'border_color' => impeka_grve_option( 'blog_border_color' ),
			'overlay_color' => impeka_grve_option( 'blog_overlay_color' ),
			'overlay_opacity' => impeka_grve_option( 'blog_overlay_opacity' ),
			'shadow' => impeka_grve_option( 'blog_shadow' ),
			'radius' => impeka_grve_option( 'blog_radius' ),
			'media_area' => impeka_grve_option( 'blog_media_area' ),
			'image_width' => impeka_grve_option( 'blog_image_width' ),
			'image_prio' => impeka_grve_option( 'blog_image_prio' ),
			'image_mode' => impeka_grve_option( 'blog_image_mode' ),
			'grid_image_mode' => impeka_grve_option( 'blog_grid_image_mode' ),
			'masonry_image_mode' => impeka_grve_option( 'blog_masonry_image_mode' ),
			'heading' => impeka_grve_option( 'blog_heading' ),
			'heading_tag' => impeka_grve_option( 'blog_heading_tag' ),
			'auto_excerpt' => impeka_grve_option( 'blog_auto_excerpt' ),
			'excerpt_length_large' =>impeka_grve_option( 'blog_excerpt_length_large' ),
			'excerpt_length' => impeka_grve_option( 'blog_excerpt_length' ),
			'excerpt_more' => impeka_grve_option( 'blog_excerpt_more' ),
			'excerpt_more_text' => impeka_grve_option( 'blog_excerpt_more_text' ),
			'author_visibility' => impeka_grve_option( 'blog_author_visibility' ),
			'date_visibility' => impeka_grve_option( 'blog_date_visibility' ),
			'comments_visibility' => impeka_grve_option( 'blog_comments_visibility' ),
			'like_visibility' => impeka_grve_option( 'blog_like_visibility' ),
			'categories_visibility' => impeka_grve_option( 'blog_categories_visibility' ),
			'categories_mode' => impeka_grve_option( 'blog_categories_mode' ),
			'indicator' => impeka_grve_option( 'blog_indicator' ),
			'indicator_text' => impeka_grve_option( 'blog_indicator_text' ),
			'indicator_color' => impeka_grve_option( 'blog_indicator_color' ),
		);
		return $params;
	}
}

if ( !function_exists('impeka_grve_get_blog_style') ) {
	function impeka_grve_get_blog_style( $params = array() ) {

		$mode = impeka_grve_array_value( $params, 'mode', 'large' );

		switch( $mode ) {
			case 'small':
				$style = impeka_grve_array_value( $params, 'small_style', 'style-small-1' );
				break;
			case 'grid':
			case 'masonry':
				$custom_overview = impeka_grve_is_enabled( impeka_grve_array_value( $params, 'custom_overview' ) );
				$overview_style = impeka_grve_post_meta( '_impeka_grve_post_overview_style' );
				if( $custom_overview  && !empty( $overview_style ) ) {
					$style = $overview_style;
				} else {
					$style = impeka_grve_array_value( $params, 'style', 'style-1' );
				}
				break;
			case 'carousel':
				$style = impeka_grve_array_value( $params, 'style', 'style-1' );
				break;
			case 'large':
			default:
				$style = 'style-large';
				break;
		}

		return $style;

	}
}

 /**
 * Prints Post Social Bar
 */
if ( !function_exists('impeka_grve_print_post_social_bar') ) {
	function impeka_grve_print_post_social_bar() {
		if ( impeka_grve_social_bar ( 'post', 'check' ) ) {
			$social_layout = impeka_grve_option( 'post_social_layout', 'layout-1' );
			impeka_grve_social_bar ( 'post', $social_layout );
		}
	}
}
add_action( 'impeka_grve_single_section', 'impeka_grve_print_post_social_bar', 15 );

/**
 * Prints Post Tags
 */
if ( !function_exists('impeka_grve_print_post_tags') ) {
	function impeka_grve_print_post_tags() {
		if ( impeka_grve_visibility( 'post_tag_visibility', '1' ) ) {
			get_template_part( 'templates/post/meta/post-meta-tags' );
		}
	}
}
add_action( 'impeka_grve_single_section', 'impeka_grve_print_post_tags', 10 );

 /**
 * Prints Post Comments
 */
if ( !function_exists('impeka_grve_print_post_comments') ) {
	function impeka_grve_print_post_comments() {
		if ( impeka_grve_visibility( 'post_comments_visibility' ) && ( comments_open() || get_comments_number() ) ) {

			$sidebar_visibility = impeka_grve_global_param( 'sidebar_visibility' );
			$comments_position = impeka_grve_option( 'post_comments_position' );

			if ( 'default' == $comments_position || ( 'auto' == $comments_position && 'yes' == $sidebar_visibility  ) ) {
?>
			<div id="grve-comments-wrapper" class="grve-border grve-border-top grve-padding-top-2x grve-margin-top-2x">
				<?php comments_template(); ?>
			</div>
<?php
			}
		}
	}
}
add_action( 'impeka_grve_single_section', 'impeka_grve_print_post_comments', 20 );

 /**
 * Prints About Author
 */
if ( !function_exists('impeka_grve_print_post_about_author') ) {
	function impeka_grve_print_post_about_author() {
		$author_description = get_the_author_meta( 'user_description' );
		if ( impeka_grve_visibility( 'post_author_visibility' ) && !empty( $author_description ) ) {
			get_template_part( 'templates/post/meta/post-meta-about-author' );
		}
	}
}
add_action( 'impeka_grve_single_after_content', 'impeka_grve_print_post_about_author', 10 );

 /**
 * Prints Post Comments Section
 */
if ( !function_exists('impeka_grve_print_post_comments_section') ) {
	function impeka_grve_print_post_comments_section() {
		if ( impeka_grve_visibility( 'post_comments_visibility' ) && ( comments_open() || get_comments_number() ) ) {

			$sidebar_visibility = impeka_grve_global_param( 'sidebar_visibility' );
			$comments_position = impeka_grve_option( 'post_comments_position' );

			if ( 'section' == $comments_position || ( 'auto' == $comments_position && 'no' == $sidebar_visibility  ) ) {

?>
			<div id="grve-comments-section" data-header-color="default" class="grve-border grve-padding-top-3x grve-padding-bottom-3x">
				<div class="grve-container">
					<?php comments_template(); ?>
				</div>
			</div>
<?php
			}
		}
	}
}
add_action( 'impeka_grve_single_after_content', 'impeka_grve_print_post_comments_section', 20 );

 /**
 * Prints Post Related Section
 */
if ( !function_exists('impeka_grve_print_post_related_posts_section') ) {
	function impeka_grve_print_post_related_posts_section() {
		if ( impeka_grve_visibility( 'post_related_visibility' ) ) {
			impeka_grve_print_related_posts();
		}
	}
}
add_action( 'impeka_grve_single_after_content', 'impeka_grve_print_post_related_posts_section', 30 );

 /**
 * Prints Post Nav Bar
 */
if ( !function_exists('impeka_grve_print_post_nav_bar') ) {
	function impeka_grve_print_post_nav_bar() {
		$grve_post_nav_layout = impeka_grve_option( 'post_nav_layout', 'layout-1' );
		impeka_grve_nav_bar( 'post', $grve_post_nav_layout );
	}
}
add_action( 'impeka_grve_single_after_content', 'impeka_grve_print_post_nav_bar', 40 );




 /**
 * Prints excerpt
 */
function impeka_grve_print_post_excerpt( $params = array() ) {

	$post_format = impeka_grve_array_value( $params, 'post_format', get_post_format() );
	$mode = impeka_grve_array_value( $params, 'mode', 'large' );
	$small_style = impeka_grve_array_value( $params, 'small_style', 'style-small-1' );
	$auto_excerpt = impeka_grve_array_value( $params, 'auto_excerpt' );
	$excerpt_length_large = impeka_grve_array_value( $params, 'excerpt_length_large', '55' );
	$excerpt_length = impeka_grve_array_value( $params, 'excerpt_length', '30' );
	$excerpt_more = impeka_grve_array_value( $params, 'excerpt_more');
	$excerpt_more_text = impeka_grve_array_value( $params, 'excerpt_more_text');
	if ( empty( $excerpt_more_text ) ) {
		$excerpt_more_text = esc_html__( 'read more', 'impeka' );
	}


	if ( 'large' == $mode ) {
		$excerpt_length = $excerpt_length_large;
	} else {
		$auto_excerpt = '1';
	}

	if ( 'leader' != $mode ) {
		if ( 'link' ==  $post_format || 'quote' ==  $post_format ) {
			$excerpt_more = '';
			$auto_excerpt = '1';
		}
	}

	//Remove more from excerpt ( printed in template )
	if ( 'small' ==  $mode && 'style-small-2' == $small_style ) {
		$excerpt_more = '';
	}

	if ( impeka_grve_is_enabled( $auto_excerpt ) ) {
		echo impeka_grve_excerpt( $excerpt_length, $excerpt_more, $excerpt_more_text );
	} else {
		if ( impeka_grve_is_enabled( $excerpt_more ) ) {
			the_content( $excerpt_more_text );
		} else {
			the_content( '' );
		}
	}

}

function impeka_grve_get_loop_title_heading_tag( $params = array() ) {

	$mode = impeka_grve_array_value( $params, 'mode', 'large' );
	$heading_tag = impeka_grve_array_value( $params, 'heading_tag', 'h3');

	if( 'auto' != $heading_tag ) {
		$title_tag = $heading_tag;
	} else {
		$title_tag = 'h3';
		if( 'large' == $mode || 'small' == $mode  ) {
			$title_tag = 'h2';
		}
	}
	return $title_tag;
}

function impeka_grve_get_loop_title_heading( $params = array() ) {

	$mode = impeka_grve_array_value( $params, 'mode', 'large' );
	$small_style = impeka_grve_array_value( $params, 'small_style', 'style-small-1' );
	$heading = impeka_grve_array_value( $params, 'heading', 'auto');
	$post_format = impeka_grve_array_value( $params, 'post_format', get_post_format() );

	if( 'auto' != $heading ) {
		$heading_class = $heading;
	} else {
		$heading_class = 'h3';
		if( 'large' == $mode ) {
			$heading_class = 'h2';
		}
	}

	if( 'quote' == $post_format || 'link' == $post_format ) {
		if ( 'small' == $mode && 'style-small-2' == $small_style ) {
			//Current Heading Class
		} else {
			$heading_class = 'small-text';
		}
	}

	return $heading_class;
}

if ( !function_exists('impeka_grve_loop_post_link_text') ) {
	function impeka_grve_loop_post_link_text( $params = array() ) {
		$text = "";
		$content = impeka_grve_post_meta( '_impeka_grve_post_link_text' );
		if ( !empty( $content ) ) {
			echo '<p class="grve-leader-text">' . wp_kses_post( $content ) . '</p>';
		}
	}
}

function impeka_grve_loop_post_title( $params = array() ) {
	$title_tag = impeka_grve_get_loop_title_heading_tag( $params );
	$title_class = impeka_grve_get_loop_title_heading( $params );
	the_title( '<' . tag_escape( $title_tag ) . ' class="grve-post-title grve-heading-color grve-' . esc_attr( $title_class ) . '" itemprop="headline"><span>', '</span></' . tag_escape( $title_tag ) . '>' );
}
function impeka_grve_loop_post_title_link( $params = array() ) {
	$title_tag = impeka_grve_get_loop_title_heading_tag( $params );
	$title_class = impeka_grve_get_loop_title_heading( $params );
	$link_type = impeka_grve_array_value( $params, 'link_type', 'item' );
	if ( 'quick-view' == $link_type ) {
		the_title( '<a href="#"><' . tag_escape( $title_tag ) . ' data-post-id="' . esc_attr( get_the_ID() ) . '" class="grve-post-title grve-quick-view-link grve-' . esc_attr( $title_class ) . '" itemprop="headline"><span>', '</span></' . tag_escape( $title_tag ) . '></a>' );
	} else {
		the_title( '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark"><' . tag_escape( $title_tag ) . ' class="grve-post-title grve-' . esc_attr( $title_class ) . '" itemprop="headline"><span>', '</span></' . tag_escape( $title_tag ) . '></a>' );
	}
}
function impeka_grve_loop_post_title_hidden( $params = array() ) {
	$title_tag = impeka_grve_get_loop_title_heading_tag();
	the_title( '<' . tag_escape( $title_tag ) . ' class="grve-hidden" itemprop="headline">', '</' . tag_escape( $title_tag ) . '>' );
}

 /**
 * Prints Single Post Title
 */
function impeka_grve_print_post_simple_title() {
	global $post;
	if ( 'yes' == impeka_grve_global_param( 'header_title_visibility' ) ) {

		$post_id = $post->ID;
		$title_options = get_post_meta( $post_id, '_impeka_grve_custom_title_options', true );

		$title_style = impeka_grve_option( 'post_title_style' );
		$title_custom = impeka_grve_array_value( $title_options, 'custom', $title_style );
		if ( 'simple' == $title_custom ) {
			echo '<div class="grve-post-simple-title-wrapper">';
			echo '<div class="grve-container">';
			the_title( '<h1 class="grve-single-simple-title" itemprop="headline">', '</h1>' );
			impeka_grve_print_post_title_meta( 'simple' );
			echo '</div>';
			echo '</div>';
		} else {
			the_title( '<h2 class="grve-hidden" itemprop="headline">', '</h2>' );
		}
	} else {
		the_title( '<h2 class="grve-hidden" itemprop="headline">', '</h2>' );
	}
}


/**
 * Gets Blog Class
 */
function impeka_grve_get_blog_class( $blog_mode ) {

	switch( $blog_mode ) {

		case 'small':
			$blog_class = 'grve-blog grve-blog-small grve-isotope';
			break;
		case 'masonry':
			$blog_class = 'grve-blog grve-blog-columns grve-blog-masonry grve-isotope';
			break;
		case 'grid':
			$blog_class = 'grve-blog grve-blog-columns grve-blog-grid grve-isotope';
			break;
		case 'large':
		default:
			$blog_class = 'grve-blog grve-blog-large grve-non-isotope';
			break;
	}

	return $blog_class;

}

/**
 * Check Background Mode
 */
function impeka_grve_post_is_bg_mode( $params = array() ) {

	$blog_mode = impeka_grve_array_value( $params, 'mode', 'large' );
	$post_format = impeka_grve_array_value( $params, 'post_format', get_post_format() );

	$bg_mode = false;

	switch( $post_format ) {
		case 'quote':
		case 'link':
			$bg_mode = true;
			break;
		case 'video':
			$post_style = impeka_grve_post_meta( '_impeka_grve_post_video_style' );
			if ( ( 'masonry' == $blog_mode || 'grid' == $blog_mode ) && 'impeka' == $post_style ) {
				$bg_mode = true;
			}
			break;
		case 'standard':
		case 'image':
		case '':
			$post_style = impeka_grve_post_meta( '_impeka_grve_post_standard_style' );
			if ( ( 'masonry' == $blog_mode || 'grid' == $blog_mode ) && 'impeka' == $post_style ) {
				$bg_mode = true;
			}
			break;
		default:
			$bg_mode = false;
			break;
	}

	return $bg_mode;

}

/**
 * Gets post inner class
 */

if ( !function_exists('impeka_grve_get_post_inner_attributes') ) {
	function  impeka_grve_get_post_inner_attributes( $params = array() ) {
		$mode = impeka_grve_array_value( $params, 'mode', 'large' );
		$wrapper_attributes = array();
		$classes = array();

		if( 'large' != $mode ) {
			$classes[] = 'grve-isotope-item-inner';
		} else {
			$classes[] = 'grve-blog-big-item-inner';
		}

		if( 'masonry' == $mode || 'grid' == $mode  ) {
			$custom_overview = impeka_grve_array_value( $params, 'custom_overview', 'no' );
			$double_size = impeka_grve_post_meta( '_impeka_grve_post_overview_double_size' );
			if ( 'yes' == $double_size && 'yes' == $custom_overview ) {
				$classes[] = 'grve-double-size';
			} else {
				$classes[] = 'grve-default-size';
			}
		}

		$class_string = implode( ' ', $classes );
		$wrapper_attributes[] = 'class="' . esc_attr( $class_string ) . '"';

		return $wrapper_attributes;

	}
}

 /**
 * Prints post feature media
 */
function impeka_grve_print_post_feature_media( $params = array() ) {

	$blog_mode = impeka_grve_array_value( $params, 'mode', 'large' );
	$blog_media_area = impeka_grve_array_value( $params, 'media_area', '1' );
	$blog_image_prio = impeka_grve_array_value( $params, 'image_prio', 'no' );
	$post_format = impeka_grve_array_value( $params, 'post_format', get_post_format() );

	if ( !impeka_grve_is_enabled( $blog_media_area ) ) {
		return;
	}

	if ( 'yes' == $blog_image_prio && has_post_thumbnail() ) {
		impeka_grve_print_post_feature_image( $params );
	} else {

		switch( $post_format ) {
			case 'audio':
				impeka_grve_print_post_audio();
				break;
			case 'video':
				impeka_grve_print_post_video();
				break;
			case 'gallery':
			 impeka_grve_print_post_gallery( $params );
				break;
			default:
				impeka_grve_print_post_feature_image( $params );
				break;
		}
	}

}

 /**
 * Prints post feature image
 */
function impeka_grve_print_post_gallery( $params = array() ) {

	$mode = impeka_grve_array_value( $params, 'mode', 'large' );
	$slider_items = impeka_grve_post_meta( '_impeka_grve_post_slider_items' );
	switch( $mode ) {
		case 'large':
			$image_size = 'impeka-grve-large-rect-horizontal';
			break;
		default:
			$image_size  = 'impeka-grve-small-rect-horizontal';
			break;
	}
	if ( !empty( $slider_items ) ) {
		impeka_grve_print_gallery_slider( 'blog-slider', $slider_items, $image_size );
	}

}

 /**
 * Prints post feature image
 */
function impeka_grve_print_post_feature_image( $params = array() ) {

	$mode = impeka_grve_array_value( $params, 'mode', 'large' );
	$image_mode = impeka_grve_array_value( $params, 'image_mode', 'landscape-large-wide' );
	$grid_image_mode = impeka_grve_array_value( $params, 'grid_image_mode', 'landscape' );
	$masonry_image_mode = impeka_grve_array_value( $params, 'masonry_image_mode', 'medium' );
	$shadow = impeka_grve_array_value( $params, 'shadow', 'small' );
	$radius = impeka_grve_array_value( $params, 'radius', 'none' );
	$image_load_mode = impeka_grve_array_value( $params, 'image_load_mode' );
	$image_width = impeka_grve_array_value( $params, 'image_width', 'normal' );

	$column_space = '100';
	if ( 'large' == $mode && 'normal' == $image_width ) {
		$column_space = 'auto';
	}

	if ( 'grid' == $mode || 'small' == $mode ) {
		$image_mode = $grid_image_mode;
	} else if ( 'masonry' == $mode ) {
		$image_mode = $masonry_image_mode;
	}

	$image_size = impeka_grve_get_image_size( $image_mode );
	impeka_grve_the_post_thumbnail( $image_size, array( 'data-column-space' => $column_space, 'data-lazyload' => $image_load_mode ) );

}



/**
 * Prints audio shortcode of post format audio
 */
function impeka_grve_print_post_audio() {
	global $wp_embed;

	$audio_mode = impeka_grve_post_meta( '_impeka_grve_post_type_audio_mode' );
	$audio_mp3 = impeka_grve_post_meta( '_impeka_grve_post_audio_mp3' );
	$audio_ogg = impeka_grve_post_meta( '_impeka_grve_post_audio_ogg' );
	$audio_wav = impeka_grve_post_meta( '_impeka_grve_post_audio_wav' );
	$audio_embed = impeka_grve_post_meta( '_impeka_grve_post_audio_embed' );

	$audio_output = '';

	if( empty( $audio_mode ) && !empty( $audio_embed ) ) {
		echo '<div class="grve-media">' . $audio_embed . '</div>';
	} else {
		if ( !empty( $audio_mp3 ) || !empty( $audio_ogg ) || !empty( $audio_wav ) ) {

			$audio_output .= '[audio ';

			if ( !empty( $audio_mp3 ) ) {
				$audio_output .= 'mp3="'. esc_url( $audio_mp3 ) .'" ';
			}
			if ( !empty( $audio_ogg ) ) {
				$audio_output .= 'ogg="'. esc_url( $audio_ogg ) .'" ';
			}
			if ( !empty( $audio_wav ) ) {
				$audio_output .= 'wav="'. esc_url( $audio_wav ) .'" ';
			}

			$audio_output .= ']';

			echo '<div class="grve-media">' . do_shortcode( $audio_output ) . '</div>';
		}
	}

}

/**
 * Prints video of the video post format
 */
function impeka_grve_print_post_video() {

	$video_mode = impeka_grve_post_meta( '_impeka_grve_post_type_video_mode' );
	$video_webm = impeka_grve_post_meta( '_impeka_grve_post_video_webm' );
	$video_mp4 = impeka_grve_post_meta( '_impeka_grve_post_video_mp4' );
	$video_ogv = impeka_grve_post_meta( '_impeka_grve_post_video_ogv' );
	$video_poster = impeka_grve_post_meta( '_impeka_grve_post_video_poster' );
	$video_embed = impeka_grve_post_meta( '_impeka_grve_post_video_embed' );

	impeka_grve_print_media_video( $video_mode, $video_webm, $video_mp4, $video_ogv, $video_embed, $video_poster );
}

/**
 * Prints video popup of the video post format
 */
function impeka_grve_print_post_video_popup() {

	$video_mode = impeka_grve_post_meta( '_impeka_grve_post_type_video_mode' );

	if( empty( $video_mode ) ) {
		$video_embed = impeka_grve_post_meta( '_impeka_grve_post_video_embed' );
		if ( !empty( $video_embed ) ) {
?>
	<a class="grve-video-popup grve-post-icon" href="<?php echo esc_url( $video_embed ); ?>">
		<?php echo impeka_grve_get_video_icon(); ?>
	</a>
<?php
		}
	} else {
		$video_webm = impeka_grve_post_meta( '_impeka_grve_post_video_webm' );
		$video_mp4 = impeka_grve_post_meta( '_impeka_grve_post_video_mp4' );
		$video_ogv = impeka_grve_post_meta( '_impeka_grve_post_video_ogv' );
		$video_id = uniqid('grve-video-id-');
		if ( !empty( $video_webm ) || !empty( $video_mp4 ) || !empty( $video_ogv ) ) {
?>
	<a class="grve-html5-video-popup grve-post-icon" href="#<?php echo esc_attr( $video_id ); ?>">
		<i class="grve-icon-video"></i>
		<svg class="grve-animated-circle" x="0px" y="0px" width="60px" height="60px" viewBox="0 0 60 60"><circle fill="none" stroke="#ffffff" stroke-width="2" cx="30" cy="30" r="29" transform="rotate(-90 30 30)"/></svg>
		<div id="<?php echo esc_attr( $video_id ); ?>" class="grve-html5-video-popup-container mfp-hide">
			<?php impeka_grve_print_post_video(); ?>
		</div>
	</a>
<?php
		}
	}
}

/**
 * Prints post icon format
 */

function impeka_grve_print_post_icon_format( $post_format = '' ) {
	$icon = '';
	switch( $post_format ) {
		case 'quote':
			$icon = 'quote-1';
			break;
		case 'link':
			$icon = 'link';
			break;
		case 'video':
			$icon = 'video-1';
			break;
		default:
			break;
	}
	if ( !empty( $icon ) ) {
?>
	<div class="grve-post-icon grve-svg-primary-1">
		<?php echo impeka_grve_get_svg_icon( $icon ); ?>
	</div>
<?php
	}
}

 /**
 * Prints Post Title Categories
 */
function impeka_grve_print_post_title_categories( $post_id = null) {
	if ( ! $post_id ) {
		$post_id = get_the_ID();
	}

	$post_terms = wp_get_object_terms( $post_id, 'category', array( 'fields' => 'ids' ) );
	if ( !empty( $post_terms ) && !is_wp_error( $post_terms ) ) {
		echo '<div class="grve-categories">';
		the_category( '','', $post_id );
		echo '</div>';
	}
}

 /**
 * Prints Post Title Categories Simple
 */
function impeka_grve_print_post_title_categories_simple( $post_id = null) {
	if ( ! $post_id ) {
		$post_id = get_the_ID();
	}

	$post_terms = wp_get_object_terms( $post_id, 'category', array( 'fields' => 'ids' ) );
	if ( !empty( $post_terms ) && !is_wp_error( $post_terms ) ) {
		echo '<li class="grve-post-categories">';
		esc_html_e( 'in', 'impeka' );
		echo ' ';
		the_category( ', ' );
		echo '</li>';
	}
}


if ( !function_exists('impeka_grve_print_post_bg_link') ) {
	function impeka_grve_print_post_bg_link( $params = array() ) {
		$post_format = impeka_grve_array_value( $params, 'post_format', get_post_format() );
		$link_type = impeka_grve_array_value( $params, 'link_type', 'item' );

		if ( 'link' == $post_format ) {

			$link_url = get_post_meta( get_the_ID(), '_impeka_grve_post_link_url', true );
			$new_window = get_post_meta( get_the_ID(), '_impeka_grve_post_link_new_window', true );
			if( empty( $link_url ) ) {
				$link_url = get_permalink();
			}
			$link_target = '_self';
			if( !empty( $new_window ) ) {
				$link_target = '_blank';
			}
?>
			<a class="grve-item-url" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>" rel="bookmark"><span class="screen-reader-text"><?php the_title(); ?></span></a>
<?php
		} else {
			if ( 'quick-view' == $link_type ) {
?>
			<a class="grve-item-url grve-quick-view-link" href="#" data-post-id="<?php echo esc_attr( get_the_ID() ); ?>"><span class="screen-reader-text"><?php the_title(); ?></span></a>
<?php
			} else {
?>
			<a class="grve-item-url" href="<?php echo esc_url( get_permalink() ); ?>" rel="bookmark"><span class="screen-reader-text"><?php the_title(); ?></span></a>
<?php
			}
		}
	}
}

 /**
 * Prints Post Title Meta
 */

function impeka_grve_print_post_title_meta( $mode = "") {

	$meta_class = "grve-post-meta";
	if ( 'simple' == $mode ) {
		$meta_class .= " grve-link-text";
	}


	$show_author = impeka_grve_visibility( 'blog_author_visibility' );
	$show_date = impeka_grve_visibility( 'blog_date_visibility' );
	$show_comments = impeka_grve_visibility( 'blog_comments_visibility' );
?>
	<ul class="<?php echo esc_attr( $meta_class ); ?>">
<?php
		impeka_grve_print_post_author_by( $show_author );
		impeka_grve_print_post_date( $show_date );
		impeka_grve_print_post_loop_comments( $show_comments );
		if ( 'simple' == $mode ) {
			impeka_grve_print_post_title_categories_simple();
		}
?>
	</ul>
<?php
}

 /**
 * Prints Post Title Meta
 */

function impeka_grve_print_feature_post_title_meta( $post_id = null ) {

	if( $post_id ) {
		$post_comments_number = get_comments_number( $post_id );
		$post_likes = impeka_grve_option( 'post_social', '', 'grve-likes' );
?>
	<div class="grve-title-meta">
		<ul class="grve-post-meta grve-small-text">
			<li class="grve-post-author"><i class="grve-icon-user"></i>
				<span><?php impeka_grve_print_author_name_by_id( $post_id ); ?></span>
			</li>
			<li class="grve-post-date"><i class="grve-icon-date"></i>
				<time datetime="<?php echo esc_attr( get_the_date( 'c', $post_id  ) ); ?>"><?php echo esc_html( get_the_date( '', $post_id  ) ); ?></time>
			</li>
			<li class="grve-post-comments"><i class="grve-icon-comment"></i>
				<span><?php echo esc_html( $post_comments_number ); ?></span>
			</li>
			<?php if ( !empty( $post_likes  ) ) { ?>
			<li class="grve-like-counter <?php echo impeka_grve_likes( $post_id, 'status' ); ?>">
				<span><?php echo impeka_grve_likes( $post_id ); ?></span>
			</li>
			<?php } ?>
		</ul>
	</div>
<?php
	}
}


function impeka_grve_print_post_loop_meta( $meta = '' ) {
	global $post;
	$post_id = $post->ID;

	switch( $meta ) {
		case 'avatar':
			echo get_avatar( get_the_author_meta( 'ID' ), 30 );
			break;
		case 'author':
			impeka_grve_print_author_name_by_id( $post_id );
			break;
		case 'like':
			echo impeka_grve_likes( $post_id );
			break;
		case 'like-number':
			echo impeka_grve_likes( $post_id, 'number' );
			break;
		case 'comments':
			comments_number();
			break;
		case 'comments-number':
			echo get_comments_number( $post_id );
			break;
		case 'categories':
		case 'categories-all':
			the_category( ' ' );
			break;
		case 'categories-one':
			impeka_grve_print_post_primary_category( $post_id );
			break;
		case 'date':
		default:
			?>
			<time datetime="<?php echo mysql2date( 'c', $post->post_date ); ?>">
				<?php echo esc_html( get_the_date() ); ?>
			</time>
			<?php
			break;
	}

}

 /**
 * Prints author name by id
 */
if ( !function_exists('impeka_grve_print_author_name_by_id') ) {
	function impeka_grve_print_author_name_by_id( $post_id ) {
		$post_author_id = get_post_field( 'post_author', $post_id );
		$userdata = get_userdata( $post_author_id );
		echo esc_html( $userdata->display_name );
	}
}

 /**
 * Prints primary category
 */
if ( !function_exists('impeka_grve_print_post_primary_category') ) {
	function impeka_grve_print_post_primary_category( $post_id ) {
		$currentID = $post_id;
		$category = get_the_category();

		// Get primary (Yoast) term if it is set
		$category_display = '';
		$category_slug = '';
		$category_id = '';

		if ( class_exists('WPSEO_Primary_Term') ) {
			 // Show the post's 'Primary' category, if this Yoast feature is available, & one is set
			$wpseo_primary_term = new WPSEO_Primary_Term( 'category', get_the_id() );
			$wpseo_primary_term = $wpseo_primary_term->get_primary_term();
			$term = get_term( $wpseo_primary_term );
			if ( is_wp_error( $term ) ) {
				// Default to first category (not Yoast) if an error is returned
				if( !empty( $category ) ) {
					$category_display = $category[0]->name;
					$category_slug = $category[0]->slug;
					$category_id = $category[0]->term_id;
				}
			} else {
				// Set variables for category_display & category_slug based on Primary Yoast Term
				$category_id = $term->term_id;
				$category_term = get_category($category_id);
				$category_display = $term->name;
				$category_slug = $term->slug;
			}
		} else {
			// Default, display the first category in WP's list of assigned categories
			if( !empty( $category ) ) {
				$category_display = $category[0]->name;
				$category_slug = $category[0]->slug;
				$category_id = $category[0]->term_id;
			}
		}
		$term_link = get_term_link( $category_id );
		if ( !is_wp_error( $term_link ) ) {
			echo '<a href="' . esc_url( $term_link ) . '">' . esc_html( $category_display ) . '</a>';
		}
	}
}

 /**
 * Prints post author by
 */
if ( !function_exists('impeka_grve_print_post_author_by') ) {
	function impeka_grve_print_post_author_by( $visibility = 'yes' ) {
		if ( impeka_grve_is_enabled( $visibility ) ) {
	?>
		<li class="grve-post-author">
			<?php echo get_avatar( get_the_author_meta( 'ID' ), 50 ); ?>
			<span><?php echo get_the_author_link(); ?></span>
		</li>
	<?php
		}
	}
}

 /**
 * Prints like counter
 */
function impeka_grve_print_like_counter( $visibility = 'yes' ) {
	if ( impeka_grve_is_enabled( $visibility ) ) {
		$post_likes = impeka_grve_option( 'post_social', '', 'grve-likes' );
		if ( !empty( $post_likes  ) ) {
			global $post;
			$post_id = $post->ID;
?>
			<li class="grve-like-counter <?php echo impeka_grve_likes( $post_id, 'status' ); ?>"><span><?php echo impeka_grve_likes( $post_id ); ?></span></li>
<?php
		}
	}
}

/**
 * Prints post date
 */
function impeka_grve_print_post_date( $visibility = 'yes' ) {
	if ( impeka_grve_is_enabled( $visibility ) ) {
		global $post;
?>
	<li class="grve-post-date">
		<time datetime="<?php echo mysql2date( 'c', $post->post_date ); ?>">
			<?php echo esc_html( get_the_date() ); ?>
		</time>
	</li>
<?php
	}
}

function impeka_grve_print_post_loop_comments(  $visibility = 'yes' ) {
	if ( impeka_grve_is_enabled( $visibility ) ) {
?>
	<li class="grve-post-comments"><span><?php comments_number(); ?></span></li>
<?php
	}
}

function impeka_grve_print_post_loop_categories( $visibility = 'yes' ) {
	if ( impeka_grve_is_enabled( $visibility ) ) {
		global $post;
		$post_id = $post->ID;
		$post_terms = wp_get_object_terms( $post_id, 'category', array( 'fields' => 'ids' ) );
		if ( !empty( $post_terms ) && !is_wp_error( $post_terms ) ) {
			$term_ids = implode( ',' , $post_terms );
			echo '<ul class="grve-categories">';
			echo wp_list_categories( 'title_li=&style=list&echo=0&hierarchical=0&taxonomy=category&include=' . $term_ids );
			echo '</ul>';
		}
	}
}

/**
 * Prints post feature bg image container
 */

function impeka_grve_print_post_overview_bg_image_container( $params = array() ) {
	if ( has_post_thumbnail() ) {
		$mode = impeka_grve_array_value( $params, 'mode', 'large' );
		$overlay_color = impeka_grve_array_value( $params, 'overlay_color', 'default' );
		$overlay_opacity = impeka_grve_array_value( $params, 'overlay_opacity', 'default' );
		if( 'grid' == $mode || 'masonry' == $mode ) {
			$custom_overview = impeka_grve_is_enabled( impeka_grve_array_value( $params, 'custom_overview' ) );
			$overview_style = impeka_grve_post_meta( '_impeka_grve_post_overview_style' );
			if( $custom_overview  && 'style-3' == $overview_style) {
				$overlay_color = impeka_grve_post_meta( '_impeka_grve_post_overview_overlay_color', $overlay_color );
				$overlay_opacity = impeka_grve_post_meta( '_impeka_grve_post_overview_overlay_opacity', $overlay_opacity );
			}
		}

		$overlay = true;
		if ( 'none' == $overlay_opacity || '0' == $overlay_opacity ) {
			$overlay = false;
		} else {
			$overlay_classes = array( 'grve-bg-overlay', 'grve-bg-' . $overlay_color, 'grve-opacity-' . $overlay_opacity );
			$overlay_class_string = implode( ' ', $overlay_classes );
		}
	?>
		<div class="grve-background-wrapper">
			<?php impeka_grve_print_post_bg_image(); ?>
			<?php if( $overlay ) { ?>
			<div class="<?php echo esc_attr( $overlay_class_string ); ?>"></div>
			<?php } ?>
		</div>
	<?php
	}

}

function impeka_grve_print_post_bg_image_container_by_type( $post_format ) {

	$bg_options = array();

 	if ( 'link' == $post_format ) {
		$bg_options['bg_color'] = impeka_grve_post_meta( '_impeka_grve_post_link_bg_color', 'primary-1' );
		$bg_options['bg_hover_color'] = impeka_grve_post_meta( '_impeka_grve_post_link_bg_hover_color', 'black' );
		$bg_options['bg_opacity'] = impeka_grve_post_meta( '_impeka_grve_post_link_bg_opacity', '70' );
	}

	impeka_grve_print_post_bg_image_container( $bg_options );

}


function impeka_grve_print_post_bg_image_container( $options ) {



	$bg_color = impeka_grve_array_value( $options, 'bg_color' );
	$bg_hover_color = impeka_grve_array_value( $options, 'bg_hover_color' );
	$bg_opacity = impeka_grve_array_value( $options, 'overlay_opacity', '80' );
	$mode = impeka_grve_array_value( $options, 'mode' );
	$overlay = true;

	$link_classes = array();
	$link_classes[] = 'grve-bg-' . $bg_color;
	if( !empty( $bg_hover_color ) ){
		$link_classes[] = 'grve-bg-hover-' . $bg_hover_color;
	}
	$link_classes[] = 'grve-bg-overlay';
	if ( has_post_thumbnail() ) {
		$link_classes[] = 'grve-opacity-' . $bg_opacity;
		if ( 'none' == $bg_opacity || '0' == $bg_opacity ) {
			$overlay = false;
		}
	} else {
		$link_classes[] = 'grve-opacity-100';
	}
	$link_class_string = implode( ' ', $link_classes );

?>
	<div class="grve-background-wrapper">
		<?php
			if ( 'image' == $mode ) {
				impeka_grve_print_post_image( $options );
			} else {
				impeka_grve_print_post_bg_image();
			}
		?>
		<?php if( $overlay ) { ?>
		<div class="<?php echo esc_attr( $link_class_string ); ?>"></div>
		<?php } ?>
	</div>
<?php
}

function impeka_grve_print_post_image( $options = array() ) {

	$image_size = impeka_grve_array_value( $options, 'image_size', 'impeka-grve-fullscreen' );

	if ( has_post_thumbnail() ) {
		impeka_grve_the_post_thumbnail( $image_size );
	} else {
		$image_src = get_template_directory_uri() . '/images/transparent/' . $image_size . '.png';
?>
		<img class="attachment-<?php echo esc_attr( $image_size ); ?>" src="<?php echo esc_url( $image_src ); ?>" alt="<?php the_title_attribute(); ?>"/>
<?php
	}
}


function impeka_grve_print_post_bg_image( $image_size = 'impeka-grve-fullscreen' ) {
	if ( has_post_thumbnail() ) {
		$post_thumbnail_id = get_post_thumbnail_id( get_the_ID() );
		$attachment_src = wp_get_attachment_image_src( $post_thumbnail_id, $image_size );
		if ( $attachment_src ) {
			$image_url = $attachment_src[0];
			if ( 'off' != impeka_grve_option( 'image_load_mode' ) ) {
				$img_srcset = wp_get_attachment_image_srcset( $post_thumbnail_id, $image_size );
				if ( empty( $img_srcset ) ) {
					$img_srcset = $image_url;
				}
				echo '<div class="grve-bg-image lazyload"  data-bgset="' . esc_attr( $img_srcset )  . '" data-sizes="auto"></div>';
			} else {
				echo '<div class="grve-bg-image" style="background-image: url(' . esc_url( $image_url ) . ');"></div>';
			}
		}
	}
}

/**
 * Get Post Term Slugs
 */
if ( !function_exists('impeka_grve_get_post_term_slugs') ) {
	function impeka_grve_get_post_term_slugs( $post_id, $term_name ) {
		$term_slugs = array();
		$terms = get_the_terms( $post_id , $term_name );
		if ( !empty( $terms ) && !is_wp_error( $terms ) ) {
			foreach ( $terms as $term ) {
				$term_slugs[] = $term->slug;
			}
		}
		return $term_slugs;
	}
}

/**
 * Prints Related Posts ( Single Post )
 */
function impeka_grve_print_related_posts() {

	$post_id = get_the_ID();
	$post_related_mode = impeka_grve_option( 'post_related_mode', 'tag' );
	$exclude_ids = array( $post_id );
	if ( 'category' == $post_related_mode ) {
		$term_slugs = impeka_grve_get_post_term_slugs( $post_id, 'category' );

		$args = array(
			'post_type' => 'post',
			'post_status'=>'publish',
			'post__not_in' => $exclude_ids ,
			'tax_query' => array(
			  array(
				  'taxonomy' => 'category',
				  'field' => 'slug',
				  'terms' => $term_slugs,
				  'operator' => 'IN'
			  ),
			),
			'posts_per_page' => 3,
			'paged' => 1,
		);
	} elseif ( 'recent' == $post_related_mode ) {
		$args = array(
			'post_type' => 'post',
			'post_status'=>'publish',
			'post__not_in' => $exclude_ids ,
			'posts_per_page' => 3,
			'paged' => 1,
			'ignore_sticky_posts' => 1,
		);
	} else {
		$tag_ids = array();
		$tags_list = get_the_tags();
		if ( ! empty( $tags_list ) ) {
			foreach ( $tags_list as $tag ) {
				$tag_ids[] = $tag->term_id;
			}
		}
		$args = array(
			'post_type' => 'post',
			'post_status'=>'publish',
			'tag__in' => $tag_ids,
			'post__not_in' => $exclude_ids,
			'posts_per_page' => 3,
			'paged' => 1,
		);
	}

	$query = new WP_Query( $args );
	if ( $query->have_posts() ) {
		get_template_part( 'templates/post/related/loop-post-related', 'start' );
		while ( $query->have_posts() ) {
			$query->the_post();
			get_template_part( 'templates/post/related/loop-post-related', 'content' );
		}
		wp_reset_postdata();
		get_template_part( 'templates/post/related/loop-post-related', 'end' );
	}
}


/**
 * Likes ajax callback ( used in Single Post )
 */
function impeka_grve_likes_callback( $post_id ) {

	$likes = 0;
	$status = "";

	if ( isset( $_POST['grve_likes_id'] ) ) {
		$post_id = sanitize_text_field( $_POST['grve_likes_id'] );
		$response = impeka_grve_likes( $post_id, 'update' );
	} else {
		$response = array(
			'status' => $status,
			'likes' => $likes,
		);
	}
	wp_send_json( $response );

	die();
}

add_action( 'wp_ajax_impeka_grve_likes_callback', 'impeka_grve_likes_callback' );
add_action( 'wp_ajax_nopriv_impeka_grve_likes_callback', 'impeka_grve_likes_callback' );

function impeka_grve_likes( $post_id, $action = 'text' ) {

	$status = '';

	if( !is_numeric( $post_id ) ) {
		$likes = 0;
	} else {
		$likes = get_post_meta( $post_id, '_impeka_grve_likes', true );
	}

	if( !$likes || !is_numeric( $likes ) ) {
		$likes = 0;
	}

	if ( 'update' == $action ) {

		if( is_numeric( $post_id ) ) {
			if ( isset( $_COOKIE['_impeka_grve_likes_' . $post_id] ) ) {
				unset( $_COOKIE['_impeka_grve_likes_' . $post_id] );

				if ( version_compare( phpversion(), '8.0', '<' ) ) {
					setcookie( '_impeka_grve_likes_' . $post_id, NULL, 1, '/' );
				} else {
					$arr_cookie_options = array (
						'expires' => 1,
						'path' => '/',
						'secure' => false,     // or false
						'httponly' => false,    // or false
						'samesite' => 'Lax' // None || Lax  || Strict
					);
					setcookie('_impeka_grve_likes_' . $post_id, NULL, $arr_cookie_options);
				}
				if( 0 != $likes ) {
					$likes--;
					update_post_meta( $post_id, '_impeka_grve_likes', $likes );
				}

			} else {
				$likes++;
				update_post_meta( $post_id, '_impeka_grve_likes', $likes );
				if ( version_compare( phpversion(), '8.0', '<' ) ) {
					setcookie('_impeka_grve_likes_' . $post_id, $post_id, strtotime("+1 year"), '/');
				} else {
					$arr_cookie_options = array (
						'expires' => strtotime("+1 year"),
						'path' => '/',
						'secure' => false,     // or false
						'httponly' => false,    // or false
						'samesite' => 'Lax' // None || Lax  || Strict
					);
					setcookie('_impeka_grve_likes_' . $post_id, $post_id, $arr_cookie_options);
				}
				$status = 'active';
			}
		}

		return $response = array(
			'status' => $status,
			'likes' => $likes,
		);

	} elseif ( 'status' == $action ) {
		if( is_numeric( $post_id ) ) {
			if ( isset( $_COOKIE['_impeka_grve_likes_' . $post_id] ) && 0 != $likes) {
				$status = 'active';
			}
		}
		return $status;
	} elseif ( 'number' == $action ) {
		return $likes;
	}

	return impeka_grve_likes_text( $likes );
}

function impeka_grve_likes_text( $number ) {
	if ( $number > 1 ) {
		$output = sprintf( _n( '%s Like', '%s Likes', $number, 'impeka' ), number_format_i18n( $number ) );
	} elseif ( $number == 0 ) {
		$output = esc_html__( 'No Likes', 'impeka' );
	} else { // must be one
		$output = esc_html__( '1 Like', 'impeka'  );
	}
	return apply_filters( 'impeka_grve_likes_text', $output, $number );
}

/**
 * Prints post structured data
 */
if ( !function_exists( 'impeka_grve_print_post_structured_data' ) ) {
	function impeka_grve_print_post_structured_data( $args = array() ) {

		if ( has_post_thumbnail() ) {
			$url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full') ;
			$image_url = $url[0];
			$image_width = $url[1];
			$image_height = $url[2];

		} else {
			$image_url = get_template_directory_uri() . '/images/empty/thumbnail.jpg';
			$image_width = 150;
			$image_height = 150;
		}
	?>
		<span class="grve-hidden">
			<span class="grve-structured-data" itemprop="image" itemscope itemtype="http://schema.org/ImageObject">
			   <span itemprop='url' ><?php echo esc_url( $image_url ); ?></span>
			   <span itemprop='height' ><?php echo esc_html( $image_width ); ?></span>
			   <span itemprop='width' ><?php echo esc_html( $image_height ); ?></span>
			</span>
			<?php if ( impeka_grve_visibility( 'blog_author_visibility', '1' ) ) { ?>
			<span class="grve-structured-data" itemprop="author" itemscope itemtype="http://schema.org/Person">
				<span itemprop="name"><?php the_author(); ?></span>
			</span>
			<span class="grve-structured-data" itemprop="publisher" itemscope itemtype="http://schema.org/Organization">
				<span itemprop='name'><?php the_author(); ?></span>
				<span itemprop='logo' itemscope itemtype='http://schema.org/ImageObject'>
					<span itemprop='url'><?php echo esc_url( get_avatar_url( get_the_author_meta( 'ID' ) ) ); ?></span>
				</span>
			</span>
			<?php } else { ?>
			<span class="grve-structured-data" itemprop="author" itemscope itemtype="http://schema.org/Person">
				<span itemprop="name"><?php echo esc_html( get_bloginfo( 'name' ) ); ?></span>
			</span>
			<span class="grve-structured-data" itemprop="publisher" itemscope itemtype="http://schema.org/Organization">
				<span itemprop='name'><?php echo esc_html( get_bloginfo( 'name' ) ); ?></span>
				<span itemprop='logo' itemscope itemtype='http://schema.org/ImageObject'>
					<span itemprop='url'><?php echo esc_url( $image_url ); ?></span>
				</span>
			</span>
			<?php } ?>
			<time class="grve-structured-data" itemprop="datePublished" datetime="<?php echo get_the_time('c'); ?>"><?php echo get_the_date(); ?></time>
			<time class="grve-structured-data" itemprop="dateModified"  datetime="<?php echo get_the_modified_time('c'); ?>"><?php echo get_the_modified_date(); ?></time>
			<span class="grve-structured-data" itemprop="mainEntityOfPage" itemscope itemtype="http://schema.org/WebPage" itemid="<?php echo esc_url( get_permalink() ); ?>"></span>
		</span>
	<?php
	}
}


//Omit closing PHP tag to avoid accidental whitespace output errors.
