<?php
/**
 *  Add Dynamic css to header
 *  @version	1.0
 *  @author		Greatives Team
 *  @URI		https://greatives.eu
 */

if ( !function_exists( 'impeka_grve_load_dynamic_css' ) ) {
	function impeka_grve_load_dynamic_css() {

		impeka_grve_dynamic_singular_css();

 		if (  1 == impeka_grve_option( 'css_generation' ) && !is_customize_preview() ) {
			if ( ! file_exists( impeka_grve_get_css_file_path() ) ) {
				impeka_grve_generate_dynamic_css_file();
			}
			wp_enqueue_style( 'impeka-dynamic', impeka_grve_get_css_file_url() , null );
		} else {
			impeka_grve_dynamic_options_css( 'inline' );
		}
	}
}

if ( !function_exists( 'impeka_grve_dynamic_options_css' ) ) {

	function impeka_grve_dynamic_options_css( $mode = '' ) {
		$css = "";
		//CSS Templates
		$css .= impeka_grve_get_css_template( 'grve-dynamic-typography-css');
		$css .= impeka_grve_get_css_template( 'grve-dynamic-options-css');
		if ( empty( $mode ) || impeka_grve_woocommerce_enabled() ) {
			$css .= impeka_grve_get_css_template( 'grve-dynamic-woo-css');
		}
		if ( empty( $mode ) || impeka_grve_events_calendar_enabled() ) {
			$css .= impeka_grve_get_css_template( 'grve-dynamic-event-css');
		}
		if ( empty( $mode ) || impeka_grve_bbpress_enabled() ) {
			$css .= impeka_grve_get_css_template( 'grve-dynamic-bbpress-css');
		}

		//Custom Button Style
		$css .= impeka_grve_get_general_button_style();
		$css .= impeka_grve_get_general_shape_style();

		//Custom CSS
		$css .= impeka_grve_option( 'css_code' );

		if( 'inline' == $mode ) {
			wp_add_inline_style( 'impeka-theme-style', impeka_grve_compress_css( $css ) );
		} else {
			return impeka_grve_compress_css( $css );
		}

	}
}

 /**
 * Load custom dynamic css from posts and taxonomies
 */
if ( !function_exists( 'impeka_grve_dynamic_singular_css' ) ) {

	function impeka_grve_dynamic_singular_css() {

		$css = '';
		$css .= impeka_grve_shop_css();
		if( class_exists( 'WPBakeryShortCode' ) ) {
			$css .= impeka_grve_get_all_area_item_custom_css();
		}
		$css .= impeka_grve_get_css_template( 'grve-dynamic-singular-css' );
		$css .= impeka_grve_add_custom_page_css();
		if ( ! empty( $css ) ) {
			wp_add_inline_style( 'impeka-theme-style', impeka_grve_compress_css( $css ) );
		}
	}
}

 /**
 * Get color array used in theme from theme options and predefined colors
 */
function impeka_grve_get_color_array() {
	return array(
		'primary-1' => impeka_grve_option( 'body_primary_1_color' ),
		'primary-2' => impeka_grve_option( 'body_primary_2_color' ),
		'primary-3' => impeka_grve_option( 'body_primary_3_color' ),
		'primary-4' => impeka_grve_option( 'body_primary_4_color' ),
		'primary-5' => impeka_grve_option( 'body_primary_5_color' ),
		'primary-6' => impeka_grve_option( 'body_primary_6_color' ),
		'dark' => '#000000',
		'black' => '#000000',
		'light' => '#ffffff',
		'white' => '#ffffff',
		'green' => '#6ECA09',
		'red' => '#D0021B',
		'orange' => '#FAB901',
		'aqua' => '#28d2dc',
		'blue' => '#71CCF6',
		'purple' => '#7639e2',
		'grey' => '#ECEFF4',
		'dark-grey' => '#1D2024',
		'light-grey' => '#F6F7FA',
		'inherit' => 'inherit',
	);
}
function impeka_grve_get_gradient_color_array() {
	return array(
		'gradient-1' => array(
			'first' => impeka_grve_option( 'body_gradient_1_1_color' ),
			'second' => impeka_grve_option( 'body_gradient_1_2_color' ),
		),
		'gradient-2' => array(
			'first' => impeka_grve_option( 'body_gradient_2_1_color' ),
			'second' => impeka_grve_option( 'body_gradient_2_2_color' ),
		),
		'gradient-3' => array(
			'first' => impeka_grve_option( 'body_gradient_3_1_color' ),
			'second' => impeka_grve_option( 'body_gradient_3_2_color' ),
		),

	);
}

function impeka_grve_add_custom_page_css( $id = null ) {

	$custom_css = '';
	$is_woo_shop = impeka_grve_is_woo_shop();

	if ( is_front_page() && is_home() ) {
		// Default homepage
		$mode = 'blog';
	} else if ( is_front_page() ) {
		// static homepage
		$mode = 'page';
	} else if ( is_home() ) {
		// blog page
		$mode = 'blog';
	} else if ( is_search() ) {
		$mode = 'search_page';
	} else if ( impeka_grve_is_bbpress() ) {
		$mode = 'forum';
	} else if ( is_singular() || $is_woo_shop ) {
		if ( is_singular( 'post' ) ) {
			$mode = 'post';
		} else if ( is_singular( 'portfolio' ) ) {
			$mode = 'portfolio';
		} else if ( is_singular( 'product' ) ) {
			$mode = 'product';
		} else if ( is_singular( 'tribe_events' ) ) {
			$mode = 'event';
		} else if ( is_singular( 'tribe_organizer' ) || is_singular( 'tribe_venue' ) ) {
			$mode = 'event_tax';
		} else {
			$mode = 'page';
		}
	} else if ( is_archive() ) {
		if( impeka_grve_is_woo_tax() ) {
			$mode = 'product_tax';
		} else if ( impeka_grve_events_calendar_is_overview() || is_post_type_archive( 'tribe_events' ) ) {
			$mode = 'event_tax';
		} else if ( is_post_type_archive( 'portfolio' ) || is_tax( 'portfolio_category' ) || is_tax( 'portfolio_field' ) ) {
			$mode = 'portfolio_tax';
		} else {
			$mode = 'blog';
		}

	} else {
		$mode = 'page';
	}

	$page_title = array(
		'bg_color' => impeka_grve_option( $mode . '_title_bg_color', 'black' ),
		'bg_color_custom' => impeka_grve_option( $mode . '_title_bg_color_custom', '#000000' ),
		'content_bg_color' => impeka_grve_option( $mode . '_title_content_bg_color', 'none' ),
		'content_bg_color_custom' => impeka_grve_option( $mode . '_title_content_bg_color_custom', '#ffffff' ),
		'title_color' => impeka_grve_option( $mode . '_title_color', 'white' ),
		'title_color_custom' => impeka_grve_option( $mode . '_title_color_custom', '#ffffff' ),
		'caption_color' => impeka_grve_option( $mode . '_description_color', 'white' ),
		'caption_color_custom' => impeka_grve_option( $mode . '_description_color_custom', '#ffffff' ),
	);

	if ( is_tag() || is_category() || impeka_grve_is_woo_category() || impeka_grve_is_woo_tag() || is_tax('portfolio_category') || is_tax('portfolio_field')  ) {
		$category_id = get_queried_object_id();
		$custom_title_options = impeka_grve_get_term_meta( $category_id, '_impeka_grve_custom_title_options' );
		$page_title_custom = impeka_grve_array_value( $custom_title_options, 'custom' );
		if ( 'custom' == $page_title_custom ) {
			$page_title = $custom_title_options;
		}
	}


	if ( is_singular() || $is_woo_shop ) {

		if ( ! $id ) {
			if ( $is_woo_shop ) {
				$id = wc_get_page_id( 'shop' );
			} else {
				$id = get_the_ID();
			}
		}
		if ( $id ) {

			//Custom Title
			$custom_title_options = get_post_meta( $id, '_impeka_grve_custom_title_options', true );
			$page_title_custom = impeka_grve_array_value( $custom_title_options, 'custom' );
			if ( !empty( $page_title_custom ) ) {
				$page_title = $custom_title_options;
			}

			//Feature Section
			$feature_section = get_post_meta( $id, '_impeka_grve_feature_section', true );
			$feature_settings = impeka_grve_array_value( $feature_section, 'feature_settings' );
			$feature_element = impeka_grve_array_value( $feature_settings, 'element' );

			if ( !empty( $feature_element ) ) {

				switch( $feature_element ) {

					case 'title':
					case 'image':
					case 'video':
						$single_item = impeka_grve_array_value( $feature_section, 'single_item' );
						if ( !empty( $single_item ) ) {
							$custom_css .= impeka_grve_get_feature_title_css( $single_item );
						}
						break;
					case 'slider':
						$slider_items = impeka_grve_array_value( $feature_section, 'slider_items' );
						if ( !empty( $slider_items ) ) {
							foreach ( $slider_items as $item ) {
								$custom_css .= impeka_grve_get_feature_title_css( $item, 'slider' );
							}
						}
						break;
					case 'posts-slider-style-1':
					case 'posts-slider-style-2':
					case 'posts-slider-style-3':
					case 'posts-slider-style-4':
						$single_item = impeka_grve_array_value( $feature_section, 'post_type_slider_settings' );
						if ( !empty( $single_item ) ) {
							$custom_css .= impeka_grve_get_feature_title_css( $single_item );
							$custom_css .= impeka_grve_get_feature_go_to_section_css( $single_item );
						}
						break;
					default:
						break;

				}
			}
		}
	}

	$custom_css .= impeka_grve_get_title_css( $page_title );

	return $custom_css ;
}

function impeka_grve_get_feature_title_css( $item, $type = 'single' ) {

	$custom_css = '';
	$custom_class = '';

	if( 'slider' == $type ) {
		$id = impeka_grve_array_value( $item, 'id' );
		if ( !empty( $id ) ) {
			$custom_class = ' .grve-slider-item-id-' . $id ;
		}
	}

	$content_bg_color = impeka_grve_array_value( $item, 'content_bg_color', 'none' );
	if ( 'custom' == $content_bg_color ) {
		$content_bg_color_custom = impeka_grve_array_value( $item, 'content_bg_color_custom', '#ffffff' );
		$custom_css .= '#grve-feature-section' . esc_attr( $custom_class ) . ' .grve-title-content-wrapper {';
		$custom_css .= impeka_grve_get_css_color( 'background-color', $content_bg_color_custom );
		$custom_css .= '}';
	}

	$subheading_color = impeka_grve_array_value( $item, 'subheading_color', 'white' );
	if ( 'custom' == $subheading_color ) {
		$subheading_color_custom = impeka_grve_array_value( $item, 'subheading_color_custom', '#ffffff' );
		$custom_css .= '#grve-feature-section' . esc_attr( $custom_class ) . ' .grve-subheading, #grve-feature-section' . esc_attr( $custom_class ) . ' .grve-title-meta {';
		$custom_css .= impeka_grve_get_css_color( 'color', $subheading_color_custom );
		$custom_css .= '}';
	}

	$title_color = impeka_grve_array_value( $item, 'title_color', 'white' );
	if ( 'custom' == $title_color ) {
		$title_color_custom = impeka_grve_array_value( $item, 'title_color_custom', '#ffffff' );
		$custom_css .= '#grve-feature-section' . esc_attr( $custom_class ) . ' .grve-title {';
		$custom_css .= impeka_grve_get_css_color( 'color', $title_color_custom );
		$custom_css .= '}';
	}

	$caption_color = impeka_grve_array_value( $item, 'caption_color', 'white' );
	if ( 'custom' == $caption_color ) {
		$caption_color_custom = impeka_grve_array_value( $item, 'caption_color_custom', '#ffffff' );
		$custom_css .= '#grve-feature-section' . esc_attr( $custom_class ) . ',';
		$custom_css .= '#grve-feature-section' . esc_attr( $custom_class ) . ' .grve-description {';
		$custom_css .= impeka_grve_get_css_color( 'color', $caption_color_custom );
		$custom_css .= '}';
	}

	$media_id = impeka_grve_array_value( $item, 'content_image_id', '0' );
	$media_max_height = impeka_grve_array_value( $item, 'content_image_max_height', '150' );
	$media_responsive_max_height = impeka_grve_array_value( $item, 'content_image_responsive_max_height', '50' );

	if( '0' != $media_id ) {
		$custom_css .= '#grve-feature-section' . esc_attr( $custom_class ) . ' .grve-content .grve-graphic img  {';
		$custom_css .= 'max-height:' . esc_attr( $media_max_height ) .'px';
		$custom_css .= '}';

		$custom_css .= '@media only screen and (max-width: 768px) {';
		$custom_css .= '#grve-feature-section' . esc_attr( $custom_class ) . ' .grve-content .grve-graphic img  {';
		$custom_css .= 'max-height:' . esc_attr( $media_responsive_max_height ) .'px';
		$custom_css .= '}';
		$custom_css .= '}';
	}

	return $custom_css;

}

function impeka_grve_get_feature_go_to_section_css( $item, $type = 'single' ) {

	$custom_css = '';
	$custom_class = '';

	if( 'slider' == $type ) {
		$id = impeka_grve_array_value( $item, 'id' );
		if ( !empty( $id ) ) {
			$custom_class = ' .grve-slider-item-id-' . $id ;
		}
	}

	$arrow_color = impeka_grve_array_value( $item, 'arrow_color', 'white' );
	if ( 'custom' == $arrow_color ) {
		$arrow_color_custom = impeka_grve_array_value( $item, 'arrow_color_custom', '#ffffff' );
		$custom_css .= '#grve-feature-section' . esc_attr( $custom_class ) . ' .grve-scroll-down {';
		$custom_css .= impeka_grve_get_css_color( 'color', $arrow_color_custom );
		$custom_css .= impeka_grve_get_css_color( 'fill', $arrow_color_custom );
		$custom_css .= '}';
	}

	return $custom_css;

}

function impeka_grve_get_title_css( $title ) {
	$custom_css = '';

	$bg_color = impeka_grve_array_value( $title, 'bg_color', 'black' );
	if ( 'custom' == $bg_color ) {
		$bg_color_custom = impeka_grve_array_value( $title, 'bg_color_custom', '#000000' );
		$custom_css .= '.grve-title-section {';
		$custom_css .= impeka_grve_get_css_color( 'background-color', $bg_color_custom );
		$custom_css .= '}';
	}

	$content_bg_color = impeka_grve_array_value( $title, 'content_bg_color', 'none' );
	if ( 'custom' == $content_bg_color ) {
		$content_bg_color_custom = impeka_grve_array_value( $title, 'content_bg_color_custom', '#ffffff' );
		$custom_css .= '.grve-title-section .grve-title-content-wrapper {';
		$custom_css .= impeka_grve_get_css_color( 'background-color', $content_bg_color_custom );
		$custom_css .= '}';
	}

	$subheading_color = impeka_grve_array_value( $title, 'subheading_color', 'white' );
	if ( 'custom' == $subheading_color ) {
		$subheading_color_custom = impeka_grve_array_value( $title, 'subheading_color_custom', '#ffffff' );
		$custom_css .= '.grve-title-section .grve-title-categories, .grve-title-section .grve-title-meta {';
		$custom_css .= impeka_grve_get_css_color( 'color', $subheading_color_custom );
		$custom_css .= '}';
	}

	$title_color = impeka_grve_array_value( $title, 'title_color', 'white' );
	if ( 'custom' == $title_color ) {
		$title_color_custom = impeka_grve_array_value( $title, 'title_color_custom', '#ffffff' );
		$custom_css .= '.grve-title-section .grve-title, .grve-title-section .grve-title-meta {';
		$custom_css .= impeka_grve_get_css_color( 'color', $title_color_custom );
		$custom_css .= '}';
	}

	$caption_color = impeka_grve_array_value( $title, 'caption_color', 'white' );
	if ( 'custom' == $caption_color ) {
		$caption_color_custom = impeka_grve_array_value( $title, 'caption_color_custom', '#ffffff' );
		$custom_css .= '.grve-title-section .grve-description {';
		$custom_css .= impeka_grve_get_css_color( 'color', $caption_color_custom );
		$custom_css .= '}';
	}

	return $custom_css;
}

 /**
 * Get Button classes
 */
function impeka_grve_get_button_classes() {
	$classes = array(
		'#grve-sliding-area input[type="submit"]:not(.grve-custom-btn)',
		'#grve-theme-wrapper .wpcf7 input[type="submit"]:not(.grve-custom-btn)',
		'#grve-theme-wrapper .grve-btn-theme-style button:not(.grve-custom-btn)',
		'#grve-theme-wrapper .grve-btn-theme-style input[type="button"]:not(.grve-custom-btn)',
		'#grve-theme-wrapper .grve-btn-theme-style input[type="submit"]:not(.grve-custom-btn)',
		'#grve-theme-wrapper .grve-btn-theme-style input[type="reset"]:not(.grve-custom-btn)',
		'#grve-comment-submit-button',
		'#grve-theme-wrapper .woocommerce .checkout-button',
		'#grve-theme-wrapper .woocommerce .woocommerce-cart-form button[name="update_cart"]',
		'#grve-theme-wrapper .woocommerce .woocommerce-checkout-payment button',
		'#grve-woo-review-submit',
		'.grve-portfolio-details-btn.grve-btn:not(.grve-custom-btn)',
		'.post-password-form input[type="submit"]',
		'.gform_wrapper input[type="button"]',
		'.gform_wrapper input[type="submit"]',
		'.gform_wrapper input[type="reset"]',
		'#tribe-bar-form .tribe-bar-submit input[type=submit]',
		'.bbp-submit-wrapper button',
		'#bbpress-forums #bbp_search_submit',
		'#grve-my-account-wrapper .woocommerce-button',
		'.woocommerce-account .woocommerce-MyAccount-content button[type="submit"]',
		'.wp-block-search .wp-block-search__button'
	);

	return apply_filters( 'impeka_grve_button_classes', $classes );
}

function impeka_grve_get_button_hover_classes() {
	$array = impeka_grve_get_button_classes();
	foreach ($array as &$value){
	    $value .= ':hover';
	}

	return $array;
}

function impeka_grve_get_general_button_style() {

	$custom_css = "";

	$button_type = impeka_grve_option( 'button_type', 'simple' );
	$button_shape = impeka_grve_option( 'button_shape', 'square' );
	$button_color = impeka_grve_option( 'button_color', 'primary-1' );
	$button_hover_color = impeka_grve_option( 'button_hover_color', 'black' );
	$button_padding_top = impeka_grve_option(  'button_spacing', '', 'padding-top'  );
	$button_padding_left = impeka_grve_option(  'button_spacing', '', 'padding-left'  );

	$color_array = impeka_grve_get_color_array();

	$custom_css .= implode( ',', impeka_grve_get_button_classes() ) . "{";
	$custom_css .= "
		display: inline-block;
		padding: 1.250em 2.500em;
		min-width: 11.250em;
		line-height: 1.4;
		position: relative;
		-webkit-border-radius: 0;
		border-radius: 0;
		z-index: 2;
		vertical-align: top;
		outline: 0;
		text-align: center;
		cursor: pointer;
		border: 1px solid transparent;
		box-sizing: border-box;
		word-wrap: break-word;
		-webkit-appearance: none;
		-webkit-user-select: none;
		-moz-user-select: none;
		-ms-user-select: none;
		user-select: none;
		text-decoration: none;
		position: relative;
		overflow: hidden;
		-webkit-transition : color .5s ease, background-color .5s ease, border-color .5s ease;
		-moz-transition    : color .5s ease, background-color .5s ease, border-color .5s ease;
		-o-transition      : color .5s ease, background-color .5s ease, border-color .5s ease;
		-ms-transition     : color .5s ease, background-color .5s ease, border-color .5s ease;
		transition         : color .5s ease, background-color .5s ease, border-color .5s ease;
		-ms-touch-action: manipulation;
		touch-action: manipulation;
	";

	$custom_css .= "padding: " . esc_attr( $button_padding_top ) . " " . esc_attr( $button_padding_left ) . ";";

	switch( $button_shape ) {
			case "round":
				$custom_css .= "-webkit-border-radius: 3px;";
				$custom_css .= "border-radius: 3px;";
			break;
			case "extra-round":
				$custom_css .= "-webkit-border-radius: 50px;";
				$custom_css .= "border-radius: 50px;";
			break;
			case "square":
			default:
			break;
		}

		$default_color = impeka_grve_option( 'body_primary_1_color' );
		$color = impeka_grve_array_value( $color_array, $button_color, $default_color );

		if ( "outline" == $button_type ) {

			$custom_css .= "border: 2px solid;";
			$custom_css .= "background-color: transparent;";
			$custom_css .= "border-color: " . esc_attr( $color ) . ";";
			$custom_css .= "color: " . esc_attr( $color ) . ";";

		} else {
			$custom_css .= "background-color: " . esc_attr( $color ) . ";";
			if ( 'white' == $button_color ) {
				$custom_css .= "color: #bababa;";
			} else {
				$custom_css .= "color: #ffffff;";
			}
		}

	$custom_css .= "}";

	$custom_css .= implode( ',', impeka_grve_get_button_hover_classes() ) . "{";
	$hover_color = impeka_grve_array_value( $color_array, $button_hover_color, "#bababa" );

	if ( "outline" == $button_type ) {

		$custom_css .= "background-color: " . esc_attr( $hover_color ) . ";";
		$custom_css .= "border-color: " . esc_attr( $hover_color ) . ";";
		if ( 'white' == $button_hover_color ) {
			$custom_css .= "color: #bababa;";
		} else {
			$custom_css .= "color: #ffffff;";
		}

	} else {
		$custom_css .= "background-color: " . esc_attr( $hover_color ) . ";";
		if ( 'white' == $button_hover_color ) {
			$custom_css .= "color: #bababa;";
		} else {
			$custom_css .= "color: #ffffff;";
		}
	}

	$custom_css .= "}";

	return $custom_css;
}


function impeka_grve_get_general_shape_style() {
	$custom_css = "";

	$shape = impeka_grve_option( 'button_shape', 'square' );

	$custom_css .= ".grve-dropcap span.grve-style-2, .grve-menu-type-button > a .grve-item, .grve-menu-type-outline > a .grve-item, .woocommerce .single_add_to_cart_button, .woocommerce .quantity {";
	switch( $shape ) {
		case "round":
			$custom_css .= "-webkit-border-radius: 3px !important;";
			$custom_css .= "border-radius: 3px !important;";
		break;
		case "extra-round":
			$custom_css .= "-webkit-border-radius: 50px !important;";
			$custom_css .= "border-radius: 50px !important;";
		break;
		case "square":
		default:
		break;
	}
	$custom_css .= "}";

	return $custom_css;

}

function impeka_grve_get_background_css( $value = array() ) {

	$css = '';

	if ( ! empty( $value ) && is_array( $value ) ) {
		foreach ( $value as $key => $value ) {
			if ( ! empty( $value ) && strpos($key, 'background-') === 0 ) {
				if ( $key == "background-image" ) {
					$css .= $key . ":url('" . $value . "');";
				} else {
					$css .= $key . ":" . $value . ";";
				}
			}
		}
	}

	return $css;
}

 /**
 * Add dynamic CSS for Page Builder
 */
function impeka_grve_load_dynamic_selector_css() {

	$css = '';

	$colors = impeka_grve_get_color_array();
	foreach ( $colors as $key => $value ) {
		$font_color = '#ffffff';
		if( 'white' == $key || 'light' == $key || 'light-grey' == $key || 'inherit' == $key  ) {
			$font_color = '#000000';
		}
		$css .= "
			.grve-colored-dropdown ." . esc_attr( $key ) . " {
				background-color: " . esc_attr( $value ) . ";
				border-color: " . esc_attr( $value ) . ";
				color: " . esc_attr( $font_color ) . ";
			}
			.grve-colored-dropdown .default {
				background-color: #F8F7FB;
				border-color: #E8E7EF;
				color: #32373c;
			}
		";
	}
	wp_add_inline_style( 'impeka-wpb-ext-elements', impeka_grve_compress_css( $css ) );

}
add_action( 'admin_enqueue_scripts' , 'impeka_grve_load_dynamic_selector_css', 11 );

//Omit closing PHP tag to avoid accidental whitespace output errors.
