<?php

/*
 *	Excerpt functions
 *
 * 	@version	1.0
 * 	@author		Greatives Team
 * 	@URI		https://greatives.eu
 */


 /**
 * Custom excerpt
 */
if ( !function_exists('impeka_grve_excerpt') ) {
	function impeka_grve_excerpt( $limit, $more = '', $more_text = '' ) {
		$post_id = get_the_ID();
		$post = get_post( $post_id );
		$excerpt = "";

		if ( has_excerpt( $post_id ) ) {
			if ( 0 != $limit ) {
				$excerpt = $post->post_excerpt;
				$excerpt = apply_filters('the_excerpt', $excerpt);
				$excerpt = strip_tags( strip_shortcodes( $excerpt ) );
				if ( 'product' == get_post_type( $post_id ) ) {
					$excerpt = wp_trim_words( $excerpt, $limit );
				}
				$excerpt = '<p>' . $excerpt  . '</p>';
			}
		} else {
			if ( 0 != $limit ) {
				$content = get_the_content('');
				$content = preg_replace("~(?:\[/?)[^/\]]+/?\]~s", '', $content);
				$content = preg_replace( '~http(s)?://[^\s]*~i', '', $content ); // removes URLs
				$content = strip_tags( strip_shortcodes( $content ) );
				$content = excerpt_remove_blocks( $content );				
				$excerpt = '<p>' . wp_trim_words( $content, $limit ) . '</p>';
			}
		}
		if ( impeka_grve_is_enabled( $more ) ) {
			$excerpt .= impeka_grve_read_more( $post_id, $more_text );
		}
		return	$excerpt;
	}
}

 /**
 * Post Slider excerpt
 */
if ( !function_exists('impeka_grve_post_slider_excerpt') ) {
	function impeka_grve_post_slider_excerpt( $post_id, $limit, $more = '', $more_text = '' ) {
		$post = get_post( $post_id );
		$excerpt = "";

		if ( has_excerpt( $post_id ) ) {
			if ( 0 != $limit ) {
				$excerpt = $post->post_excerpt;
				$excerpt = apply_filters('the_excerpt', $excerpt);
				$excerpt = strip_tags( strip_shortcodes( $excerpt ) );
				$excerpt = wp_trim_words( $excerpt, $limit );
			}
		} else {
			if ( 0 != $limit ) {
				$content = get_the_content('');
				$content = preg_replace("~(?:\[/?)[^/\]]+/?\]~s", '', $content);
				$content = preg_replace( '~http(s)?://[^\s]*~i', '', $content ); // removes URLs
				$content = strip_tags( strip_shortcodes( $content ) );
				$content = excerpt_remove_blocks( $content );
				$excerpt = wp_trim_words( $content, $limit );
			}
		}
		if ( impeka_grve_is_enabled( $more ) ) {
			$excerpt .= impeka_grve_read_more( $post_id, $more_text );
		}
		return	$excerpt;
	}
}

if ( !function_exists('impeka_grve_excerpt_quick_view') ) {
	function impeka_grve_excerpt_quick_view( $post_id, $limit = '40'  ) {
		$post = get_post( $post_id );
		$excerpt = "";

		if ( has_excerpt( $post_id ) ) {
			if ( 0 != $limit ) {
				$excerpt = $post->post_excerpt;
				$excerpt = apply_filters('the_excerpt', $excerpt);
				$excerpt = strip_tags( strip_shortcodes( $excerpt ) );
			}
		}
		return	$excerpt;
	}
}

if ( !function_exists('impeka_grve_quote_excerpt') ) {
	function impeka_grve_quote_excerpt( $limit = '' ) {
		$excerpt = "";

		$content = impeka_grve_post_meta( '_impeka_grve_post_quote_text' );
		$excerpt = '<p class="grve-quote-text">' . wp_kses_post( $content ) . '</p>';

		return	$excerpt;
	}
}

 /**
 * Custom more
 */
if ( !function_exists('impeka_grve_read_more') ) {
	function impeka_grve_read_more( $post_id = "", $more_text = '' ) {
		$icon = impeka_grve_get_svg_icon( 'arrow-2');
		if ( empty( $post_id ) ) {
			$post_id = get_the_ID();
		}
		if ( empty( $more_text ) ) {
			$more_text = esc_html__( 'read more', 'impeka' );
		}
		$more_button = '<a class="grve-read-more grve-link-text" href="' . esc_url( get_permalink( $post_id ) ) . '">';
		$more_button .= '<span>' . esc_html( $more_text ) . '</span>';
		$more_button .= $icon;
		$more_button .= '</a>';
		return $more_button;
	}
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
