<?php

/*
*	Global Parameter and functions
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/


function impeka_grve_set_global_params() {

	if ( !is_admin() ) {

		$params = array();
		/**
		 * top_bar_language_modal
		 * top_bar_left_language_modal
		 * top_bar_right_language_modal
		 * top_bar_search_modal
		 * top_bar_left_search_modal
		 * top_bar_left_form_modal
		 * top_bar_right_search_modal
		 * top_bar_right_form_modal
		 */
		$params = impeka_grve_get_top_bar_global_params( $params );
		/**
		 * header_title_visibility
		 * header_social_modal
		 * header_language_modal
		 * header_form_modal
		 * header_search_modal
		 * header_overlapping
		 * header_position
		 * header_skin
		 * responsive_header_overlapping
		 * header_group
		 * header_style
		 * header_visibility
		 * header_menu_visibility
		 * header_main_navigation_menu
		 * header_second_menu_visibility
		 * header_second_navigation_menu
		 * header_responsive_menu_visibility
		 * header_responsive_navigation_menu
		 * anchor_visibility
		 * anchor_id
		 * anchor_device_layout
		 */
		$params = impeka_grve_get_header_global_params( $params );
		/**
		 * sidearea_visibility
		 * sidearea_id
		 * sidearea_icon_style
		 */
		$params = impeka_grve_get_sidearea_global_params( $params );
		/**
		 * safebutton_visibility
		 * safebutton_id
		 */
		$params = impeka_grve_get_safebutton_global_params( $params );
		/**
		 * sidebar_visibility
		 * sidebar_extra_content
		 * sidebar_details
		 * sidebar_fixed
		 * sidebar_layout
		 * sidebar_id
		 */
		$params = impeka_grve_get_sidebar_global_params( $params );
		/**
		 * bottom_bar_area_visibility
		 * bottom_bar_area_id
		 */
		$params = impeka_grve_get_bottom_bar_global_params( $params );

		$GLOBALS[ 'impeka_grve_global_params' ] = apply_filters( "impkea_grve_global_params", $params );
	}

}
add_action( 'wp', 'impeka_grve_set_global_params' );

$impeka_grve_social_list = array(
	'twitter' => 'Twitter',
	'facebook' => 'Facebook',
	'instagram' => 'Instagram',
	'linkedin' => 'LinkedIn',
	'tumblr' => 'Tumblr',
	'pinterest' => 'Pinterest',
	'github' => 'Github',
	'dribbble' => 'Dribbble',
	'reddit' => 'reddit',
	'flickr' => 'Flickr',
	'skype' => 'Skype',
	'youtube' => 'YouTube',
	'vimeo' => 'Vimeo',
	'soundcloud' => 'SoundCloud',
	'wechat' => 'WeChat',
	'weibo' => 'Weibo',
	'renren' => 'Renren',
	'qq' => 'QQ',
	'xing' => 'XING',
	'rss' => 'RSS',
	'vk' => 'VK',
	'behance' => 'Behance',
	'foursquare' => 'Foursquare',
	'steam' => 'Steam',
	'twitch' => 'Twitch',
	'houzz' => 'Houzz',
	'yelp' => 'Yelp',
	'snapchat' => 'Snapchat',
	'medium' => 'Medium',
	'tripadvisor' => 'TripAdvisor',
	'spotify' => 'Spotify',
	'whatsapp' => 'WhatsApp',
	'telegram' => 'Telegram',
	'mixcloud' => 'Mixcloud',
	'discord' => 'Discord',
	'tiktok' => 'TikTok',
	'patreon' => 'Patreon',
	'mastodon' => 'Mastodon',
);

$impeka_grve_social_list_extended = array (
	'twitter' => array(
		'title' => 'Twitter',
		'url' => 'twitter_url',
		'id' => 'twitter',
		'class' => 'fab fa-twitter',
	),
	'facebook' => array(
		'title' => 'Facebook',
		'url' => 'facebook_url',
		'id' => 'facebook',
		'class' => 'fab fa-facebook-f',
	),
	'instagram' => array(
		'title' => 'Instagram',
		'url' => 'instagram_url',
		'id' => 'instagram',
		'class' => 'fab fa-instagram',
	),
	'linkedin' => array(
		'title' => 'LinkedIn',
		'url' => 'linkedin_url',
		'id' => 'linkedin',
		'class' => 'fab fa-linkedin-in',
	),
	'tumblr' => array(
		'title' => 'Tumblr',
		'url' => 'tumblr_url',
		'id' => 'tumblr',
		'class' => 'fab fa-tumblr',
	),
	'pinterest' => array(
		'title' => 'Pinterest',
		'url' => 'pinterest_url',
		'id' => 'pinterest',
		'class' => 'fab fa-pinterest',
	),
	'github' => array(
		'title' => 'GitHub',
		'url' => 'github_url',
		'id' => 'github',
		'class' => 'fab fa-github',
	),
	'dribbble' => array(
		'title' => 'Dribbble',
		'url' => 'dribbble_url',
		'id' => 'dribbble',
		'class' => 'fab fa-dribbble',
	),
	'reddit' => array(
		'title' => 'reddit',
		'url' => 'reddit_url',
		'id' => 'reddit',
		'class' => 'fab fa-reddit',
	),
	'flickr' => array(
		'title' => 'Flickr',
		'url' => 'flickr_url',
		'id' => 'flickr',
		'class' => 'fab fa-flickr',
	),
	'skype' => array(
		'title' => 'Skype',
		'url' => 'skype_url',
		'id' => 'skype',
		'class' => 'fab fa-skype',
	),
	'youtube' => array(
		'title' => 'YouTube',
		'url' => 'youtube_url',
		'id' => 'youtube',
		'class' => 'fab fa-youtube',
	),
	'vimeo' => array(
		'title' => 'Vimeo',
		'url' => 'vimeo_url',
		'id' => 'vimeo',
		'class' => 'fab fa-vimeo',
	),
	'soundcloud' => array(
		'title' => 'SoundCloud',
		'url' => 'soundcloud_url',
		'id' => 'soundcloud',
		'class' => 'fab fa-soundcloud',
	),
	'wechat' => array(
		'title' => 'WeChat',
		'url' => 'wechat_url',
		'id' => 'wechat',
		'class' => 'fab fa-weixin',
	),
	'weibo' => array(
		'title' => 'Weibo',
		'url' => 'weibo_url',
		'id' => 'weibo',
		'class' => 'fab fa-weibo',
	),
	'renren' => array(
		'title' => 'Renren',
		'url' => 'renren_url',
		'id' => 'renren',
		'class' => 'fab fa-renren',
	),
	'qq' => array(
		'title' => 'QQ',
		'url' => 'qq_url',
		'id' => 'qq',
		'class' => 'fab fa-qq',
	),
	'xing' => array(
		'title' => 'XING',
		'url' => 'xing_url',
		'id' => 'xing',
		'class' => 'fab fa-xing',
	),
	'rss' => array(
		'title' => 'RSS',
		'url' => 'rss_url',
		'id' => 'rss',
		'class' => 'fas fa-rss',
	),
	'vk' => array(
		'title' => 'VK',
		'url' => 'vk_url',
		'id' => 'vk',
		'class' => 'fab fa-vk',
	),
	'behance' => array(
		'title' => 'Behance',
		'url' => 'behance_url',
		'id' => 'behance',
		'class' => 'fab fa-behance',
	),
	'foursquare' => array(
		'title' => 'Foursquare',
		'url' => 'foursquare_url',
		'id' => 'foursquare',
		'class' => 'fab fa-foursquare',
	),
	'steam' => array(
		'title' => 'Steam',
		'url' => 'steam_url',
		'id' => 'steam',
		'class' => 'fab fa-steam',
	),
	'twitch' => array(
		'title' => 'Twitch',
		'url' => 'twitch_url',
		'id' => 'twitch',
		'class' => 'fab fa-twitch',
	),
	'houzz' => array(
		'title' => 'Houzz',
		'url' => 'houzz_url',
		'id' => 'houzz',
		'class' => 'fab fa-houzz',
	),
	'yelp' => array(
		'title' => 'Yelp',
		'url' => 'yelp_url',
		'id' => 'yelp',
		'class' => 'fab fa-yelp',
	),
	'snapchat' => array(
		'title' => 'Snapchat',
		'url' => 'snapchat_url',
		'id' => 'snapchat',
		'class' => 'fab fa-snapchat',
	),
	'medium' => array(
		'title' => 'Medium',
		'url' => 'medium_url',
		'id' => 'medium',
		'class' => 'fab fa-medium',
	),
	'tripadvisor' => array(
		'title' => 'TripAdvisor',
		'url' => 'tripadvisor_url',
		'id' => 'tripadvisor',
		'class' => 'fab fa-tripadvisor',
	),
	'spotify' => array(
		'title' => 'Spotify',
		'url' => 'spotify_url',
		'id' => 'spotify',
		'class' => 'fab fa-spotify',
	),
	'whatsapp' => array(
		'title' => 'WhatsApp',
		'url' => 'whatsapp_url',
		'id' => 'whatsapp',
		'class' => 'fab fa-whatsapp',
	),
	'telegram' => array(
		'title' => 'Telegram',
		'url' => 'telegram_url',
		'id' => 'telegram',
		'class' => 'fab fa-telegram',
	),
	'mixcloud' => array(
		'title' => 'Mixcloud',
		'url' => 'mixcloud_url',
		'id' => 'mixcloud',
		'class' => 'fab fa-mixcloud',
	),
	'discord' => array(
		'title' => 'Discord',
		'url' => 'discord_url',
		'id' => 'discord',
		'class' => 'fab fa-discord',
	),
	'tiktok' => array(
		'title' => 'TikTok',
		'url' => 'tiktok_url',
		'id' => 'tiktok',
		'class' => 'fab fa-tiktok',
	),
	'patreon' => array(
		'title' => 'Patreon',
		'url' => 'patreon_url',
		'id' => 'patreon',
		'class' => 'fab fa-patreon',
	),
	'mastodon' => array(
		'title' => 'Mastodon',
		'url' => 'mastodon_url',
		'id' => 'mastodon',
		'class' => 'fab fa-mastodon',
	),
);

$impeka_grve_awsome_fonts_list = array( "500px", "address-book", "address-book-o", "address-card", "address-card-o", "adjust", "adn", "align-center", "align-justify", "align-left", "align-right", "amazon", "ambulance", "american-sign-language-interpreting", "anchor", "android", "angellist", "angle-double-down", "angle-double-left", "angle-double-right", "angle-double-up", "angle-down", "angle-left", "angle-right", "angle-up", "apple", "archive", "area-chart", "arrow-circle-down", "arrow-circle-left", "arrow-circle-o-down", "arrow-circle-o-left", "arrow-circle-o-right", "arrow-circle-o-up", "arrow-circle-right", "arrow-circle-up", "arrow-down", "arrow-left", "arrow-right", "arrow-up", "arrows", "arrows-alt", "arrows-h", "arrows-v", "asl-interpreting", "assistive-listening-systems", "asterisk", "at", "audio-description", "automobile", "backward", "balance-scale", "ban", "bandcamp", "bank", "bar-chart", "bar-chart-o", "barcode", "bars", "bath", "bathtub", "battery", "battery-0", "battery-1", "battery-2", "battery-3", "battery-4", "battery-empty", "battery-full", "battery-half", "battery-quarter", "battery-three-quarters", "bed", "beer", "behance", "behance-square", "bell", "bell-o", "bell-slash", "bell-slash-o", "bicycle", "binoculars", "birthday-cake", "bitbucket", "bitbucket-square", "bitcoin", "black-tie", "blind", "bluetooth", "bluetooth-b", "bold", "bolt", "bomb", "book", "bookmark", "bookmark-o", "braille", "briefcase", "btc", "bug", "building", "building-o", "bullhorn", "bullseye", "bus", "buysellads", "cab", "calculator", "calendar", "calendar-check-o", "calendar-minus-o", "calendar-o", "calendar-plus-o", "calendar-times-o", "camera", "camera-retro", "car", "caret-down", "caret-left", "caret-right", "caret-square-o-down", "caret-square-o-left", "caret-square-o-right", "caret-square-o-up", "caret-up", "cart-arrow-down", "cart-plus", "cc", "cc-amex", "cc-diners-club", "cc-discover", "cc-jcb", "cc-mastercard", "cc-paypal", "cc-stripe", "cc-visa", "certificate", "chain", "chain-broken", "check", "check-circle", "check-circle-o", "check-square", "check-square-o", "chevron-circle-down", "chevron-circle-left", "chevron-circle-right", "chevron-circle-up", "chevron-down", "chevron-left", "chevron-right", "chevron-up", "child", "chrome", "circle", "circle-o", "circle-o-notch", "circle-thin", "clipboard", "clock-o", "clone", "close", "cloud", "cloud-download", "cloud-upload", "cny", "code", "code-fork", "codepen", "codiepie", "coffee", "cog", "cogs", "columns", "comment", "comment-o", "commenting", "commenting-o", "comments", "comments-o", "compass", "compress", "connectdevelop", "contao", "copy", "copyright", "creative-commons", "credit-card", "credit-card-alt", "crop", "crosshairs", "css3", "cube", "cubes", "cut", "cutlery", "dashboard", "dashcube", "database", "deaf", "deafness", "dedent", "delicious", "desktop", "deviantart", "diamond", "digg", "dollar", "dot-circle-o", "download", "dribbble", "drivers-license", "drivers-license-o", "dropbox", "drupal", "edge", "edit", "eercast", "eject", "ellipsis-h", "ellipsis-v", "empire", "envelope", "envelope-o", "envelope-open", "envelope-open-o", "envelope-square", "envira", "eraser", "etsy", "eur", "euro", "exchange", "exclamation", "exclamation-circle", "exclamation-triangle", "expand", "expeditedssl", "external-link", "external-link-square", "eye", "eye-slash", "eyedropper", "fa", "facebook", "facebook-f", "facebook-official", "facebook-square", "fast-backward", "fast-forward", "fax", "feed", "female", "fighter-jet", "file", "file-archive-o", "file-audio-o", "file-code-o", "file-excel-o", "file-image-o", "file-movie-o", "file-o", "file-pdf-o", "file-photo-o", "file-picture-o", "file-powerpoint-o", "file-sound-o", "file-text", "file-text-o", "file-video-o", "file-word-o", "file-zip-o", "files-o", "film", "filter", "fire", "fire-extinguisher", "firefox", "first-order", "flag", "flag-checkered", "flag-o", "flash", "flask", "flickr", "floppy-o", "folder", "folder-o", "folder-open", "folder-open-o", "font", "font-awesome", "fonticons", "fort-awesome", "forumbee", "forward", "foursquare", "free-code-camp", "frown-o", "futbol-o", "gamepad", "gavel", "gbp", "ge", "gear", "gears", "genderless", "get-pocket", "gg", "gg-circle", "gift", "git", "git-square", "github", "github-alt", "github-square", "gitlab", "gittip", "glass", "glide", "glide-g", "globe", "google", "google-plus", "google-plus-circle", "google-plus-official", "google-plus-square", "google-wallet", "graduation-cap", "gratipay", "grav", "group", "h-square", "hacker-news", "hand-grab-o", "hand-lizard-o", "hand-o-down", "hand-o-left", "hand-o-right", "hand-o-up", "hand-paper-o", "hand-peace-o", "hand-pointer-o", "hand-rock-o", "hand-scissors-o", "hand-spock-o", "hand-stop-o", "handshake-o", "hard-of-hearing", "hashtag", "hdd-o", "header", "headphones", "heart", "heart-o", "heartbeat", "history", "home", "hospital-o", "hotel", "hourglass", "hourglass-1", "hourglass-2", "hourglass-3", "hourglass-end", "hourglass-half", "hourglass-o", "hourglass-start", "houzz", "html5", "i-cursor", "id-badge", "id-card", "id-card-o", "ils", "image", "imdb", "inbox", "indent", "industry", "info", "info-circle", "inr", "instagram", "institution", "internet-explorer", "intersex", "ioxhost", "italic", "joomla", "jpy", "jsfiddle", "key", "keyboard-o", "krw", "language", "laptop", "lastfm", "lastfm-square", "leaf", "leanpub", "legal", "lemon-o", "level-down", "level-up", "life-bouy", "life-buoy", "life-ring", "life-saver", "lightbulb-o", "line-chart", "link", "linkedin", "linkedin-square", "linode", "linux", "list", "list-alt", "list-ol", "list-ul", "location-arrow", "lock", "long-arrow-down", "long-arrow-left", "long-arrow-right", "long-arrow-up", "low-vision", "magic", "magnet", "mail-forward", "mail-reply", "mail-reply-all", "male", "map", "map-marker", "map-o", "map-pin", "map-signs", "mars", "mars-double", "mars-stroke", "mars-stroke-h", "mars-stroke-v", "maxcdn", "meanpath", "medium", "medkit", "meetup", "meh-o", "mercury", "microchip", "microphone", "microphone-slash", "minus", "minus-circle", "minus-square", "minus-square-o", "mixcloud", "mobile", "mobile-phone", "modx", "money", "moon-o", "mortar-board", "motorcycle", "mouse-pointer", "music", "navicon", "neuter", "newspaper-o", "object-group", "object-ungroup", "odnoklassniki", "odnoklassniki-square", "opencart", "openid", "opera", "optin-monster", "outdent", "pagelines", "paint-brush", "paper-plane", "paper-plane-o", "paperclip", "paragraph", "paste", "pause", "pause-circle", "pause-circle-o", "paw", "paypal", "pencil", "pencil-square", "pencil-square-o", "percent", "phone", "phone-square", "photo", "picture-o", "pie-chart", "pied-piper", "pied-piper-alt", "pied-piper-pp", "pinterest", "pinterest-p", "pinterest-square", "plane", "play", "play-circle", "play-circle-o", "plug", "plus", "plus-circle", "plus-square", "plus-square-o", "podcast", "power-off", "print", "product-hunt", "puzzle-piece", "qq", "qrcode", "question", "question-circle", "question-circle-o", "quora", "quote-left", "quote-right", "ra", "random", "ravelry", "rebel", "recycle", "reddit", "reddit-alien", "reddit-square", "refresh", "registered", "remove", "renren", "reorder", "repeat", "reply", "reply-all", "resistance", "retweet", "rmb", "road", "rocket", "rotate-left", "rotate-right", "rouble", "rss", "rss-square", "rub", "ruble", "rupee", "s15", "safari", "save", "scissors", "scribd", "search", "search-minus", "search-plus", "sellsy", "send", "send-o", "server", "share", "share-alt", "share-alt-square", "share-square", "share-square-o", "shekel", "sheqel", "shield", "ship", "shirtsinbulk", "shopping-bag", "shopping-basket", "shopping-cart", "shower", "sign-in", "sign-language", "sign-out", "signal", "signing", "simplybuilt", "sitemap", "skyatlas", "skype", "slack", "sliders", "slideshare", "smile-o", "snapchat", "snapchat-ghost", "snapchat-square", "snowflake-o", "soccer-ball-o", "sort", "sort-alpha-asc", "sort-alpha-desc", "sort-amount-asc", "sort-amount-desc", "sort-asc", "sort-desc", "sort-down", "sort-numeric-asc", "sort-numeric-desc", "sort-up", "soundcloud", "space-shuttle", "spinner", "spoon", "spotify", "square", "square-o", "stack-exchange", "stack-overflow", "star", "star-half", "star-half-empty", "star-half-full", "star-half-o", "star-o", "steam", "steam-square", "step-backward", "step-forward", "stethoscope", "sticky-note", "sticky-note-o", "stop", "stop-circle", "stop-circle-o", "street-view", "strikethrough", "stumbleupon", "stumbleupon-circle", "subscript", "subway", "suitcase", "sun-o", "superpowers", "superscript", "support", "table", "tablet", "tachometer", "tag", "tags", "tasks", "taxi", "telegram", "television", "tencent-weibo", "terminal", "text-height", "text-width", "th", "th-large", "th-list", "themeisle", "thermometer", "thermometer-0", "thermometer-1", "thermometer-2", "thermometer-3", "thermometer-4", "thermometer-empty", "thermometer-full", "thermometer-half", "thermometer-quarter", "thermometer-three-quarters", "thumb-tack", "thumbs-down", "thumbs-o-down", "thumbs-o-up", "thumbs-up", "ticket", "times", "times-circle", "times-circle-o", "times-rectangle", "times-rectangle-o", "tint", "toggle-down", "toggle-left", "toggle-off", "toggle-on", "toggle-right", "toggle-up", "trademark", "train", "transgender", "transgender-alt", "trash", "trash-o", "tree", "trello", "tripadvisor", "trophy", "truck", "try", "tty", "tumblr", "tumblr-square", "turkish-lira", "tv", "twitch", "twitter", "twitter-square", "umbrella", "underline", "undo", "universal-access", "university", "unlink", "unlock", "unlock-alt", "unsorted", "upload", "usb", "usd", "user", "user-circle", "user-circle-o", "user-md", "user-o", "user-plus", "user-secret", "user-times", "users", "vcard", "vcard-o", "venus", "venus-double", "venus-mars", "viacoin", "viadeo", "viadeo-square", "video-camera", "vimeo", "vimeo-square", "vine", "vk", "volume-control-phone", "volume-down", "volume-off", "volume-up", "warning", "wechat", "weibo", "weixin", "whatsapp", "wheelchair", "wheelchair-alt", "wifi", "wikipedia-w", "window-close", "window-close-o", "window-maximize", "window-minimize", "window-restore", "windows", "won", "wordpress", "wpbeginner", "wpexplorer", "wpforms", "wrench", "xing", "xing-square", "y-combinator", "y-combinator-square", "yahoo", "yc", "yc-square", "yelp", "yen", "yoast", "youtube", "youtube-play", "youtube-square" );

/**
 * Get CSS Color
 */
function impeka_grve_get_css_color( $prefix, $color ) {
	$rgb_color = preg_match( '/rgba/', $color ) ? preg_replace( array( '/\s+/', '/^rgba\((\d+)\,(\d+)\,(\d+)\,([\d\.]+)\)$/' ), array( '', 'rgb($1,$2,$3)' ), $color ) : $color;
	$string = $prefix . ':' . $rgb_color . ';';
	if ( $rgb_color !== $color ) $string .= $prefix . ':' . $color . ';';
	return $string;
}

/**
 * Get hex2rgba Color
 */
function impeka_grve_get_hex2rgba( $color = "#000000", $alpha = "1" ) {
	return "rgba(" . impeka_grve_hex2rgb( $color ) . "," . $alpha . ")";
}


if ( !function_exists('impeka_grve_build_separator') ) {
	function impeka_grve_build_separator( $separator = '' , $color = '#ffffff' ) {

		switch( $separator ) {
			case 'wave-right-separator':
				$separator_svg = '<svg class="grve-separator grve-wave-separator" fill="' . esc_attr( $color ) . '" width="100%" height="100%" preserveAspectRatio="none" viewBox="0 0 1440 150"><path d="M0,139.588931 C152,152.720009 299.666667,139.401344 443,99.6329343 C658,39.9803202 681,66.1486839 905,90.6287661 C1129,115.108848 1222,59.3955578 1293,37.4478979 C1340.33333,22.8161246 1389.33333,16.1567919 1440,17.4698997 L1440,150 L0,150 L0,139.588931 Z"></path><path d="M0,117.980769 C152,145.786435 299.666667,138.940533 443,97.4430619 C658,35.1968558 697,56.6671048 921,82.2115385 C1145,107.755972 1222,55.4562342 1293,32.5543282 C1340.33333,17.2863909 1389.33333,10.337522 1440,11.7077215 L1440,150 L0,150 L0,117.980769 Z" fill-opacity="0.3"></path><path d="M0,106.034486 C156.666667,132.662839 291.666667,129.406134 405,96.2643713 C575,46.5517277 637,36.0308187 861,62.6436817 C1085,89.2565447 1215,51.1586623 1286,27.2988541 C1333.33333,11.3923153 1384.66667,2.2926973 1440,1.13686838e-13 L1440,150 L0,150 L0,106.034486 Z" fill-opacity="0.3"></path></svg>';
				break;
			case 'wave-left-separator':
				$separator_svg = '<svg class="grve-separator grve-wave-separator" fill="' . esc_attr( $color ) . '" width="100%" height="100%" preserveAspectRatio="none" viewBox="0 0 1440 150"><path d="M1440,139.588931 C1289.52,152.588698 1143.2871,139.665072 1001.3013,100.818052 L997,99.6329343 C835.75,54.8934737 782.5,58.4283132 671.453125,73.3194839 L662.442931,74.5343043 L662.442931,74.5343043 L638.714776,77.7557748 C609.1276,81.7612362 575.32,86.2223513 535,90.6287661 C358.04,109.968031 262.8371,79.2586121 195.650049,54.6867422 L190.600231,52.833237 L190.600231,52.833237 L178.412696,48.3386306 L178.412696,48.3386306 L173.698752,46.6108095 C164.3568,43.2015613 155.52,40.0816171 147,37.4478979 C99.6666667,22.8161246 50.6666667,16.1567919 0,17.4698997 L0,150 L1440,150 L1440,139.588931 Z"></path><path d="M1440,117.980769 C1288,145.786435 1140.33333,138.940533 997,97.4430619 C822.85,47.023635 764.1736,51.5305743 629.120599,68.6387118 L592.271808,73.329169 L592.271808,73.329169 L581.011,74.7500762 C561.95,77.1433936 541.4,79.6570951 519,82.2115385 C339.8,102.647085 254.68,73.2623625 191.448,48.9652756 L184.422933,46.2562123 L184.422933,46.2562123 L179.830875,44.4825978 L179.830875,44.4825978 L175.303977,42.740931 C165.5614,39.0056471 156.23,35.531576 147,32.5543282 C99.6666667,17.2863909 50.6666667,10.337522 0,11.7077215 L0,150 L1440,150 L1440,117.980769 Z" fill-opacity="0.3"></path><path d="M1440,106.034486 C1283.33333,132.662839 1148.33333,129.406134 1035,96.2643713 C865,46.5517277 803,36.0308187 579,62.6436817 C357.24,88.990416 227.6094,51.9141489 156.147735,28.0188408 L154,27.2988541 C106.666667,11.3923153 55.3333333,2.2926973 0,-4.26325641e-14 L0,150 L1440,150 L1440,106.034486 Z" fill-opacity="0.3"></path></svg>';
				break;
			case 'triangle-separator':
				$separator_svg = '<svg class="grve-separator grve-svg-triangle"fill="' . esc_attr( $color ) . '" width="100%" height="100%" viewBox="0 0 90 50"><polygon points="0,50 45,0 90,50 "/></svg>';
				break;
			case 'large-triangle-separator':
				$separator_svg = '<svg class="grve-separator grve-svg-large-triangle" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 1920 90" preserveAspectRatio="none"><polygon fill="' . esc_attr( $color ) . '" points="960,45 0,0 0,90 1920,90 1920,0 "/></svg>';
				break;
			case 'tilt-left-separator':
				$separator_svg = '<svg class="grve-separator grve-tilt-left-separator"fill="' . esc_attr( $color ) . '" width="100%" height="100%" viewBox="0 0 1920 90" preserveAspectRatio="none"><polygon class="fil0" points="1920,90 0,90 1920,0 "/></svg>';
				break;
			case 'tilt-right-separator':
				$separator_svg = '<svg class="grve-separator grve-tilt-right-separator"fill="' . esc_attr( $color ) . '" width="100%" height="100%" viewBox="0 0 1920 90" preserveAspectRatio="none"><polygon class="fil0" points="0,90 1920,90 0,0 "/></svg>';
				break;
			case 'tilt-alt-left-separator':
				$separator_svg = '<svg class="grve-separator grve-tilt-alt-separator" fill="' . esc_attr( $color ) . '" width="100%" height="100%" preserveAspectRatio="none" viewBox="0 0 1440 150"><polygon fill-opacity="0.3" points="1440 0 1440 150 0 150"></polygon><polygon fill-opacity="0.3" points="1440 38 1440 150 0 150"></polygon><polygon points="1440 75 1440 150 0 150"></polygon></svg>';
				break;
			case 'tilt-alt-right-separator':
				$separator_svg = '<svg class="grve-separator grve-tilt-alt-separator" fill="' . esc_attr( $color ) . '" width="100%" height="100%" preserveAspectRatio="none" viewBox="0 0 1440 150"><polygon fill-opacity="0.3" points="0 0 0 150 1440 150"></polygon><polygon fill-opacity="0.3" points="0 38 0 150 1440 150"></polygon><polygon points="0 75 0 150 1440 150"></polygon></svg>';
				break;
			case 'curve-separator':
				$separator_svg = '<svg class="grve-separator grve-curve-separator" width="100%" height="100%" viewBox="0 0 1920 90" preserveAspectRatio="none"><path fill="' . esc_attr( $color ) . '" d="M0,90C0,40.294,429.807,0,960,0s960,40.294,960,90H0z"/></svg>';
				break;
			case 'curve-left-separator':
				$separator_svg = '<svg class="grve-separator grve-curve-left-separator" width="100%" height="100%" viewBox="0 0 1440 150" preserveAspectRatio="none"><path  fill="' . esc_attr( $color ) . '" d="M0,0 C476.666667,53.9275539 821.666667,80.8913309 1035,80.8913309 C1248.33333,80.8913309 1383.33333,53.9275539 1440,0 L1440,150 L0,150 L0,0 Z"></path></svg>';
				break;
			case 'curve-right-separator':
				$separator_svg = '<svg class="grve-separator grve-curve-right-separator" width="100%" height="100%" viewBox="0 0 1440 150" preserveAspectRatio="none"><path fill="' . esc_attr( $color ) . '" d="M1440,0 C963.333333,53.9275539 618.333333,80.8913309 405,80.8913309 C191.666667,80.8913309 56.6666667,53.9275539 0,0 L0,150 L1440,150 L1440,0 Z" id="Separator-Color"></path></svg>';
				break;
			case 'round-split-separator':
				$separator_svg = '<svg class="grve-separator grve-round-split-separator" width="100%" height="100%" viewBox="0 0 90 45" preserveAspectRatio="none"><path fill="' . esc_attr( $color ) . '" d="M90,45L90,45C65.148,44.999,45,24.854,45,0l0,0c0,24.854-20.146,44.999-45,44.999V45H90z"/></svg>';
				break;
			case 'line-separator':
				$separator_svg = '<svg class="grve-separator grve-line-separator" width="100%" height="100%" viewBox="0 0 1440 100" preserveAspectRatio="none"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect fill="' . esc_attr( $color ) . '" fill-rule="nonzero" x="0" y="0" width="1440" height="100"></rect></g></svg>';
				break;
			case 'torn-paper-separator':
				$separator_svg = '<svg class="grve-separator grve-svg-torn" version="1.1" width="100%" height="100%" viewBox="0 0 1920 60" preserveAspectRatio="none"><path fill="' . esc_attr( $color ) . '" fill-rule="evenodd" clip-rule="evenodd" d="M42.728,16.599c9.228,14.816-39.39,9.974,36.298,6.492 c16.02-7.791,21.766-13.806,29.15-15.183c18.792,7.369,12.938,16.7,24.706,14.923c19.107,1.62,21.645,4.295,24.443,3.992 c19.532,0.602,23.42-2.739,27.408-2.238c15.269,8.654,29.658,7.357,39.264,6.713c8.322-3.869,4.44-10.481,4.44-10.481 c17.429,0.081,21.966,4.916,26.967,3.993c6.749-1.245,10.922-10.161,17.776-10.449c0.687,11.035,7.926,14.922,7.926,14.922 c16.338,7.064,27.334-2.205,40.743,0.748c20.006,0.072,36.746,9.646,46.255,1.268c64.623-56.952,28.432-5.807,39.489-16.938 c16.442,9.912,22.113,2.631,24.225,2.762c32.984,13.107,1.124,2.18,49.407,4.736c18.053,1.998,34.622-2.404,51.114-0.743 c16.608,1.674,2.018,14.925,18.518,9.698c6.111-1.936,10.884-7.164,17.038-8.955c21.589-2.432,24.99-8.342,30.373-9.697 c14.393,3.431,19.179,2.239,23.964,2.239c-7.127,7.735,34.558-0.999,42.263-7.463c16.464,3.134,17.354,5.277,18.775,6.979 c14.701,5.671,14.303,9.265,16.073,9.957c24.503,4.32,46.255,4.731,60.746-0.743c21.139-4.334,28.053-6.946,34.369-8.955 c12.832-4.081-1.319,7.396,15.558,8.207c17.235-6.42,20.293-9.697,23.963-9.697C912.494-8,844.468,8.95,866.353,8.95 c28.971,4.613,27.289-4.495,29.15-8.95c22.775,10.511,56.035,19.17,65.445,19.918c21.356-4.961,23.647-2.734,26.226-2.981 c22.418,2.435,29.441-2.548,37.035-2.986c30.947,12.058,3.238,1.833,40.264,5.225c26.562,5.928,31.99-0.134,47.406-2.986 c24.84-2.84,27.172-4.79,29.15-6.976c17.416,8.346,19.512-1.767,25.188,1.751c16.482,10.218,24.496,22.792,45.926,17.161 c10.627-5.809,28.699,1.072,31.373-0.744c15.418-5.719,14.408-10.484,16.334-9.96c15.781,4.358,18.074,6.828,21.039,7.722 c23.295,2.238,28.391-13.158,36.297-16.417c4.316-1.778,7.625,9.917,11.109,11.192c23.453-1.396,23.262,1.141,24.705,1.492 c92.949,22.566-17.523-4.687,26.447-2.235c13.688,7.079,22.062-1.5,27.408,1.491c25.576,7.956,37.385,2.982,45.186,2.982 c22.551-6.436,25.021-5.34,30.631-5.969c21.697,5.066,24.664,3.502,27.186,4.517c21.406,4.458,21.693,1.073,23.705,0 c49.031-15.261,116.562,3.021,116.562,3.021s30.617-2.253,37.814-11.94c23.543,4.434,28.74,7.078,34.334,7.723 c24.664,1.831,27.061-2.885,35.852-7.463c12.189,7.018,2.307,6.385,11.855,11.193c14.693-9.779,19.664-3.969,25.443-2.982 c23.627,4.029,6.672-0.377,20.004-5.972c10.193,8.832,19.617,2.306,27.408-0.744c25.084,0.585,39.549,2.333,47.395,4.143 c33.402-6.484,29.643-5.933,29.643-5.933V60H0V31.297C0,31.297,26.24,22.639,42.728,16.599L42.728,16.599z"/></svg>';
				break;
			default:
				$separator_svg = '';
				break;
		}

		$separator_svg = apply_filters( 'impeka_grve_separator_svg', $separator_svg, $separator, $color );

		return $separator_svg;

	}
}


if ( !function_exists('impeka_grve_get_icon') ) {
	function impeka_grve_get_icon( $icon = '' ) {
		$icon_library = impeka_grve_option('header_icon_library');
		if( 'awesome-fonts' == $icon_library ) {
			return impeka_grve_get_awesome_font_icon( $icon );
		} else {
			return impeka_grve_get_svg_icon( $icon );
		}
	}
}

if ( !function_exists('impeka_grve_get_awesome_font_icon') ) {
	function impeka_grve_get_awesome_font_icon( $icon = '' ) {
		switch( $icon ) {
			case 'search':
				$class = 'fas fa-search';
				break;
			case 'envelope':
				$class = 'fas fa-envelope';
				break;
			case 'globe':
				$class = 'fas fa-globe';
				break;
			case 'cart':
				$class = 'fas fa-shopping-cart';
				break;
			case 'share':
				$class = 'fas fa-share-alt';
				break;
			case 'close':
				$class = 'fas fa-times';
				break;
			case 'burger':
				$class = 'fas fa-bars';
				break;
			default:
				$class = 'fas fa-question';
				break;
		}

		$icon_font = '<span class="grve-icon ' . esc_attr( $class ) . '"></span>';
		$icon_font = apply_filters( 'impeka_grve_awesome_font_icon', $icon_font, $icon );

		return $icon_font;
	}
}

if ( !function_exists('impeka_grve_get_svg_icon') ) {
	function impeka_grve_get_svg_icon( $icon = 'arrow-1' ) {

		ob_start();

		switch( $icon ) {
			case 'arrow-1':
			?>
			<svg width="12px" height="12px" viewBox="0 0 12 12">
				<polygon points="3.6 0 10 6 3.6 12 2 10.5 6.8 6 2 1.5"></polygon>
			</svg>
			<?php
				break;
			case 'arrow-2':
			?>
				<svg width="40px" height="16px" viewBox="0 0 40 16">
					<polygon class="grve-arrow-line" points="0 7 38 7 38 9 0 9"></polygon>
					<polygon class="grve-arrow-point" points="31.3481912 0 40 8 31.3481912 16 30 14.5816219 37.1 8 30 1.41837809"></polygon>
				</svg>
			<?php
				break;
			case 'arrow-large-up':
			?>
				<svg width="16px" height="40px" viewBox="0 0 16 40">
					<polygon class="grve-arrow-point" fill-rule="nonzero" points="8 0 14.75 6.60691267 13.3267423 8 8 2.78694936 2.67325773 8 1.25 6.60691267"></polygon>
					<polygon class="grve-arrow-line" points="7 2 9 2 9 40 7 40"></polygon>
				</svg>
			<?php
				break;
			case 'arrow-3':
			?>
				<svg width="10px" height="18px" viewBox="0 0 10 18">
					<path class="grve-arrow-point" d="M0.305625115,16.21275 C-0.101374885,16.62175 -0.101374885,17.28375 0.305625115,17.69175 C0.712625115,18.09975 1.37362512,18.09975 1.78162512,17.69175 L9.69562512,9.73975 C10.1036251,9.33075 10.1036251,8.66875 9.69562512,8.25875 L1.78162512,0.30675 C1.37462512,-0.10225 0.713625115,-0.10225 0.305625115,0.30675 C-0.102374885,0.71575 -0.101374885,1.37775 0.305625115,1.78675 L7.49062512,9.00775 L0.305625115,16.21275 Z"></path>
				</svg>
			<?php
				break;
			case 'arrow-small-up':
			?>
				<svg width="12px" height="12px" viewBox="0 0 12 12">
					<polygon points="12 8.4 6 2 0 8.4 1.5 10 6 5.2 10.5 10"></polygon>
				</svg>
			<?php
				break;
			case 'arrow-small-down':
			?>
				<svg width="24px" height="24px" viewBox="0 0 24 24">
					<polygon points="18 10.6 12 17 6 10.6 7.5 9 12 13.8 16.5 9"></polygon>
				</svg>
			<?php
				break;
			case 'arrow-triangle-down':
			?>
				<svg width="24px" height="24px" viewBox="0 0 24 24">
					<polygon points="18 9 12 15.4 6 9"></polygon>
				</svg>
			<?php
				break;
			case 'quote-1':
			?>
				<svg width="32px" height="32px" viewBox="0 0 32 32" stroke-width="0">
					<path d="M21.5571429,5 C20.1952381,5 19.0952381,5.47008547 18.2571429,6.41025641 C17.4190476,7.35042735 17,8.35775336 17,9.43223443 C17,10.7216117 17.3928571,11.7423687 18.1785714,12.4945055 C18.9642857,13.2466422 19.9333333,13.6227106 21.0857143,13.6227106 C21.9761905,13.6227106 22.6964286,13.3809524 23.2464286,12.8974359 C23.7964286,12.4139194 24.2285714,11.984127 24.5428571,11.6080586 L24.8067019,12.0776466 C24.939271,12.3197365 25.1001323,12.6198616 25.2892857,12.978022 C25.6297619,13.6227106 25.8,14.4822955 25.8,15.5567766 C25.8,16.6849817 25.577381,17.7460317 25.1321429,18.7399267 C24.6869048,19.7338217 24.1107143,20.6874237 23.4035714,21.6007326 C22.6964286,22.5140415 21.9369048,23.3467643 21.125,24.0989011 C20.4754762,24.7006105 19.8343333,25.2679365 19.2015714,25.8008791 L18.7285714,26.1941392 L19.3571429,27 C20.1428571,26.4090354 21.0333333,25.6568987 22.0285714,24.7435897 C23.0238095,23.8302808 23.9666667,22.7692308 24.8571429,21.5604396 C25.747619,20.3516484 26.4940476,19.008547 27.0964286,17.5311355 C27.6988095,16.0537241 28,14.4554335 28,12.7362637 C28,12.1990232 27.9214286,11.4871795 27.7642857,10.6007326 C27.6071429,9.71428571 27.2928571,8.85470085 26.8214286,8.02197802 C26.35,7.18925519 25.6952381,6.47741148 24.8571429,5.88644689 C24.0190476,5.2954823 22.9190476,5 21.5571429,5 Z M8.55714286,5 C7.1952381,5 6.0952381,5.47008547 5.25714286,6.41025641 C4.41904762,7.35042735 4,8.35775336 4,9.43223443 C4,10.7216117 4.39285714,11.7423687 5.17857143,12.4945055 C5.96428571,13.2466422 6.93333333,13.6227106 8.08571429,13.6227106 C8.97619048,13.6227106 9.69642857,13.3809524 10.2464286,12.8974359 C10.7964286,12.4139194 11.2285714,11.984127 11.5428571,11.6080586 L11.7305556,11.9393569 C11.8760582,12.2020079 12.0623016,12.5482295 12.2892857,12.978022 C12.6297619,13.6227106 12.8,14.4822955 12.8,15.5567766 C12.8,16.6849817 12.577381,17.7460317 12.1321429,18.7399267 C11.6869048,19.7338217 11.1107143,20.6874237 10.4035714,21.6007326 C9.69642857,22.5140415 8.93690476,23.3467643 8.125,24.0989011 C7.47547619,24.7006105 6.83433333,25.2679365 6.20157143,25.8008791 L5.72857143,26.1941392 L6.35714286,27 C7.14285714,26.4090354 8.03333333,25.6568987 9.02857143,24.7435897 C10.0238095,23.8302808 10.9666667,22.7692308 11.8571429,21.5604396 C12.747619,20.3516484 13.4940476,19.008547 14.0964286,17.5311355 C14.6988095,16.0537241 15,14.4554335 15,12.7362637 C15,12.1990232 14.9214286,11.4871795 14.7642857,10.6007326 C14.6071429,9.71428571 14.2928571,8.85470085 13.8214286,8.02197802 C13.35,7.18925519 12.6952381,6.47741148 11.8571429,5.88644689 C11.0190476,5.2954823 9.91904762,5 8.55714286,5 Z"></path>
				</svg>
			<?php
				break;
			case 'link':
			?>
				<svg width="32px" height="32px" viewBox="0 0 32 32" stroke-width="0">
					<path d="M19.5,9 C22.4634791,9 24.8795391,11.34378 24.9956328,14.2787929 L25,14.5 L25,25.5 C25,28.4634791 22.65622,30.8795391 19.7212071,30.9956328 L19.5,31 L18.5,31 C15.5365209,31 13.1204609,28.65622 13.0043672,25.7212071 L13,25.5 L13,25 L15,25 L15,25.5 C15,27.3685634 16.4642776,28.8951264 18.3079648,28.9948211 L18.5,29 L19.5,29 C21.3685634,29 22.8951264,27.5357224 22.9948211,25.6920352 L23,25.5 L23,14.5 C23,12.6314366 21.5357224,11.1048736 19.6920352,11.0051789 L19.5,11 L18.5,11 C16.6314366,11 15.1048736,12.4642776 15.0051789,14.3079648 L15,14.5 L15,19 L13,19 L13,14.5 C13,11.5365209 15.34378,9.12046086 18.2787929,9.0043672 L18.5,9 L19.5,9 Z M14.5,1 C17.4634791,1 19.8795391,3.34378001 19.9956328,6.27879286 L20,6.5 L20,7 L18,7 L18,6.5 C18,4.6314366 16.5357224,3.10487355 14.6920352,3.00517886 L14.5,3 L13.5,3 C11.6314366,3 10.1048736,4.4642776 10.0051789,6.3079648 L10,6.5 L10,17.5 C10,19.3685634 11.4642776,20.8951264 13.3079648,20.9948211 L13.5,21 L14.5,21 C16.3685634,21 17.8951264,19.5357224 17.9948211,17.6920352 L18,17.5 L18,13 L20,13 L20,17.5 C20,20.4634791 17.65622,22.8795391 14.7212071,22.9956328 L14.5,23 L13.5,23 C10.5365209,23 8.12046086,20.65622 8.0043672,17.7212071 L8,17.5 L8,6.5 C8,3.53652085 10.34378,1.12046086 13.2787929,1.0043672 L13.5,1 L14.5,1 Z" transform="translate(16.500000, 16.000000) rotate(45.000000) translate(-16.500000, -16.000000) "></path>
				</svg>
			<?php
				break;
			case 'backlink':
			?>
				<svg width="24px" height="24px" viewBox="0 0 24 24" stroke-width="0">
					<rect class="grve-rect-lt" x="6" y="6" width="4" height="4"></rect>
					<rect class="grve-rect-lb" x="6" y="14" width="4" height="4"></rect>
					<rect class="grve-rect-rt" x="14" y="6" width="4" height="4"></rect>
					<rect class="grve-rect-rb" x="14" y="14" width="4" height="4"></rect>
				</svg>
			<?php
				break;
			case 'search':
			?>
				<svg width="24px" height="24px" viewBox="0 0 24 24" stroke-width="0">
					<path d="M11,3 C15.418278,3 19,6.581722 19,11 C19,13.1038245 18.1879088,15.0179749 16.860099,16.4460786 L20.2071068,19.7928932 C20.5976311,20.1834175 20.5976311,20.8165825 20.2071068,21.2071068 C19.8466228,21.5675907 19.2793918,21.5953203 18.8871006,21.2902954 L18.7928932,21.2071068 L15.3199029,17.7345448 C14.0739277,18.5354376 12.5912161,19 11,19 C6.581722,19 3,15.418278 3,11 C3,6.581722 6.581722,3 11,3 Z M11,5 C7.6862915,5 5,7.6862915 5,11 C5,14.3137085 7.6862915,17 11,17 C14.3137085,17 17,14.3137085 17,11 C17,7.6862915 14.3137085,5 11,5 Z"></path>
				</svg>
			<?php
				break;
			case 'plus':
			?>
				<svg width="24px" height="24px" viewBox="0 0 24 24" stroke-width="0">
					<path d="M12,5 C12.5128358,5 12.9355072,5.38604019 12.9932723,5.88337887 L13,6 L13,11 L18,11 C18.5522847,11 19,11.4477153 19,12 C19,12.5128358 18.6139598,12.9355072 18.1166211,12.9932723 L18,13 L13,13 L13,18 C13,18.5522847 12.5522847,19 12,19 C11.4871642,19 11.0644928,18.6139598 11.0067277,18.1166211 L11,18 L11,13 L6,13 C5.44771525,13 5,12.5522847 5,12 C5,11.4871642 5.38604019,11.0644928 5.88337887,11.0067277 L6,11 L11,11 L11,6 C11,5.44771525 11.4477153,5 12,5 Z"></path>
				</svg>
			<?php
				break;
			case 'arrows-left-right':
			?>
				<svg width="24px" height="24px" viewBox="0 0 24 24">
						<path d="M20,8 L24,12 L20,16 L19,15 L22,12 L19,9 L20,8 Z M4,8 L5,9 L2,12 L5,15 L4,16 L0,12 L4,8 Z"></path>
				</svg>
			<?php
				break;
			case 'share':
			?>
				<svg width="24px" height="24px" viewBox="0 0 24 24" stroke-width="0">
					<path d="M16.5,2 C18.709139,2 20.5,3.790861 20.5,6 C20.5,8.209139 18.709139,10 16.5,10 C15.5111872,10 14.6061749,9.64120697 13.9080502,9.0467078 L10.3318328,10.8487021 C10.4412239,11.2132995 10.5,11.5997858 10.5,12 C10.5,12.5591532 10.3852699,13.0915098 10.1780664,13.574813 L13.5655716,15.2816779 C14.296154,14.4933877 15.3404586,14 16.5,14 C18.709139,14 20.5,15.790861 20.5,18 C20.5,20.209139 18.709139,22 16.5,22 C14.290861,22 12.5,20.209139 12.5,18 C12.5,17.7595638 12.5212137,17.5240823 12.5618714,17.2953251 L8.69327853,15.3456158 C8.06347649,15.759332 7.30984375,16 6.5,16 C4.290861,16 2.5,14.209139 2.5,12 C2.5,9.790861 4.290861,8 6.5,8 C7.48881285,8 8.39382509,8.35879303 9.09194985,8.9532922 L12.6684641,7.15228678 C12.5588824,6.7873994 12.5,6.40057606 12.5,6 C12.5,3.790861 14.290861,2 16.5,2 Z M16.5,16 C15.3954305,16 14.5,16.8954305 14.5,18 C14.5,19.1045695 15.3954305,20 16.5,20 C17.6045695,20 18.5,19.1045695 18.5,18 C18.5,16.8954305 17.6045695,16 16.5,16 Z M6.5,10 C5.3954305,10 4.5,10.8954305 4.5,12 C4.5,13.1045695 5.3954305,14 6.5,14 C7.6045695,14 8.5,13.1045695 8.5,12 C8.5,10.8954305 7.6045695,10 6.5,10 Z M16.5,4 C15.3954305,4 14.5,4.8954305 14.5,6 C14.5,7.1045695 15.3954305,8 16.5,8 C17.6045695,8 18.5,7.1045695 18.5,6 C18.5,4.8954305 17.6045695,4 16.5,4 Z"></path>
				</svg>
			<?php
				break;
			case 'envelope':
			?>
				<svg width="24px" height="24px" viewBox="0 0 24 24" stroke-width="0">
					<path d="M22,4 C22.5522847,4 23,4.44771525 23,5 L23,19 C23,19.5522847 22.5522847,20 22,20 L2,20 C1.44771525,20 1,19.5522847 1,19 L1,5 C1,4.44771525 1.44771525,4 2,4 L22,4 Z M21,6.266 L12,13.2668616 L3,6.267 L3,18 L21,18 L21,6.266 Z M18.084,6 L5.915,6 L12,10.733 L18.084,6 Z"></path>
				</svg>
			<?php
				break;
			case 'cart':
			?>
				<svg width="24px" height="24px" viewBox="0 0 24 24" stroke-width="0">
					<path d="M12,5 C10.4023191,5 9.09633912,6.24891996 9.00509269,7.82372721 L9,8 L7,8 C7,5.23857625 9.23857625,3 12,3 C14.6887547,3 16.8818181,5.12230671 16.9953805,7.78311038 L17,8 L20,8 L20,17 C20,19.7614237 17.7614237,22 15,22 L9,22 C6.23857625,22 4,19.7614237 4,17 L4,8 L15,8 C15,6.34314575 13.6568542,5 12,5 Z M18,10 L6,10 L6,17 C6,18.5976809 7.24891996,19.9036609 8.82372721,19.9949073 L9,20 L15,20 C16.5976809,20 17.9036609,18.75108 17.9949073,17.1762728 L18,17 L18,10 Z"></path>
				</svg>
			<?php
				break;
			case 'globe':
			?>
				<svg width="24px" height="24px" viewBox="0 0 24 24" stroke-width="0">
					<path d="M12,2 C17.5228475,2 22,6.4771525 22,12 C22,17.5228475 17.5228475,22 12,22 C6.4771525,22 2,17.5228475 2,12 C2,6.4771525 6.4771525,2 12,2 Z M13.9784177,13.0009622 L10.0215823,13.0009622 C10.1108626,15.0606427 10.4729027,16.9392276 11.0285263,18.3282865 C11.2754231,18.9455287 11.5449918,19.4230702 11.8008831,19.7320323 L12,19.948 L12.1038698,19.8399346 C12.3872618,19.5402728 12.6937148,19.0226839 12.9714737,18.3282865 C13.5270973,16.9392276 13.8891374,15.0606427 13.9784177,13.0009622 Z M8.019761,13.0002745 L4.06201291,13.0009551 C4.44386355,16.060158 6.55302355,18.5828006 9.3826397,19.5620298 C8.63021083,17.9327086 8.1236163,15.6145965 8.019761,13.0002745 Z M19.9379871,13.0009551 L15.980239,13.0002745 C15.8763837,15.6145965 15.3697892,17.9327086 14.6177594,19.5613508 C17.4469764,18.5828006 19.5561365,16.060158 19.9379871,13.0009551 Z M9.38224064,4.43864924 C6.55221994,5.41789758 4.4433575,7.94075227 4.06188768,11.0000487 L8.01972109,11.0007306 C8.12348646,8.38599762 8.63011446,6.06750013 9.38224064,4.43864924 Z M12,4.051 L11.8961302,4.16006542 C11.6127382,4.45972721 11.3062852,4.97731607 11.0285263,5.67171354 C10.4728124,7.0609982 10.1107449,8.939968 10.0215388,11.0000422 L13.9784612,11.0000422 C13.8892551,8.939968 13.5271876,7.0609982 12.9714737,5.67171354 C12.7245769,5.05447135 12.4550082,4.57692978 12.1991169,4.26796765 L12,4.051 Z M14.6173603,4.43797019 L14.6978559,4.61683687 C15.4057641,6.2344538 15.880241,8.47992478 15.9802789,11.0007306 L19.9381123,11.0000487 C19.5565978,7.94039387 17.4472859,5.41730648 14.6173603,4.43797019 Z"></path>
				</svg>
			<?php
				break;
			case 'video-1':
			?>
				<svg width="24px" height="24px" viewBox="0 0 24 24" stroke-width="0">
					<polygon points="19 12 7 20 7 4"></polygon>
				</svg>
			<?php
				break;
			case 'heart':
			?>
				<svg width="24px" height="24px" viewBox="0 0 24 24" stroke-width="0">
					<path d="M16,4 C18.7614237,4 21,6.23857625 21,9 L20.9979707,9.14384363 C21,13.09813 18,17.049065 12,21 C6.13043478,17.1349549 3.13185255,13.2699098 3.00425331,9.40486468 L3,9 C3,6.23857625 5.23857625,4 8,4 C9.63573058,4 11.0880049,4.7854695 12.0002202,5.99980567 C12.9119951,4.7854695 14.3642694,4 16,4 Z M16,6 C15.1111332,6 14.2899521,6.38707926 13.7252504,7.04426723 L13.5995734,7.20066758 L12.0006064,9.33023224 L10.4011455,7.20103842 C9.83618754,6.44896935 8.95727871,6 8,6 C6.40231912,6 5.09633912,7.24891996 5.00499374,8.80488898 L4.99988964,8.97899015 L5.0031643,9.33887334 C5.09535291,12.1313127 7.2531301,15.1613039 11.6695429,18.3451961 L11.999,18.58 L12.3276908,18.3472272 C16.7356425,15.170173 18.8904316,12.1482009 18.9942273,9.33186537 L19,9 C19,7.34314575 17.6568542,6 16,6 Z"></path>
				</svg>
			<?php
				break;
			case 'tooltip':
			?>
				<svg width="24px" height="24px" viewBox="0 0 24 24" stroke-width="0">
					<path d="M21,4 C21.5522847,4 22,4.44585139 22,4.99583694 L22,16.9458803 C22,17.4958658 21.5522847,17.9417172 21,17.9417172 L15.071,17.9417172 L12,21 L8.929,17.9417172 L3,17.9417172 C2.44771525,17.9417172 2,17.4958658 2,16.9458803 L2,4.99583694 C2,4.44585139 2.44771525,4 3,4 L21,4 Z M20,5.99167389 L4,5.99167389 L4,15.9500433 L9.75744006,15.9500433 L12,18.1827098 L14.2425599,15.9500433 L20,15.9500433 L20,5.99167389 Z M18,12 L18,14 L6,14 L6,12 L18,12 Z M18,8 L18,10 L6,10 L6,8 L18,8 Z"></path>
				</svg>
			<?php
				break;
			case 'info':
			?>
			<svg width="24px" height="24px" viewBox="0 0 24 24">
				<path d="M13.9101562,7.4453125 C14.3867188,7.4453125 14.7929688,7.27734375 15.1289062,6.94140625 C15.4648438,6.60546875 15.6328125,6.19921875 15.6328125,5.72265625 C15.6328125,5.24609375 15.4667969,4.83984375 15.1347656,4.50390625 C14.8027344,4.16796875 14.3945312,4 13.9101562,4 C13.4335938,4 13.0292969,4.16796875 12.6972656,4.50390625 C12.3652344,4.83984375 12.1992188,5.24609375 12.1992188,5.72265625 C12.1992188,6.19921875 12.3671875,6.60546875 12.703125,6.94140625 C13.0390625,7.27734375 13.4414062,7.4453125 13.9101562,7.4453125 Z M10.6640625,20.5820312 C11.9921875,20.5820312 13.2460938,19.5546875 14.4257812,17.5 L14.4257812,17.5 L14.0273438,17.265625 C13.5351562,18.0234375 13.1132812,18.546875 12.7617188,18.8359375 C12.6289062,18.953125 12.4960938,19.0117188 12.3632812,19.0117188 C12.2851562,19.0117188 12.2109375,18.9746094 12.140625,18.9003906 C12.0703125,18.8261719 12.0351562,18.7460938 12.0351562,18.6601562 C12.0351562,18.5117188 12.1015625,18.1992188 12.234375,17.7226562 L12.234375,17.7226562 L14.6367188,9.390625 L13.9335938,9.390625 L9.9609375,10.0351562 L9.80859375,10.5039062 C9.97265625,10.4960938 10.1132812,10.4921875 10.2304688,10.4921875 C10.4882812,10.4921875 10.6914062,10.5585938 10.8398438,10.6914062 C10.9882812,10.8242188 11.0625,10.9765625 11.0625,11.1484375 C11.0625,11.421875 10.984375,11.828125 10.828125,12.3671875 L10.828125,12.3671875 L9.19921875,17.96875 C9.06640625,18.4140625 9,18.78125 9,19.0703125 C9,19.5078125 9.15039062,19.8691406 9.45117188,20.1542969 C9.75195312,20.4394531 10.15625,20.5820312 10.6640625,20.5820312 Z"></path>
			</svg>
			<?php
				break;
			case 'marker':
			?>
			<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
				<path d="M12,0 C16.9705627,0 21,4.02943725 21,9 C21,11.1207734 19.7712,13.9322519 17.3136,17.4344353 L16.8384,18.0991889 C16.6752,18.3234715 16.5072,18.5504522 16.3344,18.7801309 L15.8016,19.4772613 L15.24,20.1905801 C15.048,20.4310511 14.8512,20.6742201 14.6496,20.9200873 L14.0304,21.6657829 L13.3824,22.4276668 L12.7056,23.2057392 L12,24 L11.2944,23.2057392 L10.6176,22.4276668 L9.9696,21.6657829 L9.3504,20.9200873 L9.0516,20.5533101 L9.0516,20.5533101 L8.4756,19.8318971 C8.382,19.7130107 8.2896,19.5947987 8.1984,19.4772613 L7.6656,18.7801309 C7.4928,18.5504522 7.3248,18.3234715 7.1616,18.0991889 L6.6864,17.4344353 C4.2288,13.9322519 3,11.1207734 3,9 C3,4.02943725 7.02943725,0 12,0 Z M12,2 C8.13400675,2 5,5.13400675 5,9 C5,10.3036772 5.6759684,12.0939815 7.03662534,14.3282664 L7.39105897,14.8960626 L7.5789835,15.1868516 L7.5789835,15.1868516 L7.97626693,15.7821189 L8.1856334,16.0865602 L8.1856334,16.0865602 L8.62583476,16.7089655 L9.09468593,17.3492776 L9.33986465,17.6761025 L9.33986465,17.6761025 L9.85174728,18.3429974 L10.1184588,18.6830303 L10.1184588,18.6830303 L10.8166808,19.552172 L10.8166808,19.552172 L11.5598693,20.4483098 L12,20.966 L12.1302515,20.8142591 C12.3443263,20.5629003 12.5533592,20.3145176 12.7573554,20.0691376 L13.3542399,19.3420323 C13.5481684,19.1026842 13.7370658,18.8663653 13.9209375,18.6331021 L14.4574807,17.9425063 L14.7144546,17.6041335 L14.7144546,17.6041335 L15.2058273,16.9413377 C15.6027697,16.3967909 15.968386,15.8717568 16.302761,15.36665 L16.6890206,14.7701134 C18.174119,12.4224396 18.9401992,10.5377092 18.9966335,9.16175857 L19,9 C19,5.13400675 15.8659932,2 12,2 Z M12,6 C13.6568542,6 15,7.34314575 15,9 C15,10.6568542 13.6568542,12 12,12 C10.3431458,12 9,10.6568542 9,9 C9,7.34314575 10.3431458,6 12,6 Z"></path>
			</svg>
			<?php
				break;
			case 'burger-1':
			?>
			<svg width="24px" height="24px" viewBox="0 0 24 24" stroke-width="0">
				<path d="M24,17 L24,19 L0,19 L0,17 L24,17 Z M24,11 L24,13 L0,13 L0,11 L24,11 Z M24,5 L24,7 L0,7 L0,5 L24,5 Z"></path>
			</svg>
			<?php
				break;
			case 'burger-2':
			?>
			<svg width="24px" height="24px" viewBox="0 0 24 24">
				<path d="M24,14 L24,16 L0,16 L0,14 L24,14 Z M24,8 L24,10 L0,10 L0,8 L24,8 Z"></path>
			</svg>
			<?php
				break;
			case 'burger-3':
			?>
			<svg width="24px" height="24px" viewBox="0 0 24 24" stroke-width="0">
				<path d="M24,17 L24,19 L9,19 L9,17 L24,17 Z M24,11 L24,13 L0,13 L0,11 L24,11 Z M24,5 L24,7 L9,7 L9,5 L24,5 Z"></path>
			</svg>
			<?php
				break;
			case 'burger-4':
			?>
			<svg width="24px" height="24px" viewBox="0 0 24 24" stroke-width="0">
				<path d="M7,14 C8.65685425,14 10,15.3431458 10,17 C10,18.6568542 8.65685425,20 7,20 C5.34314575,20 4,18.6568542 4,17 C4,15.3431458 5.34314575,14 7,14 Z M17,14 C18.6568542,14 20,15.3431458 20,17 C20,18.6568542 18.6568542,20 17,20 C15.3431458,20 14,18.6568542 14,17 C14,15.3431458 15.3431458,14 17,14 Z M7,4 C8.65685425,4 10,5.34314575 10,7 C10,8.65685425 8.65685425,10 7,10 C5.34314575,10 4,8.65685425 4,7 C4,5.34314575 5.34314575,4 7,4 Z M17,4 C18.6568542,4 20,5.34314575 20,7 C20,8.65685425 18.6568542,10 17,10 C15.3431458,10 14,8.65685425 14,7 C14,5.34314575 15.3431458,4 17,4 Z"></path>
			</svg>
			<?php
				break;
			case 'burger-5':
			?>
			<svg width="24px" height="24px" viewBox="0 0 24 24" stroke-width="0">
				<path d="M3,9 C4.65685425,9 6,10.3431458 6,12 C6,13.6568542 4.65685425,15 3,15 C1.34314575,15 0,13.6568542 0,12 C0,10.3431458 1.34314575,9 3,9 Z M12,9 C13.6568542,9 15,10.3431458 15,12 C15,13.6568542 13.6568542,15 12,15 C10.3431458,15 9,13.6568542 9,12 C9,10.3431458 10.3431458,9 12,9 Z M21,9 C22.6568542,9 24,10.3431458 24,12 C24,13.6568542 22.6568542,15 21,15 C19.3431458,15 18,13.6568542 18,12 C18,10.3431458 19.3431458,9 21,9 Z"></path>
			</svg>
			<?php
				break;
			case 'close':
			?>
				<svg width="24px" height="24px" viewBox="0 0 24 24" stroke-width="0">
					<path d="M6.61289944,5.20970461 L6.70710678,5.29289322 L12,10.585 L17.2928932,5.29289322 L17.3871006,5.20970461 C17.7793918,4.90467972 18.3466228,4.93240926 18.7071068,5.29289322 C19.0976311,5.68341751 19.0976311,6.31658249 18.7071068,6.70710678 L18.7071068,6.70710678 L13.415,12 L18.7071068,17.2928932 C19.0976311,17.6834175 19.0976311,18.3165825 18.7071068,18.7071068 C18.3466228,19.0675907 17.7793918,19.0953203 17.3871006,18.7902954 L17.2928932,18.7071068 L12,13.415 L6.70710678,18.7071068 L6.61289944,18.7902954 C6.22060824,19.0953203 5.65337718,19.0675907 5.29289322,18.7071068 C4.90236893,18.3165825 4.90236893,17.6834175 5.29289322,17.2928932 L5.29289322,17.2928932 L10.585,12 L5.29289322,6.70710678 C4.90236893,6.31658249 4.90236893,5.68341751 5.29289322,5.29289322 C5.65337718,4.93240926 6.22060824,4.90467972 6.61289944,5.20970461 Z"></path>
				</svg>
			<?php
				break;
			default:
				break;
		}

		$svg_icon = ob_get_clean();

		$svg_icon = apply_filters( 'impeka_grve_svg_icon', $svg_icon, $icon );

		return $svg_icon;

	}
}


function impeka_grve_get_custom_svg_icon( $icon_svg = '' ) {
	if ( !empty( $icon_svg ) ) {
		$svg_url = $icon_svg['url'];
		if ( $svg_url ) {
			$parts = pathinfo( $svg_url );
			if ( !isset( $parts['extension'] ) || 'svg' != $parts['extension'] ) {
				return impeka_grve_get_svg_icon('burger-1');
			} else {
				return file_get_contents( $svg_url );
			}
		}
	}
}

if ( !function_exists('impeka_grve_build_svg_icon') ) {
	function impeka_grve_build_svg_icon( $icon_options = array() ) {

		$icon = impeka_grve_array_value( $icon_options, 'icon', 'arrow-1' );
		$icon_color = impeka_grve_array_value( $icon_options, 'icon_color', 'black' );
		$shape = impeka_grve_array_value( $icon_options, 'shape' );
		$shape_type = impeka_grve_array_value( $icon_options, 'shape_type' );
		$shape_color = impeka_grve_array_value( $icon_options, 'shape_color' );
		$direction = impeka_grve_array_value( $icon_options, 'direction', 'right' );
		$extra_class = impeka_grve_array_value( $icon_options, 'extra_class' );

		$svg_icon = impeka_grve_get_svg_icon( $icon );

		$icon_classes = array( 'grve-svg-icon' );
		$icon_classes[] = 'grve-direction-' . $direction;
		$icon_classes[] = 'grve-' . $icon;
		if ( !empty( $icon_color) ) {
			$icon_classes[] = 'grve-svg-' . $icon_color;
		}
		if ( !empty( $shape) ) {
			$icon_classes[] = 'grve-with-shape';
			$icon_classes[] = 'grve-' . $shape;
			if ( 'simple' == $shape_type ) {
				$icon_classes[] = 'grve-bg-' . $shape_color;
			} else {
				$icon_classes[] = 'grve-outline';
				$icon_classes[] = 'grve-border-' . $shape_color;
			}
		}
		if ( !empty( $extra_class) ) {
			$icon_classes[] = $extra_class;
		}
		$icon_class_string = implode( ' ', $icon_classes );

		$output = '';
		$output .= '<div class="' . esc_attr( $icon_class_string ) . '">';
		$output .= $svg_icon;
		$output .= '</div>';

		return $output;
	}
}

/**
 * Get Adaptive URL
 */
function impeka_grve_get_adaptive_url( $media_id, $image_size = "responsive" ) {

	if ( 'full' == $image_size ) {
		$default_src = wp_get_attachment_image_src( $media_id, 'full'  );
		$img_url = $default_src[0];
	} elseif ( 'extra-extra-large' == $image_size ) {
		$default_src = wp_get_attachment_image_src( $media_id, 'impeka-grve-fullscreen' );
		$img_url = $default_src[0];
	} else {
		$resolutions   = array( 2560, 1600, 768 );
		$hidpi         = TRUE;
		$resolution = FALSE;

		// Get resolution cookie
		if ( isset( $_GET['resolution'] ) ) {
			$cookie_resolution = $_GET['resolution'];
		} else if ( isset( $_COOKIE['resolution'] ) ) {
			$cookie_resolution = $_COOKIE['resolution'];
		} else {
			$cookie_resolution = null;
		}

		// Default values
		$client_width  = 1920;
		$pixel_density = 1;

		if ( isset( $cookie_resolution ) && preg_match( "/^[0-9]+[,]+[0-9.]+$/", $cookie_resolution ) ) {
			$cookie_array = explode( ',', $cookie_resolution );
			// Get screen width.
			if ( count( $cookie_array ) > 0 ) {
				$client_width  = intval( $cookie_array[0] );
			}
			// Get pixel density.
			if ( $hidpi ) {
				if ( count( $cookie_array ) > 1 ) {
					$pixel_density = $cookie_array[1];
				}
			}
		}

		// Scale client screen width according to its pixel density.
		$client_width_scaled = $client_width * $pixel_density;

		// Find the closest available resolution
		$closest = null;
		foreach ( $resolutions as $res ) {
			if ( $closest == null || abs( $client_width_scaled - $closest ) > abs( $res - $client_width_scaled ) ) {
				$closest = $res;
			}
		}
		$resolution = $closest;

		$default_src = wp_get_attachment_image_src( $media_id, 'impeka-grve-fullscreen' );
		$skip_check = false;
		switch( $resolution ) {
			case '2560':
				$img_src = wp_get_attachment_image_src( $media_id, 'full' );
				$skip_check = true;
			break;
			case '768':
				$img_src = wp_get_attachment_image_src( $media_id, 'large' );
			break;
			case '1600':
			default:
				$img_src = $default_src;
			break;
		}

		if( $img_src[1] > $default_src[1]  && !$skip_check ) {
			$img_url = $default_src[0];
		} else {
			$img_url = $img_src[0];
		}
	}

	return $img_url;
}


/**
 * Check Theme Intro Visibility
 */
if ( ! function_exists( 'impeka_grve_check_theme_intro_visibility' ) ) {
	function impeka_grve_check_theme_intro_visibility() {
		$show = false;
		$theme_intro = impeka_grve_option( 'theme_intro' );
		if ( is_front_page() && impeka_grve_is_enabled( $theme_intro ) ) {
			$intro_appearance = impeka_grve_option( 'intro_appearance', 'always' );
			if( 'always' == $intro_appearance ) {
				$show = true;
			} else {
				if ( !isset( $_COOKIE['grve-intro'] ) ) {
					$show = true;
				}
			}
		}
		return $show;
	}
}

/**
 * Get post width
 */
if ( ! function_exists( 'impeka_grve_get_post_width_array' ) ) {
	function impeka_grve_get_post_width_array() {
		return array(
			'large' => 1170,
			'medium' => 970,
			'small' => 770,
		);
	}
}

/**
 * Get post title width
 */
if ( ! function_exists( 'impeka_grve_get_post_title_width_array' ) ) {
	function impeka_grve_get_post_title_width_array() {
		return array(
			'container' => 1170,
			'large' => 770,
			'medium' => 570,
			'small' => 370,
		);
	}
}

/**
 * Extract video ID from youtube url
 */
function impeka_grve_extract_youtube_id( $url ) {
	$youtube_id = "";
	parse_str( parse_url( $url, PHP_URL_QUERY ), $vars );
	if ( ! isset( $vars['v'] ) ) {
		$youtube_id = '';
	} else {
		$youtube_id = $vars['v'];
	}

	return apply_filters( 'impeka_grve_privacy_bg_youtube_id', $youtube_id );
}

/**
 * Allow additional tags in post content
 */
if ( ! function_exists( 'impeka_grve_wp_kses_allowed_html' ) ) {
	function impeka_grve_wp_kses_allowed_html( $allowedposttags, $context ) {
		if ( is_array( $context ) ){
			return $allowedposttags;
		}
		if ( 'post' === $context ) {
			$allowedposttags['iframe'] = array(
				'src' => true,
				'srcdoc' => true,
				'name' => true,
				'sandbox' => true,
				'seamless' => true,
				'width' => true,
				'height' => true,
				'align' => true,
				'frameborder' => true,
				'scrolling' => true,
				'marginwidth' => true,
				'marginheight' => true,
				'allow' => true,
				'id' => true,
				'class' => true,
				'style' => true,
			);
		}
		return $allowedposttags;
	}
}
add_filter( 'wp_kses_allowed_html', 'impeka_grve_wp_kses_allowed_html', 10, 2 );

if ( ! function_exists('impeka_grve_combine_atts') ) {
	function impeka_grve_combine_atts( $pairs, $atts ) {
		$atts = (array) $atts;
		$out  = array();
		foreach ( $pairs as $name => $default ) {
			if ( array_key_exists( $name, $atts ) ) {
				$out[ $name ] = $atts[ $name ];
			} else {
				$out[ $name ] = $default;
			}
		}
		return $out;
	}
}

if ( ! function_exists('impeka_grve_get_template_part') ) {
    function impeka_grve_get_template_part( $template, $slug = '', $args = array() ) {
		get_template_part( $template, $slug, $args );
    }
}

/**
 * Custom Content Filters
 */
add_filter( 'impeka_grve_the_content', 'wptexturize' );
add_filter( 'impeka_grve_the_content', 'convert_smilies', 20 );
add_filter( 'impeka_grve_the_content', 'wpautop' );
add_filter( 'impeka_grve_the_content', 'shortcode_unautop' );
add_filter( 'impeka_grve_the_content', 'prepend_attachment' );
add_filter( 'impeka_grve_the_content', 'wp_filter_content_tags' );
add_filter( 'impeka_grve_the_content', 'do_shortcode', 11 );

//Omit closing PHP tag to avoid accidental whitespace output errors.
