<?php

/*
*	Layout Helper functions
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/


/**
 * Get Grid Layout Attributes
 */
function impeka_grve_get_grid_layout_atts( $params = array() ) {

	$mode = impeka_grve_array_value( $params, 'mode', 'large' );
	$columns_large_screen = impeka_grve_array_value( $params, 'columns_large_screen', '3' );
	$columns = impeka_grve_array_value( $params, 'columns', '3' );
	$columns_tablet_landscape = impeka_grve_array_value( $params, 'columns_tablet_landscape', '2' );
	$columns_tablet_portrait = impeka_grve_array_value( $params, 'columns_tablet_portrait', '2' );
	$columns_mobile = impeka_grve_array_value( $params, 'columns_mobile', '1' );
	$gutter = impeka_grve_array_value( $params, 'gutter' );
	$gutter_size = impeka_grve_array_value( $params, 'gutter_size', '30' );
	$spinner = impeka_grve_array_value( $params, 'spinner', 'no' );
	$display_style = impeka_grve_array_value( $params, 'display_style', 'pagination' );
	$animation = impeka_grve_array_value( $params, 'animation', 'none' );

	if ( 'large' == $mode ) {
		$display_style = 'pagination';
	}
	if ( !impeka_grve_is_enabled( $gutter ) ) {
		$gutter_size = 0;
	}

	$wrapper_attributes = array();
	$wrapper_attributes[] = 'data-display-style="' . esc_attr( $display_style ) . '"';
	$wrapper_attributes[] = 'data-spinner="' . esc_attr( $spinner ) . '"';

	switch( $mode ) {
		case 'masonry':
			$wrapper_attributes[] = 'data-columns-large-screen="' . esc_attr( $columns_large_screen ) . '"';
			$wrapper_attributes[] = 'data-columns="' . esc_attr( $columns ) . '"';
			$wrapper_attributes[] = 'data-columns-tablet-landscape="' . esc_attr( $columns_tablet_landscape ) . '"';
			$wrapper_attributes[] = 'data-columns-tablet-portrait="' . esc_attr( $columns_tablet_portrait ) . '"';
			$wrapper_attributes[] = 'data-columns-mobile="' . esc_attr( $columns_mobile ) . '"';
			$wrapper_attributes[] = 'data-layout="masonry"';
			$wrapper_attributes[] = 'data-gutter-size="' . esc_attr( $gutter_size ) . '"';
			$wrapper_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
			break;
		case 'grid':
			$wrapper_attributes[] = 'data-columns-large-screen="' . esc_attr( $columns_large_screen ) . '"';
			$wrapper_attributes[] = 'data-columns="' . esc_attr( $columns ) . '"';
			$wrapper_attributes[] = 'data-columns-tablet-landscape="' . esc_attr( $columns_tablet_landscape ) . '"';
			$wrapper_attributes[] = 'data-columns-tablet-portrait="' . esc_attr( $columns_tablet_portrait ) . '"';
			$wrapper_attributes[] = 'data-columns-mobile="' . esc_attr( $columns_mobile ) . '"';
			$wrapper_attributes[] = 'data-layout="fitRows"';
			$wrapper_attributes[] = 'data-gutter-size="' . esc_attr( $gutter_size ) . '"';
			$wrapper_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
			break;
		case 'small':
			$wrapper_attributes[] = 'data-columns-large-screen="1"';
			$wrapper_attributes[] = 'data-columns="1"';
			$wrapper_attributes[] = 'data-columns-tablet-landscape="1"';
			$wrapper_attributes[] = 'data-columns-tablet-portrait="1"';
			$wrapper_attributes[] = 'data-columns-mobile="1"';
			$wrapper_attributes[] = 'data-layout="fitRows"';
			$wrapper_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
			break;
		default:
			break;
	}

	return $wrapper_attributes;

}

/**
 * Get Grid Layout Attributes
 */
function impeka_grve_get_indicator_atts( $params = array() ) {

	$indicator = impeka_grve_array_value( $params, 'indicator', 'none' );
	$indicator_text = impeka_grve_array_value( $params, 'indicator_text' );
	$indicator_color = impeka_grve_array_value( $params, 'indicator_color', 'black' );

	$atts = array();
	if ( 'none' != $indicator ) {
		$atts[] = 'data-indicator="' . esc_attr( $indicator ) . '"';
		if ( 'text' == $indicator ) {
			$atts[] = 'data-indicator-text="' . esc_attr( $indicator_text ) . '"';
		}
		$atts[] = 'data-indicator-color="' . esc_attr( $indicator_color ) . '"';
	}
	return $atts;

}

/**
 * Function to fetch content class
 */
function impeka_grve_content_class( $class = '') {
	echo 'class="' . join( ' ', impeka_grve_get_content_classes( $class ) ) . '"';
}

/**
 * Get content classes
 */
function impeka_grve_get_content_classes( $class = '' ) {

	$classes = array();

	if ( $class ) {
		if ( ! is_array( $class ) ) {
			$class = preg_split( '#\s+#', $class );
		}
		$classes = array_map( 'esc_attr', $class );
	} else {
		// Ensure that we always coerce class to being an array.
		$class = array();
	}

	$classes[] = 'clearfix';

	$sidebar_visibility = impeka_grve_global_param( 'sidebar_visibility' );
	if ( 'yes' == $sidebar_visibility ) {
		$classes[] = 'grve-with-sidebar';
		$sidebar_layout = impeka_grve_global_param( 'sidebar_layout' );
		if ( 'right' == $sidebar_layout ) {
			$classes[] = 'grve-right-sidebar';
		} else if ( 'left' == $sidebar_layout ) {
			$classes[] = 'grve-left-sidebar';
		}
	}

	$classes = array_map( 'esc_attr', $classes );
	$classes = apply_filters( 'impeka_grve_content_classes', $classes );
	return array_unique( $classes );
}

/**
 * Navigation Bar
 */

if ( !function_exists('impeka_grve_nav_bar') ) {

	function impeka_grve_nav_bar( $post_type = 'post', $mode = 'layout-1') {

		global $post;

		$has_nav_section = false;
		$prev_post_text = $next_post_text = '';

		if ( 'product' == $post_type ) {
			$grve_in_same_term = impeka_grve_option( 'product_nav_same_term' );
			if( $grve_in_same_term ) {
				$grve_in_same_term = true;
			} else {
				$grve_in_same_term = false;
			}
			$prev_post = get_adjacent_post( $grve_in_same_term, '', true, 'product_cat');
			$next_post = get_adjacent_post( $grve_in_same_term, '', false, 'product_cat' );
			$prev_post_text = impeka_grve_option( 'product_nav_prev_text' );
			$next_post_text = impeka_grve_option( 'product_nav_next_text' );
			$bg_mode = impeka_grve_option( 'product_nav_bg_mode' );
			$skin_assets = impeka_grve_option( 'product_nav_skin_assets' );
			if ( impeka_grve_visibility( 'product_nav_visibility', '1' )  && ( is_a( $prev_post, 'WP_Post' ) || is_a( $next_post, 'WP_Post' ) ) ) {
				$has_nav_section = true;
			}
		} elseif( 'portfolio' == $post_type ) {
			$grve_nav_term = impeka_grve_option( 'portfolio_nav_term', 'none' );
			if( 'none' != $grve_nav_term ) {
				$grve_in_same_term = true;
			} else {
				$grve_in_same_term = false;
				$grve_nav_term = 'portfolio_category';
			}
			$prev_post = get_adjacent_post( $grve_in_same_term, '', true, $grve_nav_term );
			$next_post = get_adjacent_post( $grve_in_same_term, '', false, $grve_nav_term );
			$prev_post_text = impeka_grve_option( 'portfolio_nav_prev_text' );
			$next_post_text = impeka_grve_option( 'portfolio_nav_next_text' );
			$bg_mode = impeka_grve_option( 'portfolio_nav_bg_mode' );
			$skin_assets = impeka_grve_option( 'portfolio_nav_skin_assets' );
			if ( impeka_grve_visibility( 'portfolio_nav_visibility', '1' )  && ( is_a( $prev_post, 'WP_Post' ) || is_a( $next_post, 'WP_Post' ) ) ) {
				$has_nav_section = true;
			}
		} elseif( 'event' == $post_type && impeka_grve_events_calendar_enabled() ) {
			$prev_post = Tribe__Events__Main::instance()->get_closest_event( $post, 'previous' ) ;
			$next_post = Tribe__Events__Main::instance()->get_closest_event( $post, 'next' ) ;
			$prev_post_text = impeka_grve_option( 'event_nav_prev_text' );
			$next_post_text = impeka_grve_option( 'event_nav_next_text' );
			$bg_mode = impeka_grve_option( 'event_nav_bg_mode' );
			$skin_assets = impeka_grve_option( 'event_nav_skin_assets' );
			if ( impeka_grve_visibility( 'event_nav_visibility', '1' )  && ( is_a( $prev_post, 'WP_Post' ) || is_a( $next_post, 'WP_Post' ) ) ) {
				$has_nav_section = true;
			}
		}  else {
			$grve_in_same_term = impeka_grve_visibility( 'post_nav_same_term', '0' );
			$prev_post = get_adjacent_post( $grve_in_same_term, '', true);
			$next_post = get_adjacent_post( $grve_in_same_term, '', false);
			$prev_post_text = impeka_grve_option( 'post_nav_prev_text' );
			$next_post_text = impeka_grve_option( 'post_nav_next_text' );
			$bg_mode = impeka_grve_option( 'post_nav_bg_mode' );
			$skin_assets = impeka_grve_option( 'post_nav_skin_assets' );
			if ( impeka_grve_visibility( 'post_nav_visibility', '1' )  && ( is_a( $prev_post, 'WP_Post' ) || is_a( $next_post, 'WP_Post' ) ) ) {
				$has_nav_section = true;
			}
		}

		if ( 'check' == $mode ) {
			return $has_nav_section;
		}

		$grve_backlink = $grve_backlink_url = $grve_backlink_title = '';

		if ( 'event' == $post_type && impeka_grve_events_calendar_enabled() ) {
			$grve_backlink_url = tribe_get_events_link();
			$grve_backlink_title = tribe_get_event_label_plural();
		} else {
			$grve_backlink = impeka_grve_post_meta( '_impeka_grve_backlink_id', impeka_grve_option( $post_type . '_backlink_id' ) );
			if( !empty( $grve_backlink ) ) {
				$grve_backlink = apply_filters( 'wpml_object_id', $grve_backlink, 'page', TRUE  );
				$grve_backlink_url = get_permalink( $grve_backlink );
			}
		}


		if ( $has_nav_section ) {

			$prev_post_title = $next_post_title = '';
			$prev_post_img_url = $next_post_img_url = '';

			if ( is_a( $prev_post, 'WP_Post' ) ) {
				$prev_post_title = get_the_title( $prev_post->ID );
				if ( has_post_thumbnail( $prev_post->ID ) ) {
					$post_thumbnail_id = get_post_thumbnail_id( $prev_post->ID );
					$attachment_src = wp_get_attachment_image_src( $post_thumbnail_id, 'large' );
					if ( $attachment_src  ) {
						$prev_post_img_url = $attachment_src[0];
					}
				}
			}
			if ( is_a( $next_post, 'WP_Post' ) ) {
				$next_post_title = get_the_title( $next_post->ID );
				if ( has_post_thumbnail( $next_post->ID ) ) {
					$post_thumbnail_id = get_post_thumbnail_id( $next_post->ID );
					$attachment_src = wp_get_attachment_image_src( $post_thumbnail_id, 'large' );
					if ( $attachment_src  ) {
						$next_post_img_url = $attachment_src[0];
					}
				}
			}

			$nav_params = array(
				'post_type' => $post_type,
				'prev_post' => $prev_post,
				'prev_post_title' => $prev_post_title,
				'prev_post_text' => $prev_post_text,
				'prev_post_img_url' => $prev_post_img_url,
				'next_post' => $next_post,
				'next_post_title' => $next_post_title,
				'next_post_text' => $next_post_text,
				'next_post_img_url' => $next_post_img_url,
				'backlink_url' => $grve_backlink_url,
				'backlink_title' => $grve_backlink_title,
				'bg_mode' => $bg_mode,
				'skin_assets' => $skin_assets,
			);
			get_template_part( 'templates/singular/navigation-bar/navigation-bar-' . $mode, '', $nav_params );

		}
	}
}

/**
 * Social Like
 */
 if ( !function_exists('impeka_grve_social_like') ) {
	function impeka_grve_social_like( $post_type = 'post', $mode = '') {
		$post_likes = impeka_grve_option( $post_type . '_social', '', 'grve-likes' );
		if ( !empty( $post_likes  ) ) {
			global $post;
			$post_id = $post->ID;
			if ( 'icon' == $mode ) {
?>
			<div class="grve-like-counter grve-link-text"><i class="fas fa-heart-o"></i><span><?php echo impeka_grve_likes( $post_id, 'number' ); ?></span></div>
<?php
			} else {
?>
			<li class="grve-like-counter <?php echo impeka_grve_likes( $post_id, 'status' ); ?>"><span><?php echo impeka_grve_likes( $post_id ); ?></span></li>
<?php
			}
		}
	}
}

/**
 * Social Bar
 */

if ( !function_exists('impeka_grve_social_bar') ) {
	function impeka_grve_social_bar( $post_type = 'post', $mode = 'layout-1' ) {

		$has_nav_section = false;

		$grve_socials = impeka_grve_option( $post_type . '_social');
		if ( is_array( $grve_socials ) ) {
			$grve_socials = array_filter( $grve_socials );
		} else {
			$grve_socials = '';
		}

		if ( !empty( $grve_socials ) ) {
			$has_nav_section = true;
		}

		if ( 'check' == $mode ) {
			return $has_nav_section;
		}

		if ( $has_nav_section ) {
			$social_params = array(
				'post_type' => $post_type,
				'social_email' => impeka_grve_option( $post_type . '_social', '', 'email' ),
				'social_facebook' => impeka_grve_option( $post_type . '_social', '', 'facebook' ),
				'social_twitter' => impeka_grve_option( $post_type . '_social', '', 'twitter' ),
				'social_linkedin' => impeka_grve_option( $post_type . '_social', '', 'linkedin' ),
				'social_pinterest' => impeka_grve_option( $post_type . '_social', '', 'pinterest' ),
				'social_reddit' => impeka_grve_option( $post_type . '_social', '', 'reddit' ),
				'social_tumblr' => impeka_grve_option( $post_type . '_social', '', 'tumblr' ),
				'social_likes' => impeka_grve_option( $post_type . '_social', '', 'grve-likes' ),
				'social_title' => impeka_grve_option( $post_type . '_social_share_title' ),
			);
			get_template_part( 'templates/singular/social-bar/social-bar-' . $mode, '', $social_params );

		}
	}
}

/**
 * Get Thumbnail
 */

if ( !function_exists('impeka_grve_get_thumbnail_url') ) {
	function impeka_grve_get_thumbnail_url( $image_size = 'impeka-grve-small-square' ) {

		if ( has_post_thumbnail() ) {
			$post_thumbnail_id = get_post_thumbnail_id( get_the_ID() );
			$attachment_src = wp_get_attachment_image_src( $post_thumbnail_id, $image_size );
			$image_src = $attachment_src[0];
		} else {
			$image_src = get_template_directory_uri() . '/images/empty/' . $image_size . '.jpg';
		}
		return $image_src ;
	}
}

/**
 * Quickview ajax callback
 */
function impeka_grve_quick_view( $post_id ) {
	if ( isset( $_POST['grve_view_id'] ) ) {
		$post_id = sanitize_text_field( $_POST['grve_view_id'] );
		$post_type = get_post_type( $post_id );
		if ( $post_type ) {
			if( class_exists('WPBMap') && method_exists('WPBMap', 'addAllMappedShortcodes') ) {
				WPBMap::addAllMappedShortcodes();
			}
			get_template_part( 'templates/singular/quick-view/quick-view', $post_type, array( 'post_id' => $post_id ) );
		}
	}
	die();
}

add_action( 'wp_ajax_impeka_grve_quick_view_callback', 'impeka_grve_quick_view' );
add_action( 'wp_ajax_nopriv_impeka_grve_quick_view_callback', 'impeka_grve_quick_view' );

//Omit closing PHP tag to avoid accidental whitespace output errors.
