<?php

/*
 *	Media functions
 *
 * 	@version	1.0
 * 	@author		Greatives Team
 * 	@URI		https://greatives.eu
 */




if ( !function_exists( 'impeka_grve_print_hover_media' ) ) {
	function impeka_grve_print_hover_media( $params = array() ) {
		$element = impeka_grve_array_value( $params, 'element', 'image' );
		$image_size= impeka_grve_array_value( $params, 'image_size' );
		$image_atts= impeka_grve_array_value( $params, 'image_atts' );
		$link_type = impeka_grve_array_value( $params, 'link_type' );
		$video_icon_color = impeka_grve_array_value( $params, 'video_icon_color', 'none' );

		switch( $element ) {
			case 'image':
				$image_id = impeka_grve_array_value( $params, 'image_id' );
				$image_ids = impeka_grve_array_value( $params, 'image_ids' );

				$attachments = explode( ",", $image_ids );
				if ( 'gallery-popup' == $link_type && !empty( $image_ids ) && !empty( $attachments ) ) {
					$image_popup_title_caption = impeka_grve_array_value( $params, 'image_popup_title_caption' );
					$image_popup_size = impeka_grve_array_value( $params, 'image_popup_size' );

					$index = 0;
					echo '<div class="grve-hidden">';
					foreach ( $attachments as $id ) {
						$gallery_link_atts = array();
						$full_src = wp_get_attachment_image_src( $id, $image_popup_size );
						$full_url = $full_src[0];
						$image_title = get_post_field( 'post_title', $id );
						$image_caption = get_post_field( 'post_excerpt', $id );
						$data_html = '';
						if ( !empty( $image_title ) && 'none' != $image_popup_title_caption && 'caption-only' != $image_popup_title_caption ) {
							$data_html .= '<span class="grve-title">' . $image_title . '</span>';
						}
						if ( !empty( $image_caption ) && 'none' != $image_popup_title_caption && 'title-only' != $image_popup_title_caption ) {
							$data_html .= '<span class="grve-caption">' . $image_caption . '</span>';
						}
						if ( !empty( $data_html ) ) {
							$gallery_link_atts[] = 'data-sub-html="' . esc_attr( $data_html ) . '"';
						}
						if ( 0 != $index ) {
							echo '<a class="grve-item-url" href="' . esc_url( $full_url ) . '" ' . implode( ' ', $gallery_link_atts ) . '></a>';
						}
						$index ++;
					}
					echo '</div>';
				} elseif ('video-popup' == $link_type ) {
					if ( 'none' != $video_icon_color ) {
						echo impeka_grve_get_video_icon( $video_icon_color);
					}
				}
				if ( !empty( $image_id ) ) {
					if (is_numeric( $image_id )) {
						echo impeka_grve_get_attachment_image( $image_id, $image_size, '', $image_atts );
					} else {
						echo impeka_grve_get_fallback_image_wrapper( 'full', 'custom', $image_id );
					}
				} else {
					echo impeka_grve_get_fallback_image_wrapper( $image_size );
				}
			break;
			case 'portfolio':
				impeka_grve_print_portfolio_image( $image_size, $image_atts );
			break;
			default:
				$image_id = impeka_grve_array_value( $params, 'image_id' );
				if ( !empty( $image_id ) ) {
					if ('video-popup' == $link_type && 'none' != $video_icon_color ) {
						echo impeka_grve_get_video_icon( $video_icon_color );
					}
					echo impeka_grve_get_attachment_image( $image_id, $image_size, '', $image_atts );
				}
			break;
		}
	}
}

if ( !function_exists( 'impeka_grve_print_hover_title' ) ) {
	function impeka_grve_print_hover_title( $params = array() ) {

		$title = impeka_grve_array_value( $params, 'title' );
		if( !empty( $title ) ) {
			$style = impeka_grve_array_value( $params, 'style' );
			$title_heading_tag = impeka_grve_array_value( $params, 'title_heading_tag', 'h3' );
			$title_heading = impeka_grve_array_value( $params, 'title_heading', 'h3' );
			$title_custom_font_family = impeka_grve_array_value( $params, 'title_custom_font_family' );
			$title_color = impeka_grve_array_value( $params, 'title_color', 'white' );
			$title_bg_color = impeka_grve_array_value( $params, 'title_bg_color', 'transparent' );

			//Image Title
			$title_classes = array( 'grve-title' );
			$title_classes[]  = 'grve-' . $title_heading;
			$title_classes[]  = 'grve-text-' . $title_color;
			if ( 'style-5' == $style && 'transparent' != $title_bg_color ) {
				$title_classes[]  = 'grve-bg-' . $title_bg_color;
			}
			if ( !empty( $title_custom_font_family ) ) {
				$title_classes[]  = 'grve-' . $title_custom_font_family;
			}
			$title_class_string = implode( ' ', $title_classes );

	?>
		<<?php echo tag_escape( $title_heading_tag ); ?> class="<?php echo esc_attr( $title_class_string ); ?>"><span><?php echo wp_kses_post( $title ); ?></span></<?php echo tag_escape( $title_heading_tag ); ?>>
	<?php
		}
	}
}

 /**
 * Generic function that prints a slider/carousel navigation
 */
function impeka_grve_element_navigation( $navigation_style, $arrows, $pagination) {

	$output = '';

	if ( 1 == $navigation_style ) {
		if( 'yes' == $arrows ) {
			$output .= '<div class="grve-carousel-buttons">';
			$output .= '	<div class="grve-carousel-prev">';
			$output .= impeka_grve_get_svg_icon( 'arrow-1' );
			$output .= '	</div>';
			$output .= '	<div class="grve-carousel-next">';
			$output .= impeka_grve_get_svg_icon( 'arrow-1' );
			$output .= '	</div>';
			$output .= '</div>';
		}
		if( 'yes' == $pagination ) {
			$output .= '<ul class="flickity-page-dots"></ul>';
		}
	} else if ( 2 == $navigation_style ) {
		$output .= '<div class="grve-nav-wrapper">';
		$output .= '	<div class="grve-container">';
		$output .= '		<div class="grve-nav-inner">';
		$output .= '			<div class="grve-nav-left-area">';
		if( 'yes' == $pagination ) {
			$output .= '<ul class="flickity-page-dots"></ul>';
		}
		$output .= '			</div>';
		$output .= '			<div class="grve-nav-right-area">';
		if( 'yes' == $arrows ) {
			$output .= '				<div class="grve-slider-progress">';
			$output .= '					<div class="grve-current-slide grve-link-text"><div class="grve-counter"></div></div>';
			$output .= '					<div class="grve-slider-bar-wrapper">';
			$output .= '						<div class="grve-slider-bar"></div>';
			$output .= '						<div class="grve-slider-bar-bg"></div>';
			$output .= '					</div>';
			$output .= '					<div class="grve-total-slide grve-link-text"></div>';
			$output .= '				</div>';
			$output .= '				<div class="grve-carousel-next">';
			$output .= impeka_grve_get_svg_icon( 'arrow-2' );
			$output .= '				</div>';
		}
		$output .= '			</div>';
		$output .= '		</div>';
		$output .= '	</div>';
		$output .= '</div>';
	} else if ( 3 == $navigation_style ) {
		$output .= '<div class="grve-nav-wrapper">';
		$output .= '	<div class="grve-container">';
		$output .= '		<div class="grve-nav-inner">';
		$output .= '			<div class="grve-nav-left-area">';
		if( 'yes' == $arrows ) {
			$output .= '			<div class="grve-carousel-prev">';
			$output .= impeka_grve_get_svg_icon( 'arrow-1' );
			$output .= '			</div>';
			$output .= '			<div class="grve-carousel-next">';
			$output .= impeka_grve_get_svg_icon( 'arrow-1' );
			$output .= '			</div>';
		}
		$output .= '			</div>';
		$output .= '			<div class="grve-nav-right-area">';
		if( 'yes' == $pagination ) {
			$output .= '<ul class="flickity-page-dots"></ul>';
		}
		$output .= '			</div>';
		$output .= '		</div>';
		$output .= '	</div>';
		$output .= '</div>';
	}

	return 	$output;

}

/**
 * Generic function that prints a slider or gallery
 */
if ( !function_exists( 'impeka_grve_print_gallery_slider' ) ) {
	function impeka_grve_print_gallery_slider( $gallery_mode, $slider_items , $image_size_slider = 'impeka-grve-large-rect-horizontal', $extra_class = "") {

		if ( empty( $slider_items ) ) {
			return;
		}
		$image_link_mode = "";
		if ( is_singular( 'portfolio' ) ) {
			$image_link_mode = impeka_grve_post_meta( '_impeka_grve_portfolio_media_image_link_mode' );
		}
?>
		<div class="grve-media clearfix <?php echo esc_attr( $extra_class ); ?>">
<?php
		if ( empty( $gallery_mode ) ) {
			 $gallery_mode = 'gallery';
		}

		if ( 'gallery' == $gallery_mode || 'gallery-vertical' == $gallery_mode ) {

			$image_size_gallery_thumb = 'impeka-grve-small-rect-horizontal';
			if( 'gallery-vertical' == $gallery_mode ) {
				$image_size_gallery_thumb = $image_size_slider;
			}

			$gallery_classes = array( 'grve-gallery' );
			if( empty( $image_link_mode ) ){
				$gallery_classes[] = 'grve-gallery-popup';
			}
			if( 'gallery-vertical' == $gallery_mode ) {
				$gallery_classes[] = 'grve-vertical-style';
			} else {
				$gallery_classes[] = 'grve-classic-style';
			}
			$gallery_class_string = implode( ' ', $gallery_classes );
	?>
			<div class="<?php echo esc_attr( $gallery_class_string ); ?>">
	<?php

			foreach ( $slider_items as $slider_item ) {

				$media_id = $slider_item['id'];
				$full_src = wp_get_attachment_image_src( $media_id, 'impeka-grve-fullscreen' );
				if ( !$full_src ) {
					continue;
				}
				$image_full_url = $full_src[0];

				$caption = get_post_field( 'post_excerpt', $media_id );
				$figcaption = '';
				if	( !empty( $caption ) ) {
					$figcaption = wptexturize( $caption );
				}
	?>
				<?php if( empty( $image_link_mode ) ){ ?>
					<div class="grve-gallery-item">
						<a class="grve-item-url" data-title="<?php echo esc_attr( $figcaption ); ?>" href="<?php echo esc_url( $image_full_url ); ?>"></a>
						<?php echo impeka_grve_get_attachment_image( $media_id, $image_size_gallery_thumb, '', array( 'data-column-space' => '100' ) ); ?>
					</div>
				<?php } else { ?>
					<div class="grve-gallery-item">
						<?php echo impeka_grve_get_attachment_image( $media_id, $image_size_gallery_thumb, '', array( 'data-column-space' => '100' ) ); ?>
					</div>
				<?php } ?>
	<?php

			}
	?>
			</div>
	<?php
		} else {

			$slider_settings = array();
			if ( is_singular( 'post' ) || is_singular( 'portfolio' ) ) {
				if ( is_singular( 'post' ) ) {
					$slider_settings = impeka_grve_post_meta( '_impeka_grve_post_slider_settings' );
				} else {
					$slider_settings = impeka_grve_post_meta( '_impeka_grve_portfolio_slider_settings' );
				}
			}
			$slider_speed = impeka_grve_array_value( $slider_settings, 'slideshow_speed', '2500' );
			$nav_visibility = impeka_grve_array_value( $slider_settings, 'arrows', 'yes' );
			$nav_icon_color = impeka_grve_array_value( $slider_settings, 'direction_nav_color', 'black' );

			$nav_params = array(
				'nav_visibility' => $nav_visibility,
				'nav_icon' => 'arrow-1',
				'nav_icon_color' => $nav_icon_color,
			);

			//Slider Element Wrapper
			$slider_attributes = array();
			$slider_attributes[] = 'data-slider-speed="' . esc_attr( $slider_speed ) . '"';
			$slider_attributes[] = 'data-slider-pause="yes"';
			$slider_attributes[] = 'data-slider-autoheight="no"';
			$slider_attributes[] = 'data-pagination-color="' . esc_attr( $nav_icon_color ) . '"';

			$slider_classes = array( 'grve-slider-element' );
			$slider_class_string = implode( ' ', $slider_classes );
			$slider_attributes[] = 'class="' . esc_attr( $slider_class_string ) . '"';

	?>
			<div class="grve-slider grve-layout-1">
				<div class="grve-carousel-wrapper">
					<?php get_template_part( 'templates/navigation/carousel-nav', '', $nav_params ); ?>
					<div <?php echo implode( ' ', $slider_attributes ); ?>>
	<?php
							foreach ( $slider_items as $slider_item ) {
								$media_id = $slider_item['id'];
								$full_src = wp_get_attachment_image_src( $media_id, 'impeka-grve-fullscreen' );
								if ( !$full_src ) {
									continue;
								}
								echo '<div class="grve-slider-item">';
								echo impeka_grve_get_attachment_image( $media_id, $image_size_slider, '', array( 'data-column-space' => '100' ) );
								echo '</div>';

							}
	?>
					</div>
				</div>
			</div>
	<?php
		}
	?>
		</div>
	<?php
	}
}

/**
 * Generic function that prints video settings ( HTML5 )
 */

if ( !function_exists( 'impeka_grve_print_media_video_settings' ) ) {
	function impeka_grve_print_media_video_settings( $video_settings ) {
		$video_attr = '';

		if ( !empty( $video_settings ) ) {

			$video_poster = impeka_grve_array_value( $video_settings, 'poster' );
			$video_preload = impeka_grve_array_value( $video_settings, 'preload', 'metadata' );

			if( 'yes' == impeka_grve_array_value( $video_settings, 'controls' ) ) {
				$video_attr .= ' controls';
			}
			if( 'yes' == impeka_grve_array_value( $video_settings, 'loop' ) ) {
				$video_attr .= ' loop="loop"';
			}
			if( 'yes' ==  impeka_grve_array_value( $video_settings, 'muted' ) ) {
				$video_attr .= ' muted="muted"';
			}
			if( 'yes' == impeka_grve_array_value( $video_settings, 'autoplay' ) ) {
				$video_attr .= ' autoplay="autoplay"';
			}
			if( 'yes' == impeka_grve_array_value( $video_settings, 'playsinline' ) ) {
				$video_attr .= ' playsinline';
			}
			if( !empty( $video_poster ) ) {
				$video_attr .= ' poster="' . esc_url( $video_poster ) . '"';
			}
			$video_attr .= ' preload="' . esc_attr( $video_preload ) . '"';

		}
		return $video_attr;
	}
}

/**
 * Generic function that prints a video ( Embed or HTML5 )
 */
function impeka_grve_print_media_video( $video_mode, $video_webm, $video_mp4, $video_ogv, $video_embed, $video_poster = '' ) {
	global $wp_embed;

	if( empty( $video_mode ) ) {
		if ( !empty( $video_embed ) ) {
			echo '<div class="grve-media">' . $wp_embed->run_shortcode( '[embed]' . $video_embed . '[/embed]' ) . '</div>';
		}
	} elseif( 'code' == $video_mode ) {
		if ( !empty( $video_embed ) ) {
			echo '<div class="grve-media">' . $video_embed . '</div>';
		}
	} else {
		if ( !empty( $video_webm ) || !empty( $video_mp4 ) || !empty( $video_ogv ) ) {

			$video_settings = array(
				'controls' => 'yes',
				'poster' => $video_poster,
			);
			$video_settings = apply_filters( 'impeka_grve_media_video_settings', $video_settings );

			echo '<div class="grve-media">';
			echo '<video ' . impeka_grve_print_media_video_settings( $video_settings ) . ' >';

			if ( !empty( $video_webm ) ) {
				echo '<source src="' . esc_url( $video_webm ) . '" type="video/webm">';
			}
			if ( !empty( $video_mp4 ) ) {
				echo '<source src="' . esc_url( $video_mp4 ) . '" type="video/mp4">';
			}
			if ( !empty( $video_ogv ) ) {
				echo '<source src="' . esc_url( $video_ogv ) . '" type="video/ogg">';
			}
			echo '</video>';
			echo '</div>';

		}
	}

}

/**
 * Print video icon
 */
if ( !function_exists( 'impeka_grve_get_video_icon' ) ) {
	function impeka_grve_get_video_icon( $color = 'white', $position = '' ) {
		$icon_classes[] = 'grve-video-icon';
		$icon_classes[]  = 'grve-bg-' . $color;
		if( 'white' == $color || 'grey' == $color ) {
			$icon_classes[] = 'grve-svg-black';
		} else {
			$icon_classes[] = 'grve-svg-white';
		}
		if ( !empty( $position ) ) {
			$icon_classes[]  = 'grve-icon-' . $position;
		}
		$icon_class_string = implode( ' ', $icon_classes );

		$icon_output = '';
		$icon_output .= '<div class="' . esc_attr( $icon_class_string ) . '">';
		$icon_output .= impeka_grve_get_svg_icon( 'video-1' );
		$icon_output .= '</div>';

		return $icon_output;
	}
}

/**
 * Get Mansorny Data
 */

function impeka_grve_get_masonry_data( $index, $columns ) {

	$image_size_class = "grve-image-square";
	$image_size = 'impeka-grve-small-square';

	if( '2' == $columns ) {
		if ( $index % 3  == 0 ) {
			$image_size_class = "grve-image-landscape";
			$image_size = 'impeka-grve-medium-square';
		}
	}

	if( '3' == $columns ) {

		if ( $index % 4  == 0 ) {
			$image_size_class = "grve-image-landscape";
			$image_size = "impeka-grve-medium-square";
		}
		if ( $index % 5  == 0 ) {
			$image_size_class = "grve-image-square";
			$image_size = 'impeka-grve-small-square';
		}
		if ( $index % 6  == 0 ) {
			$image_size_class = "grve-image-square";
			$image_size = 'impeka-grve-small-square';
		}
		if ( $index % 7  == 0 ) {
			$image_size_class = "grve-image-portrait";
			$image_size = 'impeka-grve-medium-square';
		}
		if ( $index % 8  == 0 ) {
			$image_size_class = "grve-image-square";
			$image_size = 'impeka-grve-small-square';
		}
		if ( $index % 9  == 0 ) {
			$image_size_class = "grve-image-square";
			$image_size = 'impeka-grve-small-square';
		}
		if ( $index % 10  == 0 ) {
			$image_size_class = "grve-image-square";
			$image_size = 'impeka-grve-small-square';
		}
	}

	if( '4' == $columns ) {

		if ( $index % 3  == 0 ) {
			$image_size_class = "grve-image-portrait";
			$image_size = 'impeka-grve-medium-square';
		}
		if ( $index % 5  == 0 ) {
			$image_size_class = "grve-image-landscape";
			$image_size = "impeka-grve-medium-square";
		}
		if ( $index % 6  == 0 ) {
			$image_size_class = "grve-image-square";
			$image_size = 'impeka-grve-small-square';
		}
		if ( $index % 7  == 0 ) {
			$image_size_class = "grve-image-large-square";
			$image_size = 'impeka-grve-medium-square';
		}
		if ( $index % 10  == 0 ) {
			$image_size_class = "grve-image-square";
			$image_size = 'impeka-grve-small-square';
		}
		if ( $index % 14  == 0 ) {
			$image_size_class = "grve-image-square";
			$image_size = 'impeka-grve-small-square';
		}

	}

	if( '5' == $columns ) {

		if ( $index % 3  == 0 ) {
			$image_size_class = "grve-image-portrait";
			$image_size = 'impeka-grve-medium-rect-vertical';
		}
		if ( $index % 6  == 0 ) {
			$image_size_class = "grve-image-landscape";
			$image_size = "impeka-grve-medium-rect-horizontal";
		}
		if ( $index % 9  == 0 ) {
			$image_size_class = "grve-image-large-square";
			$image_size = 'impeka-grve-medium-square';
		}
	}

	return array(
		'class' => $image_size_class,
		'image_size' => $image_size,
	);
}

function impeka_grve_get_custom_masonry_data( $size = 'square' ) {

	switch( $size ) {
		case 'landscape':
			$image_size_class = "grve-image-landscape";
			$image_size = 'impeka-grve-medium-rect-horizontal';
			break;
		case 'portrait':
			$image_size_class = "grve-image-portrait";
			$image_size = 'impeka-grve-medium-rect-vertical';
			break;
		case 'large-square':
			$image_size_class = "grve-image-large-square";
			$image_size = 'impeka-grve-medium-square';
			break;
		case 'square':
		default:
			$image_size_class = "grve-image-square";
			$image_size = 'impeka-grve-small-square';
			break;
	}
	return array(
		'class' => $image_size_class,
		'image_size' => $image_size,
	);
}

function impeka_grve_get_broken_grid_data( $index, $layout ) {

	$image_size_class = "grve-image-square";
	$image_size = 'impeka-grve-small-square';

	if( 'layout-1' == $layout ) {
		if ( $index % 4  == 0 ) {
			$image_size_class = "grve-image-landscape";
			$image_size = "impeka-grve-medium-rect-horizontal";
		}
		if ( $index % 5  == 0 ) {
			$image_size_class = "grve-image-portrait";
			$image_size = 'impeka-grve-medium-rect-vertical';
		}
	}

	if( 'layout-2' == $layout ) {
		if ( $index % 1  == 0 ) {
			$image_size_class = "grve-image-portrait";
			$image_size = 'impeka-grve-medium-rect-vertical';
		}
		if ( $index % 2  == 0 ) {
			$image_size_class = "grve-image-square";
			$image_size = 'impeka-grve-small-square';
		}
		if ( $index % 11  == 0 ) {
			$image_size_class = "grve-image-landscape";
			$image_size = "impeka-grve-medium-rect-horizontal";
		}
	}

	if( 'layout-3' == $layout ) {
		if ( $index % 5  == 0 ) {
			$image_size_class = "grve-image-portrait";
			$image_size = 'impeka-grve-medium-rect-vertical';
		}
		if ( $index % 8  == 0 ) {
			$image_size_class = "grve-image-portrait";
			$image_size = 'impeka-grve-medium-rect-vertical';
		}
		if ( $index % 6  == 0 ) {
			$image_size_class = "grve-image-landscape";
			$image_size = "impeka-grve-medium-rect-horizontal";
		}
	}

	if( 'layout-4' == $layout ) {
		$image_size_class = "grve-image-portrait";
		$image_size = 'impeka-grve-medium-rect-vertical';
		if ( $index % 2  == 0 ) {
			$image_size_class = "grve-image-landscape";
			$image_size = "impeka-grve-medium-rect-horizontal";
		}
		if ( $index % 3  == 0 ) {
			$image_size_class = "grve-image-landscape";
			$image_size = "impeka-grve-medium-rect-horizontal";
		}
		if ( $index % 5  == 0 ) {
			$image_size_class = "grve-image-landscape";
			$image_size = "impeka-grve-medium-rect-horizontal";
		}
		if ( $index % 9  == 0 ) {
			$image_size_class = "grve-image-landscape";
			$image_size = "impeka-grve-medium-rect-horizontal";
		}
		if ( $index % 12  == 0 ) {
			$image_size_class = "grve-image-landscape";
			$image_size = "impeka-grve-medium-rect-horizontal";
		}
	}

	return array(
		'class' => $image_size_class,
		'image_size' => $image_size,
	);
}

/**
 * Get Image Size for fallback images
 */

function impeka_grve_get_image_size( $image_mode = 'large', $index = 1 ) {

	switch( $image_mode ) {
		case 'thumbnail':
			$image_size = 'thumbnail';
		break;
		case 'medium':
			$image_size = 'medium';
		break;
		case 'medium_large':
			$image_size = 'medium_large';
		break;
		case 'large':
			$image_size = 'large';
		break;
		case 'square':
			$image_size = 'impeka-grve-small-square';
		break;
		case 'landscape':
			$image_size = 'impeka-grve-small-rect-horizontal';
		break;
		case 'landscape-medium':
			$image_size = 'impeka-grve-medium-rect-horizontal';
		break;
		case 'portrait':
			$image_size = 'impeka-grve-small-rect-vertical';
		break;
		case 'portrait-medium':
			$image_size = 'impeka-grve-medium-rect-vertical';
		break;
		case 'landscape-large-wide':
			$image_size = 'impeka-grve-large-rect-horizontal';
		break;
		case 'fullscreen':
		case 'extra-extra-large':
			$image_size = 'impeka-grve-fullscreen';
		break;
		case 'full':
			$image_size = 'full';
		break;
		case 'loop':
			$image_size = "impeka-grve-small-rect-vertical";
			if ( $index % 2  == 0 ) {
				$image_size = "impeka-grve-medium-rect-horizontal";
			}
		break;
		default:
			$image_size = 'full';
		break;
	}

	return $image_size;

}

function impeka_grve_get_all_image_sizes() {
    global $_wp_additional_image_sizes;
    $default_image_sizes = get_intermediate_image_sizes();
    foreach ( $default_image_sizes as $size ) {
        $image_sizes[ $size ][ 'width' ] = intval( get_option( "{$size}_size_w" ) );
        $image_sizes[ $size ][ 'height' ] = intval( get_option( "{$size}_size_h" ) );
        $image_sizes[ $size ][ 'crop' ] = get_option( "{$size}_crop" ) ? get_option( "{$size}_crop" ) : false;
    }
    if ( isset( $_wp_additional_image_sizes ) && count( $_wp_additional_image_sizes ) ) {
        $image_sizes = array_merge( $image_sizes, $_wp_additional_image_sizes );
    }
    return $image_sizes;
}

function impeka_grve_add_image_dimensions( $options ) {
    $image_sizes = impeka_grve_get_all_image_sizes();
	$new_options =  array();

	foreach ( $options as $image_mode => $desc ) {
		$size = impeka_grve_get_image_size( $image_mode );
		if ( isset( $image_sizes[$size] ) ) {
			$dim = ' - ' . $image_sizes[$size]['width'] . 'x' . $image_sizes[$size]['height'] ;
			$new_options[ $image_mode ] = $desc . $dim;
		} else {
			$new_options[ $image_mode ] = $desc ;
		}
    }
    return $new_options;
}
add_filter( 'impeka_grve_add_image_dimensions', 'impeka_grve_add_image_dimensions' );

function impeka_grve_get_fallback_image_attr( $size = '' ) {

	$image_atts = array();

	switch( $size ) {
		case 'thumbnail':
			$image_atts['width'] = "150";
			$image_atts['height'] = "150";
		break;
		case 'medium':
			$image_atts['width'] = "300";
			$image_atts['height'] = "300";
		break;
		case 'large':
			$image_atts['width'] = "1024";
			$image_atts['height'] = "768";
		break;
		case 'impeka-grve-small-square':
			$image_atts['width'] = "560";
			$image_atts['height'] = "560";
		break;
		case 'impeka-grve-medium-square':
			$image_atts['width'] = "900";
			$image_atts['height'] = "900";
		break;
		case 'impeka-grve-small-rect-horizontal':
			$image_atts['width'] = "560";
			$image_atts['height'] = "420";
		break;
		case 'impeka-grve-medium-rect-horizontal':
			$image_atts['width'] = "900";
			$image_atts['height'] = "675";
		break;
		case 'impeka-grve-small-rect-vertical':
			$image_atts['width'] = "560";
			$image_atts['height'] = "745";
		break;
		case 'impeka-grve-medium-rect-vertical':
			$image_atts['width'] = "840";
			$image_atts['height'] = "1120";
		break;
		case 'impeka-grve-fullscreen':
		default:
			$size = 'full';
			$image_atts['width'] = "1920";
			$image_atts['height'] = "1080";
		break;
	}
	$placeholder_mode = impeka_grve_option( 'placeholder_mode', 'dummy' );
	$placeholder_mode =  apply_filters( 'impeka_grve_placeholder_mode', $placeholder_mode );
	switch( $placeholder_mode ) {
		case 'placehold':
			$image_atts['url'] = 'https://placehold.it/' . $image_atts['width'] . 'x' . $image_atts['height'];
		break;
		case 'unsplash':
			$image_atts['url'] = 'https://source.unsplash.com/category/people/' . $image_atts['width'] . 'x' . $image_atts['height'] . '?sig=' . uniqid();
		break;
		case 'dummy':
		default:
			$image_atts['url'] =  get_template_directory_uri() . '/images/empty/' . $size . '.jpg';
		break;
	}
	$image_atts['class'] = 'grve-dummy-image attachment-' . $size . ' size-' . $size ;
	$image_atts['alt'] = "Dummy Image";

	return $image_atts;

}

function impeka_grve_get_fallback_image( $size = '', $mode = '', $url = '' ) {
	$html = '';
	$image_atts = impeka_grve_get_fallback_image_attr( $size );
	$placeholder_mode = impeka_grve_option( 'placeholder_mode', 'dummy' );
	if ( 'custom' == $placeholder_mode ) {
		$image_id = impeka_grve_option( 'placeholder_image', '', 'id'  );
		if((int)$image_id > 0 && ( $attachment_src = wp_get_attachment_image_src( $image_id, $size ) ) !== false ) {
			if( 'url' == $mode ) {
					$html .= $attachment_src[0];
			} else {
				$html .= wp_get_attachment_image( $image_id, $size, '', $image_atts );
			}
			return $html;
		}
	}

	$image_atts = impeka_grve_get_fallback_image_attr( $size );
	if( 'url' == $mode ) {
		if ( !empty( $url ) ) {
			$html .= $url;
		} else {
			$html .= $image_atts['url'];
		}
	} else if ( 'custom' == $mode && !empty( $url ) ) {
		$html .= '<img class="' . esc_attr( $image_atts['class'] ) . '" alt="' . esc_attr( $image_atts['alt'] ) . '" src="' . esc_url( $url ) . '">';
	} else {
		$html .= '<img class="' . esc_attr( $image_atts['class'] ) . '" alt="' . esc_attr( $image_atts['alt'] ) . '" src="' . esc_url( $image_atts['url'] ) . '" width="' . esc_attr( $image_atts['width'] ) . '" height="' . esc_attr( $image_atts['height'] ) . '">';
	}
	return $html;
}

function impeka_grve_get_fallback_image_wrapper( $size = '', $mode = '', $url = '' ) {
	$html = '';
	$html .= '<div class="grve-thumbnail-wrapper">';
	$html .= '<div class="grve-thumbnail">';
	$html .= impeka_grve_get_fallback_image( $size, $mode, $url );
	$html .= '</div>';
	$html .= '</div>';
	return $html;

}


function impeka_grve_disable_template_image_lazy_loading( $default, $tag_name, $context ) {

	$image_load_mode = impeka_grve_option( 'image_load_mode', 'off' );
	if( 'lazyload' == $image_load_mode || 'off' == $image_load_mode ) {
		if ( 'img' === $tag_name && 'wp_get_attachment_image' === $context ) {
			return false;
		}
	}
    return $default;
}
add_filter( 'wp_lazy_loading_enabled', 'impeka_grve_disable_template_image_lazy_loading', 10, 3 );

function impeka_grve_attachment_image_attributes( $attr, $image ) {

	if ( isset( $attr['data-grve-filter'] ) ) {

		$theme_lazyload = $native_lazyload = 'no';
		$image_load_mode = impeka_grve_option( 'image_load_mode', 'off' );
		$data_lazyload = isset($attr['data-lazyload']) ? $attr['data-lazyload'] : '';


		//Theme Lazy load
		if( 'lazyload' == $image_load_mode && empty( $data_lazyload ) ) {
			$theme_lazyload = 'yes';
		} else if( 'lazyload' == $data_lazyload ) {
			$theme_lazyload = 'yes';
		}
		if( 'yes' == $theme_lazyload ) {
			$attr['class']          = $attr['class'] . ' grve-lazy-load lazyload';
			$attr['data-src']       = $attr['src'];
			$attr['data-sizes']     = 'auto';
			$attr['data-srcset']    = isset($attr['srcset']) ? $attr['srcset'] : '';
			if ( !empty( $attr['data-srcset'] ) ) {
				$attr['srcset']         = get_template_directory_uri() . '/images/empty/empty.png';
			}
			$attr['data-expand']   = 1;
			unset($attr['sizes']);
		}

		//Native Lazy load
		if( 'native-lazyload' == $image_load_mode && empty( $data_lazyload ) ) {
			$native_lazyload = 'yes';
		} else if( 'native-lazyload' == $data_lazyload ) {
			$native_lazyload = 'yes';
		}
		if( 'yes' == $native_lazyload ) {
			if ( !array_key_exists( 'loading', $attr ) ) {
				$attr['loading'] = 'lazy';
			}
		} else {
			if ( array_key_exists( 'loading', $attr ) ) {
				unset( $attr['loading'] );
			}
		}

		//unset($attr['data-column-space']);
	}
	return $attr;
}
add_filter( 'wp_get_attachment_image_attributes' , 'impeka_grve_attachment_image_attributes', 11, 2 );


function impeka_grve_get_attachment_image( $id, $size = 'thumbnail', $icon = false, $attr = array() ) {
	$html = '';
	if ( !is_array( $attr ) ) {
		$attr = array();
	}
	$attr['data-grve-filter'] = 'yes';
	$html .= impeka_grve_get_image_wrapper_start( $id, $size, $attr );
	$html .= wp_get_attachment_image( $id, $size , $icon, $attr );
	$html .= impeka_grve_get_image_wrapper_end();
	return $html;
}

function impeka_grve_get_the_post_thumbnail( $post_id , $size = 'thumbnail', $attr = array() ) {
	$html = '';
	$id = get_post_thumbnail_id( $post_id );
	if ( !is_array( $attr ) ) {
		$attr = array();
	}
	$attr['data-grve-filter'] = 'yes';
	$html .= impeka_grve_get_image_wrapper_start( $id, $size, $attr );
	$html .= get_the_post_thumbnail( $post_id, $size , $attr );
	$html .= impeka_grve_get_image_wrapper_end();
	return $html;
}

function impeka_grve_the_post_thumbnail( $size = 'thumbnail', $attr = array() ) {
	$id = get_post_thumbnail_id();
	if ( !is_array( $attr ) ) {
		$attr = array();
	}
	$attr['data-grve-filter'] = 'yes';
	echo impeka_grve_get_image_wrapper_start( $id, $size, $attr );
	the_post_thumbnail( $size , $attr );
	echo impeka_grve_get_image_wrapper_end();
}

function impeka_grve_get_image_wrapper_start( $id = 0, $size = 'thumbnail', $attr = array() ) {
	$html = '';
	$img_width = $img_height = $percentage = 0;
	$img_src = wp_get_attachment_image_src( $id, $size );
	if ( $img_src ) {
		if ( preg_match('/.svg$/i', $img_src[0]) && $img_src[1] <= 1 ) {
			$html .= '<div class="grve-svg-thumbnail-wrapper">';
			$html .= '<div class="grve-svg-thumbnail">';
			return $html;
		}
		$img_width = $img_src[1];
		$img_height = $img_src[2];
		if ( $img_width < 1 || $img_height < 1 ) {
			$percentage = '100';
		} else {
			$percentage = round($img_height / $img_width * 100, 3);
		}
	}

	$thumbnail_wrapper_attributes = array();
	$thumbnail_wrapper_attributes[] = impeka_grve_build_media_style(
		array(
			'width' => $img_width,
		)
	);
	$thumbnail_attributes = array();
	$thumbnail_attributes[] = impeka_grve_build_media_style(
		array(
			'padding_top' => $percentage . '%',
		)
	);

	$column_space = impeka_grve_array_value( $attr, 'data-column-space', 'auto' );
	if ( 'auto' != $column_space ){
		$html .= '<div class="grve-thumbnail-wrapper">';
	} else {
		$html .= '<div class="grve-thumbnail-wrapper" ' . implode( ' ', $thumbnail_wrapper_attributes ) . '>';
	}
	$html .= '<div class="grve-thumbnail" ' . implode( ' ', $thumbnail_attributes ) . '>';
	return $html;
}

function impeka_grve_get_image_wrapper_end() {
	$html = '';
	$html .= '</div>';
	$html .= '</div>';
	return $html;
}

function impeka_grve_build_media_style( $item = array() ) {
	$padding_top = impeka_grve_array_value( $item, 'padding_top');
	$padding_bottom = impeka_grve_array_value( $item, 'padding_bottom' );
	$width = impeka_grve_array_value( $item, 'width' );

	$data = '';

	if( $padding_top != '' ) {
		$data .= 'padding-top: '.(preg_match('/(px|em|\%|pt|cm|vh|vw)$/', $padding_top) ? $padding_top : $padding_top.'px').';';
	}
	if( $padding_bottom != '' ) {
		$data .= 'padding-bottom: '.(preg_match('/(px|em|\%|pt|cm|vh|vw)$/', $padding_bottom) ? $padding_bottom : $padding_bottom.'px').';';
	}
	if( $width != '' ) {
		$data .= 'width: '.(preg_match('/(px|em|\%|pt|cm|vh|vw)$/', $width) ? $width : $width.'px').';';
	}

	return empty($data) ? $data : ' style="'. esc_attr( $data ) .'"';
}



//Omit closing PHP tag to avoid accidental whitespace output errors.
