<?php

/*
*	Typography Helper functions
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/


/**
 * Get Responsive Typography Group CSS
 */
function impeka_grve_get_typography_responsive_group_css( $fonts = array() , $threshold = 35, $ratio = 0.7, $mode = '' ) {

	$css = '';

	if ( !empty( $fonts ) && $ratio < 1 ) {

		foreach ( $fonts as $font_id => $font) {
			$impeka_grve_size = impeka_grve_option( $font_id, '32px', 'font-size'  );
			$impeka_grve_size = filter_var( $impeka_grve_size, FILTER_SANITIZE_NUMBER_INT );
			$line_height = impeka_grve_option( $font_id, '32px', 'line-height'  );
			$line_height = filter_var( $line_height, FILTER_SANITIZE_NUMBER_INT );

			if ( $impeka_grve_size >= $threshold ) {
				$custom_line_height = $line_height / $impeka_grve_size;
				$custom_size = $impeka_grve_size * $ratio;

				 if ( is_array( $font['selector'] ) && ! empty( $font['selector'] ) ) {
					 $font_selector = implode(",", $font['selector'] );
				 } else {
					 $font_selector = $font['selector'];
				 }

				if ( 'link_text' == $font_id || 'button_text' == $font_id ) {
					$css .= $font_selector . " {
						font-size: " . round( $custom_size, 0 ) . "px !important;
						line-height: " . round( $custom_line_height, 2 ) . "em;
					}
					";
				} else {
					$css .= $font_selector . " {
						font-size: " . round( $custom_size, 0 ) . "px;
						line-height: " . round( $custom_line_height, 2 ) . "em;
					}
					";
				}
			}

			if ( isset( $font['custom_selector'] ) ) {
				$sizes = array( '120', '140', '160', '180', '200', '250', '300' );
				foreach ( $sizes as $size ) {
					$custom_size = $impeka_grve_size * ( $size / 100 );
					if ( $custom_size >= $threshold ) {
						if ( '250' == $size || '300' == $size ) {
							$custom_size = $impeka_grve_size * ( $ratio / 1.7 );
						} elseif ( '200' == $size ) {
							$custom_size = $impeka_grve_size * ( $ratio / 1.4 );
						} else {
							$custom_size = $impeka_grve_size * ( $ratio / 1.15 );
						}
						if( !empty ( $mode ) ) {
							$css .= $font['custom_selector'] . ".grve-heading-" . esc_attr( $size ) .":not(.grve-" . esc_attr( $mode ) . "-reset-increase-heading ) {
								font-size: " . round( $custom_size, 0 ) . "px;
							}
							";
						} else {
							$css .= $font['custom_selector'] . ".grve-heading-" . esc_attr( $size ) ." {
								font-size: " . round( $custom_size, 0 ) . "px;
							}
							";
						}
					}
				}
			}

		}
	}

	return $css;
}

/**
 * Get Responsive Typography CSS
 */
function impeka_grve_get_typography_responsive_css( $group_headings = array(), $group_1 = array() , $group_2 = array() ) {

	//Headings
	$small_desktop_threshold_headings = impeka_grve_option( 'typography_small_desktop_threshold_headings', 20 );
	$small_desktop_ratio_headings = impeka_grve_option( 'typography_small_desktop_ratio_headings', 1 );
	$tablet_landscape_threshold_headings = impeka_grve_option( 'typography_tablet_landscape_threshold_headings', 20 );
	$tablet_landscape_ratio_headings = impeka_grve_option( 'typography_tablet_landscape_ratio_headings', 1 );
	$tablet_portrait_threshold_headings = impeka_grve_option( 'typography_tablet_portrait_threshold_headings', 20 );
	$tablet_portrait_ratio_headings = impeka_grve_option( 'typography_tablet_portrait_ratio_headings', 1 );
	$mobile_threshold_headings = impeka_grve_option( 'typography_mobile_threshold_headings', 20 );
	$mobile_ratio_headings = impeka_grve_option( 'typography_mobile_ratio_headings', 1 );

	//Group 1
	$small_desktop_threshold = impeka_grve_option( 'typography_small_desktop_threshold', 20 );
	$small_desktop_ratio = impeka_grve_option( 'typography_small_desktop_ratio', 1 );
	$tablet_landscape_threshold = impeka_grve_option( 'typography_tablet_landscape_threshold', 20 );
	$tablet_landscape_ratio = impeka_grve_option( 'typography_tablet_landscape_ratio', 0.9 );
	$tablet_portrait_threshold = impeka_grve_option( 'typography_tablet_portrait_threshold', 20 );
	$tablet_portrait_ratio = impeka_grve_option( 'typography_tablet_portrait_ratio', 0.85 );
	$mobile_threshold = impeka_grve_option( 'typography_mobile_threshold', 28 );
	$mobile_ratio = impeka_grve_option( 'typography_mobile_ratio', 0.6 );

	//Group 2
	$small_desktop_threshold2 = impeka_grve_option( 'typography_small_desktop_threshold2', 14 );
	$small_desktop_ratio2 = impeka_grve_option( 'typography_small_desktop_ratio2', 1 );
	$tablet_landscape_threshold2 = impeka_grve_option( 'typography_tablet_landscape_threshold2', 14 );
	$tablet_landscape_ratio2 = impeka_grve_option( 'typography_tablet_landscape_ratio2', 0.9 );
	$tablet_portrait_threshold2 = impeka_grve_option( 'typography_tablet_portrait_threshold2', 14 );
	$tablet_portrait_ratio2 = impeka_grve_option( 'typography_tablet_portrait_ratio2', 0.8 );
	$mobile_threshold2 = impeka_grve_option( 'typography_mobile_threshold2', 13 );
	$mobile_ratio2 = impeka_grve_option( 'typography_mobile_ratio2', 0.7 );

	$css = "
		@media only screen and (min-width: 1201px) and (max-width: 1440px) {
			" . impeka_grve_get_typography_responsive_group_css( $group_headings, $small_desktop_threshold_headings, $small_desktop_ratio_headings, 'desktop-sm' ). "
			" . impeka_grve_get_typography_responsive_group_css( $group_1, $small_desktop_threshold, $small_desktop_ratio, 'desktop-sm' ). "
			" . impeka_grve_get_typography_responsive_group_css( $group_2, $small_desktop_threshold2, $small_desktop_ratio2, 'desktop-sm' ). "
		}
		@media only screen and (min-width: 960px) and (max-width: 1200px) {
			" . impeka_grve_get_typography_responsive_group_css( $group_headings, $tablet_landscape_threshold_headings, $tablet_landscape_ratio_headings, 'tablet' ). "
			" . impeka_grve_get_typography_responsive_group_css( $group_1, $tablet_landscape_threshold, $tablet_landscape_ratio, 'tablet' ). "
			" . impeka_grve_get_typography_responsive_group_css( $group_2, $tablet_landscape_threshold2, $tablet_landscape_ratio2, 'tablet' ). "
		}
		@media only screen and (min-width: 768px) and (max-width: 959px) {
			" . impeka_grve_get_typography_responsive_group_css( $group_headings, $tablet_portrait_threshold_headings, $tablet_portrait_ratio_headings, 'tablet-sm' ). "
			" . impeka_grve_get_typography_responsive_group_css( $group_1, $tablet_portrait_threshold, $tablet_portrait_ratio, 'tablet-sm' ). "
			" . impeka_grve_get_typography_responsive_group_css( $group_2, $tablet_portrait_threshold2, $tablet_portrait_ratio2, 'tablet-sm' ). "
		}
		@media only screen and (max-width: 767px) {
			" . impeka_grve_get_typography_responsive_group_css( $group_headings, $mobile_threshold_headings, $mobile_ratio_headings, 'mobile' ). "
			" . impeka_grve_get_typography_responsive_group_css( $group_1, $mobile_threshold, $mobile_ratio, 'mobile' ). "
			" . impeka_grve_get_typography_responsive_group_css( $group_2, $mobile_threshold2, $mobile_ratio2, 'mobile' ). "
		}
		@media print {
			" . impeka_grve_get_typography_responsive_group_css( $group_headings, $mobile_threshold_headings, $mobile_ratio_headings ). "
			" . impeka_grve_get_typography_responsive_group_css( $group_1, $mobile_threshold, $mobile_ratio ). "
			" . impeka_grve_get_typography_responsive_group_css( $group_2, $mobile_threshold2, $mobile_ratio2 ). "
		}
	";

	return $css;
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
