<?php

/*
*	Woocommerce helper functions and configuration
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

/**
 * Helper function to check if woocommerce is enabled
 */
function impeka_grve_woocommerce_enabled() {

	if ( class_exists( 'woocommerce' ) ) {
		return true;
	}
	return false;

}

function impeka_grve_is_woo_shop() {
	if ( impeka_grve_woocommerce_enabled() && is_shop() && !is_search() ) {
		return true;
	}
	return false;
}

function impeka_grve_is_woo_tax() {
	if ( impeka_grve_woocommerce_enabled() && is_product_taxonomy() ) {
		return true;
	}
	return false;
}

function impeka_grve_is_woo_category() {
	if ( impeka_grve_woocommerce_enabled() && is_product_category() ) {
		return true;
	}
	return false;
}

function impeka_grve_is_woo_tag() {
	if ( impeka_grve_woocommerce_enabled() && is_product_tag() ) {
		return true;
	}
	return false;
}

//If woocomerce plugin is not enabled return
if ( !impeka_grve_woocommerce_enabled() ) {
	return false;
}

//Add Theme support for woocommerce
add_theme_support( 'woocommerce' );

/**
 * De-register WooCommerce styles
 */
add_filter( 'woocommerce_enqueue_styles', '__return_false' );

/**
 * Helper function to get shop custom fields with fallback
 */
function impeka_grve_post_meta_shop( $id, $fallback = false ) {
	$post_id = wc_get_page_id( 'shop' );
	if ( $fallback == false ) $fallback = '';
	$post_meta = get_post_meta( $post_id, $id, true );
	$output = ( $post_meta !== '' ) ? $post_meta : $fallback;
	return $output;
}

/**
 * Helper function to skin Product Search
 */
function impeka_grve_woo_product_search( $form ) {
	ob_start();
	get_template_part( 'templates/product/product', 'searchform' );
	return ob_get_clean();
}
add_filter( 'get_product_search_form', 'impeka_grve_woo_product_search' );

/**
 * Helper function to update cart count on header icon via ajax
 */

function impeka_grve_woo_mini_cart( $args = array() ) {

	$defaults = array(
		'list_class' => ''
	);

	$args = wp_parse_args( $args, $defaults );

	wc_get_template( 'templates/product/cart/grve-mini-cart.php', $args );
}

function impeka_grve_woo_mini_cart_button_colors( $args = array() ) {

	$btn_type = impeka_grve_array_value( $args, 'type', 'simple' );
	$btn_shape = impeka_grve_array_value( $args, 'shape', 'square' );
	$btn_color = impeka_grve_array_value( $args, 'color', 'black' );
	$btn_hover_color = impeka_grve_array_value( $args, 'hover_color', 'primary-1' );

	$classes = array();
	if ( 'outline' == $btn_type ) {
		$classes[] = 'grve-btn-outline';
		$classes[] = 'grve-' . $btn_shape;
		$classes[] = 'grve-border-' . $btn_color;
		$classes[] = 'grve-bg-hover-' . $btn_hover_color;
		$classes[] = 'grve-border-hover-' . $btn_hover_color;
		if( 'grey' == $btn_color || 'light-grey' == $btn_color ) {
			$classes[] = 'grve-text-dark-grey';
		} else {
			$classes[] = 'grve-text-' . $btn_color;
		}
		if( 'white' == $btn_hover_color || 'grey' == $btn_hover_color || 'light-grey' == $btn_hover_color ) {
			$classes[] = 'grve-text-hover-dark-grey';
		} else {
			$classes[] = 'grve-text-hover-white';
		}
	} else {
		$classes[] = 'grve-' . $btn_shape;
		$classes[] = 'grve-bg-' . $btn_color;
		$classes[] = 'grve-bg-hover-' . $btn_hover_color;
		if( 'white' == $btn_color || 'grey' == $btn_color || 'light-grey' == $btn_color ) {
			$classes[] = 'grve-text-dark-grey';
		} else {
			$classes[] = 'grve-text-white';
		}
		if( 'white' == $btn_hover_color || 'grey' == $btn_hover_color || 'light-grey' == $btn_hover_color ) {
			$classes[] = 'grve-text-hover-dark-grey';
		} else {
			$classes[] = 'grve-text-hover-white';
		}
	}

	return $classes;
}



function impeka_grve_woo_header_add_to_cart_fragment( $fragments ) {
	global $woocommerce;
	ob_start();
?>
	<span class="grve-purchased-items"><?php echo esc_html( $woocommerce->cart->cart_contents_count ); ?></span>
<?php
	$fragments['span.grve-purchased-items'] = ob_get_clean();

	ob_start();
	impeka_grve_woo_mini_cart();
	$mini_cart = ob_get_clean();

	$fragments['div.grve-shopping-cart-content'] = '<div class="grve-shopping-cart-content">' . $mini_cart . '</div>';

	return $fragments;
}
add_filter('woocommerce_add_to_cart_fragments', 'impeka_grve_woo_header_add_to_cart_fragment');


function impeka_grve_woo_product_review_comment_form_args( $comment_form ) {
	$comment_form['id_submit'] = 'grve-woo-review-submit';
	return $comment_form;
}
add_filter( 'woocommerce_product_review_comment_form_args', 'impeka_grve_woo_product_review_comment_form_args' );



/**
 * Function to modify columns number on product thumbnails
 */
function impeka_grve_woo_product_thumbnails_columns() {
	$columns = impeka_grve_option( 'product_thumbnails_columns', '4' );
	return $columns;
}
add_filter( 'woocommerce_product_thumbnails_columns', 'impeka_grve_woo_product_thumbnails_columns' );

/**
 * Function to add before main woocommerce content
 */
function impeka_grve_woo_before_main_content() {

	if ( is_shop() && !is_search() ) {
		impeka_grve_print_header_title( 'page' );
		impeka_grve_print_header_breadcrumbs( 'page' );
		impeka_grve_print_anchor_menu( 'page' );
	} elseif( is_product() ) {
		if ( 'woo' == impeka_grve_option( 'product_woo_style', 'theme' ) ) {
			impeka_grve_print_header_title( 'product' );
			impeka_grve_print_header_breadcrumbs( 'product' );
			impeka_grve_print_anchor_menu( 'product' );
		}
	}  elseif( is_product_taxonomy() ) {
		impeka_grve_print_header_title( 'product_tax' );
		impeka_grve_print_header_breadcrumbs( 'product_tax' );
	} else {
		impeka_grve_print_header_title( 'page' );
		impeka_grve_print_header_breadcrumbs( 'page' );
	}

	if( is_product() ) {
		echo '<div class="grve-single-wrapper">'; //START .grve-single-wrapper
	}
?>
	<!-- CONTENT -->
	<div id="grve-content" <?php impeka_grve_content_class(); ?>>
		<div class="grve-content-wrapper">
			<!-- MAIN CONTENT -->
			<div id="grve-main-content" role="main">
				<div class="grve-main-content-wrapper clearfix">
<?php
		if ( is_shop() ) {
			$post_id = wc_get_page_id( 'shop' );
			$content = get_post_field( 'post_content', $post_id );
			if( !empty( $content ) ) {
				if( !has_shortcode( $content, 'vc_row') ) {
					echo '<div class="grve-container">' . apply_filters( 'the_content', $content )  . '</div>';
				} else {
					echo apply_filters( 'the_content', $content );
				}
			}
		}
		if( !is_product() ) {
			echo '<div class="grve-container">'; //START .grve-container
		}
}
add_action('woocommerce_before_main_content', 'impeka_grve_woo_before_main_content', 10);


/**
 * Function to add after main woocommerce content
 */
function impeka_grve_woo_after_main_content() {
	if( !is_product() ) {
		echo '</div>'; //END .grve-container
	}
?>
				</div>
			</div>
			<!-- END MAIN CONTENT -->
			<?php get_sidebar(); ?>
		</div>
	</div>
	<!-- END CONTENT -->
<?php
	if( is_product() ) {
		do_action( 'impeka_grve_woocommerce_after_single_product_sections' );
		echo '</div>'; //END .grve-single-wrapper
	}
}
add_action('woocommerce_after_main_content', 'impeka_grve_woo_after_main_content', 10);

/**
 * Functions to add product area wrapper
 */
function impeka_grve_woo_product_area_start(){
	//Section Classes
	$product_area_classes = array( '' );
	$padding_top_multiplier = impeka_grve_option( 'product_area_padding_top_multiplier', '3x' );
	$padding_top_multiplier = impeka_grve_post_meta( '_impeka_grve_area_padding_top_multiplier', $padding_top_multiplier );
	if ( !empty ( $padding_top_multiplier ) ) {
		$product_area_classes[] = 'grve-padding-top-' . $padding_top_multiplier;
	}
	$padding_bottom_multiplier = impeka_grve_option( 'product_area_padding_bottom_multiplier', '3x' );
	$padding_bottom_multiplier = impeka_grve_post_meta( '_impeka_grve_area_padding_bottom_multiplier', $padding_bottom_multiplier );
	if ( !empty ( $padding_bottom_multiplier ) ) {
		$product_area_classes[] = 'grve-padding-bottom-' . $padding_bottom_multiplier;
	}
	$product_area_string = implode( ' ', $product_area_classes );

?>
	<div id="grve-product-area" class="<?php echo esc_attr( $product_area_string ); ?>">
		<div class="grve-container">
			<div class="grve-product-area-inner">
<?php
}
add_action('woocommerce_before_single_product_summary', 'impeka_grve_woo_product_area_start', 5);


function impeka_grve_woo_product_area_end(){
?>
			</div>
		</div>
	</div>
<?php
}
add_action('woocommerce_after_single_product_summary', 'impeka_grve_woo_product_area_end', 5);

/**
 * Functions to add related / upsells wrapper
 */
function impeka_grve_woo_related_start(){
	if( impeka_grve_woo_has_related_upsells() ) {
?>
	<div class="grve-related-area grve-padding-top-4x grve-margin-top-4x grve-border grve-border-top">
		<div class="grve-container">
<?php
	}
}

function impeka_grve_woo_related_end(){
	if( impeka_grve_woo_has_related_upsells() ) {
?>
		</div>
	</div>
<?php
	}
}

/**
 * Functions to add product image wrapper
 */
function impeka_grve_woo_product_image_start(){
?>
	<div class="grve-product-image-wrapper">
<?php
}
add_action('woocommerce_before_single_product_summary', 'impeka_grve_woo_product_image_start', 9);


function impeka_grve_woo_product_image_end(){
?>
	</div>
<?php
}
add_action('woocommerce_before_single_product_summary', 'impeka_grve_woo_product_image_end', 21);




/**
 * Functions to add to form wrapper
 */
function impeka_grve_woo_form_wrapper_start(){
?>
	<div class="grve-form-wrapper">
<?php
}
add_action('woocommerce_before_add_to_cart_form', 'impeka_grve_woo_form_wrapper_start');

function impeka_grve_woo_form_wrapper_end(){
?>
	</div>
<?php
}
add_action('woocommerce_after_add_to_cart_form', 'impeka_grve_woo_form_wrapper_end');


/**
 * Functions to add to cart button wrapper
 */
function impeka_grve_woo_add_to_cart_wrapper_start(){
?>
	<div class="grve-add-to-cart-wrapper">
<?php
}
add_action('woocommerce_before_add_to_cart_button', 'impeka_grve_woo_add_to_cart_wrapper_start', 21);

function impeka_grve_woo_add_to_cart_wrapper_end(){
?>
	</div>
<?php
}
add_action('woocommerce_after_add_to_cart_button', 'impeka_grve_woo_add_to_cart_wrapper_end', 21);


/**
 * Function to add Price under product name (for mobile)
 */
function impeka_grve_woo_after_cart_item_name( $cart_item, $cart_item_key ) {
	// Price
	$price = $cart_item['data']->get_price();

	// Quantity
	$quantity = $cart_item['quantity'];

	echo '<div class="grve-mobile-product-price">' . sprintf( '%s &times; %s', $cart_item['quantity'], wc_price( $price ) ) . '</div>';
}

add_action( 'woocommerce_after_cart_item_name', 'impeka_grve_woo_after_cart_item_name', 10, 2 );

/**
 * Function to add Summary Accordion
 */
function impeka_grve_woo_summary_accordion(){

	$product_tabs = apply_filters( 'woocommerce_product_tabs', array() );
	if ( ! empty( $product_tabs ) ) {
?>
	<div class="grve-summary-accordion">
		<?php foreach ( $product_tabs as $key => $product_tab ) : ?>
			<div id="grve-accordion-<?php echo esc_attr( $key ); ?>" class="grve-accordion-item">
				<div class="grve-accordion-title grve-link-text">
					<span><?php echo wp_kses_post( apply_filters( 'woocommerce_product_' . $key . '_tab_title', $product_tab['title'], $key ) ); ?></span>
					<?php echo impeka_grve_get_svg_icon('plus'); ?>
				</div>
				<div class="grve-accordion-content">
					<?php
					if ( isset( $product_tab['callback'] ) ) {
						call_user_func( $product_tab['callback'], $key, $product_tab );
					}
					?>
				</div>
			</div>
		<?php endforeach; ?>
	</div>
<?php
	}
}
// add_action('woocommerce_single_product_summary', 'impeka_grve_woo_summary_accordion', 35);
// remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10);

/**
 * Functions to add Form Checkout Wrapper
 */
function impeka_grve_woo_form_checkout_wrapper_start() {
?>
	<div class="grve-form-checkout-wrapper grve-padding-top-3x grve-padding-bottom-4x">
<?php
}
add_action('woocommerce_before_checkout_form', 'impeka_grve_woo_form_checkout_wrapper_start', 5);

function impeka_grve_woo_form_checkout_wrapper_end() {
?>
	</div>
<?php
}
add_action('woocommerce_after_checkout_form', 'impeka_grve_woo_form_checkout_wrapper_end');


/**
 * Functions to add Checkout Wrapper
 */
function impeka_grve_woo_checkout_wrapper_start() {
?>
	<div class="grve-inner">
		<div class="grve-checkout-wrapper">
<?php
}
add_action('woocommerce_checkout_before_customer_details', 'impeka_grve_woo_checkout_wrapper_start');

function impeka_grve_woo_checkout_wrapper_end() {
?>
		</div>
<?php
}
add_action('woocommerce_checkout_after_customer_details', 'impeka_grve_woo_checkout_wrapper_end');


/**
 * Functions to add Order Wrapper
 */
function impeka_grve_woo_order_wrapper_start() {
?>
		<div class="grve-order-wrapper">
<?php
}
add_action('woocommerce_checkout_before_order_review_heading', 'impeka_grve_woo_order_wrapper_start');

function impeka_grve_woo_order_wrapper_end() {
?>
		</div>
	</div>
<?php
}
add_action('woocommerce_checkout_after_order_review', 'impeka_grve_woo_order_wrapper_end');




function impeka_grve_woo_single_title() {
?>
	<div itemprop="name" class="grve-hidden product_title entry-title"><?php the_title(); ?></div>
<?php
}

function impeka_grve_woo_replace_default_single_title() {
	remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );
	add_action( 'woocommerce_single_product_summary', 'impeka_grve_woo_single_title', 5 );
}


/**
 * Single Product Social
 */
function impeka_grve_print_product_social() {
	if ( impeka_grve_social_bar ( 'product', 'check' ) ) {
		$social_layout = impeka_grve_option( 'product_social_layout', 'layout-1' );
		impeka_grve_social_bar ( 'product', $social_layout );
	}
}

/**
 * Single Product Navigation
 */
function impeka_grve_print_product_bar() {
	$grve_product_nav_layout = impeka_grve_option( 'product_nav_layout', 'layout-1' );
	impeka_grve_nav_bar( 'product', $grve_product_nav_layout );
}

/**
 * Shop Loop columns
 */
function impeka_grve_woo_loop_columns( $columns ) {
	$columns = impeka_grve_option( 'product_loop_columns', '4' );
	return $columns;
}

/**
 * Shop Loop per page
 */
function impeka_grve_woo_loop_shop_per_page( $items ) {
	$items = impeka_grve_option( 'product_loop_shop_per_page', '12' );
	return $items;
}

/**
 * Single Product Related args
 */
function impeka_grve_woo_related_args( $args ) {
	$args = array(
		'posts_per_page' 	=> 4,
		'columns' 			=> 4,
		'orderby' 			=> 'rand'
	);
	return $args;
}


/**
 * Single Product Large Thumbnail Size
 */
function impeka_grve_woo_large_thumbnail_size ( $size ) {

	$product_size = impeka_grve_option( 'product_image_size' );
	if( 'default' != $product_size ) {
		$size = impeka_grve_get_image_size( $product_size );
	}
	return $size;
}


/**
 * Gallery Thumbnail Size
 */
function impeka_grve_woo_gallery_thumbnail_size ( $size ) {
	$product_size = impeka_grve_option( 'product_thumb_size' );
	if( 'default' != $product_size ) {
		$size = impeka_grve_get_image_size( $product_size );
	}
	return $size;
}

/**
 * Product Category Loop Thumbnail Size
 */
function impeka_grve_woo_archive_thumbnail_size ( $size ) {
	$product_size = impeka_grve_option( 'product_overview_image_size' );
	if( 'default' != $product_size ) {
		$size = impeka_grve_get_image_size( $product_size );
	}
	return $size;
}
/**
 * Product Category Loop Classes
 */

function impeka_grve_woo_product_cat_class ( $classes, $class, $category  ) {
	$classes[] = 'grve-entry-item';
	$classes[] = 'grve-product-item';
	return $classes;
}

function impeka_grve_woo_product_class ( $classes, $class  ) {
		$classes[] = 'grve-entry-item';
		$classes[] = 'grve-product-item';
	return $classes;
}

/**
 * Overwrite Checkout Fields
 */

function impeka_grve_woo_checkout_fields_no_label($fields) {
	// loop by category
	foreach ($fields as $category => $value) {
		// loop by fields
		foreach ($fields[$category] as $field => $property) {
			$placeholder = isset( $fields[$category][$field]['label'] )? $fields[$category][$field]['label'] : '';
			if ( $placeholder ) {
				$required = isset( $fields[$category][$field]['required'] )? $fields[$category][$field]['required'] : '';
				if ( $required ) {
					$placeholder .= ' *';
				}
				$fields[$category][$field]['placeholder'] = $placeholder;
				// remove label property
				unset($fields[$category][$field]['label']);
			}
		}
	}

	return $fields;
}





/**
 * Functions to add thumbnail gallery wrapper
 */
function impeka_grve_woo_thumbnails_before() {
	if( impeka_grve_visibility( 'product_gallery_woo_slider' )  ) {
		return;
	}
?>
	<div class="grve-woocommerce-thumbnails-wrapper">
<?php
}

function impeka_grve_woo_thumbnails_after() {
	if( impeka_grve_visibility( 'product_gallery_woo_slider' )  ) {
		return;
	}
?>
	</div>
<?php
}



/**
 * Functions to add Shop Page Counter wrapper
 */
function impeka_grve_woo_start_shop_result_wrapper() {
?>
	<div class="grve-result-count-wrapper">
<?php
}

function impeka_grve_woo_end_shop_result_wrapper() {
?>
	</div>
<?php
}


// Loop Price / Add to cart
function impeka_grve_woo_loop_add_to_cart_wrapper() {
	$text_color = impeka_grve_option( 'product_overview_text_color', 'default' );
?>
	<div class="grve-transform-wrapper grve-text-<?php echo esc_attr( $text_color ); ?>">
		<div class="grve-price-wrapper">
			<?php do_action( 'impeka_grve_woo_loop_price' ); ?>
		</div>
		<div class="grve-add-to-cart-wrapper">
			<?php do_action( 'impeka_grve_woo_loop_add_to_cart' ); ?>
		</div>
	</div>
<?php
}

function impeka_grve_woo_loop_product_second_thumbnail() {
	global $product;
	$image_effect = impeka_grve_option( 'product_overview_image_effect', 'second' );
	if ( 'second' == $image_effect ) {

		//Second Product Image
		$attachment_ids = $product->get_gallery_image_ids();
		$image_size = apply_filters( 'single_product_archive_thumbnail_size', 'shop_catalog' );

		//Second Image Classes
		$image_classes = array();
		$image_classes[] = 'attachment-' . $image_size;
		$image_classes[] = 'size-' . $image_size;
		$image_classes[] = 'grve-product-thumbnail-second';
		$image_class_string = implode( ' ', $image_classes );

		$product_thumb_second_id = '';

		if ( $attachment_ids ) {
			$loop = 0;
			foreach ( $attachment_ids as $attachment_id ) {
				$image_link = wp_get_attachment_url( $attachment_id );
				if (!$image_link) {
					continue;
				}
				$loop++;
				$product_thumb_second_id = $attachment_id;
				if ($loop == 1) {
					break;
				}
			}
		}

		if ( !empty( $product_thumb_second_id ) ) {
			echo wp_get_attachment_image( $product_thumb_second_id, $image_size , "", array( 'class' => $image_class_string ) );
		}
	}

}

/**
 * Product Loop Product Thumbnail Wrapper
 */
function impeka_grve_woo_loop_product_thumbnail_wrapper() {
	$overlay_color = impeka_grve_option( 'product_overview_overlay_color', 'light' );
	$overlay_opacity = impeka_grve_option( 'product_overview_overlay_opacity', '90' );
?>
	<div class="grve-media grve-image-hover">
		<div class="grve-bg-<?php echo esc_attr( $overlay_color ); ?> grve-hover-overlay grve-opacity-<?php echo esc_attr( $overlay_opacity ); ?>"></div>
		<a class="grve-item-url" href="<?php echo esc_url( get_permalink() ); ?>"><span class="screen-reader-text"><?php the_title(); ?></span></a>
		<?php
			/**
			 * impeka_grve_woo_loop_product_thumbnail hook
			 *
			 * @hooked impeka_grve_woo_loop_product_thumbnail - 10
			 * @hooked impeka_grve_woo_loop_product_second_thumbnail - 15
			 */
			do_action( 'impeka_grve_woo_loop_product_media' );
		?>
	</div>
<?php
}


/**
 * Product Loop Product Title
 */
function impeka_grve_woo_loop_product_title() {
	$title_heading_tag = impeka_grve_option( 'product_overview_heading_tag', 'h4' );
	$title_heading = impeka_grve_option( 'product_overview_heading', 'h4' );
	$text_color = impeka_grve_option( 'product_overview_text_color', 'default' );
?>
<<?php echo tag_escape( $title_heading_tag ); ?> class="grve-product-title grve-<?php echo esc_attr( $title_heading ); ?> grve-text-<?php echo esc_attr( $text_color ); ?>"><?php the_title(); ?></<?php echo tag_escape( $title_heading_tag ); ?>>
<?php
}

/**
 * Product Loop Product Title Wrapper
 */
function impeka_grve_woo_loop_product_title_wrapper() {
?>
	<div class="grve-content">
		<div class="grve-content-inner">
		<?php
			/**
			 * impeka_grve_woo_loop_product_title hook
			 *
			 * @hooked impeka_grve_woo_loop_product_title - 10
			 * @hooked impeka_grve_woo_loop_add_to_cart_wrapper - 15

			 */
			do_action( 'impeka_grve_woo_loop_product_content' );
		?>
		</div>
	</div>
<?php
}

/**
 * Product Loop Overview Wrapper Start
 */
function impeka_grve_woo_shop_loop_wrapper_start(){
	$hover_style = impeka_grve_option( 'product_overview_hover_style', 'hover-style-1' );
?>
<div class="grve-isotope-item-inner">
	<div class="grve-hover-item grve-product-<?php echo esc_attr( $hover_style ); ?>">

<?php
}

/**
 * Product Loop Overview Wrapper End
 */
function impeka_grve_woo_shop_loop_wrapper_end(){
?>
	</div>
</div>
<?php
}

/**
 * Product Loop Category Thumbnail Wrapper
 */
function impeka_grve_woo_loop_subcategory_thumbnail_wrapper( $category ){
	$overlay_color = impeka_grve_option( 'product_overview_overlay_color', 'light' );
	$overlay_opacity = impeka_grve_option( 'product_overview_overlay_opacity', '90' );
?>
	<div class="grve-media grve-image-hover">
		<div class="grve-bg-<?php echo esc_attr( $overlay_color ); ?> grve-hover-overlay grve-opacity-<?php echo esc_attr( $overlay_opacity ); ?>"></div>
		<a class="grve-item-url" href="<?php echo esc_url( get_term_link( $category, 'product_cat' ) ); ?>"></a>
		<?php
			/**
			 * impeka_grve_woo_loop_subcategory_thumbnail hook
			 *
			 * @hooked impeka_grve_woo_loop_subcategory_thumbnail - 10
			 */
			do_action( 'impeka_grve_woo_loop_subcategory_thumbnail', $category );
		?>
	</div>
<?php
}

/**
 * Product Loop Category Title Wrapper
 */
function impeka_grve_woo_loop_subcategory_title_wrapper( $category ){
?>
	<div class="grve-content">
		<div class="grve-content-inner">
		<?php
			/**
			 * impeka_grve_woo_loop_subcategory_title hook
			 *
			 * @hooked impeka_grve_woo_loop_category_title - 10
			 */
			do_action( 'impeka_grve_woo_loop_subcategory_title', $category );
		?>
		</div>
	</div>
<?php
}

/**
 * Product Loop Category Title
 */
function impeka_grve_woo_loop_subcategory_title( $category ) {
	$title_heading_tag = impeka_grve_option( 'product_overview_heading_tag', 'h4' );
	$title_heading = impeka_grve_option( 'product_overview_heading', 'h4' );
	$text_color = impeka_grve_option( 'product_overview_text_color', 'default' );
	?>
	<<?php echo tag_escape( $title_heading_tag ); ?> class="grve-product-title grve-<?php echo esc_attr( $title_heading ); ?> grve-text-<?php echo esc_attr( $text_color ); ?>">
		<?php
		echo esc_html( $category->name );
		if ( $category->count > 0 ) {
			// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			echo apply_filters( 'woocommerce_subcategory_count_html', ' <mark class="count grve-small-text">' . esc_html( $category->count ) . '</mark>', $category );
		}
		?>
	</<?php echo tag_escape( $title_heading_tag ); ?>>
	<?php
}

function impeka_grve_woo_has_related_upsells() {
	global $product;

	if ( ! $product ) {
		return false;
	}

	$related = wc_get_related_products( $product->get_id(), 4, $product->get_upsell_ids() );
	$related = absint( $related );
	$upsells = $product->get_upsell_ids();
	$upsells = absint( $upsells );
	return $related + $upsells;
}

function impeka_grve_woo_add_gallery_popup_class( $classes ) {
	if( 'theme' == impeka_grve_option( 'product_image_thumb_style', 'woo' ) ) {
		if( impeka_grve_visibility( 'product_gallery_woo_lightbox' )  ) {
			$classes[] = 'grve-woo-light-gallery-popup';
		}
		if( impeka_grve_visibility( 'product_gallery_woo_zoom' )  ) {
			$classes[] = 'grve-woo-gallery-zoom';
		}
		$classes[] = 'grve-woo-theme-gallery';
	}
	return $classes;
}

function impeka_grve_woo_theme_setup() {

	if( impeka_grve_visibility( 'product_gallery_woo_zoom' ) ) {
		add_theme_support( 'wc-product-gallery-zoom' );
	}

	if( 'woo' == impeka_grve_option( 'product_image_thumb_style', 'woo' ) ) {
		if ( impeka_grve_visibility( 'product_gallery_woo_lightbox' )  ) {
			add_theme_support( 'wc-product-gallery-lightbox' );
		}
		if( impeka_grve_visibility( 'product_gallery_woo_slider' ) ) {
			add_theme_support( 'wc-product-gallery-slider' );
		}
	} else {
		add_theme_support( 'wc-product-gallery-slider' );
	}
	if( 'theme' == impeka_grve_option( 'product_woo_style', 'theme' ) ) {
		remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );
		remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );
		remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );

		add_action( 'impeka_grve_single_main_content', 'woocommerce_output_product_data_tabs', 10 );
		add_action( 'impeka_grve_single_main_content', 'impeka_grve_woo_related_start', 11);
		add_action( 'impeka_grve_single_main_content', 'woocommerce_upsell_display', 15 );
		add_action( 'impeka_grve_single_main_content', 'woocommerce_output_related_products', 20 );
		add_action( 'impeka_grve_single_main_content', 'impeka_grve_woo_related_end', 100);
	} else {
		add_action( 'woocommerce_after_single_product_summary', 'impeka_grve_woo_related_start', 11 );
		add_action( 'woocommerce_after_single_product_summary', 'impeka_grve_woo_related_end', 100 );
	}
}


/**
 * My Account add wrapper
 */
function impeka_grve_woo_customer_login_form_wrapper_start(){
?>
	<div id="grve-my-account-wrapper">
<?php
}

function impeka_grve_woo_customer_login_form_wrapper_end(){
?>
	</div>
<?php
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
