

var GRVEWizard = GRVEWizard || {};

(function($){

	'use strict';

    var callbacks = {
        install_plugins: function(btn){
            var plugins = new PluginManager();
            plugins.init(btn);
        },
    };

    function loading_content(){
        $('.grve-setup-content').block({
            message: null,
            overlayCSS: {
                background: '#fff',
                opacity: 0.6
            }
        });
    }
    function PluginManager(){

        var complete;
        var items_completed = 0;
        var current_item = '';
        var $current_node;
        var current_item_hash = '';

        function ajax_callback(response){
            if( typeof response == 'object' && typeof response.message != 'undefined' ){
                $current_node.find('span').text(response.message);
                if(typeof response.url != 'undefined'){
                    // we have an ajax url action to perform.

                    if(response.hash == current_item_hash){
                        $current_node.find('span').text("failed");
                        find_next();
                    }else {
                        current_item_hash = response.hash;
                        $.post(response.url, response, function(response2) {
                            process_current();
                            $current_node.find('span').text(response.message + impeka_grve_wizard_params.verify_text);
                        }).fail(ajax_callback);
                    }

                }else if(typeof response.done != 'undefined'){
                    // finished processing this plugin, move onto next
                    find_next();
                }else{
                    // error processing this plugin
                    find_next();
                }
            } else{
                // error - try again with next plugin
                $current_node.find('span').text("ajax error");
                find_next();
            }
        }
        function process_current(){
            if(current_item){
                $.post(impeka_grve_wizard_params.ajaxurl, {
                    action: 'impeka_grve_wizard_ajax_plugins',
                    _grve_nonce: impeka_grve_wizard_params.nonce_wizard,
                    slug: current_item
                }, ajax_callback).fail(ajax_callback);
            }
        }
        function find_next(){
            var do_next = false;
            if($current_node){
                if(!$current_node.data('done_item')){
                    items_completed++;
                    $current_node.data('done_item',1);
                }
                $current_node.find('.spinner').css('visibility','hidden');
            }
            var $li = $('.grve-wizard-plugins li.grve-selected');
            $li.each(function(){
                if(current_item == '' || do_next){
                    current_item = $(this).data('slug');
                    $current_node = $(this);
                    process_current();
                    do_next = false;
                } else if($(this).data('slug') == current_item){
                    do_next = true;
                }
            });
            if(items_completed >= $li.length){
                // finished all plugins!
                complete();
            }
        }

        return {
            init: function(btn){
                $('.grve-wizard-plugins').addClass('installing');
                complete = function(){
                    loading_content();
                    window.location.href=btn.href;
                };
                find_next();
            }
        }
    }

	$(document).ready(function($) {
		$('.grve-wizard-next').on( 'click', function(e) {

			$('.grve-wizard-button-bar a').attr('disabled',true);
			$('.grve-plugin-checkbox').attr('disabled',true);

			if($(this).data('callback') && typeof callbacks[$(this).data('callback')] != 'undefined'){
				callbacks[$(this).data('callback')](this);
				return false;
			} else{
				loading_content();
				return true;
			}
		});
		$('.grve-plugin-checkbox').on( 'change', function(e) {
			$( this ).is( ':checked' ) ? $( this ).parents('.grve-plugin-item').addClass('grve-selected') : $( this ).parents('.grve-plugin-item').removeClass('grve-selected');
		});

		$('.grve-builder-button').on( 'click', function(e) {
			e.preventDefault();
            var $that = $(this);
			$that.addClass('grve-selected').siblings().removeClass('grve-selected');

			var dataParams = {
				action: 'impeka_grve_wizard_ajax_builder_plugins',
                _grve_nonce: impeka_grve_wizard_params.nonce_wizard,
                mode: $that.data('mode')
			};
			var pluginsContainer = $that.parents('.grve-wizard-panel-content').find('.grve-wizard-builder-container');

			$.post( impeka_grve_wizard_params.ajaxurl, dataParams, function( pluginsHtml ) {
				pluginsContainer.html(pluginsHtml);
			}).fail(function(xhr, status, error) {
				//
			});
		});

	});

})(jQuery);