(function($){

	"use strict";
	var grveCheck = {
		init: function() {
			$( document.body ).on( 'change', '#grve-consent-license', this.consentLicense );
			$( document.body ).on( 'click', '#grve-activate-license', this.activateLicense );
			$( document.body ).on( 'click', '#grve-deactivate-license', this.deactivateLicense );
			$( document.body ).on( 'click', '#grve-check-license', this.checkLicense );
		},
		consentLicense: function() {
			$( this ).is( ':checked' ) ? $('#grve-activate-license').prop("disabled", false) : $('#grve-activate-license').prop("disabled", true);
		},
		activateLicense: function() {
			var purchaseCode = $('#grve-purchase-code').val(),
				$button = $( this );
			var dataParams = {
				action: 'impeka_grve_check_api',
				api_action: 'activate',
				purchase_code: purchaseCode,
				_grve_nonce: impeka_grve_check_texts.nonce_check
			};
			$button.prop("disabled", true).addClass('grve-wait');
			$('.grve-license-errors').html('');
			$.post( impeka_grve_check_texts.ajaxurl, dataParams, function( response ) {
				if ( 'success' == response ) {
					window.location.reload(true);
				} else {
					$('.grve-license-errors').html( response );
					$button.prop("disabled", false).removeClass('grve-wait');
				}
			}).fail(function(xhr, status, error) {
				$button.prop("disabled", false).removeClass('grve-wait');
			});
		},
		deactivateLicense: function() {
			var purchaseCode = $('#grve-purchase-code').val(),
				$button = $( this );
			var dataParams = {
				action: 'impeka_grve_check_api',
				api_action: 'deactivate',
				purchase_code: purchaseCode,
				_grve_nonce: impeka_grve_check_texts.nonce_check
			};
			$button.prop("disabled", true).addClass('grve-wait');
			$('.grve-license-errors').html('');
			$.post( impeka_grve_check_texts.ajaxurl, dataParams, function( response ) {
				if ( 'success' == response ) {
					window.location.reload(true);
				} else {
					$('.grve-license-errors').html( response );
					$button.prop("disabled", false).removeClass('grve-wait');
				}
			}).fail(function(xhr, status, error) {
				$button.prop("disabled", false).removeClass('grve-wait');
			});
		},
		checkLicense: function( e ) {
			e.preventDefault();
			var purchaseCode = $('#grve-purchase-code').val(),
				$button = $( this );
			var dataParams = {
				action: 'impeka_grve_check_api',
				api_action: 'check',
				purchase_code: purchaseCode,
				_grve_nonce: impeka_grve_check_texts.nonce_check
			};
			$button.prop("disabled", true).addClass('grve-wait');
			$('.grve-license-errors').html('');
			$.post( impeka_grve_check_texts.ajaxurl, dataParams, function( response ) {
				if ( 'success' == response ) {
					window.location.reload(true);
				} else {
					$('.grve-license-errors').html( response );
					$button.prop("disabled", false).removeClass('grve-wait');
				}
			}).fail(function(xhr, status, error) {
				$button.prop("disabled", false).removeClass('grve-wait');
			});
		}
	};

	$(function() {
		grveCheck.init();
	});


	$(window).on('load',function() {
		$('#grve-consent-license').trigger('change');
	});

})(jQuery);