<?php

/**
 * Include the TGM_Plugin_Activation class.
 */
require_once get_template_directory() . '/includes/plugins/tgm-plugin-activation/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'impeka_grve_register_required_plugins' );

/**
 * Register the required plugins for this theme.
 *
 * This function is hooked into tgmpa_init, which is fired within the
 * TGM_Plugin_Activation class constructor.
 */
function impeka_grve_register_required_plugins() {
	/**
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	$plugins = array(
		'impeka-extension' => array(
			'name'					=> esc_html__( 'Impeka Core Extension', 'impeka' ),
			'slug'					=> 'impeka-extension',
			'source'				=> get_template_directory() . '/includes/plugins/impeka-extension.zip',
			'required'				=> true,
			'version'				=> '1.3.6',
			'force_activation' 		=> false,
			'force_deactivation' 	=> false,
			'external_url'			=> '',
			'is_callable'			=> '',
		),
		'impeka-wpb-extension' => array(
			'name'					=> esc_html__( 'Impeka WPBakery Extension', 'impeka' ),
			'slug'					=> 'impeka-wpb-extension',
			'source'				=> get_template_directory() . '/includes/plugins/impeka-wpb-extension.zip',
			'required'				=> false,
			'version'				=> '1.3.6',
			'force_activation' 		=> false,
			'force_deactivation' 	=> false,
			'external_url'			=> '',
			'is_callable'			=> '',
			'has_notices'			=> false,
			'is_premium'			=> true,
		),
		'impeka-elementor-extension' => array(
			'name'					=> esc_html__( 'Impeka Elementor Extension', 'impeka' ),
			'slug'					=> 'impeka-elementor-extension',
			'source'				=> get_template_directory() . '/includes/plugins/impeka-elementor-extension.zip',
			'required'				=> false,
			'version'				=> '1.3.6',
			'force_activation' 		=> false,
			'force_deactivation' 	=> false,
			'external_url'			=> '',
			'is_callable'			=> '',
			'has_notices'			=> false,
			'is_premium'			=> true,
		),
		'impeka-gutenberg-extension' => array(
			'name'					=> esc_html__( 'Impeka Gutenberg Extension', 'impeka' ),
			'slug'					=> 'impeka-gutenberg-extension',
			'source'				=> get_template_directory() . '/includes/plugins/impeka-gutenberg-extension.zip',
			'required'				=> false,
			'version'				=> '1.3.3',
			'force_activation' 		=> false,
			'force_deactivation' 	=> false,
			'external_url'			=> '',
			'is_callable'			=> '',
			'has_notices'			=> false,
			'is_premium'			=> true,
		),
 		'impeka-dummy-importer' => array(
			'name'					=> esc_html__( 'Impeka Demo Importer', 'impeka' ),
			'slug'					=> 'impeka-dummy-importer',
			'source'				=> get_template_directory() . '/includes/plugins/impeka-dummy-importer.zip',
			'required'				=> false,
			'version'				=> '1.3.6',
			'force_activation' 		=> false,
			'force_deactivation' 	=> false,
			'external_url'			=> '',
			'is_callable'			=> '',
			'has_notices'			=> false,
			'is_premium'			=> true,
		),
		'js_composer' => array(
			'name'					=> esc_html__( 'WPBakery Page Builder', 'impeka' ),
			'slug'					=> 'js_composer',
			'source'				=> get_template_directory() . '/includes/plugins/js_composer.zip',
			'required'				=> false,
			'version'				=> '6.9.0',
			'force_activation' 		=> false,
			'force_deactivation' 	=> false,
			'external_url'			=> '',
			'is_callable'			=> '',
			'has_notices'			=> false,
			'is_premium'			=> true,
		),
 		'revslider' => array(
			'name'					=> esc_html__( 'Revolution Slider', 'impeka' ),
			'slug'					=> 'revslider',
			'source'				=> get_template_directory() . '/includes/plugins/revslider.zip',
			'required'				=> false,
			'version'				=> '6.5.20',
			'force_activation' 		=> false,
			'force_deactivation' 	=> false,
			'external_url'			=> '',
			'is_callable'			=> '',
			'has_notices'			=> false,
			'is_premium'			=> true,
		),
		'envato-market' => array(
			'name'					=> esc_html__( 'Envato Market', 'impeka' ),
			'slug'					=> 'envato-market',
			'source'				=> get_template_directory() . '/includes/plugins/envato-market.zip',
			'required'				=> false,
			'version'				=> '2.0.7',
			'force_activation'		=> false,
			'force_deactivation' 	=> false,
			'external_url'			=> '',
			'is_callable'			=> '',
			'has_notices'			=> false,
		),
		'elementor' => array(
			'name'					=> esc_html__( 'Elementor', 'impeka' ),
			'slug'					=> 'elementor',
			'required'				=> false,
			'has_notices'           => false,
		),
		'contact-form-7' => array(
			'name'					=> esc_html__( 'Contact Form 7', 'impeka' ),
			'slug'					=> 'contact-form-7',
			'required'				=> false,
			'has_notices'			=> false,
		),
		'woocommerce' => array(
			'name'					=> esc_html__( 'WooCommerce', 'impeka' ),
			'slug'					=> 'woocommerce',
			'required'				=> false,
			'has_notices'			=> false,
		),
		'the-events-calendar' => array(
			'name'					=> esc_html__( 'The Events Calendar', 'impeka' ),
			'slug'					=> 'the-events-calendar',
			'required'				=> false,
			'has_notices'			=> false,
			'has_wizard'			=> false,
		),
		'leadin' => array(
			'name'					=> esc_html__( 'HubSpot All-In-One Marketing - Forms, Popups, Live Chat', 'impeka' ),
			'slug'					=> 'leadin',
			'required'				=> false,
			'has_notices'			=> false,
		),
	);

	$plugins = apply_filters( 'impeka_grve_recommended_plugins', $plugins );

	/**
	* Array of configuration settings. Amend each line as needed.
	* If you want the default strings to be available under your own theme domain,
	* leave the strings uncommented.
	* Some of the strings are added into a sprintf, so see the comments at the
	* end of each line for what each argument will be.
	*/
	$config = array(
		'id'           => 'impeka-tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'impeka-tgmpa-install-plugins', // Menu slug.
		'parent_slug'  => 'admin.php',            // Parent menu slug.
		'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'message'      => '',                      // Message to output right before the plugins table.
		'strings'      => array(
			'nag_type'	=> 'updated' // Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
		)
	);

	if ( isset( $_GET['page'] ) && ( 'impeka-wizard' == $_GET['page'] ) ) {
		 $config['has_notices'] = false;
	}

	tgmpa( $plugins, $config );

}

/**
 * Add tgmpa to theme menu
 */
function impeka_grve_admin_menu_args($args) {
    $args['parent_slug'] = 'impeka';
    return $args;
}
add_filter( 'tgmpa_admin_menu_args', 'impeka_grve_admin_menu_args' );

/**
 * Disable redirects
 */
add_filter( 'transient__vc_page_welcome_redirect', '__return_false' );
add_filter( 'woocommerce_enable_setup_wizard', '__return_false' );

//Omit closing PHP tag to avoid accidental whitespace output errors.
