
var GTB = GTB || {};

(function($){
	'use strict';

	GTB = {
		init: function() {
			this.editor.init();
		},
		onResize: function() {
			this.editor.onResize();
		},
	};

	GTB.editor = {
		init: function(){
			this.isotope.init();
			this.carouselElements.init();
		},
		onResize: function(){
			this.isotope.relayout();
		},
		listTitleGrid: {
			init: function(){
				var base = this;
				$('.grve-list-title-grid').each(function(){
					var $wrapper = $(this),
						displayStyle = $wrapper.data('display-style'),
						$container = $wrapper.find('.grve-list-grid'),
						originLeft = true;
					if( $body.hasClass('rtl')) {
						originLeft = false;
					}
					base.filtersCounter( $wrapper );

					$container.isotope({
						itemSelector: '.grve-list-item',
						layoutMode: 'fitRows',
						originLeft: originLeft,
					}).isotope( 'layout' );
					base.toggleImage( $wrapper );
					$wrapper.css('visibility','visible');
				});
			},
			toggleImage: function( $element ){
				var images = $.makeArray( $element.find('.grve-list-image') ),
					$item = $element.find('.grve-list-item');
				$element.on('mouseenter', '.grve-list-item',function(){
					var $that = $(this),
						index = $that.index(),
						$image = $(images[index]);
					$that.addClass('grve-active').siblings().addClass('grve-hide');
					$image.addClass('grve-active').siblings().removeClass('grve-active');
				});
				$element.on('mouseleave','.grve-list-item',function(){
					var $that = $(this),
						index = $that.index(),
						$image = $(images[index]);
					$that.removeClass('grve-active').siblings().removeClass('grve-hide');
					$image.removeClass('grve-active');
				});
			},
			filtersCounter: function( $wrapper ){
				var base = this,
					$filters = $wrapper.find('.grve-filter.grve-filter-style-count'),
					counter = '<div class="grve-count"><span></span></div>',
					filterClasses = [];
				if( $filters.length ) {
					var $filter = $filters.find('li');
					$filter.each(function(){
						var $that = $(this),
						filterClass = $that.data('filter');
						if( -1 === filterClasses.indexOf( filterClass ) ) {
							filterClasses.push( filterClass );
						}
						if( !$that.find('.grve-count').length ) {
							$(counter).appendTo($that);
						}
					});
					// All Counter
					$($filter[0]).find('.grve-count span').text( $wrapper.find('.grve-list-item').length );

					$.each( filterClasses,function( index, itemClass ){
						if( itemClass !== '*' ) {
							var count = $wrapper.find(itemClass).length;
							$($filter[index]).find('.grve-count span').text( count );
						}
					});
				}
			},
		},
		isotope: {
			init: function(){
				var base = this;
				$('.grve-isotope').each(function(){
					var $wrapper     = $(this),
						$container   = $wrapper.find('.grve-isotope-container'),
						itemsArr     = $.makeArray( $container.find('.grve-entry-item') ),
						layoutMode   = $wrapper.data('layout'),
						$pagination  = $wrapper.find('.grve-infinite-pagination'),
						displayStyle = $wrapper.data('display-style'),
						originLeft = true;
					if( $body.hasClass('rtl')) {
						originLeft = false;
					}

					base.updateSettings( $wrapper );
					base.filtersCounter( $wrapper );

					$container.isotope({
						itemSelector: '.grve-entry-item',
						layoutMode: layoutMode,
						originLeft: originLeft,
						// transitionDuration: 0,
						masonry: {
							columnWidth: '.grve-grid-sizer'
						}
					}).css('visibility','visible');
				});
			},
			updateSettings: function( $wrapper ){
				var base = this,
					$container  = $wrapper.find('.grve-isotope-container'),
					itemsArr    = $.makeArray( $container.find('.grve-entry-item') );

				base.isotopeColumns = base.getColumns( $wrapper );

				base.containerSize( $wrapper );
				base.itemSize( $wrapper, itemsArr );
			},
			relayout: function(){
				var base = this;
				$('.grve-isotope').each(function(){
					var $wrapper   = $(this),
						$container = $wrapper.find('.grve-isotope-container');
					base.updateSettings( $wrapper );
					$container.isotope({
						// transitionDuration: 0
					}).isotope( 'layout' );
				});
			},
			filtersCounter: function( $wrapper ){
				var base = this,
					$filters = $wrapper.find('.grve-filter.grve-filter-style-count'),
					counter = '<div class="grve-count"><span></span></div>',
					filterClasses = [];
				if( $filters.length ) {
					var $filter = $filters.find('li');
					$filter.each(function(){
						var $that = $(this),
						filterClass = $that.data('filter');
						if( -1 === filterClasses.indexOf( filterClass ) ) {
							filterClasses.push( filterClass );
						}
						if( !$that.find('.grve-count').length ) {
							$(counter).appendTo($that);
						}
					});
					// All Counter
					$($filter[0]).find('.grve-count span').text( $wrapper.find('.grve-entry-item').length );

					$.each( filterClasses,function( index, itemClass ){
						if( itemClass !== '*' ) {
							var count = $wrapper.find(itemClass).length;
							$($filter[index]).find('.grve-count span').text( count );
						}
					});
				}
			},
			itemSize: function( $wrapper, items ){
				var base       = this,
					gutter     = !isNaN( $wrapper.data('gutter-size') ) ? Math.abs( $wrapper.data('gutter-size') ) : 0,
					columns    = base.isotopeColumns,
					$gridSizer = $wrapper.find('.grve-grid-sizer'),
					wrapperW   = $wrapper.innerWidth(),
					offset     = $wrapper.parents('.grve-section').hasClass('grve-fullwidth') ? - gutter : gutter,
					columnW    = (wrapperW + offset) / columns,
					columnW    = (columnW % 1 !== 0) ? Math.ceil(columnW) : columnW;

				$gridSizer.css({'width' : columnW });

				$.each( items, function(index, item){
					var $item = $(item),
						$itemInner = $item.children(),
						$thumb = $item.find('.grve-thumbnail');
					if( $itemInner.hasClass('grve-image-landscape') ) {
						if ( columns != 1 ) {
							$item.css({'width' : columnW * 2});
						} else {
							$item.css({'width' : columnW });
						}
						$thumb.removeAttr('style');
						$thumb.css('height',columnW - gutter);
					} else if( $itemInner.hasClass('grve-image-portrait') ) {
						$item.css({'width' : columnW });
						$thumb.removeAttr('style');
						$thumb.css('height',columnW*2  - gutter);
					} else if( $itemInner.hasClass('grve-double-size') || $itemInner.hasClass('grve-image-large-square') ) {
						if ( columns != 1 ) {
							$item.css({'width' : columnW * 2});
						} else {
							$item.css({'width' : columnW });
						}
					} else {
						$item.css({'width' : columnW });
					}
					$item.css({ 'padding' : gutter/2 });
				});

				// Equal Columns
				base.equalColumns( $wrapper, items );
			},
			containerSize: function( $wrapper ){
				var base       = this,
					$container = $wrapper.find('.grve-isotope-container'),
					wrapperW   = $wrapper.innerWidth(),
					gutter     = !isNaN( $wrapper.data('gutter-size') ) ? Math.abs( $wrapper.data('gutter-size') ) : 0,
					columns    = base.isotopeColumns,
					offset     = $wrapper.parents('.grve-section').hasClass('grve-fullwidth') ? - gutter : gutter,
					columnW    = (wrapperW + offset) / columns,
					columnW    = (columnW % 1 !== 0) ? Math.ceil(columnW) : columnW,
					containerW = columnW * columns;

				if ( $container.parents('.grve-section').hasClass('grve-fullwidth') ) {
					$container.css({ 'padding-left' : gutter/2, 'padding-right' : gutter/2, 'width' : containerW + gutter });
				} else {
					$container.css({ 'margin' : - (gutter/2), 'width' : containerW });
				}
			},
			getColumns: function( $wrapper ){
				var windowWidth = $(window).width(),
					columns = {
						largeS  : $wrapper.data('columns-large-screen'),
						desktop : $wrapper.data('columns'),
						tabletL : $wrapper.data('columns-tablet-landscape'),
						tabletP : $wrapper.data('columns-tablet-portrait'),
						mobile : $wrapper.data('columns-mobile')
					};

				if ( windowWidth > largeScreen ) {
					columns = columns.largeS;
				} else if ( windowWidth > tabletLandscape && windowWidth <= largeScreen ) {
					columns = columns.desktop;
				} else if ( windowWidth > tabletPortrait && windowWidth <= tabletLandscape ) {
					columns = columns.tabletL;
				} else if ( windowWidth > mobileScreen && windowWidth <= tabletPortrait ) {
					columns = columns.tabletP;
				} else {
					columns = columns.mobile;
				}

				return columns;
			},
			getRows: function( $wrapper, items ){
				var base = this;
				if( items.length ) {
					var columns = base.isotopeColumns,
						itemsArr = [],
						rows = [];

					$.each( items, function(i,item){
						itemsArr.push(item);
						if( $(items[i]).children().hasClass('grve-double-size') ) {
							itemsArr.push('');
						}
					});

					for (var index = 0; index < itemsArr.length; index += columns) {
						var rowItems = itemsArr.slice( index, index + columns );
						rowItems = $.grep(rowItems,function(n){
							return(n);
						});
						rows.push( rowItems );
					}

					return rows;
				}
			},
			equalColumns: function( $wrapper, items ){
				var base = this;
				if( $wrapper.hasClass('grve-blog-grid')) {
					var rows = base.getRows( $wrapper, items );
					$.each( rows, function( index, col ){
						$(this).imagesLoaded( function() {
							var maxHeight = GTB.helpers.getMaxHeights( col, '.grve-post-item-inner' );
							$.each(col, function( index, value ) {
								var $that = $(this),
								$post = $that.find('.grve-post-item-inner');
								$post.css( 'height', maxHeight );
							});
						});
					});
				}
				if( $wrapper.hasClass('grve-testimonial-grid')) {
					var rows = base.getRows( $wrapper, items );
					$.each( rows, function( index, col ){
						$(this).imagesLoaded( function() {
							var maxHeight = GTB.helpers.getMaxHeights( col, '.grve-testimonial-inner' );
							$.each(col, function( index, value ) {
								var $that = $(this),
								$post = $that.find('.grve-testimonial-inner');
								$post.css( 'height', maxHeight );
							});
						});
					});
				}
			}
		},
		carouselElements: {
			init: function(){
				var base = this;
				base.carousel();
				base.carouselFlickity();
				base.slider();
			},
			carousel: function(){
				var $element = $('.grve-classic-carousel');
				$element.each(function(){
					var $carousel = $(this),
						$nextNav = $carousel.parent().find('.grve-carousel-next'),
						$prevNav = $carousel.parent().find('.grve-carousel-prev'),
						sliderSpeed = ( parseInt( $carousel.attr('data-slider-speed') ) ) ? parseInt( $carousel.attr('data-slider-speed') ) : 3000,
						pagination = $carousel.attr('data-pagination') != 'no' ? true : false,
						paginColor = $carousel.attr('data-pagination-color') !== undefined ? 'grve-carousel-pagination grve-dots-' + $carousel.attr('data-pagination-color') : 'grve-carousel-pagination',
						paginationSpeed = ( parseInt( $carousel.attr('data-pagination-speed') ) ) ? parseInt( $carousel.attr('data-pagination-speed') ) : 400,
						autoHeight = $carousel.attr('data-slider-autoheight') == 'yes' ? true : false,
						autoPlay = $carousel.attr('data-slider-autoplay') != 'no' ? true : false,
						sliderPause = $carousel.attr('data-slider-pause') == 'yes' ? true : false,
						loop = $carousel.attr('data-slider-loop') != 'no' ? true : false,
						itemNum = parseInt( $carousel.attr('data-items')),
						tabletLandscapeNum = $carousel.attr('data-items-tablet-landscape') ? parseInt( $carousel.attr('data-items-tablet-landscape')) : 3,
						tabletPortraitNum = $carousel.attr('data-items-tablet-portrait') ? parseInt( $carousel.attr('data-items-tablet-portrait')) : 3,
						mobileNum = $carousel.attr('data-items-mobile') ? parseInt( $carousel.attr('data-items-mobile')) : 1,
						gap = $carousel.hasClass('grve-with-gap') && !isNaN( $carousel.data('gutter-size') ) ? Math.abs( $carousel.data('gutter-size') ) : 0,
						stagePadding = parseInt( $carousel.attr('data-stage-padding') ) > 0 ? parseInt( $carousel.attr('data-stage-padding') ) : 0,
						dotsContainer =  $carousel.parent().find('.grve-thumb-pagination').length ?  $carousel.parent().find('.grve-thumb-pagination')[0] : false,
						rtl = false;
					if ( $carousel.find('.grve-carousel-item').length == 1 ) {
						loop = false;
					}
					if( $body.hasClass('rtl')) {
						rtl = true;
					}
					// Carousel Init
					$carousel.owlCarousel({
						loop : loop,
						autoplay : autoPlay,
						autoplayTimeout : sliderSpeed,
						autoplayHoverPause : sliderPause,
						smartSpeed : 500,
						dots : pagination,
						dotsClass : paginColor,
						autoHeight : autoHeight,
						navContainer : 'grve-carousel-navigation',
						stageOuterClass : 'grve-carousel-stage-outer',
						stageClass : 'grve-carousel-stage',
						autoHeightClass : 'grve-auto-height',
						grabClass : 'grve-grab',
						dotClass : 'grve-dot',
						dotsContainer : dotsContainer,
						rtl: rtl,
						responsive : {
							0 : {
								items : mobileNum
							},
							768 : {
								items : tabletPortraitNum
							},
							1024 : {
								items : tabletLandscapeNum
							},
							1200 : {
								items : itemNum
							}
						},
						margin : gap,
						stagePadding : stagePadding,
						itemClass : 'grve-carousel-item-wrapper'
					});

					$carousel.css('visibility','visible');

					// Go to the next item
					$nextNav.on( 'click', function() {
						$carousel.trigger('next.owl.carousel');
					});
					// Go to the previous item
					$prevNav.on( 'click', function() {
						$carousel.trigger('prev.owl.carousel');
					});

					$carousel.on( 'drag.owl.carousel', function(){
						$(this).addClass('grve-disable-link');
					});

					$carousel.on( 'dragged.owl.carousel', function(){
						$(this).removeClass('grve-disable-link');
					});
				});
			},
			carouselFlickity: function(){
				var $element = $('.grve-flickity-carousel');
				$element.each(function(){
					var $carousel = $(this),
						$nextNav = $carousel.parents('.grve-carousel').find('.grve-carousel-next'),
						$prevNav = $carousel.parents('.grve-carousel').find('.grve-carousel-prev'),
						pagination = $carousel.attr('data-pagination') != 'no' ? true : false,
						autoPlay = $carousel.attr('data-slider-autoplay') != 'no' ? true : false,
						loop = $carousel.attr('data-slider-loop') != 'no' ? true : false,
						align = $carousel.attr('data-slider-loop') != 'no' ? 'center' : 'left',
						rtl = false;

					if( $body.hasClass('rtl')) {
						rtl = true;
						align = $carousel.attr('data-slider-loop') != 'no' ? 'center' : 'right';
					}

					// $carousel.on( 'ready.flickity change.flickity', function() {
					$carousel.on( 'ready.flickity', function() {
						var $that = $(this);
						if( $that.hasClass('grve-blog-carousel') ) {
							var $item = $that.find('.grve-post-item'),
								items = $.makeArray( $item ),
								maxHeight = GTB.helpers.getMaxHeights( items, '.grve-post-item-inner' );
							$that.find('.grve-post-item-inner').css('height',maxHeight);
						}
						if( $that.hasClass('grve-testimonial') ) {
							var $item = $that.find('.grve-testimonial-item'),
								items = $.makeArray( $item ),
								maxHeight = GTB.helpers.getMaxHeights( items, '.grve-testimonial-inner' );
							$that.find('.grve-testimonial-inner').css('height',maxHeight);
						}
					});
					$carousel.flickity({
						cellAlign: align,
						contain: loop,
						wrapAround: loop,
						groupCells: true,
						pageDots: pagination,
						autoPlay: autoPlay,
						prevNextButtons: false,
						adaptiveHeight: false,
						cellSelector: '.grve-carousel-item',
						rightToLeft: rtl
					});
					$carousel.css('visibility','visible');

					// Go to the next item
					$nextNav.on( 'click', function() {
						$carousel.flickity('next');
					});
					// Go to the previous item
					$prevNav.on( 'click', function() {
						$carousel.flickity('previous');
					});

					$carousel.on( 'dragStart.flickity', function(){
						$(this).addClass('grve-disable-link');
					});

					$carousel.on( 'dragEnd.flickity', function(){
						$(this).removeClass('grve-disable-link');
					});
				});
			},
			flexibleCarouselAdvanced: function(){
				var $element = $('.grve-flexible-advanced-carousel');
				$element.each(function(){
					var $carousel = $(this),
						$nextNav = $carousel.parents('.grve-carousel-wrapper').find('.grve-carousel-next'),
						$prevNav = $carousel.parents('.grve-carousel-wrapper').find('.grve-carousel-prev'),
						pagination = $carousel.attr('data-pagination') != 'no' ? true : false,
						autoPlay = $carousel.attr('data-slider-autoplay') != 'no' ? true : false,
						loop = $carousel.attr('data-slider-loop') != 'no' ? true : false,
						align = $carousel.attr('data-slider-loop') != 'no' ? 'center' : 'left',
						rtl = false;
					if( $body.hasClass('rtl')) {
						rtl = true;
						align = $carousel.attr('data-slider-loop') != 'no' ? 'center' : 'right';
					}

					$carousel.flickity({
						cellAlign: align,
						contain: loop,
						wrapAround: loop,
						groupCells: true,
						pageDots: pagination,
						autoPlay: autoPlay,
						prevNextButtons: false,
						adaptiveHeight: false,
						rightToLeft: rtl
					});
					$carousel.css('visibility','visible');

					// Go to the next item
					$nextNav.on( 'click', function() {
						$carousel.flickity('next');
					});
					// Go to the previous item
					$prevNav.on( 'click', function() {
						$carousel.flickity('previous');
					});

					$carousel.on( 'dragStart.flickity', function(){
						$(this).addClass('grve-disable-link');
					});

					$carousel.on( 'dragEnd.flickity', function(){
						$(this).removeClass('grve-disable-link');
					});
				});
			},
			slider: function(){
				var $element = $('.grve-slider-element');
				$element.each(function(){
					var $slider = $(this),
						$nextNav = $slider.parents('.grve-slider').find('.grve-carousel-next'),
						$prevNav = $slider.parents('.grve-slider').find('.grve-carousel-prev'),
						sliderSpeed = ( parseInt( $slider.attr('data-slider-speed') ) ) ? parseInt( $slider.attr('data-slider-speed') ) : 3000,
						sliderPause = $slider.attr('data-slider-pause') == 'yes' ? true : false,
						transition = $slider.attr('data-slider-transition'),
						loop = $slider.attr('data-slider-loop') != 'no' ? true : false,
						autoPlay = $slider.attr('data-slider-autoplay') != 'no' ? true : false,
						paginColor = $slider.attr('data-pagination-color') !== undefined ? 'grve-carousel-pagination grve-dots-' + $slider.attr('data-pagination-color') : 'grve-carousel-pagination',
						pagination = $slider.attr('data-pagination') != 'no' ? true : false,
						animateOut = false,
						animateIn = false;

					// Slider Trantition
					if( $slider.parents('.grve-slider').hasClass('grve-layout-2') || 'fade' == transition ){
						animateOut = 'carousel-fade-out';
						animateIn = 'carousel-fade-in';
					}

					if ( $slider.find('.grve-slider-item').length == 1 ) {
						loop = false;
					}

					// Slider Init
					$slider.owlCarousel({
						items : 1,
						loop : loop,
						autoplay : autoPlay,
						autoplayTimeout : sliderSpeed,
						autoplayHoverPause : sliderPause,
						smartSpeed : 500,
						dots : pagination,
						animateOut : animateOut,
						animateIn : animateIn,
						dotsClass : paginColor,
						itemClass : 'grve-slider-item-wrapper',
						navContainer : 'grve-carousel-navigation',
						stageOuterClass : 'grve-carousel-stage-outer',
						stageClass : 'grve-carousel-stage',
						grabClass : 'grve-grab',
						dotClass : 'grve-dot',
					});

					$slider.css('visibility','visible');

					// Go to the next item
					$nextNav.on( 'click', function() {
						$slider.trigger('next.owl.carousel');
					});
					// Go to the previous item
					$prevNav.on( 'click', function() {
						$slider.trigger('prev.owl.carousel');
					});

				});

			}
		},
	};

	GTB.helpers = {
		getMaxHeights: function( itemsArr, selector ){
			var maxHeight = 0,
				heightArr = [];
			$.each( itemsArr, function( index, item ){
				var $item = $(item).find( selector ),
					itemH = $item.css('height','auto').outerHeight();
				heightArr.push(itemH);
			});

			maxHeight = Math.max.apply( Math, heightArr ) + 2;

			return maxHeight;
		},
	};


	var $document = $(document),
		$window = $(window),
		$body = $('body');

	var largeScreen = 2048;
	var tabletLandscape = 1200;
	var tabletPortrait = 1023;
	var mobileScreen = 767;
	var lastScrollTop = 0;

	$(function() {
		GTB.init();

		var target = "";
		
		document.getElementById('editor');
		
		if ( $('#editor').length ) {
			target = document.getElementById('editor');
		} else if(  $('#widgets-editor').length  ) {
			target = document.getElementById('widgets-editor');
		}
		
		if ( '' != target ) {	
			var observer = new MutationObserver(function (mutations) {
				mutations.forEach(function (mutation) {
					$(mutation.addedNodes).find('.grve-list-title-grid').each(function () {
						GTB.editor.listTitleGrid.init();
					});
					$(mutation.addedNodes).find('.grve-isotope').each(function () {
						GTB.editor.isotope.init();
					});
					$(mutation.addedNodes).find('.grve-classic-carousel').each(function () {
						GTB.editor.carouselElements.carousel();
					});
					$(mutation.addedNodes).find('.grve-flickity-carousel').each(function () {
						GTB.editor.carouselElements.carouselFlickity();
					});
					$(mutation.addedNodes).find('.grve-slider-element').each(function () {
						GTB.editor.carouselElements.slider();
					});
				});
			});
			observer.observe(target, {childList: true, subtree: true});
		}
	});

})(jQuery);