<?php
/*
Template Name: Scrolling Full Screen Sections
*/

get_header();
the_post();

$responsive_scrolling_page = impeka_grve_post_meta( '_impeka_grve_responsive_scrolling', 'yes' );
$scrolling_lock_anchors = impeka_grve_post_meta( '_impeka_grve_scrolling_lock_anchors', 'yes' );
$scrolling_loop = impeka_grve_post_meta( '_impeka_grve_scrolling_loop', 'none' );
$scrolling_speed = impeka_grve_post_meta( '_impeka_grve_scrolling_speed', 1000 );

$wrapper_attributes = array();
$wrapper_attributes[] = 'id="grve-fullpage"';
$wrapper_attributes[] = 'data-device-scrolling="' . esc_attr( $responsive_scrolling_page ) . '"';
$wrapper_attributes[] = 'data-lock-anchors="' . esc_attr( $scrolling_lock_anchors ) . '"';
$wrapper_attributes[] = 'data-scroll-loop="' . esc_attr( $scrolling_loop ) . '"';
$wrapper_attributes[] = 'data-scroll-speed="' . esc_attr( $scrolling_speed ) . '"';
?>
<div id="grve-content" class="clearfix">
	<div class="grve-content-wrapper">
		<div id="grve-main-content">
			<div class="grve-main-content-wrapper clearfix" style="padding: 0;">
				<div id="page-<?php the_ID(); ?>" <?php post_class(); ?>>
						<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
						<?php the_content(); ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php
get_footer( 'basic' );

//Omit closing PHP tag to avoid accidental whitespace output errors.
