<?php
/*
*	Loop event Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$event_params = isset( $args ) ? $args : array();

$overlay_color = impeka_grve_array_value( $event_params, 'overlay_color', 'white' );
$overlay_opacity = impeka_grve_array_value( $event_params, 'overlay_opacity', '90' ) ;
$image_size = impeka_grve_array_value( $event_params, 'image_size', 'large' );
$title_heading_tag = impeka_grve_array_value( $event_params, 'title_heading_tag', 'h3' );
$title_heading = impeka_grve_array_value( $event_params, 'title_heading', 'h3' );
?>
<div class="grve-event-item">
	<a class="grve-item-url" href="<?php echo esc_url( tribe_get_event_link() ); ?>"></a>
	<?php if ( has_post_thumbnail() ) { ?>
	<div class="grve-event-media">
		<div class="grve-bg-<?php echo esc_attr( $overlay_color ); ?> grve-hover-overlay grve-opacity-<?php echo esc_attr( $overlay_opacity ); ?>"></div>
		<?php the_post_thumbnail( $image_size ); ?>
	</div>
	<?php } ?>
	<?php if ( tribe_get_cost() ) { ?>
		<div class="tribe-events-event-cost grve-small-text"><?php echo tribe_get_cost( null, true ); ?></div>
	<?php } ?>
	<div class="grve-event-content">
		<<?php echo tag_escape( $title_heading_tag ); ?> class="grve-title grve-<?php echo esc_attr( $title_heading ); ?>"><?php the_title(); ?></<?php echo tag_escape( $title_heading_tag ); ?>>
		<div class="grve-event-exerpt">
			<?php echo impeka_grve_excerpt( '30' ); ?>
		</div>
		<div class="tribe-event-schedule-details grve-small-text">
			<?php echo tribe_events_event_schedule_details() ?>
		</div>
	</div>
</div>