<?php
/*
*	Dropdown Language Switcher
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$skip_missing = impeka_grve_option('language_switcher_skip_missing', '0' );
$skip_missing = intval( $skip_missing );

$language_switcher_options = impeka_grve_option('language_switcher_options');
$flag = impeka_grve_array_value( $language_switcher_options, 'flag' );
$name = impeka_grve_array_value( $language_switcher_options, 'name' );
$show_current_lang = impeka_grve_array_value( $language_switcher_options, 'current-lang' );

$languages = '';

if( function_exists( 'pll_the_languages' ) ) {
	//Polylang
	$languages = pll_the_languages( array( 'raw'=>1, 'hide_if_no_translation' => $skip_missing  ) );

	$lang_option_current = $lang_options = '';

	foreach ( $languages as $l ) {

		if ( !$l['current_lang'] ) {
			$lang_options .= '<li>';
			$lang_options .= '<a href="' . esc_url( $l['url'] ) . '" class="grve-language-item">';
			if ( $flag ) {
				$lang_options .= '<img src="' . esc_url( $l['flag'] ) . '" alt="' . esc_attr( $l['name'] ) . '"/>';
			}
			if ( $name ) {
				$lang_options .= esc_html( $l['name'] );
			}
			$lang_options .= '</a>';
			$lang_options .= '</li>';
		} else {
			$lang_option_current .= '<a href="#" class="grve-language-item">';
			if ( $flag ) {
				$lang_option_current .= '<img src="' . esc_url( $l['flag'] ) . '" alt="' . esc_attr( $l['name'] ) . '"/>';
			}
			if ( $name ) {
				$lang_option_current .= esc_html( $l['name'] );
			}
			$lang_option_current .= '</a>';
			if ( $show_current_lang ) {
				$lang_options .= '<li>';
				$lang_options .= '<a href="' . esc_url( $l['url'] ) . '" class="grve-language-item">';
				if ( $flag ) {
					$lang_options .= '<img src="' . esc_url( $l['flag'] ) . '" alt="' . esc_attr( $l['name'] ) . '"/>';
				}
				if ( $name ) {
					$lang_options .= esc_html( $l['name'] );
				}
				$lang_options .= '</a>';
				$lang_options .= '</li>';
			}
		}
	}

} else if ( defined( 'ICL_SITEPRESS_VERSION' ) && defined( 'ICL_LANGUAGE_CODE' ) && function_exists( 'icl_get_languages' ) ) {
	//WPML
	$languages = icl_get_languages( 'skip_missing=' . $skip_missing );
	if ( ! empty( $languages ) ) {

		$lang_option_current = $lang_options = '';

		foreach ( $languages as $l ) {

			if ( !$l['active'] ) {
				$lang_options .= '<li>';
				$lang_options .= '<a href="' . esc_url( $l['url'] ) . '" class="grve-language-item">';
				if ( $flag ) {
					$lang_options .= '<img src="' . esc_url( $l['country_flag_url'] ) . '" alt="' . esc_attr( $l['language_code'] ) . '"/>';
				}
				if ( $name ) {
					$lang_options .= esc_html( $l['native_name'] );
				}
				$lang_options .= '</a>';
				$lang_options .= '</li>';
			} else {
				$lang_option_current .= '<a href="#" class="grve-language-item">';
				if ( $flag ) {
					$lang_option_current .= '<img src="' . esc_url( $l['country_flag_url'] ) . '" alt="' . esc_attr( $l['language_code'] ) . '"/>';
				}
				if ( $name ) {
					$lang_option_current .= esc_html( $l['native_name'] );
				}
				$lang_option_current .= '</a>';
				if ( $show_current_lang ) {
					$lang_options .= '<li>';
					$lang_options .= '<a href="' . esc_url( $l['url'] ) . '" class="grve-language-item">';
					if ( $flag ) {
						$lang_options .= '<img src="' . esc_url( $l['country_flag_url'] ) . '" alt="' . esc_attr( $l['language_code'] ) . '"/>';
					}
					if ( $name ) {
						$lang_options .= esc_html( $l['native_name'] );
					}
					$lang_options .= '</a>';
					$lang_options .= '</li>';
				}
			}
		}
	}
}
if ( empty( $languages ) ) {
	return;
}

?>
<ul class="grve-language grve-dropdown">
	<li>
		<?php echo wp_kses_post( $lang_option_current ); ?>
		<?php if ( !empty( $lang_options ) ) { ?>
		<ul>
			<?php echo wp_kses_post( $lang_options ); ?>
		</ul>
		<?php } ?>
	</li>
</ul>