<?php
/*
*	List Language Switcher
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$skip_missing = impeka_grve_option('language_switcher_skip_missing', '0' );
$skip_missing = intval( $skip_missing );

$language_switcher_options = impeka_grve_option('language_switcher_options');
$flag = impeka_grve_array_value( $language_switcher_options, 'flag' );
$name = impeka_grve_array_value( $language_switcher_options, 'name' );
$show_current_lang = impeka_grve_array_value( $language_switcher_options, 'current-lang' );

?>

<ul class="grve-language grve-list">
<?php
	if( function_exists( 'pll_the_languages' ) ) {
		//Polylang
		$languages = pll_the_languages( array( 'raw'=>1, 'hide_if_no_translation' => $skip_missing  ) );
		if ( ! empty( $languages ) ) {
			foreach ( $languages as $l ) {

				if ( !$show_current_lang && $l['current_lang'] ) {
					continue;
				}
				echo '<li>';
				if ( !$l['current_lang'] ) {
					echo '<a href="' . esc_url( $l['url'] ) . '">';
				} else {
					echo '<a href="#" class="grve-active">';
				}
				if ( $flag ) {
					echo '<img src="' . esc_url( $l['flag'] ) . '" alt="' . esc_attr( $l['name'] ) . '"/>';
				}
				if ( $name ) {
					echo esc_html( $l['name'] );
				}
				echo '</a></li>';
			}
		}
	} else if ( defined( 'ICL_SITEPRESS_VERSION' ) && defined( 'ICL_LANGUAGE_CODE' ) && function_exists( 'icl_get_languages' ) ) {
		//WPML
		$languages = icl_get_languages( 'skip_missing=' . $skip_missing );
		if ( ! empty( $languages ) ) {
			foreach ( $languages as $l ) {

				if ( !$show_current_lang && $l['active'] ) {
					continue;
				}
				echo '<li>';
				if ( !$l['active'] ) {
					echo '<a href="' . esc_url( $l['url'] ) . '">';
				} else {
					echo '<a href="#" class="grve-active">';
				}
				if ( $flag ) {
					echo '<img src="' . esc_url( $l['country_flag_url'] ) . '" alt="' . esc_attr( $l['language_code'] ) . '"/>';
				}
				if ( $name ) {
					echo esc_html( $l['native_name'] );
				}
				echo '</a></li>';
			}
		}
	}
?>
</ul>
