<?php
/*
*	Hover Style 5
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$hover_params = isset( $args ) ? $args : array();
$style = impeka_grve_array_value( $hover_params, 'style' );
$link_atts = impeka_grve_array_value( $hover_params, 'link_atts', array() );
$overlay_color = impeka_grve_array_value( $hover_params, 'overlay_color');
$overlay_opacity = impeka_grve_array_value( $hover_params, 'overlay_opacity', 'none' );
$caption= impeka_grve_array_value( $hover_params, 'caption' );
$text_color= impeka_grve_array_value( $hover_params, 'text_color' );
$text_bg_color= impeka_grve_array_value( $hover_params, 'text_bg_color', 'transparent' );
$image_effect = impeka_grve_array_value( $hover_params, 'image_effect', 'no-effect' );
$shadow = impeka_grve_array_value( $hover_params, 'shadow', 'none' );
$radius = impeka_grve_array_value( $hover_params, 'radius', 'none' );

$item_attributes = array();
$item_attributes[] = 'data-indicator="content"';

$media_class = array( 'grve-image-hover', 'grve-media', 'grve-tilt-inner' );
	if( 'none' != $shadow ) {
		$media_class[] = 'grve-shadow-' . $shadow;
	}
	if( 'none' != $radius ) {
		$media_class[] = 'grve-radius-' . $radius;
	}
	if( 'no-effect' != $image_effect ) {
		$media_class[] = 'grve-' . $image_effect;
	}
$media_class_string = implode( ' ', $media_class );

$item_attributes[] = 'class="' . esc_attr( $media_class_string ) . '"';

?>
<div class="grve-hover-item grve-hover-<?php echo esc_attr( $style ); ?>">
	<div <?php echo implode( ' ', $item_attributes ); ?>>
		<?php if ( !empty( $link_atts ) ) { ?>
		<a <?php echo implode( ' ', $link_atts ); ?>></a>
		<?php } ?>
		<?php impeka_grve_print_hover_media( $hover_params ); ?>
		<?php if ( 'none' != $overlay_opacity ) { ?>
		<div class="grve-bg-<?php echo esc_attr( $overlay_color ); ?> grve-hover-overlay grve-opacity-<?php echo esc_attr( $overlay_opacity ); ?>"></div>
		<?php } ?>
		<div class="grve-content grve-indicator-content">
			<div class="grve-content-inner">
				<?php impeka_grve_print_hover_title( $hover_params ); ?>
				<?php if( !empty( $caption ) ) { ?>
				<div class="grve-description grve-bg-<?php echo esc_attr( $text_bg_color ); ?> grve-text-<?php echo esc_attr( $text_color ); ?>"><?php echo wp_kses_post( $caption ); ?></div>
				<?php } ?>
			</div>
		</div>
	</div>
</div>
