<?php
/*
*	Loop Post Meta Style 2 Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$blog_params = isset( $args ) ? $args : array();

$show_author = impeka_grve_is_enabled( impeka_grve_array_value( $blog_params, 'author_visibility' ) );
$show_comments = impeka_grve_is_enabled( impeka_grve_array_value( $blog_params, 'comments_visibility' ) );
$show_like = impeka_grve_is_enabled( impeka_grve_array_value( $blog_params, 'like_visibility' ) );
$meta_color = impeka_grve_array_value( $blog_params, 'meta_color', 'default' );

$meta_class = array(
	'grve-post-meta',
	'grve-style-2',
	'grve-text-' . $meta_color,
	'grve-svg-' . $meta_color,
);
$meta_class_string = implode( ' ', $meta_class );

if ( $show_author || $show_comments || $show_like ) {
?>
	<div class="<?php echo esc_attr( $meta_class_string ); ?>">
		<?php if ( $show_author ) { ?>
		<div class="grve-post-author grve-small-text"><?php impeka_grve_print_post_loop_meta( 'author' ); ?></div>
		<?php } ?>
		<?php if ( $show_comments || $show_like ) { ?>
		<div class="grve-meta-wrapper">
			<?php if ( $show_like ) { ?>
			<div class="grve-post-likes grve-small-text"><span><?php impeka_grve_print_post_loop_meta( 'like' ); ?></span></div>
			<?php } ?>
			<?php if ( $show_comments ) { ?>
			<div class="grve-post-comments grve-small-text"><span><?php impeka_grve_print_post_loop_meta( 'comments' ); ?></span></div>
			<?php } ?>
		</div>
		<?php } ?>
	</div>
<?php
}