<?php
/*
*	Template Post Related Content
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$thumb_class = 'without-thumb';
if ( has_post_thumbnail() ) {
	$thumb_class = 'with-thumb';
}
$indicator = impeka_grve_option( 'post_related_indicator', 'none' );
$indicator_text = impeka_grve_option( 'post_related_indicator_text' );
$indicator_color = impeka_grve_option( 'post_related_indicator_color' );

$inner_wrapper_attributes = array();
$inner_wrapper_attributes[] = 'class="grve-related-item-inner grve-bg-mouse-move"';
if( 'none' != $indicator ) {
	$inner_wrapper_attributes[] = 'data-indicator="' . esc_attr( $indicator ) . '"';
	$inner_wrapper_attributes[] = 'data-indicator-text="' . esc_attr( $indicator_text ) . '"';
	$inner_wrapper_attributes[] = 'indicator-color="' . esc_attr( $indicator_color ) . '"';
}

$post_link = get_permalink();
$link_target = '_self';

if ( 'link' == get_post_format() ) {
	$post_link = get_post_meta( get_the_ID(), '_impeka_grve_post_link_url', true );
	$new_window = get_post_meta( get_the_ID(), '_impeka_grve_post_link_new_window', true );
	if( empty( $post_link ) ) {
		$post_link = get_permalink();
	}

	if( !empty( $new_window ) ) {
		$link_target = '_blank';
	}
}
?>
<article class="grve-related-item grve-related-item-<?php echo esc_attr( $thumb_class ); ?>">
	<div <?php echo implode( ' ', $inner_wrapper_attributes ); ?>>
		<a class="grve-item-url" href="<?php echo esc_url( $post_link ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><span class="screen-reader-text"><?php the_title(); ?></span></a>
		<?php if ( has_post_thumbnail() ) { ?>
		<div class="grve-background-wrapper">
			<?php impeka_grve_print_post_bg_image('impeka-grve-small-rect-vertical'); ?>
		</div>
		<?php } ?>
		<div class="grve-related-content grve-indicator-content">
			<div class="grve-small-text">
				<time datetime="<?php echo mysql2date( 'c', $post->post_date ); ?>">
					<?php echo esc_html( get_the_date() ); ?>
				</time>
			</div>
			<h3 class="grve-title grve-h5"><?php the_title(); ?></h3>
		</div>
	</div>
</article>

<?php

//Omit closing PHP tag to avoid accidental whitespace output errors.