<?php
/*
*	Loop Post Style 2 Audio Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$blog_params = isset( $args ) ? $args : array();

$show_media = impeka_grve_is_enabled( impeka_grve_array_value( $blog_params, 'media_area' ) );
$show_date = impeka_grve_is_enabled( impeka_grve_array_value( $blog_params, 'date_visibility'  ) );
$show_categories = impeka_grve_is_enabled( impeka_grve_array_value( $blog_params, 'categories_visibility' ) );
$categories_mode = impeka_grve_array_value( $blog_params, 'categories_mode', 'all' );
$image_prio = impeka_grve_array_value( $blog_params, 'image_prio', 'no' );

$shadow = impeka_grve_array_value( $blog_params, 'shadow', 'none' );
$radius = impeka_grve_array_value( $blog_params, 'radius', 'none' );

$heading_color = impeka_grve_array_value( $blog_params, 'heading_color', 'default' );
$text_color = impeka_grve_array_value( $blog_params, 'text_color', 'default' );
$meta_color = impeka_grve_array_value( $blog_params, 'meta_color', 'default' );
$bg_color = impeka_grve_array_value( $blog_params, 'bg_color', 'default' );
$border_color = impeka_grve_array_value( $blog_params, 'border_color', 'default' );

$item_class = array(
	'grve-post-item-inner',
	'grve-border',
	'grve-radius-' . $radius,
	'grve-shadow-' . $shadow,
	'grve-bg-' . $bg_color,
	'grve-text-' . $text_color,
	'grve-headings-' . $heading_color,
	'grve-border-' . $border_color
);
if( 'yes' == $image_prio ) {
	$item_class[] = 'grve-image-priority';
}
if ( !$show_media ) {
	$item_class[] = 'grve-without-media';
}
$item_class_string = implode( ' ', $item_class );

$item_attributes = impeka_grve_get_indicator_atts( $blog_params );
$item_attributes[] = 'class="' . esc_attr( $item_class_string ) . '"';
?>
<div class="grve-post-item grve-style-2 grve-format-audio">
	<div <?php echo implode( ' ', $item_attributes ); ?>>
		<?php if ( $show_media ) { ?>
			<?php if ( 'yes' == $image_prio && has_post_thumbnail() ) { ?>
			<div class="grve-post-media">
				<?php impeka_grve_print_post_bg_link( $blog_params ); ?>
				<?php impeka_grve_print_post_feature_image( $blog_params ); ?>
			</div>
			<?php if ( $show_categories ) { ?>
			<div class="grve-post-category grve-small-text"><?php impeka_grve_print_post_loop_meta( 'categories-' . $categories_mode ); ?></div>
			<?php } ?>
			<?php } else { ?>
			<div class="grve-post-media">
				<?php impeka_grve_print_post_audio(); ?>
			</div>
			<?php } ?>
		<?php } else { ?>
			<?php if ( $show_categories ) { ?>
			<div class="grve-post-category grve-small-text"><?php impeka_grve_print_post_loop_meta( 'categories-' . $categories_mode ); ?></div>
			<?php } ?>
		<?php } ?>
		<div class="grve-post-content">
			<?php if ( $show_date ) { ?>
			<div class="grve-post-date grve-small-text"><span><?php impeka_grve_print_post_loop_meta( 'date' ); ?></span></div>
			<?php } ?>
			<?php impeka_grve_loop_post_title_link( $blog_params ); ?>
			<div class="grve-post-exerpt" itemprop="articleBody">
				<?php impeka_grve_print_post_excerpt( $blog_params ); ?>
			</div>
		</div>
		<?php get_template_part( 'templates/post/meta/loop-post-meta-style-3', '', $blog_params ); ?>
	</div>
	<?php impeka_grve_print_post_structured_data(); ?>
</div>
