<?php
/*
*	Loop Post Style 2 Gallery Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$blog_params = isset( $args ) ? $args : array();

$shadow = impeka_grve_array_value( $blog_params, 'shadow', 'none' );
$radius = impeka_grve_array_value( $blog_params, 'radius', 'none' );

$link_url = get_post_meta( get_the_ID(), '_impeka_grve_post_link_url', true );
if( empty( $link_url ) ) {
	$link_url = get_permalink();
}

$custom_overview = impeka_grve_is_enabled( impeka_grve_array_value( $blog_params, 'custom_overview' ) );
$overview_style = impeka_grve_post_meta( '_impeka_grve_post_overview_style' );

$heading_color = 'white';
$text_color = 'white';
$meta_color = 'white';
$bg_color = 'gradient-1';
$border_color = 'default';

if( $custom_overview  && 'style-2' == $overview_style) {
	$heading_color = impeka_grve_post_meta( '_impeka_grve_post_overview_heading_color', $heading_color );
	$text_color = impeka_grve_post_meta( '_impeka_grve_post_overview_text_color', $text_color );
	$meta_color = impeka_grve_post_meta( '_impeka_grve_post_overview_meta_color', $meta_color );
	$bg_color = impeka_grve_post_meta( '_impeka_grve_post_overview_bg_color', $bg_color );
	$border_color = impeka_grve_post_meta( '_impeka_grve_post_overview_border_color', $border_color );
}

$item_class = array(
	'grve-post-item-inner',
	'grve-border',
	'grve-radius-' . $radius,
	'grve-shadow-' . $shadow,
	'grve-bg-' . $bg_color,
	'grve-text-' . $text_color,
	'grve-headings-' . $heading_color,
	'grve-border-' . $border_color
);
$item_class_string = implode( ' ', $item_class );
$item_attributes = impeka_grve_get_indicator_atts( $blog_params );
$item_attributes[] = 'class="' . esc_attr( $item_class_string ) . '"';
?>
<div class="grve-post-item grve-style-2 grve-format-link">
	<div <?php echo implode( ' ', $item_attributes ); ?>>
		<?php impeka_grve_print_post_bg_link( $blog_params ); ?>
		<div class="grve-post-content-wrapper">
			<div class="grve-post-content">
				<?php impeka_grve_print_post_icon_format('link'); ?>
				<?php impeka_grve_loop_post_title( $blog_params ); ?>
				<?php impeka_grve_loop_post_link_text(); ?>
				<div class="grve-post-url grve-post-small-text" data-title-hover="<?php echo esc_url( $link_url ); ?>"><?php echo esc_url( $link_url ); ?></div>
			</div>
		</div>
	</div>
	<?php impeka_grve_print_post_structured_data(); ?>
</div>
